# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['FolderArgs', 'Folder']

@pulumi.input_type
class FolderArgs:
    def __init__(__self__, *,
                 parent: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Folder resource.
        :param pulumi.Input[_builtins.str] parent: The parent folder
        :param pulumi.Input[_builtins.str] description: The description of the folder
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] labels: Labels assigned to the folder
        :param pulumi.Input[_builtins.str] name: The name of the folder
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] snippets: Snippets associated with the folder
        """
        pulumi.set(__self__, "parent", parent)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if snippets is not None:
            pulumi.set(__self__, "snippets", snippets)

    @_builtins.property
    @pulumi.getter
    def parent(self) -> pulumi.Input[_builtins.str]:
        """
        The parent folder
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "parent", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the folder
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Labels assigned to the folder
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the folder
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def snippets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Snippets associated with the folder
        """
        return pulumi.get(self, "snippets")

    @snippets.setter
    def snippets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "snippets", value)


@pulumi.input_type
class _FolderState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 snippets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tfid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Folder resources.
        :param pulumi.Input[_builtins.str] description: The description of the folder
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] labels: Labels assigned to the folder
        :param pulumi.Input[_builtins.str] name: The name of the folder
        :param pulumi.Input[_builtins.str] parent: The parent folder
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] snippets: Snippets associated with the folder
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if snippets is not None:
            pulumi.set(__self__, "snippets", snippets)
        if tfid is not None:
            pulumi.set(__self__, "tfid", tfid)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the folder
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Labels assigned to the folder
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the folder
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The parent folder
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent", value)

    @_builtins.property
    @pulumi.getter
    def snippets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Snippets associated with the folder
        """
        return pulumi.get(self, "snippets")

    @snippets.setter
    def snippets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "snippets", value)

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tfid")

    @tfid.setter
    def tfid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tfid", value)


@pulumi.type_token("scm:index/folder:Folder")
class Folder(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 snippets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Folder resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        #
        # Creates a folder under the "All Firewalls" aka "ngfw-shared" folder
        #
        scm_folder_example = scm.Folder("scm_folder_example",
            name="scm_folder_example",
            parent="ngfw-shared",
            description="Managed by Pulumi")
        #
        # Creates a folder under the "scm_folder_example" folder created beforehand
        #
        scm_nested_folder_example = scm.Folder("scm_nested_folder_example",
            name="scm_nested_folder_example",
            parent="scm_folder_example",
            description="Managed by Pulumi",
            opts = pulumi.ResourceOptions(depends_on=[scm_folder_example]))
        #
        # Creates a snippet that will be associated to a folder
        #
        scm_snippet_example = scm.Snippet("scm_snippet_example",
            name="scm_snippet_example",
            description="Managed by Pulumi")
        #
        # Creates a folder with an attached snippet
        #
        scm_folder_with_snippets = scm.Folder("scm_folder_with_snippets",
            name="scm_folder_with_snippets",
            parent="ngfw-shared",
            description="Managed by Pulumi",
            snippets=[scm_snippet_example.name])
        #
        # Creates a label that will be associated to a folder
        #
        scm_label_example = scm.Label("scm_label_example",
            name="scm_label_example",
            description="Managed by Pulumi")
        #
        # Creates a folder with an attached label
        #
        scm_folder_with_label = scm.Folder("scm_folder_with_label",
            name="scm_folder_with_label",
            parent="ngfw-shared",
            description="Managed by Pulumi",
            labels=[scm_label_example.name],
            opts = pulumi.ResourceOptions(depends_on=[scm_label_example]))
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the folder
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] labels: Labels assigned to the folder
        :param pulumi.Input[_builtins.str] name: The name of the folder
        :param pulumi.Input[_builtins.str] parent: The parent folder
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] snippets: Snippets associated with the folder
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FolderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Folder resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        #
        # Creates a folder under the "All Firewalls" aka "ngfw-shared" folder
        #
        scm_folder_example = scm.Folder("scm_folder_example",
            name="scm_folder_example",
            parent="ngfw-shared",
            description="Managed by Pulumi")
        #
        # Creates a folder under the "scm_folder_example" folder created beforehand
        #
        scm_nested_folder_example = scm.Folder("scm_nested_folder_example",
            name="scm_nested_folder_example",
            parent="scm_folder_example",
            description="Managed by Pulumi",
            opts = pulumi.ResourceOptions(depends_on=[scm_folder_example]))
        #
        # Creates a snippet that will be associated to a folder
        #
        scm_snippet_example = scm.Snippet("scm_snippet_example",
            name="scm_snippet_example",
            description="Managed by Pulumi")
        #
        # Creates a folder with an attached snippet
        #
        scm_folder_with_snippets = scm.Folder("scm_folder_with_snippets",
            name="scm_folder_with_snippets",
            parent="ngfw-shared",
            description="Managed by Pulumi",
            snippets=[scm_snippet_example.name])
        #
        # Creates a label that will be associated to a folder
        #
        scm_label_example = scm.Label("scm_label_example",
            name="scm_label_example",
            description="Managed by Pulumi")
        #
        # Creates a folder with an attached label
        #
        scm_folder_with_label = scm.Folder("scm_folder_with_label",
            name="scm_folder_with_label",
            parent="ngfw-shared",
            description="Managed by Pulumi",
            labels=[scm_label_example.name],
            opts = pulumi.ResourceOptions(depends_on=[scm_label_example]))
        ```

        :param str resource_name: The name of the resource.
        :param FolderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FolderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 snippets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FolderArgs.__new__(FolderArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            if parent is None and not opts.urn:
                raise TypeError("Missing required property 'parent'")
            __props__.__dict__["parent"] = parent
            __props__.__dict__["snippets"] = snippets
            __props__.__dict__["tfid"] = None
        super(Folder, __self__).__init__(
            'scm:index/folder:Folder',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parent: Optional[pulumi.Input[_builtins.str]] = None,
            snippets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tfid: Optional[pulumi.Input[_builtins.str]] = None) -> 'Folder':
        """
        Get an existing Folder resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the folder
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] labels: Labels assigned to the folder
        :param pulumi.Input[_builtins.str] name: The name of the folder
        :param pulumi.Input[_builtins.str] parent: The parent folder
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] snippets: Snippets associated with the folder
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FolderState.__new__(_FolderState)

        __props__.__dict__["description"] = description
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["parent"] = parent
        __props__.__dict__["snippets"] = snippets
        __props__.__dict__["tfid"] = tfid
        return Folder(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the folder
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Labels assigned to the folder
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the folder
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def parent(self) -> pulumi.Output[_builtins.str]:
        """
        The parent folder
        """
        return pulumi.get(self, "parent")

    @_builtins.property
    @pulumi.getter
    def snippets(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Snippets associated with the folder
        """
        return pulumi.get(self, "snippets")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tfid")

