# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetAddressGroupResult',
    'AwaitableGetAddressGroupResult',
    'get_address_group',
    'get_address_group_output',
]

@pulumi.output_type
class GetAddressGroupResult:
    """
    A collection of values returned by getAddressGroup.
    """
    def __init__(__self__, description=None, device=None, dynamic=None, folder=None, id=None, name=None, snippet=None, statics=None, tags=None, tfid=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if device and not isinstance(device, str):
            raise TypeError("Expected argument 'device' to be a str")
        pulumi.set(__self__, "device", device)
        if dynamic and not isinstance(dynamic, dict):
            raise TypeError("Expected argument 'dynamic' to be a dict")
        pulumi.set(__self__, "dynamic", dynamic)
        if folder and not isinstance(folder, str):
            raise TypeError("Expected argument 'folder' to be a str")
        pulumi.set(__self__, "folder", folder)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if snippet and not isinstance(snippet, str):
            raise TypeError("Expected argument 'snippet' to be a str")
        pulumi.set(__self__, "snippet", snippet)
        if statics and not isinstance(statics, list):
            raise TypeError("Expected argument 'statics' to be a list")
        pulumi.set(__self__, "statics", statics)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if tfid and not isinstance(tfid, str):
            raise TypeError("Expected argument 'tfid' to be a str")
        pulumi.set(__self__, "tfid", tfid)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def device(self) -> _builtins.str:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter
    def dynamic(self) -> 'outputs.GetAddressGroupDynamicResult':
        """
        Dynamic
        """
        return pulumi.get(self, "dynamic")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> _builtins.str:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The UUID of the address group
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the address group
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> _builtins.str:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def statics(self) -> Sequence[_builtins.str]:
        """
        Static
        """
        return pulumi.get(self, "statics")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        Tags for address group object
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> _builtins.str:
        return pulumi.get(self, "tfid")


class AwaitableGetAddressGroupResult(GetAddressGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAddressGroupResult(
            description=self.description,
            device=self.device,
            dynamic=self.dynamic,
            folder=self.folder,
            id=self.id,
            name=self.name,
            snippet=self.snippet,
            statics=self.statics,
            tags=self.tags,
            tfid=self.tfid)


def get_address_group(id: Optional[_builtins.str] = None,
                      name: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAddressGroupResult:
    """
    AddressGroup data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    # Look up the address group by its ID.
    scm_address_group_ds = scm.get_address_group(id="99802bce-76c6-42c9-801e-e2e4529bb335")
    pulumi.export("addressGroupOutputs", {
        "groupId": scm_address_group_ds.id,
        "folder": scm_address_group_ds.folder,
        "name": scm_address_group_ds.name,
        "description": scm_address_group_ds.description,
        "static": scm_address_group_ds.statics,
    })
    ```


    :param _builtins.str id: The UUID of the address group
    :param _builtins.str name: The name of the address group
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scm:index/getAddressGroup:getAddressGroup', __args__, opts=opts, typ=GetAddressGroupResult).value

    return AwaitableGetAddressGroupResult(
        description=pulumi.get(__ret__, 'description'),
        device=pulumi.get(__ret__, 'device'),
        dynamic=pulumi.get(__ret__, 'dynamic'),
        folder=pulumi.get(__ret__, 'folder'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        snippet=pulumi.get(__ret__, 'snippet'),
        statics=pulumi.get(__ret__, 'statics'),
        tags=pulumi.get(__ret__, 'tags'),
        tfid=pulumi.get(__ret__, 'tfid'))
def get_address_group_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                             name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAddressGroupResult]:
    """
    AddressGroup data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    # Look up the address group by its ID.
    scm_address_group_ds = scm.get_address_group(id="99802bce-76c6-42c9-801e-e2e4529bb335")
    pulumi.export("addressGroupOutputs", {
        "groupId": scm_address_group_ds.id,
        "folder": scm_address_group_ds.folder,
        "name": scm_address_group_ds.name,
        "description": scm_address_group_ds.description,
        "static": scm_address_group_ds.statics,
    })
    ```


    :param _builtins.str id: The UUID of the address group
    :param _builtins.str name: The name of the address group
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scm:index/getAddressGroup:getAddressGroup', __args__, opts=opts, typ=GetAddressGroupResult)
    return __ret__.apply(lambda __response__: GetAddressGroupResult(
        description=pulumi.get(__response__, 'description'),
        device=pulumi.get(__response__, 'device'),
        dynamic=pulumi.get(__response__, 'dynamic'),
        folder=pulumi.get(__response__, 'folder'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        snippet=pulumi.get(__response__, 'snippet'),
        statics=pulumi.get(__response__, 'statics'),
        tags=pulumi.get(__response__, 'tags'),
        tfid=pulumi.get(__response__, 'tfid')))
