# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetAntiSpywareProfileResult',
    'AwaitableGetAntiSpywareProfileResult',
    'get_anti_spyware_profile',
    'get_anti_spyware_profile_output',
]

@pulumi.output_type
class GetAntiSpywareProfileResult:
    """
    A collection of values returned by getAntiSpywareProfile.
    """
    def __init__(__self__, cloud_inline_analysis=None, description=None, device=None, folder=None, id=None, inline_exception_edl_urls=None, inline_exception_ip_addresses=None, mica_engine_spyware_enableds=None, name=None, rules=None, snippet=None, tfid=None, threat_exceptions=None):
        if cloud_inline_analysis and not isinstance(cloud_inline_analysis, bool):
            raise TypeError("Expected argument 'cloud_inline_analysis' to be a bool")
        pulumi.set(__self__, "cloud_inline_analysis", cloud_inline_analysis)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if device and not isinstance(device, str):
            raise TypeError("Expected argument 'device' to be a str")
        pulumi.set(__self__, "device", device)
        if folder and not isinstance(folder, str):
            raise TypeError("Expected argument 'folder' to be a str")
        pulumi.set(__self__, "folder", folder)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if inline_exception_edl_urls and not isinstance(inline_exception_edl_urls, list):
            raise TypeError("Expected argument 'inline_exception_edl_urls' to be a list")
        pulumi.set(__self__, "inline_exception_edl_urls", inline_exception_edl_urls)
        if inline_exception_ip_addresses and not isinstance(inline_exception_ip_addresses, list):
            raise TypeError("Expected argument 'inline_exception_ip_addresses' to be a list")
        pulumi.set(__self__, "inline_exception_ip_addresses", inline_exception_ip_addresses)
        if mica_engine_spyware_enableds and not isinstance(mica_engine_spyware_enableds, list):
            raise TypeError("Expected argument 'mica_engine_spyware_enableds' to be a list")
        pulumi.set(__self__, "mica_engine_spyware_enableds", mica_engine_spyware_enableds)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if rules and not isinstance(rules, list):
            raise TypeError("Expected argument 'rules' to be a list")
        pulumi.set(__self__, "rules", rules)
        if snippet and not isinstance(snippet, str):
            raise TypeError("Expected argument 'snippet' to be a str")
        pulumi.set(__self__, "snippet", snippet)
        if tfid and not isinstance(tfid, str):
            raise TypeError("Expected argument 'tfid' to be a str")
        pulumi.set(__self__, "tfid", tfid)
        if threat_exceptions and not isinstance(threat_exceptions, list):
            raise TypeError("Expected argument 'threat_exceptions' to be a list")
        pulumi.set(__self__, "threat_exceptions", threat_exceptions)

    @_builtins.property
    @pulumi.getter(name="cloudInlineAnalysis")
    def cloud_inline_analysis(self) -> _builtins.bool:
        """
        Cloud inline analysis
        """
        return pulumi.get(self, "cloud_inline_analysis")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def device(self) -> _builtins.str:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> _builtins.str:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The UUID of the anti-spyware profile
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="inlineExceptionEdlUrls")
    def inline_exception_edl_urls(self) -> Sequence[_builtins.str]:
        """
        Inline exception edl url
        """
        return pulumi.get(self, "inline_exception_edl_urls")

    @_builtins.property
    @pulumi.getter(name="inlineExceptionIpAddresses")
    def inline_exception_ip_addresses(self) -> Sequence[_builtins.str]:
        """
        Inline exception ip address
        """
        return pulumi.get(self, "inline_exception_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="micaEngineSpywareEnableds")
    def mica_engine_spyware_enableds(self) -> Sequence['outputs.GetAntiSpywareProfileMicaEngineSpywareEnabledResult']:
        """
        Mica engine spyware enabled
        """
        return pulumi.get(self, "mica_engine_spyware_enableds")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the anti-spyware profile
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetAntiSpywareProfileRuleResult']:
        """
        Rules
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> _builtins.str:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> _builtins.str:
        return pulumi.get(self, "tfid")

    @_builtins.property
    @pulumi.getter(name="threatExceptions")
    def threat_exceptions(self) -> Sequence['outputs.GetAntiSpywareProfileThreatExceptionResult']:
        """
        Threat exception
        """
        return pulumi.get(self, "threat_exceptions")


class AwaitableGetAntiSpywareProfileResult(GetAntiSpywareProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAntiSpywareProfileResult(
            cloud_inline_analysis=self.cloud_inline_analysis,
            description=self.description,
            device=self.device,
            folder=self.folder,
            id=self.id,
            inline_exception_edl_urls=self.inline_exception_edl_urls,
            inline_exception_ip_addresses=self.inline_exception_ip_addresses,
            mica_engine_spyware_enableds=self.mica_engine_spyware_enableds,
            name=self.name,
            rules=self.rules,
            snippet=self.snippet,
            tfid=self.tfid,
            threat_exceptions=self.threat_exceptions)


def get_anti_spyware_profile(id: Optional[_builtins.str] = None,
                             name: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAntiSpywareProfileResult:
    """
    AntiSpywareProfile data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    # Look up anti-spyware-profile by ID
    scm_anti_spyware_profile_ds = scm.get_anti_spyware_profile(id="7720ab77-d9fe-42c1-8001-6ef2202aae8c")
    pulumi.export("scmAntiSpywareProfileOutput", {
        "profileId": scm_anti_spyware_profile_ds.id,
        "folder": scm_anti_spyware_profile_ds.folder,
        "name": scm_anti_spyware_profile_ds.name,
        "description": scm_anti_spyware_profile_ds.description,
        "cloudInlineAnalysis": scm_anti_spyware_profile_ds.cloud_inline_analysis,
    })
    ```


    :param _builtins.str id: The UUID of the anti-spyware profile
    :param _builtins.str name: The name of the anti-spyware profile
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scm:index/getAntiSpywareProfile:getAntiSpywareProfile', __args__, opts=opts, typ=GetAntiSpywareProfileResult).value

    return AwaitableGetAntiSpywareProfileResult(
        cloud_inline_analysis=pulumi.get(__ret__, 'cloud_inline_analysis'),
        description=pulumi.get(__ret__, 'description'),
        device=pulumi.get(__ret__, 'device'),
        folder=pulumi.get(__ret__, 'folder'),
        id=pulumi.get(__ret__, 'id'),
        inline_exception_edl_urls=pulumi.get(__ret__, 'inline_exception_edl_urls'),
        inline_exception_ip_addresses=pulumi.get(__ret__, 'inline_exception_ip_addresses'),
        mica_engine_spyware_enableds=pulumi.get(__ret__, 'mica_engine_spyware_enableds'),
        name=pulumi.get(__ret__, 'name'),
        rules=pulumi.get(__ret__, 'rules'),
        snippet=pulumi.get(__ret__, 'snippet'),
        tfid=pulumi.get(__ret__, 'tfid'),
        threat_exceptions=pulumi.get(__ret__, 'threat_exceptions'))
def get_anti_spyware_profile_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                                    name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAntiSpywareProfileResult]:
    """
    AntiSpywareProfile data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    # Look up anti-spyware-profile by ID
    scm_anti_spyware_profile_ds = scm.get_anti_spyware_profile(id="7720ab77-d9fe-42c1-8001-6ef2202aae8c")
    pulumi.export("scmAntiSpywareProfileOutput", {
        "profileId": scm_anti_spyware_profile_ds.id,
        "folder": scm_anti_spyware_profile_ds.folder,
        "name": scm_anti_spyware_profile_ds.name,
        "description": scm_anti_spyware_profile_ds.description,
        "cloudInlineAnalysis": scm_anti_spyware_profile_ds.cloud_inline_analysis,
    })
    ```


    :param _builtins.str id: The UUID of the anti-spyware profile
    :param _builtins.str name: The name of the anti-spyware profile
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scm:index/getAntiSpywareProfile:getAntiSpywareProfile', __args__, opts=opts, typ=GetAntiSpywareProfileResult)
    return __ret__.apply(lambda __response__: GetAntiSpywareProfileResult(
        cloud_inline_analysis=pulumi.get(__response__, 'cloud_inline_analysis'),
        description=pulumi.get(__response__, 'description'),
        device=pulumi.get(__response__, 'device'),
        folder=pulumi.get(__response__, 'folder'),
        id=pulumi.get(__response__, 'id'),
        inline_exception_edl_urls=pulumi.get(__response__, 'inline_exception_edl_urls'),
        inline_exception_ip_addresses=pulumi.get(__response__, 'inline_exception_ip_addresses'),
        mica_engine_spyware_enableds=pulumi.get(__response__, 'mica_engine_spyware_enableds'),
        name=pulumi.get(__response__, 'name'),
        rules=pulumi.get(__response__, 'rules'),
        snippet=pulumi.get(__response__, 'snippet'),
        tfid=pulumi.get(__response__, 'tfid'),
        threat_exceptions=pulumi.get(__response__, 'threat_exceptions')))
