# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetAppOverrideRuleResult',
    'AwaitableGetAppOverrideRuleResult',
    'get_app_override_rule',
    'get_app_override_rule_output',
]

@pulumi.output_type
class GetAppOverrideRuleResult:
    """
    A collection of values returned by getAppOverrideRule.
    """
    def __init__(__self__, application=None, description=None, destinations=None, device=None, disabled=None, folder=None, froms=None, group_tag=None, id=None, name=None, negate_destination=None, negate_source=None, port=None, position=None, protocol=None, relative_position=None, snippet=None, sources=None, tags=None, target_rule=None, tfid=None, tos=None):
        if application and not isinstance(application, str):
            raise TypeError("Expected argument 'application' to be a str")
        pulumi.set(__self__, "application", application)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if destinations and not isinstance(destinations, list):
            raise TypeError("Expected argument 'destinations' to be a list")
        pulumi.set(__self__, "destinations", destinations)
        if device and not isinstance(device, str):
            raise TypeError("Expected argument 'device' to be a str")
        pulumi.set(__self__, "device", device)
        if disabled and not isinstance(disabled, bool):
            raise TypeError("Expected argument 'disabled' to be a bool")
        pulumi.set(__self__, "disabled", disabled)
        if folder and not isinstance(folder, str):
            raise TypeError("Expected argument 'folder' to be a str")
        pulumi.set(__self__, "folder", folder)
        if froms and not isinstance(froms, list):
            raise TypeError("Expected argument 'froms' to be a list")
        pulumi.set(__self__, "froms", froms)
        if group_tag and not isinstance(group_tag, str):
            raise TypeError("Expected argument 'group_tag' to be a str")
        pulumi.set(__self__, "group_tag", group_tag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if negate_destination and not isinstance(negate_destination, bool):
            raise TypeError("Expected argument 'negate_destination' to be a bool")
        pulumi.set(__self__, "negate_destination", negate_destination)
        if negate_source and not isinstance(negate_source, bool):
            raise TypeError("Expected argument 'negate_source' to be a bool")
        pulumi.set(__self__, "negate_source", negate_source)
        if port and not isinstance(port, str):
            raise TypeError("Expected argument 'port' to be a str")
        pulumi.set(__self__, "port", port)
        if position and not isinstance(position, str):
            raise TypeError("Expected argument 'position' to be a str")
        pulumi.set(__self__, "position", position)
        if protocol and not isinstance(protocol, str):
            raise TypeError("Expected argument 'protocol' to be a str")
        pulumi.set(__self__, "protocol", protocol)
        if relative_position and not isinstance(relative_position, str):
            raise TypeError("Expected argument 'relative_position' to be a str")
        pulumi.set(__self__, "relative_position", relative_position)
        if snippet and not isinstance(snippet, str):
            raise TypeError("Expected argument 'snippet' to be a str")
        pulumi.set(__self__, "snippet", snippet)
        if sources and not isinstance(sources, list):
            raise TypeError("Expected argument 'sources' to be a list")
        pulumi.set(__self__, "sources", sources)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if target_rule and not isinstance(target_rule, str):
            raise TypeError("Expected argument 'target_rule' to be a str")
        pulumi.set(__self__, "target_rule", target_rule)
        if tfid and not isinstance(tfid, str):
            raise TypeError("Expected argument 'tfid' to be a str")
        pulumi.set(__self__, "tfid", tfid)
        if tos and not isinstance(tos, list):
            raise TypeError("Expected argument 'tos' to be a list")
        pulumi.set(__self__, "tos", tos)

    @_builtins.property
    @pulumi.getter
    def application(self) -> _builtins.str:
        """
        Application
        """
        return pulumi.get(self, "application")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> Sequence[_builtins.str]:
        """
        Destination
        """
        return pulumi.get(self, "destinations")

    @_builtins.property
    @pulumi.getter
    def device(self) -> _builtins.str:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> _builtins.bool:
        """
        Disabled
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> _builtins.str:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def froms(self) -> Sequence[_builtins.str]:
        """
        From
        """
        return pulumi.get(self, "froms")

    @_builtins.property
    @pulumi.getter(name="groupTag")
    def group_tag(self) -> _builtins.str:
        """
        Group tag
        """
        return pulumi.get(self, "group_tag")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        UUID of the resource
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="negateDestination")
    def negate_destination(self) -> _builtins.bool:
        """
        Negate destination
        """
        return pulumi.get(self, "negate_destination")

    @_builtins.property
    @pulumi.getter(name="negateSource")
    def negate_source(self) -> _builtins.bool:
        """
        Negate source
        """
        return pulumi.get(self, "negate_source")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.str:
        """
        Port
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def position(self) -> _builtins.str:
        """
        The position of a security rule
        """
        return pulumi.get(self, "position")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        Protocol
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="relativePosition")
    def relative_position(self) -> _builtins.str:
        """
        Relative positioning rule. String must be one of these: `"before"`, `"after"`, `"top"`, `"bottom"`. If not specified, rule is created at the bottom of the ruleset.
        """
        return pulumi.get(self, "relative_position")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> _builtins.str:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Sequence[_builtins.str]:
        """
        Source
        """
        return pulumi.get(self, "sources")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        Tag
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="targetRule")
    def target_rule(self) -> _builtins.str:
        """
        The name or UUID of the rule to position this rule relative to. Required when `relative_position` is `"before"` or `"after"`.
        """
        return pulumi.get(self, "target_rule")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> _builtins.str:
        return pulumi.get(self, "tfid")

    @_builtins.property
    @pulumi.getter
    def tos(self) -> Sequence[_builtins.str]:
        """
        To
        """
        return pulumi.get(self, "tos")


class AwaitableGetAppOverrideRuleResult(GetAppOverrideRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAppOverrideRuleResult(
            application=self.application,
            description=self.description,
            destinations=self.destinations,
            device=self.device,
            disabled=self.disabled,
            folder=self.folder,
            froms=self.froms,
            group_tag=self.group_tag,
            id=self.id,
            name=self.name,
            negate_destination=self.negate_destination,
            negate_source=self.negate_source,
            port=self.port,
            position=self.position,
            protocol=self.protocol,
            relative_position=self.relative_position,
            snippet=self.snippet,
            sources=self.sources,
            tags=self.tags,
            target_rule=self.target_rule,
            tfid=self.tfid,
            tos=self.tos)


def get_app_override_rule(id: Optional[_builtins.str] = None,
                          name: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAppOverrideRuleResult:
    """
    AppOverrideRule data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    # 1. RESOURCE: Create an Application Override rule to ensure a predictable target for lookups
    test_app_override_rule = scm.AppOverrideRule("test_app_override_rule",
        name="data-source-app-override-test",
        description="Rule created specifically for data source testing.",
        folder="All",
        position="pre",
        application="ssl",
        protocol="tcp",
        port="8443",
        froms=["trust"],
        tos=["untrust"],
        sources=["any"],
        destinations=["any"])
    single_rule_by_id = scm.get_app_override_rule_output(id=test_app_override_rule.id)
    pulumi.export("singleAppOverrideRuleName", single_rule_by_id)
    ```


    :param _builtins.str id: UUID of the resource
    :param _builtins.str name: Name
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scm:index/getAppOverrideRule:getAppOverrideRule', __args__, opts=opts, typ=GetAppOverrideRuleResult).value

    return AwaitableGetAppOverrideRuleResult(
        application=pulumi.get(__ret__, 'application'),
        description=pulumi.get(__ret__, 'description'),
        destinations=pulumi.get(__ret__, 'destinations'),
        device=pulumi.get(__ret__, 'device'),
        disabled=pulumi.get(__ret__, 'disabled'),
        folder=pulumi.get(__ret__, 'folder'),
        froms=pulumi.get(__ret__, 'froms'),
        group_tag=pulumi.get(__ret__, 'group_tag'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        negate_destination=pulumi.get(__ret__, 'negate_destination'),
        negate_source=pulumi.get(__ret__, 'negate_source'),
        port=pulumi.get(__ret__, 'port'),
        position=pulumi.get(__ret__, 'position'),
        protocol=pulumi.get(__ret__, 'protocol'),
        relative_position=pulumi.get(__ret__, 'relative_position'),
        snippet=pulumi.get(__ret__, 'snippet'),
        sources=pulumi.get(__ret__, 'sources'),
        tags=pulumi.get(__ret__, 'tags'),
        target_rule=pulumi.get(__ret__, 'target_rule'),
        tfid=pulumi.get(__ret__, 'tfid'),
        tos=pulumi.get(__ret__, 'tos'))
def get_app_override_rule_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                                 name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAppOverrideRuleResult]:
    """
    AppOverrideRule data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    # 1. RESOURCE: Create an Application Override rule to ensure a predictable target for lookups
    test_app_override_rule = scm.AppOverrideRule("test_app_override_rule",
        name="data-source-app-override-test",
        description="Rule created specifically for data source testing.",
        folder="All",
        position="pre",
        application="ssl",
        protocol="tcp",
        port="8443",
        froms=["trust"],
        tos=["untrust"],
        sources=["any"],
        destinations=["any"])
    single_rule_by_id = scm.get_app_override_rule_output(id=test_app_override_rule.id)
    pulumi.export("singleAppOverrideRuleName", single_rule_by_id)
    ```


    :param _builtins.str id: UUID of the resource
    :param _builtins.str name: Name
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scm:index/getAppOverrideRule:getAppOverrideRule', __args__, opts=opts, typ=GetAppOverrideRuleResult)
    return __ret__.apply(lambda __response__: GetAppOverrideRuleResult(
        application=pulumi.get(__response__, 'application'),
        description=pulumi.get(__response__, 'description'),
        destinations=pulumi.get(__response__, 'destinations'),
        device=pulumi.get(__response__, 'device'),
        disabled=pulumi.get(__response__, 'disabled'),
        folder=pulumi.get(__response__, 'folder'),
        froms=pulumi.get(__response__, 'froms'),
        group_tag=pulumi.get(__response__, 'group_tag'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        negate_destination=pulumi.get(__response__, 'negate_destination'),
        negate_source=pulumi.get(__response__, 'negate_source'),
        port=pulumi.get(__response__, 'port'),
        position=pulumi.get(__response__, 'position'),
        protocol=pulumi.get(__response__, 'protocol'),
        relative_position=pulumi.get(__response__, 'relative_position'),
        snippet=pulumi.get(__response__, 'snippet'),
        sources=pulumi.get(__response__, 'sources'),
        tags=pulumi.get(__response__, 'tags'),
        target_rule=pulumi.get(__response__, 'target_rule'),
        tfid=pulumi.get(__response__, 'tfid'),
        tos=pulumi.get(__response__, 'tos')))
