# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetApplicationFilterResult',
    'AwaitableGetApplicationFilterResult',
    'get_application_filter',
    'get_application_filter_output',
]

@pulumi.output_type
class GetApplicationFilterResult:
    """
    A collection of values returned by getApplicationFilter.
    """
    def __init__(__self__, categories=None, device=None, evasive=None, excessive_bandwidth_use=None, excludes=None, folder=None, has_known_vulnerabilities=None, id=None, is_saas=None, name=None, new_appid=None, pervasive=None, prone_to_misuse=None, risks=None, saas_certifications=None, saas_risks=None, snippet=None, subcategories=None, tagging=None, technologies=None, tfid=None, transfers_files=None, tunnels_other_apps=None, used_by_malware=None):
        if categories and not isinstance(categories, list):
            raise TypeError("Expected argument 'categories' to be a list")
        pulumi.set(__self__, "categories", categories)
        if device and not isinstance(device, str):
            raise TypeError("Expected argument 'device' to be a str")
        pulumi.set(__self__, "device", device)
        if evasive and not isinstance(evasive, bool):
            raise TypeError("Expected argument 'evasive' to be a bool")
        pulumi.set(__self__, "evasive", evasive)
        if excessive_bandwidth_use and not isinstance(excessive_bandwidth_use, bool):
            raise TypeError("Expected argument 'excessive_bandwidth_use' to be a bool")
        pulumi.set(__self__, "excessive_bandwidth_use", excessive_bandwidth_use)
        if excludes and not isinstance(excludes, list):
            raise TypeError("Expected argument 'excludes' to be a list")
        pulumi.set(__self__, "excludes", excludes)
        if folder and not isinstance(folder, str):
            raise TypeError("Expected argument 'folder' to be a str")
        pulumi.set(__self__, "folder", folder)
        if has_known_vulnerabilities and not isinstance(has_known_vulnerabilities, bool):
            raise TypeError("Expected argument 'has_known_vulnerabilities' to be a bool")
        pulumi.set(__self__, "has_known_vulnerabilities", has_known_vulnerabilities)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_saas and not isinstance(is_saas, bool):
            raise TypeError("Expected argument 'is_saas' to be a bool")
        pulumi.set(__self__, "is_saas", is_saas)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if new_appid and not isinstance(new_appid, bool):
            raise TypeError("Expected argument 'new_appid' to be a bool")
        pulumi.set(__self__, "new_appid", new_appid)
        if pervasive and not isinstance(pervasive, bool):
            raise TypeError("Expected argument 'pervasive' to be a bool")
        pulumi.set(__self__, "pervasive", pervasive)
        if prone_to_misuse and not isinstance(prone_to_misuse, bool):
            raise TypeError("Expected argument 'prone_to_misuse' to be a bool")
        pulumi.set(__self__, "prone_to_misuse", prone_to_misuse)
        if risks and not isinstance(risks, list):
            raise TypeError("Expected argument 'risks' to be a list")
        pulumi.set(__self__, "risks", risks)
        if saas_certifications and not isinstance(saas_certifications, list):
            raise TypeError("Expected argument 'saas_certifications' to be a list")
        pulumi.set(__self__, "saas_certifications", saas_certifications)
        if saas_risks and not isinstance(saas_risks, list):
            raise TypeError("Expected argument 'saas_risks' to be a list")
        pulumi.set(__self__, "saas_risks", saas_risks)
        if snippet and not isinstance(snippet, str):
            raise TypeError("Expected argument 'snippet' to be a str")
        pulumi.set(__self__, "snippet", snippet)
        if subcategories and not isinstance(subcategories, list):
            raise TypeError("Expected argument 'subcategories' to be a list")
        pulumi.set(__self__, "subcategories", subcategories)
        if tagging and not isinstance(tagging, dict):
            raise TypeError("Expected argument 'tagging' to be a dict")
        pulumi.set(__self__, "tagging", tagging)
        if technologies and not isinstance(technologies, list):
            raise TypeError("Expected argument 'technologies' to be a list")
        pulumi.set(__self__, "technologies", technologies)
        if tfid and not isinstance(tfid, str):
            raise TypeError("Expected argument 'tfid' to be a str")
        pulumi.set(__self__, "tfid", tfid)
        if transfers_files and not isinstance(transfers_files, bool):
            raise TypeError("Expected argument 'transfers_files' to be a bool")
        pulumi.set(__self__, "transfers_files", transfers_files)
        if tunnels_other_apps and not isinstance(tunnels_other_apps, bool):
            raise TypeError("Expected argument 'tunnels_other_apps' to be a bool")
        pulumi.set(__self__, "tunnels_other_apps", tunnels_other_apps)
        if used_by_malware and not isinstance(used_by_malware, bool):
            raise TypeError("Expected argument 'used_by_malware' to be a bool")
        pulumi.set(__self__, "used_by_malware", used_by_malware)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Sequence[_builtins.str]:
        """
        Category
        """
        return pulumi.get(self, "categories")

    @_builtins.property
    @pulumi.getter
    def device(self) -> _builtins.str:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter
    def evasive(self) -> _builtins.bool:
        """
        only True is a valid value
        """
        return pulumi.get(self, "evasive")

    @_builtins.property
    @pulumi.getter(name="excessiveBandwidthUse")
    def excessive_bandwidth_use(self) -> _builtins.bool:
        """
        only True is a valid value
        """
        return pulumi.get(self, "excessive_bandwidth_use")

    @_builtins.property
    @pulumi.getter
    def excludes(self) -> Sequence[_builtins.str]:
        """
        Exclude
        """
        return pulumi.get(self, "excludes")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> _builtins.str:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter(name="hasKnownVulnerabilities")
    def has_known_vulnerabilities(self) -> _builtins.bool:
        """
        only True is a valid value
        """
        return pulumi.get(self, "has_known_vulnerabilities")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        UUID of the resource
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isSaas")
    def is_saas(self) -> _builtins.bool:
        """
        only True is a valid value
        """
        return pulumi.get(self, "is_saas")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Alphanumeric string [ 0-9a-zA-Z._-]
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="newAppid")
    def new_appid(self) -> _builtins.bool:
        """
        only True is a valid value
        """
        return pulumi.get(self, "new_appid")

    @_builtins.property
    @pulumi.getter
    def pervasive(self) -> _builtins.bool:
        """
        only True is a valid value
        """
        return pulumi.get(self, "pervasive")

    @_builtins.property
    @pulumi.getter(name="proneToMisuse")
    def prone_to_misuse(self) -> _builtins.bool:
        """
        only True is a valid value
        """
        return pulumi.get(self, "prone_to_misuse")

    @_builtins.property
    @pulumi.getter
    def risks(self) -> Sequence[_builtins.int]:
        """
        Risk
        """
        return pulumi.get(self, "risks")

    @_builtins.property
    @pulumi.getter(name="saasCertifications")
    def saas_certifications(self) -> Sequence[_builtins.str]:
        """
        Saas certifications
        """
        return pulumi.get(self, "saas_certifications")

    @_builtins.property
    @pulumi.getter(name="saasRisks")
    def saas_risks(self) -> Sequence[_builtins.str]:
        """
        Saas risk
        """
        return pulumi.get(self, "saas_risks")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> _builtins.str:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def subcategories(self) -> Sequence[_builtins.str]:
        """
        Subcategory
        """
        return pulumi.get(self, "subcategories")

    @_builtins.property
    @pulumi.getter
    def tagging(self) -> 'outputs.GetApplicationFilterTaggingResult':
        """
        Tagging
        """
        return pulumi.get(self, "tagging")

    @_builtins.property
    @pulumi.getter
    def technologies(self) -> Sequence[_builtins.str]:
        """
        Technology
        """
        return pulumi.get(self, "technologies")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> _builtins.str:
        return pulumi.get(self, "tfid")

    @_builtins.property
    @pulumi.getter(name="transfersFiles")
    def transfers_files(self) -> _builtins.bool:
        """
        only True is a valid value
        """
        return pulumi.get(self, "transfers_files")

    @_builtins.property
    @pulumi.getter(name="tunnelsOtherApps")
    def tunnels_other_apps(self) -> _builtins.bool:
        """
        only True is a valid value
        """
        return pulumi.get(self, "tunnels_other_apps")

    @_builtins.property
    @pulumi.getter(name="usedByMalware")
    def used_by_malware(self) -> _builtins.bool:
        """
        only True is a valid value
        """
        return pulumi.get(self, "used_by_malware")


class AwaitableGetApplicationFilterResult(GetApplicationFilterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApplicationFilterResult(
            categories=self.categories,
            device=self.device,
            evasive=self.evasive,
            excessive_bandwidth_use=self.excessive_bandwidth_use,
            excludes=self.excludes,
            folder=self.folder,
            has_known_vulnerabilities=self.has_known_vulnerabilities,
            id=self.id,
            is_saas=self.is_saas,
            name=self.name,
            new_appid=self.new_appid,
            pervasive=self.pervasive,
            prone_to_misuse=self.prone_to_misuse,
            risks=self.risks,
            saas_certifications=self.saas_certifications,
            saas_risks=self.saas_risks,
            snippet=self.snippet,
            subcategories=self.subcategories,
            tagging=self.tagging,
            technologies=self.technologies,
            tfid=self.tfid,
            transfers_files=self.transfers_files,
            tunnels_other_apps=self.tunnels_other_apps,
            used_by_malware=self.used_by_malware)


def get_application_filter(id: Optional[_builtins.str] = None,
                           name: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApplicationFilterResult:
    """
    ApplicationFilter data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    scm_application_filter_ds = scm.get_application_filter(id="52ee6475-a99c-42d7-be0a-e251c05e805b")
    pulumi.export("applicationFiltersDataSourceResults", scm_application_filter_ds)
    ```


    :param _builtins.str id: UUID of the resource
    :param _builtins.str name: Alphanumeric string [ 0-9a-zA-Z._-]
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scm:index/getApplicationFilter:getApplicationFilter', __args__, opts=opts, typ=GetApplicationFilterResult).value

    return AwaitableGetApplicationFilterResult(
        categories=pulumi.get(__ret__, 'categories'),
        device=pulumi.get(__ret__, 'device'),
        evasive=pulumi.get(__ret__, 'evasive'),
        excessive_bandwidth_use=pulumi.get(__ret__, 'excessive_bandwidth_use'),
        excludes=pulumi.get(__ret__, 'excludes'),
        folder=pulumi.get(__ret__, 'folder'),
        has_known_vulnerabilities=pulumi.get(__ret__, 'has_known_vulnerabilities'),
        id=pulumi.get(__ret__, 'id'),
        is_saas=pulumi.get(__ret__, 'is_saas'),
        name=pulumi.get(__ret__, 'name'),
        new_appid=pulumi.get(__ret__, 'new_appid'),
        pervasive=pulumi.get(__ret__, 'pervasive'),
        prone_to_misuse=pulumi.get(__ret__, 'prone_to_misuse'),
        risks=pulumi.get(__ret__, 'risks'),
        saas_certifications=pulumi.get(__ret__, 'saas_certifications'),
        saas_risks=pulumi.get(__ret__, 'saas_risks'),
        snippet=pulumi.get(__ret__, 'snippet'),
        subcategories=pulumi.get(__ret__, 'subcategories'),
        tagging=pulumi.get(__ret__, 'tagging'),
        technologies=pulumi.get(__ret__, 'technologies'),
        tfid=pulumi.get(__ret__, 'tfid'),
        transfers_files=pulumi.get(__ret__, 'transfers_files'),
        tunnels_other_apps=pulumi.get(__ret__, 'tunnels_other_apps'),
        used_by_malware=pulumi.get(__ret__, 'used_by_malware'))
def get_application_filter_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                                  name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApplicationFilterResult]:
    """
    ApplicationFilter data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    scm_application_filter_ds = scm.get_application_filter(id="52ee6475-a99c-42d7-be0a-e251c05e805b")
    pulumi.export("applicationFiltersDataSourceResults", scm_application_filter_ds)
    ```


    :param _builtins.str id: UUID of the resource
    :param _builtins.str name: Alphanumeric string [ 0-9a-zA-Z._-]
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scm:index/getApplicationFilter:getApplicationFilter', __args__, opts=opts, typ=GetApplicationFilterResult)
    return __ret__.apply(lambda __response__: GetApplicationFilterResult(
        categories=pulumi.get(__response__, 'categories'),
        device=pulumi.get(__response__, 'device'),
        evasive=pulumi.get(__response__, 'evasive'),
        excessive_bandwidth_use=pulumi.get(__response__, 'excessive_bandwidth_use'),
        excludes=pulumi.get(__response__, 'excludes'),
        folder=pulumi.get(__response__, 'folder'),
        has_known_vulnerabilities=pulumi.get(__response__, 'has_known_vulnerabilities'),
        id=pulumi.get(__response__, 'id'),
        is_saas=pulumi.get(__response__, 'is_saas'),
        name=pulumi.get(__response__, 'name'),
        new_appid=pulumi.get(__response__, 'new_appid'),
        pervasive=pulumi.get(__response__, 'pervasive'),
        prone_to_misuse=pulumi.get(__response__, 'prone_to_misuse'),
        risks=pulumi.get(__response__, 'risks'),
        saas_certifications=pulumi.get(__response__, 'saas_certifications'),
        saas_risks=pulumi.get(__response__, 'saas_risks'),
        snippet=pulumi.get(__response__, 'snippet'),
        subcategories=pulumi.get(__response__, 'subcategories'),
        tagging=pulumi.get(__response__, 'tagging'),
        technologies=pulumi.get(__response__, 'technologies'),
        tfid=pulumi.get(__response__, 'tfid'),
        transfers_files=pulumi.get(__response__, 'transfers_files'),
        tunnels_other_apps=pulumi.get(__response__, 'tunnels_other_apps'),
        used_by_malware=pulumi.get(__response__, 'used_by_malware')))
