# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetDecryptionProfileResult',
    'AwaitableGetDecryptionProfileResult',
    'get_decryption_profile',
    'get_decryption_profile_output',
]

@pulumi.output_type
class GetDecryptionProfileResult:
    """
    A collection of values returned by getDecryptionProfile.
    """
    def __init__(__self__, device=None, folder=None, id=None, name=None, snippet=None, ssl_forward_proxy=None, ssl_inbound_proxy=None, ssl_no_proxy=None, ssl_protocol_settings=None, tfid=None):
        if device and not isinstance(device, str):
            raise TypeError("Expected argument 'device' to be a str")
        pulumi.set(__self__, "device", device)
        if folder and not isinstance(folder, str):
            raise TypeError("Expected argument 'folder' to be a str")
        pulumi.set(__self__, "folder", folder)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if snippet and not isinstance(snippet, str):
            raise TypeError("Expected argument 'snippet' to be a str")
        pulumi.set(__self__, "snippet", snippet)
        if ssl_forward_proxy and not isinstance(ssl_forward_proxy, dict):
            raise TypeError("Expected argument 'ssl_forward_proxy' to be a dict")
        pulumi.set(__self__, "ssl_forward_proxy", ssl_forward_proxy)
        if ssl_inbound_proxy and not isinstance(ssl_inbound_proxy, dict):
            raise TypeError("Expected argument 'ssl_inbound_proxy' to be a dict")
        pulumi.set(__self__, "ssl_inbound_proxy", ssl_inbound_proxy)
        if ssl_no_proxy and not isinstance(ssl_no_proxy, dict):
            raise TypeError("Expected argument 'ssl_no_proxy' to be a dict")
        pulumi.set(__self__, "ssl_no_proxy", ssl_no_proxy)
        if ssl_protocol_settings and not isinstance(ssl_protocol_settings, dict):
            raise TypeError("Expected argument 'ssl_protocol_settings' to be a dict")
        pulumi.set(__self__, "ssl_protocol_settings", ssl_protocol_settings)
        if tfid and not isinstance(tfid, str):
            raise TypeError("Expected argument 'tfid' to be a str")
        pulumi.set(__self__, "tfid", tfid)

    @_builtins.property
    @pulumi.getter
    def device(self) -> _builtins.str:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> _builtins.str:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        UUID of the resource
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Must start with alphanumeric char and should contain only alphanemeric, underscore, hyphen, dot or space
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> _builtins.str:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter(name="sslForwardProxy")
    def ssl_forward_proxy(self) -> 'outputs.GetDecryptionProfileSslForwardProxyResult':
        """
        Ssl forward proxy
        """
        return pulumi.get(self, "ssl_forward_proxy")

    @_builtins.property
    @pulumi.getter(name="sslInboundProxy")
    def ssl_inbound_proxy(self) -> 'outputs.GetDecryptionProfileSslInboundProxyResult':
        """
        Ssl inbound proxy
        """
        return pulumi.get(self, "ssl_inbound_proxy")

    @_builtins.property
    @pulumi.getter(name="sslNoProxy")
    def ssl_no_proxy(self) -> 'outputs.GetDecryptionProfileSslNoProxyResult':
        """
        Ssl no proxy
        """
        return pulumi.get(self, "ssl_no_proxy")

    @_builtins.property
    @pulumi.getter(name="sslProtocolSettings")
    def ssl_protocol_settings(self) -> 'outputs.GetDecryptionProfileSslProtocolSettingsResult':
        """
        Ssl protocol settings
        """
        return pulumi.get(self, "ssl_protocol_settings")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> _builtins.str:
        return pulumi.get(self, "tfid")


class AwaitableGetDecryptionProfileResult(GetDecryptionProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDecryptionProfileResult(
            device=self.device,
            folder=self.folder,
            id=self.id,
            name=self.name,
            snippet=self.snippet,
            ssl_forward_proxy=self.ssl_forward_proxy,
            ssl_inbound_proxy=self.ssl_inbound_proxy,
            ssl_no_proxy=self.ssl_no_proxy,
            ssl_protocol_settings=self.ssl_protocol_settings,
            tfid=self.tfid)


def get_decryption_profile(id: Optional[_builtins.str] = None,
                           name: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDecryptionProfileResult:
    """
    DecryptionProfile data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    #
    # Data source to retrieve a single SCM Decryption Profile object by its ID.
    #
    # Replace the ID with the UUID of the SCM Decryption Profile you want to find.
    scm_dp_profile = scm.get_decryption_profile(id="c7629092-d286-400b-ba3f-1d57b8065645")
    pulumi.export("scmDecryptionProfileDetails", {
        "profileId": scm_dp_profile.id,
        "folder": scm_dp_profile.folder,
        "name": scm_dp_profile.name,
    })
    ```


    :param _builtins.str id: UUID of the resource
    :param _builtins.str name: Must start with alphanumeric char and should contain only alphanemeric, underscore, hyphen, dot or space
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scm:index/getDecryptionProfile:getDecryptionProfile', __args__, opts=opts, typ=GetDecryptionProfileResult).value

    return AwaitableGetDecryptionProfileResult(
        device=pulumi.get(__ret__, 'device'),
        folder=pulumi.get(__ret__, 'folder'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        snippet=pulumi.get(__ret__, 'snippet'),
        ssl_forward_proxy=pulumi.get(__ret__, 'ssl_forward_proxy'),
        ssl_inbound_proxy=pulumi.get(__ret__, 'ssl_inbound_proxy'),
        ssl_no_proxy=pulumi.get(__ret__, 'ssl_no_proxy'),
        ssl_protocol_settings=pulumi.get(__ret__, 'ssl_protocol_settings'),
        tfid=pulumi.get(__ret__, 'tfid'))
def get_decryption_profile_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                                  name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDecryptionProfileResult]:
    """
    DecryptionProfile data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    #
    # Data source to retrieve a single SCM Decryption Profile object by its ID.
    #
    # Replace the ID with the UUID of the SCM Decryption Profile you want to find.
    scm_dp_profile = scm.get_decryption_profile(id="c7629092-d286-400b-ba3f-1d57b8065645")
    pulumi.export("scmDecryptionProfileDetails", {
        "profileId": scm_dp_profile.id,
        "folder": scm_dp_profile.folder,
        "name": scm_dp_profile.name,
    })
    ```


    :param _builtins.str id: UUID of the resource
    :param _builtins.str name: Must start with alphanumeric char and should contain only alphanemeric, underscore, hyphen, dot or space
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scm:index/getDecryptionProfile:getDecryptionProfile', __args__, opts=opts, typ=GetDecryptionProfileResult)
    return __ret__.apply(lambda __response__: GetDecryptionProfileResult(
        device=pulumi.get(__response__, 'device'),
        folder=pulumi.get(__response__, 'folder'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        snippet=pulumi.get(__response__, 'snippet'),
        ssl_forward_proxy=pulumi.get(__response__, 'ssl_forward_proxy'),
        ssl_inbound_proxy=pulumi.get(__response__, 'ssl_inbound_proxy'),
        ssl_no_proxy=pulumi.get(__response__, 'ssl_no_proxy'),
        ssl_protocol_settings=pulumi.get(__response__, 'ssl_protocol_settings'),
        tfid=pulumi.get(__response__, 'tfid')))
