# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetDecryptionRuleResult',
    'AwaitableGetDecryptionRuleResult',
    'get_decryption_rule',
    'get_decryption_rule_output',
]

@pulumi.output_type
class GetDecryptionRuleResult:
    """
    A collection of values returned by getDecryptionRule.
    """
    def __init__(__self__, action=None, categories=None, description=None, destination_hips=None, destinations=None, device=None, disabled=None, folder=None, froms=None, id=None, log_fail=None, log_setting=None, log_success=None, name=None, negate_destination=None, negate_source=None, position=None, profile=None, relative_position=None, services=None, snippet=None, source_hips=None, source_users=None, sources=None, tags=None, target_rule=None, tfid=None, tos=None, type=None):
        if action and not isinstance(action, str):
            raise TypeError("Expected argument 'action' to be a str")
        pulumi.set(__self__, "action", action)
        if categories and not isinstance(categories, list):
            raise TypeError("Expected argument 'categories' to be a list")
        pulumi.set(__self__, "categories", categories)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if destination_hips and not isinstance(destination_hips, list):
            raise TypeError("Expected argument 'destination_hips' to be a list")
        pulumi.set(__self__, "destination_hips", destination_hips)
        if destinations and not isinstance(destinations, list):
            raise TypeError("Expected argument 'destinations' to be a list")
        pulumi.set(__self__, "destinations", destinations)
        if device and not isinstance(device, str):
            raise TypeError("Expected argument 'device' to be a str")
        pulumi.set(__self__, "device", device)
        if disabled and not isinstance(disabled, bool):
            raise TypeError("Expected argument 'disabled' to be a bool")
        pulumi.set(__self__, "disabled", disabled)
        if folder and not isinstance(folder, str):
            raise TypeError("Expected argument 'folder' to be a str")
        pulumi.set(__self__, "folder", folder)
        if froms and not isinstance(froms, list):
            raise TypeError("Expected argument 'froms' to be a list")
        pulumi.set(__self__, "froms", froms)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if log_fail and not isinstance(log_fail, bool):
            raise TypeError("Expected argument 'log_fail' to be a bool")
        pulumi.set(__self__, "log_fail", log_fail)
        if log_setting and not isinstance(log_setting, str):
            raise TypeError("Expected argument 'log_setting' to be a str")
        pulumi.set(__self__, "log_setting", log_setting)
        if log_success and not isinstance(log_success, bool):
            raise TypeError("Expected argument 'log_success' to be a bool")
        pulumi.set(__self__, "log_success", log_success)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if negate_destination and not isinstance(negate_destination, bool):
            raise TypeError("Expected argument 'negate_destination' to be a bool")
        pulumi.set(__self__, "negate_destination", negate_destination)
        if negate_source and not isinstance(negate_source, bool):
            raise TypeError("Expected argument 'negate_source' to be a bool")
        pulumi.set(__self__, "negate_source", negate_source)
        if position and not isinstance(position, str):
            raise TypeError("Expected argument 'position' to be a str")
        pulumi.set(__self__, "position", position)
        if profile and not isinstance(profile, str):
            raise TypeError("Expected argument 'profile' to be a str")
        pulumi.set(__self__, "profile", profile)
        if relative_position and not isinstance(relative_position, str):
            raise TypeError("Expected argument 'relative_position' to be a str")
        pulumi.set(__self__, "relative_position", relative_position)
        if services and not isinstance(services, list):
            raise TypeError("Expected argument 'services' to be a list")
        pulumi.set(__self__, "services", services)
        if snippet and not isinstance(snippet, str):
            raise TypeError("Expected argument 'snippet' to be a str")
        pulumi.set(__self__, "snippet", snippet)
        if source_hips and not isinstance(source_hips, list):
            raise TypeError("Expected argument 'source_hips' to be a list")
        pulumi.set(__self__, "source_hips", source_hips)
        if source_users and not isinstance(source_users, list):
            raise TypeError("Expected argument 'source_users' to be a list")
        pulumi.set(__self__, "source_users", source_users)
        if sources and not isinstance(sources, list):
            raise TypeError("Expected argument 'sources' to be a list")
        pulumi.set(__self__, "sources", sources)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if target_rule and not isinstance(target_rule, str):
            raise TypeError("Expected argument 'target_rule' to be a str")
        pulumi.set(__self__, "target_rule", target_rule)
        if tfid and not isinstance(tfid, str):
            raise TypeError("Expected argument 'tfid' to be a str")
        pulumi.set(__self__, "tfid", tfid)
        if tos and not isinstance(tos, list):
            raise TypeError("Expected argument 'tos' to be a list")
        pulumi.set(__self__, "tos", tos)
        if type and not isinstance(type, dict):
            raise TypeError("Expected argument 'type' to be a dict")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        The action to be taken
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Sequence[_builtins.str]:
        """
        The destination URL category
        """
        return pulumi.get(self, "categories")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the decryption rule
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destinationHips")
    def destination_hips(self) -> Sequence[_builtins.str]:
        """
        The Host Integrity Profile of the destination host
        """
        return pulumi.get(self, "destination_hips")

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> Sequence[_builtins.str]:
        """
        The destination addresses
        """
        return pulumi.get(self, "destinations")

    @_builtins.property
    @pulumi.getter
    def device(self) -> _builtins.str:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> _builtins.bool:
        """
        Is the rule disabled?
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> _builtins.str:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def froms(self) -> Sequence[_builtins.str]:
        """
        The source security zone
        """
        return pulumi.get(self, "froms")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The UUID of the decryption rule
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="logFail")
    def log_fail(self) -> _builtins.bool:
        """
        Log failed decryption events?
        """
        return pulumi.get(self, "log_fail")

    @_builtins.property
    @pulumi.getter(name="logSetting")
    def log_setting(self) -> _builtins.str:
        """
        The log settings of the decryption rule
        """
        return pulumi.get(self, "log_setting")

    @_builtins.property
    @pulumi.getter(name="logSuccess")
    def log_success(self) -> _builtins.bool:
        """
        Log successful decryption events?
        """
        return pulumi.get(self, "log_success")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the decryption rule
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="negateDestination")
    def negate_destination(self) -> _builtins.bool:
        """
        Negate the destination addresses?
        """
        return pulumi.get(self, "negate_destination")

    @_builtins.property
    @pulumi.getter(name="negateSource")
    def negate_source(self) -> _builtins.bool:
        """
        Negate the source addresses?
        """
        return pulumi.get(self, "negate_source")

    @_builtins.property
    @pulumi.getter
    def position(self) -> _builtins.str:
        """
        The position of a security rule
        """
        return pulumi.get(self, "position")

    @_builtins.property
    @pulumi.getter
    def profile(self) -> _builtins.str:
        """
        The decryption profile associated with the decryption rule
        """
        return pulumi.get(self, "profile")

    @_builtins.property
    @pulumi.getter(name="relativePosition")
    def relative_position(self) -> _builtins.str:
        """
        Relative positioning rule. String must be one of these: `"before"`, `"after"`, `"top"`, `"bottom"`. If not specified, rule is created at the bottom of the ruleset.
        """
        return pulumi.get(self, "relative_position")

    @_builtins.property
    @pulumi.getter
    def services(self) -> Sequence[_builtins.str]:
        """
        The destination services and/or service groups
        """
        return pulumi.get(self, "services")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> _builtins.str:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter(name="sourceHips")
    def source_hips(self) -> Sequence[_builtins.str]:
        """
        Source hip
        """
        return pulumi.get(self, "source_hips")

    @_builtins.property
    @pulumi.getter(name="sourceUsers")
    def source_users(self) -> Sequence[_builtins.str]:
        """
        List of source users and/or groups.  Reserved words include `any`, `pre-login`, `known-user`, and `unknown`.
        """
        return pulumi.get(self, "source_users")

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Sequence[_builtins.str]:
        """
        The source addresses
        """
        return pulumi.get(self, "sources")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        The tags associated with the decryption rule
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="targetRule")
    def target_rule(self) -> _builtins.str:
        """
        The name or UUID of the rule to position this rule relative to. Required when `relative_position` is `"before"` or `"after"`.
        """
        return pulumi.get(self, "target_rule")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> _builtins.str:
        return pulumi.get(self, "tfid")

    @_builtins.property
    @pulumi.getter
    def tos(self) -> Sequence[_builtins.str]:
        """
        The destination security zone
        """
        return pulumi.get(self, "tos")

    @_builtins.property
    @pulumi.getter
    def type(self) -> 'outputs.GetDecryptionRuleTypeResult':
        """
        The type of decryption
        """
        return pulumi.get(self, "type")


class AwaitableGetDecryptionRuleResult(GetDecryptionRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDecryptionRuleResult(
            action=self.action,
            categories=self.categories,
            description=self.description,
            destination_hips=self.destination_hips,
            destinations=self.destinations,
            device=self.device,
            disabled=self.disabled,
            folder=self.folder,
            froms=self.froms,
            id=self.id,
            log_fail=self.log_fail,
            log_setting=self.log_setting,
            log_success=self.log_success,
            name=self.name,
            negate_destination=self.negate_destination,
            negate_source=self.negate_source,
            position=self.position,
            profile=self.profile,
            relative_position=self.relative_position,
            services=self.services,
            snippet=self.snippet,
            source_hips=self.source_hips,
            source_users=self.source_users,
            sources=self.sources,
            tags=self.tags,
            target_rule=self.target_rule,
            tfid=self.tfid,
            tos=self.tos,
            type=self.type)


def get_decryption_rule(id: Optional[_builtins.str] = None,
                        name: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDecryptionRuleResult:
    """
    DecryptionRule data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    # 1. RESOURCE: Create a rule to ensure a predictable target for lookups
    test_decryption_rule = scm.DecryptionRule("test_decryption_rule",
        name="data-source-test-rule",
        description="Rule created specifically for data source testing.",
        folder="All",
        position="pre",
        action="decrypt",
        froms=["trust"],
        tos=["untrust"],
        sources=["any"],
        destinations=["any"],
        services=["service-https"],
        categories=["high-risk"],
        source_users=["any"],
        type={
            "ssl_forward_proxy": {},
        })
    # We use the ID from the resource created above.
    single_rule_by_id = scm.get_decryption_rule_output(id=test_decryption_rule.id)
    pulumi.export("singleDecryptionRuleName", single_rule_by_id)
    ```


    :param _builtins.str id: The UUID of the decryption rule
    :param _builtins.str name: The name of the decryption rule
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scm:index/getDecryptionRule:getDecryptionRule', __args__, opts=opts, typ=GetDecryptionRuleResult).value

    return AwaitableGetDecryptionRuleResult(
        action=pulumi.get(__ret__, 'action'),
        categories=pulumi.get(__ret__, 'categories'),
        description=pulumi.get(__ret__, 'description'),
        destination_hips=pulumi.get(__ret__, 'destination_hips'),
        destinations=pulumi.get(__ret__, 'destinations'),
        device=pulumi.get(__ret__, 'device'),
        disabled=pulumi.get(__ret__, 'disabled'),
        folder=pulumi.get(__ret__, 'folder'),
        froms=pulumi.get(__ret__, 'froms'),
        id=pulumi.get(__ret__, 'id'),
        log_fail=pulumi.get(__ret__, 'log_fail'),
        log_setting=pulumi.get(__ret__, 'log_setting'),
        log_success=pulumi.get(__ret__, 'log_success'),
        name=pulumi.get(__ret__, 'name'),
        negate_destination=pulumi.get(__ret__, 'negate_destination'),
        negate_source=pulumi.get(__ret__, 'negate_source'),
        position=pulumi.get(__ret__, 'position'),
        profile=pulumi.get(__ret__, 'profile'),
        relative_position=pulumi.get(__ret__, 'relative_position'),
        services=pulumi.get(__ret__, 'services'),
        snippet=pulumi.get(__ret__, 'snippet'),
        source_hips=pulumi.get(__ret__, 'source_hips'),
        source_users=pulumi.get(__ret__, 'source_users'),
        sources=pulumi.get(__ret__, 'sources'),
        tags=pulumi.get(__ret__, 'tags'),
        target_rule=pulumi.get(__ret__, 'target_rule'),
        tfid=pulumi.get(__ret__, 'tfid'),
        tos=pulumi.get(__ret__, 'tos'),
        type=pulumi.get(__ret__, 'type'))
def get_decryption_rule_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                               name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDecryptionRuleResult]:
    """
    DecryptionRule data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    # 1. RESOURCE: Create a rule to ensure a predictable target for lookups
    test_decryption_rule = scm.DecryptionRule("test_decryption_rule",
        name="data-source-test-rule",
        description="Rule created specifically for data source testing.",
        folder="All",
        position="pre",
        action="decrypt",
        froms=["trust"],
        tos=["untrust"],
        sources=["any"],
        destinations=["any"],
        services=["service-https"],
        categories=["high-risk"],
        source_users=["any"],
        type={
            "ssl_forward_proxy": {},
        })
    # We use the ID from the resource created above.
    single_rule_by_id = scm.get_decryption_rule_output(id=test_decryption_rule.id)
    pulumi.export("singleDecryptionRuleName", single_rule_by_id)
    ```


    :param _builtins.str id: The UUID of the decryption rule
    :param _builtins.str name: The name of the decryption rule
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scm:index/getDecryptionRule:getDecryptionRule', __args__, opts=opts, typ=GetDecryptionRuleResult)
    return __ret__.apply(lambda __response__: GetDecryptionRuleResult(
        action=pulumi.get(__response__, 'action'),
        categories=pulumi.get(__response__, 'categories'),
        description=pulumi.get(__response__, 'description'),
        destination_hips=pulumi.get(__response__, 'destination_hips'),
        destinations=pulumi.get(__response__, 'destinations'),
        device=pulumi.get(__response__, 'device'),
        disabled=pulumi.get(__response__, 'disabled'),
        folder=pulumi.get(__response__, 'folder'),
        froms=pulumi.get(__response__, 'froms'),
        id=pulumi.get(__response__, 'id'),
        log_fail=pulumi.get(__response__, 'log_fail'),
        log_setting=pulumi.get(__response__, 'log_setting'),
        log_success=pulumi.get(__response__, 'log_success'),
        name=pulumi.get(__response__, 'name'),
        negate_destination=pulumi.get(__response__, 'negate_destination'),
        negate_source=pulumi.get(__response__, 'negate_source'),
        position=pulumi.get(__response__, 'position'),
        profile=pulumi.get(__response__, 'profile'),
        relative_position=pulumi.get(__response__, 'relative_position'),
        services=pulumi.get(__response__, 'services'),
        snippet=pulumi.get(__response__, 'snippet'),
        source_hips=pulumi.get(__response__, 'source_hips'),
        source_users=pulumi.get(__response__, 'source_users'),
        sources=pulumi.get(__response__, 'sources'),
        tags=pulumi.get(__response__, 'tags'),
        target_rule=pulumi.get(__response__, 'target_rule'),
        tfid=pulumi.get(__response__, 'tfid'),
        tos=pulumi.get(__response__, 'tos'),
        type=pulumi.get(__response__, 'type')))
