# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetDnsSecurityProfileResult',
    'AwaitableGetDnsSecurityProfileResult',
    'get_dns_security_profile',
    'get_dns_security_profile_output',
]

@pulumi.output_type
class GetDnsSecurityProfileResult:
    """
    A collection of values returned by getDnsSecurityProfile.
    """
    def __init__(__self__, botnet_domains=None, description=None, device=None, folder=None, id=None, name=None, snippet=None, tfid=None):
        if botnet_domains and not isinstance(botnet_domains, dict):
            raise TypeError("Expected argument 'botnet_domains' to be a dict")
        pulumi.set(__self__, "botnet_domains", botnet_domains)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if device and not isinstance(device, str):
            raise TypeError("Expected argument 'device' to be a str")
        pulumi.set(__self__, "device", device)
        if folder and not isinstance(folder, str):
            raise TypeError("Expected argument 'folder' to be a str")
        pulumi.set(__self__, "folder", folder)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if snippet and not isinstance(snippet, str):
            raise TypeError("Expected argument 'snippet' to be a str")
        pulumi.set(__self__, "snippet", snippet)
        if tfid and not isinstance(tfid, str):
            raise TypeError("Expected argument 'tfid' to be a str")
        pulumi.set(__self__, "tfid", tfid)

    @_builtins.property
    @pulumi.getter(name="botnetDomains")
    def botnet_domains(self) -> 'outputs.GetDnsSecurityProfileBotnetDomainsResult':
        """
        Botnet domains
        """
        return pulumi.get(self, "botnet_domains")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the DNS security profile
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def device(self) -> _builtins.str:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> _builtins.str:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The UUID of the DNS security profile
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the DNS security profile
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> _builtins.str:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> _builtins.str:
        return pulumi.get(self, "tfid")


class AwaitableGetDnsSecurityProfileResult(GetDnsSecurityProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDnsSecurityProfileResult(
            botnet_domains=self.botnet_domains,
            description=self.description,
            device=self.device,
            folder=self.folder,
            id=self.id,
            name=self.name,
            snippet=self.snippet,
            tfid=self.tfid)


def get_dns_security_profile(id: Optional[_builtins.str] = None,
                             name: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDnsSecurityProfileResult:
    """
    DnsSecurityProfile data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    #
    # Data source to retrieve a single SCM DNS Security Profile object by its ID.
    #
    # Replace the ID with the UUID of the SCM DNS Profile you want to find.
    scm_dns_profile = scm.get_dns_security_profile(id="18607c90-22fa-4627-8741-f0584d1fa7d6")
    pulumi.export("scmDnsSecurityProfileDetails", {
        "profileId": scm_dns_profile.id,
        "folder": scm_dns_profile.folder,
        "name": scm_dns_profile.name,
    })
    ```


    :param _builtins.str id: The UUID of the DNS security profile
    :param _builtins.str name: The name of the DNS security profile
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scm:index/getDnsSecurityProfile:getDnsSecurityProfile', __args__, opts=opts, typ=GetDnsSecurityProfileResult).value

    return AwaitableGetDnsSecurityProfileResult(
        botnet_domains=pulumi.get(__ret__, 'botnet_domains'),
        description=pulumi.get(__ret__, 'description'),
        device=pulumi.get(__ret__, 'device'),
        folder=pulumi.get(__ret__, 'folder'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        snippet=pulumi.get(__ret__, 'snippet'),
        tfid=pulumi.get(__ret__, 'tfid'))
def get_dns_security_profile_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                                    name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDnsSecurityProfileResult]:
    """
    DnsSecurityProfile data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    #
    # Data source to retrieve a single SCM DNS Security Profile object by its ID.
    #
    # Replace the ID with the UUID of the SCM DNS Profile you want to find.
    scm_dns_profile = scm.get_dns_security_profile(id="18607c90-22fa-4627-8741-f0584d1fa7d6")
    pulumi.export("scmDnsSecurityProfileDetails", {
        "profileId": scm_dns_profile.id,
        "folder": scm_dns_profile.folder,
        "name": scm_dns_profile.name,
    })
    ```


    :param _builtins.str id: The UUID of the DNS security profile
    :param _builtins.str name: The name of the DNS security profile
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scm:index/getDnsSecurityProfile:getDnsSecurityProfile', __args__, opts=opts, typ=GetDnsSecurityProfileResult)
    return __ret__.apply(lambda __response__: GetDnsSecurityProfileResult(
        botnet_domains=pulumi.get(__response__, 'botnet_domains'),
        description=pulumi.get(__response__, 'description'),
        device=pulumi.get(__response__, 'device'),
        folder=pulumi.get(__response__, 'folder'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        snippet=pulumi.get(__response__, 'snippet'),
        tfid=pulumi.get(__response__, 'tfid')))
