# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetEthernetInterfaceResult',
    'AwaitableGetEthernetInterfaceResult',
    'get_ethernet_interface',
    'get_ethernet_interface_output',
]

@pulumi.output_type
class GetEthernetInterfaceResult:
    """
    A collection of values returned by getEthernetInterface.
    """
    def __init__(__self__, comment=None, default_value=None, device=None, encrypted_values=None, folder=None, id=None, layer2=None, layer3=None, link_duplex=None, link_speed=None, link_state=None, name=None, poe=None, snippet=None, tap=None, tfid=None):
        if comment and not isinstance(comment, str):
            raise TypeError("Expected argument 'comment' to be a str")
        pulumi.set(__self__, "comment", comment)
        if default_value and not isinstance(default_value, str):
            raise TypeError("Expected argument 'default_value' to be a str")
        pulumi.set(__self__, "default_value", default_value)
        if device and not isinstance(device, str):
            raise TypeError("Expected argument 'device' to be a str")
        pulumi.set(__self__, "device", device)
        if encrypted_values and not isinstance(encrypted_values, dict):
            raise TypeError("Expected argument 'encrypted_values' to be a dict")
        pulumi.set(__self__, "encrypted_values", encrypted_values)
        if folder and not isinstance(folder, str):
            raise TypeError("Expected argument 'folder' to be a str")
        pulumi.set(__self__, "folder", folder)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if layer2 and not isinstance(layer2, dict):
            raise TypeError("Expected argument 'layer2' to be a dict")
        pulumi.set(__self__, "layer2", layer2)
        if layer3 and not isinstance(layer3, dict):
            raise TypeError("Expected argument 'layer3' to be a dict")
        pulumi.set(__self__, "layer3", layer3)
        if link_duplex and not isinstance(link_duplex, str):
            raise TypeError("Expected argument 'link_duplex' to be a str")
        pulumi.set(__self__, "link_duplex", link_duplex)
        if link_speed and not isinstance(link_speed, str):
            raise TypeError("Expected argument 'link_speed' to be a str")
        pulumi.set(__self__, "link_speed", link_speed)
        if link_state and not isinstance(link_state, str):
            raise TypeError("Expected argument 'link_state' to be a str")
        pulumi.set(__self__, "link_state", link_state)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if poe and not isinstance(poe, dict):
            raise TypeError("Expected argument 'poe' to be a dict")
        pulumi.set(__self__, "poe", poe)
        if snippet and not isinstance(snippet, str):
            raise TypeError("Expected argument 'snippet' to be a str")
        pulumi.set(__self__, "snippet", snippet)
        if tap and not isinstance(tap, dict):
            raise TypeError("Expected argument 'tap' to be a dict")
        pulumi.set(__self__, "tap", tap)
        if tfid and not isinstance(tfid, str):
            raise TypeError("Expected argument 'tfid' to be a str")
        pulumi.set(__self__, "tfid", tfid)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> _builtins.str:
        """
        Interface description
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> _builtins.str:
        """
        Default interface assignment
        """
        return pulumi.get(self, "default_value")

    @_builtins.property
    @pulumi.getter
    def device(self) -> _builtins.str:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter(name="encryptedValues")
    def encrypted_values(self) -> Mapping[str, _builtins.str]:
        """
        Map of sensitive values returned from the API.
        """
        return pulumi.get(self, "encrypted_values")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> _builtins.str:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        UUID of the resource
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def layer2(self) -> 'outputs.GetEthernetInterfaceLayer2Result':
        """
        Layer2
        """
        return pulumi.get(self, "layer2")

    @_builtins.property
    @pulumi.getter
    def layer3(self) -> 'outputs.GetEthernetInterfaceLayer3Result':
        """
        Ethernet Interface Layer 3 configuration
        """
        return pulumi.get(self, "layer3")

    @_builtins.property
    @pulumi.getter(name="linkDuplex")
    def link_duplex(self) -> _builtins.str:
        """
        Link duplex
        """
        return pulumi.get(self, "link_duplex")

    @_builtins.property
    @pulumi.getter(name="linkSpeed")
    def link_speed(self) -> _builtins.str:
        """
        Link speed
        """
        return pulumi.get(self, "link_speed")

    @_builtins.property
    @pulumi.getter(name="linkState")
    def link_state(self) -> _builtins.str:
        """
        Link state
        """
        return pulumi.get(self, "link_state")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Interface name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def poe(self) -> 'outputs.GetEthernetInterfacePoeResult':
        """
        Poe
        """
        return pulumi.get(self, "poe")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> _builtins.str:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def tap(self) -> 'outputs.GetEthernetInterfaceTapResult':
        """
        Tap
        """
        return pulumi.get(self, "tap")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> _builtins.str:
        return pulumi.get(self, "tfid")


class AwaitableGetEthernetInterfaceResult(GetEthernetInterfaceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEthernetInterfaceResult(
            comment=self.comment,
            default_value=self.default_value,
            device=self.device,
            encrypted_values=self.encrypted_values,
            folder=self.folder,
            id=self.id,
            layer2=self.layer2,
            layer3=self.layer3,
            link_duplex=self.link_duplex,
            link_speed=self.link_speed,
            link_state=self.link_state,
            name=self.name,
            poe=self.poe,
            snippet=self.snippet,
            tap=self.tap,
            tfid=self.tfid)


def get_ethernet_interface(id: Optional[_builtins.str] = None,
                           name: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEthernetInterfaceResult:
    """
    EthernetInterface data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    # Look up ethernet interface by its ID.
    scm_l3_intf_static_ds = scm.get_ethernet_interface(id="ddad1e64-0b64-41a4-b361-c6199769a8f2")
    pulumi.export("ethernetInterfaceDataSourceResults", {
        "id": scm_l3_intf_static_ds.id,
        "name": scm_l3_intf_static_ds.name,
        "comment": scm_l3_intf_static_ds.comment,
        "layer3": scm_l3_intf_static_ds.layer3,
        "folder": scm_l3_intf_static_ds.folder,
    })
    ```


    :param _builtins.str id: UUID of the resource
    :param _builtins.str name: Interface name
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scm:index/getEthernetInterface:getEthernetInterface', __args__, opts=opts, typ=GetEthernetInterfaceResult).value

    return AwaitableGetEthernetInterfaceResult(
        comment=pulumi.get(__ret__, 'comment'),
        default_value=pulumi.get(__ret__, 'default_value'),
        device=pulumi.get(__ret__, 'device'),
        encrypted_values=pulumi.get(__ret__, 'encrypted_values'),
        folder=pulumi.get(__ret__, 'folder'),
        id=pulumi.get(__ret__, 'id'),
        layer2=pulumi.get(__ret__, 'layer2'),
        layer3=pulumi.get(__ret__, 'layer3'),
        link_duplex=pulumi.get(__ret__, 'link_duplex'),
        link_speed=pulumi.get(__ret__, 'link_speed'),
        link_state=pulumi.get(__ret__, 'link_state'),
        name=pulumi.get(__ret__, 'name'),
        poe=pulumi.get(__ret__, 'poe'),
        snippet=pulumi.get(__ret__, 'snippet'),
        tap=pulumi.get(__ret__, 'tap'),
        tfid=pulumi.get(__ret__, 'tfid'))
def get_ethernet_interface_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                                  name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEthernetInterfaceResult]:
    """
    EthernetInterface data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    # Look up ethernet interface by its ID.
    scm_l3_intf_static_ds = scm.get_ethernet_interface(id="ddad1e64-0b64-41a4-b361-c6199769a8f2")
    pulumi.export("ethernetInterfaceDataSourceResults", {
        "id": scm_l3_intf_static_ds.id,
        "name": scm_l3_intf_static_ds.name,
        "comment": scm_l3_intf_static_ds.comment,
        "layer3": scm_l3_intf_static_ds.layer3,
        "folder": scm_l3_intf_static_ds.folder,
    })
    ```


    :param _builtins.str id: UUID of the resource
    :param _builtins.str name: Interface name
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scm:index/getEthernetInterface:getEthernetInterface', __args__, opts=opts, typ=GetEthernetInterfaceResult)
    return __ret__.apply(lambda __response__: GetEthernetInterfaceResult(
        comment=pulumi.get(__response__, 'comment'),
        default_value=pulumi.get(__response__, 'default_value'),
        device=pulumi.get(__response__, 'device'),
        encrypted_values=pulumi.get(__response__, 'encrypted_values'),
        folder=pulumi.get(__response__, 'folder'),
        id=pulumi.get(__response__, 'id'),
        layer2=pulumi.get(__response__, 'layer2'),
        layer3=pulumi.get(__response__, 'layer3'),
        link_duplex=pulumi.get(__response__, 'link_duplex'),
        link_speed=pulumi.get(__response__, 'link_speed'),
        link_state=pulumi.get(__response__, 'link_state'),
        name=pulumi.get(__response__, 'name'),
        poe=pulumi.get(__response__, 'poe'),
        snippet=pulumi.get(__response__, 'snippet'),
        tap=pulumi.get(__response__, 'tap'),
        tfid=pulumi.get(__response__, 'tfid')))
