# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetFolderResult',
    'AwaitableGetFolderResult',
    'get_folder',
    'get_folder_output',
]

@pulumi.output_type
class GetFolderResult:
    """
    A collection of values returned by getFolder.
    """
    def __init__(__self__, description=None, id=None, labels=None, name=None, parent=None, snippets=None, tfid=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, list):
            raise TypeError("Expected argument 'labels' to be a list")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if parent and not isinstance(parent, str):
            raise TypeError("Expected argument 'parent' to be a str")
        pulumi.set(__self__, "parent", parent)
        if snippets and not isinstance(snippets, list):
            raise TypeError("Expected argument 'snippets' to be a list")
        pulumi.set(__self__, "snippets", snippets)
        if tfid and not isinstance(tfid, str):
            raise TypeError("Expected argument 'tfid' to be a str")
        pulumi.set(__self__, "tfid", tfid)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the folder
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The UUID of the folder
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Sequence[_builtins.str]:
        """
        Labels assigned to the folder
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the folder
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def parent(self) -> _builtins.str:
        """
        The parent folder
        """
        return pulumi.get(self, "parent")

    @_builtins.property
    @pulumi.getter
    def snippets(self) -> Sequence[_builtins.str]:
        """
        Snippets associated with the folder
        """
        return pulumi.get(self, "snippets")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> _builtins.str:
        return pulumi.get(self, "tfid")


class AwaitableGetFolderResult(GetFolderResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFolderResult(
            description=self.description,
            id=self.id,
            labels=self.labels,
            name=self.name,
            parent=self.parent,
            snippets=self.snippets,
            tfid=self.tfid)


def get_folder(id: Optional[_builtins.str] = None,
               name: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFolderResult:
    """
    Folder data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    # Look up a folder by id
    scm_folder_ds = scm.get_folder(id="0f11d0d9-df7c-45da-a60c-4d80f8422544")
    pulumi.export("scmFolderOutput", {
        "id": scm_folder_ds.id,
        "name": scm_folder_ds.name,
        "description": scm_folder_ds.description,
        "parent": scm_folder_ds.parent,
    })
    ```


    :param _builtins.str id: The UUID of the folder
    :param _builtins.str name: The name of the folder
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scm:index/getFolder:getFolder', __args__, opts=opts, typ=GetFolderResult).value

    return AwaitableGetFolderResult(
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        parent=pulumi.get(__ret__, 'parent'),
        snippets=pulumi.get(__ret__, 'snippets'),
        tfid=pulumi.get(__ret__, 'tfid'))
def get_folder_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                      name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFolderResult]:
    """
    Folder data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    # Look up a folder by id
    scm_folder_ds = scm.get_folder(id="0f11d0d9-df7c-45da-a60c-4d80f8422544")
    pulumi.export("scmFolderOutput", {
        "id": scm_folder_ds.id,
        "name": scm_folder_ds.name,
        "description": scm_folder_ds.description,
        "parent": scm_folder_ds.parent,
    })
    ```


    :param _builtins.str id: The UUID of the folder
    :param _builtins.str name: The name of the folder
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scm:index/getFolder:getFolder', __args__, opts=opts, typ=GetFolderResult)
    return __ret__.apply(lambda __response__: GetFolderResult(
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        parent=pulumi.get(__response__, 'parent'),
        snippets=pulumi.get(__response__, 'snippets'),
        tfid=pulumi.get(__response__, 'tfid')))
