# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetIkeCryptoProfileResult',
    'AwaitableGetIkeCryptoProfileResult',
    'get_ike_crypto_profile',
    'get_ike_crypto_profile_output',
]

@pulumi.output_type
class GetIkeCryptoProfileResult:
    """
    A collection of values returned by getIkeCryptoProfile.
    """
    def __init__(__self__, authentication_multiple=None, device=None, dh_groups=None, encryptions=None, folder=None, hashes=None, id=None, lifetime=None, name=None, snippet=None, tfid=None):
        if authentication_multiple and not isinstance(authentication_multiple, int):
            raise TypeError("Expected argument 'authentication_multiple' to be a int")
        pulumi.set(__self__, "authentication_multiple", authentication_multiple)
        if device and not isinstance(device, str):
            raise TypeError("Expected argument 'device' to be a str")
        pulumi.set(__self__, "device", device)
        if dh_groups and not isinstance(dh_groups, list):
            raise TypeError("Expected argument 'dh_groups' to be a list")
        pulumi.set(__self__, "dh_groups", dh_groups)
        if encryptions and not isinstance(encryptions, list):
            raise TypeError("Expected argument 'encryptions' to be a list")
        pulumi.set(__self__, "encryptions", encryptions)
        if folder and not isinstance(folder, str):
            raise TypeError("Expected argument 'folder' to be a str")
        pulumi.set(__self__, "folder", folder)
        if hashes and not isinstance(hashes, list):
            raise TypeError("Expected argument 'hashes' to be a list")
        pulumi.set(__self__, "hashes", hashes)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifetime and not isinstance(lifetime, dict):
            raise TypeError("Expected argument 'lifetime' to be a dict")
        pulumi.set(__self__, "lifetime", lifetime)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if snippet and not isinstance(snippet, str):
            raise TypeError("Expected argument 'snippet' to be a str")
        pulumi.set(__self__, "snippet", snippet)
        if tfid and not isinstance(tfid, str):
            raise TypeError("Expected argument 'tfid' to be a str")
        pulumi.set(__self__, "tfid", tfid)

    @_builtins.property
    @pulumi.getter(name="authenticationMultiple")
    def authentication_multiple(self) -> _builtins.int:
        """
        IKEv2 SA reauthentication interval equals authetication-multiple * rekey-lifetime; 0 means reauthentication disabled
        """
        return pulumi.get(self, "authentication_multiple")

    @_builtins.property
    @pulumi.getter
    def device(self) -> _builtins.str:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter(name="dhGroups")
    def dh_groups(self) -> Sequence[_builtins.str]:
        """
        Dh group
        """
        return pulumi.get(self, "dh_groups")

    @_builtins.property
    @pulumi.getter
    def encryptions(self) -> Sequence[_builtins.str]:
        """
        Encryption algorithm
        """
        return pulumi.get(self, "encryptions")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> _builtins.str:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def hashes(self) -> Sequence[_builtins.str]:
        """
        Hash
        """
        return pulumi.get(self, "hashes")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        UUID of the resource
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def lifetime(self) -> 'outputs.GetIkeCryptoProfileLifetimeResult':
        """
        Ike crypto profile lifetime
        """
        return pulumi.get(self, "lifetime")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Alphanumeric string begin with letter: [0-9a-zA-Z._-]
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> _builtins.str:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> _builtins.str:
        return pulumi.get(self, "tfid")


class AwaitableGetIkeCryptoProfileResult(GetIkeCryptoProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIkeCryptoProfileResult(
            authentication_multiple=self.authentication_multiple,
            device=self.device,
            dh_groups=self.dh_groups,
            encryptions=self.encryptions,
            folder=self.folder,
            hashes=self.hashes,
            id=self.id,
            lifetime=self.lifetime,
            name=self.name,
            snippet=self.snippet,
            tfid=self.tfid)


def get_ike_crypto_profile(id: Optional[_builtins.str] = None,
                           name: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIkeCryptoProfileResult:
    """
    IkeCryptoProfile data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    # Example of looking up an individual IPsec Crypto Profile by its ID.
    scm_ike_crypto_profile_ds = scm.get_ike_crypto_profile(id="f3a1251a-bb9e-437d-8048-f5d54617d0be")
    pulumi.export("ikeProfileById", scm_ike_crypto_profile_ds)
    ```


    :param _builtins.str id: UUID of the resource
    :param _builtins.str name: Alphanumeric string begin with letter: [0-9a-zA-Z._-]
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scm:index/getIkeCryptoProfile:getIkeCryptoProfile', __args__, opts=opts, typ=GetIkeCryptoProfileResult).value

    return AwaitableGetIkeCryptoProfileResult(
        authentication_multiple=pulumi.get(__ret__, 'authentication_multiple'),
        device=pulumi.get(__ret__, 'device'),
        dh_groups=pulumi.get(__ret__, 'dh_groups'),
        encryptions=pulumi.get(__ret__, 'encryptions'),
        folder=pulumi.get(__ret__, 'folder'),
        hashes=pulumi.get(__ret__, 'hashes'),
        id=pulumi.get(__ret__, 'id'),
        lifetime=pulumi.get(__ret__, 'lifetime'),
        name=pulumi.get(__ret__, 'name'),
        snippet=pulumi.get(__ret__, 'snippet'),
        tfid=pulumi.get(__ret__, 'tfid'))
def get_ike_crypto_profile_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                                  name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIkeCryptoProfileResult]:
    """
    IkeCryptoProfile data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    # Example of looking up an individual IPsec Crypto Profile by its ID.
    scm_ike_crypto_profile_ds = scm.get_ike_crypto_profile(id="f3a1251a-bb9e-437d-8048-f5d54617d0be")
    pulumi.export("ikeProfileById", scm_ike_crypto_profile_ds)
    ```


    :param _builtins.str id: UUID of the resource
    :param _builtins.str name: Alphanumeric string begin with letter: [0-9a-zA-Z._-]
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scm:index/getIkeCryptoProfile:getIkeCryptoProfile', __args__, opts=opts, typ=GetIkeCryptoProfileResult)
    return __ret__.apply(lambda __response__: GetIkeCryptoProfileResult(
        authentication_multiple=pulumi.get(__response__, 'authentication_multiple'),
        device=pulumi.get(__response__, 'device'),
        dh_groups=pulumi.get(__response__, 'dh_groups'),
        encryptions=pulumi.get(__response__, 'encryptions'),
        folder=pulumi.get(__response__, 'folder'),
        hashes=pulumi.get(__response__, 'hashes'),
        id=pulumi.get(__response__, 'id'),
        lifetime=pulumi.get(__response__, 'lifetime'),
        name=pulumi.get(__response__, 'name'),
        snippet=pulumi.get(__response__, 'snippet'),
        tfid=pulumi.get(__response__, 'tfid')))
