# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetIkeGatewayResult',
    'AwaitableGetIkeGatewayResult',
    'get_ike_gateway',
    'get_ike_gateway_output',
]

@pulumi.output_type
class GetIkeGatewayResult:
    """
    A collection of values returned by getIkeGateway.
    """
    def __init__(__self__, authentication=None, device=None, encrypted_values=None, folder=None, id=None, local_address=None, local_id=None, name=None, peer_address=None, peer_id=None, protocol=None, protocol_common=None, snippet=None, tfid=None):
        if authentication and not isinstance(authentication, dict):
            raise TypeError("Expected argument 'authentication' to be a dict")
        pulumi.set(__self__, "authentication", authentication)
        if device and not isinstance(device, str):
            raise TypeError("Expected argument 'device' to be a str")
        pulumi.set(__self__, "device", device)
        if encrypted_values and not isinstance(encrypted_values, dict):
            raise TypeError("Expected argument 'encrypted_values' to be a dict")
        pulumi.set(__self__, "encrypted_values", encrypted_values)
        if folder and not isinstance(folder, str):
            raise TypeError("Expected argument 'folder' to be a str")
        pulumi.set(__self__, "folder", folder)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if local_address and not isinstance(local_address, dict):
            raise TypeError("Expected argument 'local_address' to be a dict")
        pulumi.set(__self__, "local_address", local_address)
        if local_id and not isinstance(local_id, dict):
            raise TypeError("Expected argument 'local_id' to be a dict")
        pulumi.set(__self__, "local_id", local_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if peer_address and not isinstance(peer_address, dict):
            raise TypeError("Expected argument 'peer_address' to be a dict")
        pulumi.set(__self__, "peer_address", peer_address)
        if peer_id and not isinstance(peer_id, dict):
            raise TypeError("Expected argument 'peer_id' to be a dict")
        pulumi.set(__self__, "peer_id", peer_id)
        if protocol and not isinstance(protocol, dict):
            raise TypeError("Expected argument 'protocol' to be a dict")
        pulumi.set(__self__, "protocol", protocol)
        if protocol_common and not isinstance(protocol_common, dict):
            raise TypeError("Expected argument 'protocol_common' to be a dict")
        pulumi.set(__self__, "protocol_common", protocol_common)
        if snippet and not isinstance(snippet, str):
            raise TypeError("Expected argument 'snippet' to be a str")
        pulumi.set(__self__, "snippet", snippet)
        if tfid and not isinstance(tfid, str):
            raise TypeError("Expected argument 'tfid' to be a str")
        pulumi.set(__self__, "tfid", tfid)

    @_builtins.property
    @pulumi.getter
    def authentication(self) -> 'outputs.GetIkeGatewayAuthenticationResult':
        """
        Authentication
        """
        return pulumi.get(self, "authentication")

    @_builtins.property
    @pulumi.getter
    def device(self) -> _builtins.str:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter(name="encryptedValues")
    def encrypted_values(self) -> Mapping[str, _builtins.str]:
        """
        Map of sensitive values returned from the API.
        """
        return pulumi.get(self, "encrypted_values")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> _builtins.str:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        UUID of the resource
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="localAddress")
    def local_address(self) -> 'outputs.GetIkeGatewayLocalAddressResult':
        """
        Local address
        """
        return pulumi.get(self, "local_address")

    @_builtins.property
    @pulumi.getter(name="localId")
    def local_id(self) -> 'outputs.GetIkeGatewayLocalIdResult':
        """
        Local id
        """
        return pulumi.get(self, "local_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Alphanumeric string begin with letter: [0-9a-zA-Z._-]
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="peerAddress")
    def peer_address(self) -> 'outputs.GetIkeGatewayPeerAddressResult':
        """
        Peer address
        """
        return pulumi.get(self, "peer_address")

    @_builtins.property
    @pulumi.getter(name="peerId")
    def peer_id(self) -> 'outputs.GetIkeGatewayPeerIdResult':
        """
        Peer id
        """
        return pulumi.get(self, "peer_id")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> 'outputs.GetIkeGatewayProtocolResult':
        """
        Protocol
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="protocolCommon")
    def protocol_common(self) -> 'outputs.GetIkeGatewayProtocolCommonResult':
        """
        Protocol common
        """
        return pulumi.get(self, "protocol_common")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> _builtins.str:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> _builtins.str:
        return pulumi.get(self, "tfid")


class AwaitableGetIkeGatewayResult(GetIkeGatewayResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIkeGatewayResult(
            authentication=self.authentication,
            device=self.device,
            encrypted_values=self.encrypted_values,
            folder=self.folder,
            id=self.id,
            local_address=self.local_address,
            local_id=self.local_id,
            name=self.name,
            peer_address=self.peer_address,
            peer_id=self.peer_id,
            protocol=self.protocol,
            protocol_common=self.protocol_common,
            snippet=self.snippet,
            tfid=self.tfid)


def get_ike_gateway(id: Optional[_builtins.str] = None,
                    name: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIkeGatewayResult:
    """
    IkeGateway data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    # Data source to retrieve a single IKE Gateway by its ID.
    # Replace the placeholder ID with the actual UUID of the gateway you want to fetch.
    example_singular_ike_gateway_ds = scm.get_ike_gateway(id="1ba42513-2985-4783-8bdf-c83cf20d6dd1")
    pulumi.export("ikeGatewaySingularExample", example_singular_ike_gateway_ds)
    ```


    :param _builtins.str id: UUID of the resource
    :param _builtins.str name: Alphanumeric string begin with letter: [0-9a-zA-Z._-]
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scm:index/getIkeGateway:getIkeGateway', __args__, opts=opts, typ=GetIkeGatewayResult).value

    return AwaitableGetIkeGatewayResult(
        authentication=pulumi.get(__ret__, 'authentication'),
        device=pulumi.get(__ret__, 'device'),
        encrypted_values=pulumi.get(__ret__, 'encrypted_values'),
        folder=pulumi.get(__ret__, 'folder'),
        id=pulumi.get(__ret__, 'id'),
        local_address=pulumi.get(__ret__, 'local_address'),
        local_id=pulumi.get(__ret__, 'local_id'),
        name=pulumi.get(__ret__, 'name'),
        peer_address=pulumi.get(__ret__, 'peer_address'),
        peer_id=pulumi.get(__ret__, 'peer_id'),
        protocol=pulumi.get(__ret__, 'protocol'),
        protocol_common=pulumi.get(__ret__, 'protocol_common'),
        snippet=pulumi.get(__ret__, 'snippet'),
        tfid=pulumi.get(__ret__, 'tfid'))
def get_ike_gateway_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                           name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIkeGatewayResult]:
    """
    IkeGateway data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    # Data source to retrieve a single IKE Gateway by its ID.
    # Replace the placeholder ID with the actual UUID of the gateway you want to fetch.
    example_singular_ike_gateway_ds = scm.get_ike_gateway(id="1ba42513-2985-4783-8bdf-c83cf20d6dd1")
    pulumi.export("ikeGatewaySingularExample", example_singular_ike_gateway_ds)
    ```


    :param _builtins.str id: UUID of the resource
    :param _builtins.str name: Alphanumeric string begin with letter: [0-9a-zA-Z._-]
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scm:index/getIkeGateway:getIkeGateway', __args__, opts=opts, typ=GetIkeGatewayResult)
    return __ret__.apply(lambda __response__: GetIkeGatewayResult(
        authentication=pulumi.get(__response__, 'authentication'),
        device=pulumi.get(__response__, 'device'),
        encrypted_values=pulumi.get(__response__, 'encrypted_values'),
        folder=pulumi.get(__response__, 'folder'),
        id=pulumi.get(__response__, 'id'),
        local_address=pulumi.get(__response__, 'local_address'),
        local_id=pulumi.get(__response__, 'local_id'),
        name=pulumi.get(__response__, 'name'),
        peer_address=pulumi.get(__response__, 'peer_address'),
        peer_id=pulumi.get(__response__, 'peer_id'),
        protocol=pulumi.get(__response__, 'protocol'),
        protocol_common=pulumi.get(__response__, 'protocol_common'),
        snippet=pulumi.get(__response__, 'snippet'),
        tfid=pulumi.get(__response__, 'tfid')))
