# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetIpsecTunnelResult',
    'AwaitableGetIpsecTunnelResult',
    'get_ipsec_tunnel',
    'get_ipsec_tunnel_output',
]

@pulumi.output_type
class GetIpsecTunnelResult:
    """
    A collection of values returned by getIpsecTunnel.
    """
    def __init__(__self__, anti_replay=None, auto_key=None, copy_tos=None, device=None, enable_gre_encapsulation=None, folder=None, id=None, name=None, snippet=None, tfid=None, tunnel_interface=None, tunnel_monitor=None):
        if anti_replay and not isinstance(anti_replay, bool):
            raise TypeError("Expected argument 'anti_replay' to be a bool")
        pulumi.set(__self__, "anti_replay", anti_replay)
        if auto_key and not isinstance(auto_key, dict):
            raise TypeError("Expected argument 'auto_key' to be a dict")
        pulumi.set(__self__, "auto_key", auto_key)
        if copy_tos and not isinstance(copy_tos, bool):
            raise TypeError("Expected argument 'copy_tos' to be a bool")
        pulumi.set(__self__, "copy_tos", copy_tos)
        if device and not isinstance(device, str):
            raise TypeError("Expected argument 'device' to be a str")
        pulumi.set(__self__, "device", device)
        if enable_gre_encapsulation and not isinstance(enable_gre_encapsulation, bool):
            raise TypeError("Expected argument 'enable_gre_encapsulation' to be a bool")
        pulumi.set(__self__, "enable_gre_encapsulation", enable_gre_encapsulation)
        if folder and not isinstance(folder, str):
            raise TypeError("Expected argument 'folder' to be a str")
        pulumi.set(__self__, "folder", folder)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if snippet and not isinstance(snippet, str):
            raise TypeError("Expected argument 'snippet' to be a str")
        pulumi.set(__self__, "snippet", snippet)
        if tfid and not isinstance(tfid, str):
            raise TypeError("Expected argument 'tfid' to be a str")
        pulumi.set(__self__, "tfid", tfid)
        if tunnel_interface and not isinstance(tunnel_interface, str):
            raise TypeError("Expected argument 'tunnel_interface' to be a str")
        pulumi.set(__self__, "tunnel_interface", tunnel_interface)
        if tunnel_monitor and not isinstance(tunnel_monitor, dict):
            raise TypeError("Expected argument 'tunnel_monitor' to be a dict")
        pulumi.set(__self__, "tunnel_monitor", tunnel_monitor)

    @_builtins.property
    @pulumi.getter(name="antiReplay")
    def anti_replay(self) -> _builtins.bool:
        """
        Enable Anti-Replay check on this tunnel
        """
        return pulumi.get(self, "anti_replay")

    @_builtins.property
    @pulumi.getter(name="autoKey")
    def auto_key(self) -> 'outputs.GetIpsecTunnelAutoKeyResult':
        """
        Auto key
        """
        return pulumi.get(self, "auto_key")

    @_builtins.property
    @pulumi.getter(name="copyTos")
    def copy_tos(self) -> _builtins.bool:
        """
        Copy IP TOS bits from inner packet to IPSec packet (not recommended)
        """
        return pulumi.get(self, "copy_tos")

    @_builtins.property
    @pulumi.getter
    def device(self) -> _builtins.str:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter(name="enableGreEncapsulation")
    def enable_gre_encapsulation(self) -> _builtins.bool:
        """
        allow GRE over IPSec
        """
        return pulumi.get(self, "enable_gre_encapsulation")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> _builtins.str:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        UUID of the resource
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Alphanumeric string begin with letter: [0-9a-zA-Z._-]
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> _builtins.str:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> _builtins.str:
        return pulumi.get(self, "tfid")

    @_builtins.property
    @pulumi.getter(name="tunnelInterface")
    def tunnel_interface(self) -> _builtins.str:
        """
        Tunnel interface variable or hardcoded tunnel. Default will be tunnels.
        """
        return pulumi.get(self, "tunnel_interface")

    @_builtins.property
    @pulumi.getter(name="tunnelMonitor")
    def tunnel_monitor(self) -> 'outputs.GetIpsecTunnelTunnelMonitorResult':
        """
        Tunnel monitor
        """
        return pulumi.get(self, "tunnel_monitor")


class AwaitableGetIpsecTunnelResult(GetIpsecTunnelResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIpsecTunnelResult(
            anti_replay=self.anti_replay,
            auto_key=self.auto_key,
            copy_tos=self.copy_tos,
            device=self.device,
            enable_gre_encapsulation=self.enable_gre_encapsulation,
            folder=self.folder,
            id=self.id,
            name=self.name,
            snippet=self.snippet,
            tfid=self.tfid,
            tunnel_interface=self.tunnel_interface,
            tunnel_monitor=self.tunnel_monitor)


def get_ipsec_tunnel(id: Optional[_builtins.str] = None,
                     name: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIpsecTunnelResult:
    """
    IpsecTunnel data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    # Example of looking up an individual IPsec Tunnel by its ID.
    scm_ipsec_tunnel_ds = scm.get_ipsec_tunnel(id="7c237a82-8c11-4f09-bdbf-599e159019ce")
    pulumi.export("ipsecTunnelById", scm_ipsec_tunnel_ds)
    ```


    :param _builtins.str id: UUID of the resource
    :param _builtins.str name: Alphanumeric string begin with letter: [0-9a-zA-Z._-]
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scm:index/getIpsecTunnel:getIpsecTunnel', __args__, opts=opts, typ=GetIpsecTunnelResult).value

    return AwaitableGetIpsecTunnelResult(
        anti_replay=pulumi.get(__ret__, 'anti_replay'),
        auto_key=pulumi.get(__ret__, 'auto_key'),
        copy_tos=pulumi.get(__ret__, 'copy_tos'),
        device=pulumi.get(__ret__, 'device'),
        enable_gre_encapsulation=pulumi.get(__ret__, 'enable_gre_encapsulation'),
        folder=pulumi.get(__ret__, 'folder'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        snippet=pulumi.get(__ret__, 'snippet'),
        tfid=pulumi.get(__ret__, 'tfid'),
        tunnel_interface=pulumi.get(__ret__, 'tunnel_interface'),
        tunnel_monitor=pulumi.get(__ret__, 'tunnel_monitor'))
def get_ipsec_tunnel_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                            name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIpsecTunnelResult]:
    """
    IpsecTunnel data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    # Example of looking up an individual IPsec Tunnel by its ID.
    scm_ipsec_tunnel_ds = scm.get_ipsec_tunnel(id="7c237a82-8c11-4f09-bdbf-599e159019ce")
    pulumi.export("ipsecTunnelById", scm_ipsec_tunnel_ds)
    ```


    :param _builtins.str id: UUID of the resource
    :param _builtins.str name: Alphanumeric string begin with letter: [0-9a-zA-Z._-]
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scm:index/getIpsecTunnel:getIpsecTunnel', __args__, opts=opts, typ=GetIpsecTunnelResult)
    return __ret__.apply(lambda __response__: GetIpsecTunnelResult(
        anti_replay=pulumi.get(__response__, 'anti_replay'),
        auto_key=pulumi.get(__response__, 'auto_key'),
        copy_tos=pulumi.get(__response__, 'copy_tos'),
        device=pulumi.get(__response__, 'device'),
        enable_gre_encapsulation=pulumi.get(__response__, 'enable_gre_encapsulation'),
        folder=pulumi.get(__response__, 'folder'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        snippet=pulumi.get(__response__, 'snippet'),
        tfid=pulumi.get(__response__, 'tfid'),
        tunnel_interface=pulumi.get(__response__, 'tunnel_interface'),
        tunnel_monitor=pulumi.get(__response__, 'tunnel_monitor')))
