# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetLogicalRouterListResult',
    'AwaitableGetLogicalRouterListResult',
    'get_logical_router_list',
    'get_logical_router_list_output',
]

@pulumi.output_type
class GetLogicalRouterListResult:
    """
    A collection of values returned by getLogicalRouterList.
    """
    def __init__(__self__, datas=None, device=None, folder=None, id=None, limit=None, name=None, offset=None, pagination=None, snippet=None, tfid=None, total=None):
        if datas and not isinstance(datas, list):
            raise TypeError("Expected argument 'datas' to be a list")
        pulumi.set(__self__, "datas", datas)
        if device and not isinstance(device, str):
            raise TypeError("Expected argument 'device' to be a str")
        pulumi.set(__self__, "device", device)
        if folder and not isinstance(folder, str):
            raise TypeError("Expected argument 'folder' to be a str")
        pulumi.set(__self__, "folder", folder)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if limit and not isinstance(limit, int):
            raise TypeError("Expected argument 'limit' to be a int")
        pulumi.set(__self__, "limit", limit)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if offset and not isinstance(offset, int):
            raise TypeError("Expected argument 'offset' to be a int")
        pulumi.set(__self__, "offset", offset)
        if pagination and not isinstance(pagination, bool):
            raise TypeError("Expected argument 'pagination' to be a bool")
        pulumi.set(__self__, "pagination", pagination)
        if snippet and not isinstance(snippet, str):
            raise TypeError("Expected argument 'snippet' to be a str")
        pulumi.set(__self__, "snippet", snippet)
        if tfid and not isinstance(tfid, str):
            raise TypeError("Expected argument 'tfid' to be a str")
        pulumi.set(__self__, "tfid", tfid)
        if total and not isinstance(total, int):
            raise TypeError("Expected argument 'total' to be a int")
        pulumi.set(__self__, "total", total)

    @_builtins.property
    @pulumi.getter
    def datas(self) -> Sequence['outputs.GetLogicalRouterListDataResult']:
        """
        The data.
        """
        return pulumi.get(self, "datas")

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[_builtins.str]:
        """
        The device of the item.
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[_builtins.str]:
        """
        The folder of the item. Default: Shared.
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def limit(self) -> Optional[_builtins.int]:
        """
        The max number of items to return. Default: 200.
        """
        return pulumi.get(self, "limit")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the item.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def offset(self) -> Optional[_builtins.int]:
        """
        The offset of the first item to return.
        """
        return pulumi.get(self, "offset")

    @_builtins.property
    @pulumi.getter
    def pagination(self) -> Optional[_builtins.bool]:
        """
        The parameter to mention if the response should be paginated. By default, its set to false
        """
        return pulumi.get(self, "pagination")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[_builtins.str]:
        """
        The snippet of the item.
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> _builtins.str:
        return pulumi.get(self, "tfid")

    @_builtins.property
    @pulumi.getter
    def total(self) -> _builtins.int:
        """
        The total number of items.
        """
        return pulumi.get(self, "total")


class AwaitableGetLogicalRouterListResult(GetLogicalRouterListResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLogicalRouterListResult(
            datas=self.datas,
            device=self.device,
            folder=self.folder,
            id=self.id,
            limit=self.limit,
            name=self.name,
            offset=self.offset,
            pagination=self.pagination,
            snippet=self.snippet,
            tfid=self.tfid,
            total=self.total)


def get_logical_router_list(device: Optional[_builtins.str] = None,
                            folder: Optional[_builtins.str] = None,
                            limit: Optional[_builtins.int] = None,
                            name: Optional[_builtins.str] = None,
                            offset: Optional[_builtins.int] = None,
                            pagination: Optional[_builtins.bool] = None,
                            snippet: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLogicalRouterListResult:
    """
    Retrieves a listing of config items.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    # Fetch a list of all logical routers
    all_logical_routers = scm.get_logical_router_list(folder="ngfw-shared",
        limit=100)
    pulumi.export("scmLogicalRouterList", {router.name: router for router in all_logical_routers.datas})
    ```


    :param _builtins.str device: The device of the item.
    :param _builtins.str folder: The folder of the item. Default: Shared.
    :param _builtins.int limit: The max number of items to return. Default: 200.
    :param _builtins.str name: The name of the item.
    :param _builtins.int offset: The offset of the first item to return.
    :param _builtins.bool pagination: The parameter to mention if the response should be paginated. By default, its set to false
    :param _builtins.str snippet: The snippet of the item.
    """
    __args__ = dict()
    __args__['device'] = device
    __args__['folder'] = folder
    __args__['limit'] = limit
    __args__['name'] = name
    __args__['offset'] = offset
    __args__['pagination'] = pagination
    __args__['snippet'] = snippet
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scm:index/getLogicalRouterList:getLogicalRouterList', __args__, opts=opts, typ=GetLogicalRouterListResult).value

    return AwaitableGetLogicalRouterListResult(
        datas=pulumi.get(__ret__, 'datas'),
        device=pulumi.get(__ret__, 'device'),
        folder=pulumi.get(__ret__, 'folder'),
        id=pulumi.get(__ret__, 'id'),
        limit=pulumi.get(__ret__, 'limit'),
        name=pulumi.get(__ret__, 'name'),
        offset=pulumi.get(__ret__, 'offset'),
        pagination=pulumi.get(__ret__, 'pagination'),
        snippet=pulumi.get(__ret__, 'snippet'),
        tfid=pulumi.get(__ret__, 'tfid'),
        total=pulumi.get(__ret__, 'total'))
def get_logical_router_list_output(device: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   folder: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   limit: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                   name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   offset: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                   pagination: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                   snippet: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLogicalRouterListResult]:
    """
    Retrieves a listing of config items.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    # Fetch a list of all logical routers
    all_logical_routers = scm.get_logical_router_list(folder="ngfw-shared",
        limit=100)
    pulumi.export("scmLogicalRouterList", {router.name: router for router in all_logical_routers.datas})
    ```


    :param _builtins.str device: The device of the item.
    :param _builtins.str folder: The folder of the item. Default: Shared.
    :param _builtins.int limit: The max number of items to return. Default: 200.
    :param _builtins.str name: The name of the item.
    :param _builtins.int offset: The offset of the first item to return.
    :param _builtins.bool pagination: The parameter to mention if the response should be paginated. By default, its set to false
    :param _builtins.str snippet: The snippet of the item.
    """
    __args__ = dict()
    __args__['device'] = device
    __args__['folder'] = folder
    __args__['limit'] = limit
    __args__['name'] = name
    __args__['offset'] = offset
    __args__['pagination'] = pagination
    __args__['snippet'] = snippet
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scm:index/getLogicalRouterList:getLogicalRouterList', __args__, opts=opts, typ=GetLogicalRouterListResult)
    return __ret__.apply(lambda __response__: GetLogicalRouterListResult(
        datas=pulumi.get(__response__, 'datas'),
        device=pulumi.get(__response__, 'device'),
        folder=pulumi.get(__response__, 'folder'),
        id=pulumi.get(__response__, 'id'),
        limit=pulumi.get(__response__, 'limit'),
        name=pulumi.get(__response__, 'name'),
        offset=pulumi.get(__response__, 'offset'),
        pagination=pulumi.get(__response__, 'pagination'),
        snippet=pulumi.get(__response__, 'snippet'),
        tfid=pulumi.get(__response__, 'tfid'),
        total=pulumi.get(__response__, 'total')))
