# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetLoopbackInterfaceResult',
    'AwaitableGetLoopbackInterfaceResult',
    'get_loopback_interface',
    'get_loopback_interface_output',
]

@pulumi.output_type
class GetLoopbackInterfaceResult:
    """
    A collection of values returned by getLoopbackInterface.
    """
    def __init__(__self__, comment=None, default_value=None, device=None, folder=None, id=None, interface_management_profile=None, ips=None, ipv6=None, mtu=None, name=None, snippet=None, tfid=None):
        if comment and not isinstance(comment, str):
            raise TypeError("Expected argument 'comment' to be a str")
        pulumi.set(__self__, "comment", comment)
        if default_value and not isinstance(default_value, str):
            raise TypeError("Expected argument 'default_value' to be a str")
        pulumi.set(__self__, "default_value", default_value)
        if device and not isinstance(device, str):
            raise TypeError("Expected argument 'device' to be a str")
        pulumi.set(__self__, "device", device)
        if folder and not isinstance(folder, str):
            raise TypeError("Expected argument 'folder' to be a str")
        pulumi.set(__self__, "folder", folder)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if interface_management_profile and not isinstance(interface_management_profile, str):
            raise TypeError("Expected argument 'interface_management_profile' to be a str")
        pulumi.set(__self__, "interface_management_profile", interface_management_profile)
        if ips and not isinstance(ips, list):
            raise TypeError("Expected argument 'ips' to be a list")
        pulumi.set(__self__, "ips", ips)
        if ipv6 and not isinstance(ipv6, dict):
            raise TypeError("Expected argument 'ipv6' to be a dict")
        pulumi.set(__self__, "ipv6", ipv6)
        if mtu and not isinstance(mtu, int):
            raise TypeError("Expected argument 'mtu' to be a int")
        pulumi.set(__self__, "mtu", mtu)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if snippet and not isinstance(snippet, str):
            raise TypeError("Expected argument 'snippet' to be a str")
        pulumi.set(__self__, "snippet", snippet)
        if tfid and not isinstance(tfid, str):
            raise TypeError("Expected argument 'tfid' to be a str")
        pulumi.set(__self__, "tfid", tfid)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> _builtins.str:
        """
        Description
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> _builtins.str:
        """
        Default interface assignment
        """
        return pulumi.get(self, "default_value")

    @_builtins.property
    @pulumi.getter
    def device(self) -> _builtins.str:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> _builtins.str:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        UUID of the resource
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="interfaceManagementProfile")
    def interface_management_profile(self) -> _builtins.str:
        """
        Interface management profile
        """
        return pulumi.get(self, "interface_management_profile")

    @_builtins.property
    @pulumi.getter
    def ips(self) -> Sequence['outputs.GetLoopbackInterfaceIpResult']:
        """
        Loopback IP Parent
        """
        return pulumi.get(self, "ips")

    @_builtins.property
    @pulumi.getter
    def ipv6(self) -> 'outputs.GetLoopbackInterfaceIpv6Result':
        """
        Loopback IPv6 Configuration
        """
        return pulumi.get(self, "ipv6")

    @_builtins.property
    @pulumi.getter
    def mtu(self) -> _builtins.int:
        """
        MTU
        """
        return pulumi.get(self, "mtu")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Loopback Interface name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> _builtins.str:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> _builtins.str:
        return pulumi.get(self, "tfid")


class AwaitableGetLoopbackInterfaceResult(GetLoopbackInterfaceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLoopbackInterfaceResult(
            comment=self.comment,
            default_value=self.default_value,
            device=self.device,
            folder=self.folder,
            id=self.id,
            interface_management_profile=self.interface_management_profile,
            ips=self.ips,
            ipv6=self.ipv6,
            mtu=self.mtu,
            name=self.name,
            snippet=self.snippet,
            tfid=self.tfid)


def get_loopback_interface(id: Optional[_builtins.str] = None,
                           name: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLoopbackInterfaceResult:
    """
    LoopbackInterface data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    # Look up loopback interface by its ID.
    scm_loopback_intf_ds = scm.get_loopback_interface(id="ddad1e64-0b64-41a4-b361-c6199769a8f1")
    pulumi.export("scmLoopbackInterfaceDataSourceResults", {
        "id": scm_loopback_intf_ds.id,
        "name": scm_loopback_intf_ds.name,
        "comment": scm_loopback_intf_ds.comment,
        "ip": scm_loopback_intf_ds.ips,
        "folder": scm_loopback_intf_ds.folder,
    })
    ```


    :param _builtins.str id: UUID of the resource
    :param _builtins.str name: Loopback Interface name
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scm:index/getLoopbackInterface:getLoopbackInterface', __args__, opts=opts, typ=GetLoopbackInterfaceResult).value

    return AwaitableGetLoopbackInterfaceResult(
        comment=pulumi.get(__ret__, 'comment'),
        default_value=pulumi.get(__ret__, 'default_value'),
        device=pulumi.get(__ret__, 'device'),
        folder=pulumi.get(__ret__, 'folder'),
        id=pulumi.get(__ret__, 'id'),
        interface_management_profile=pulumi.get(__ret__, 'interface_management_profile'),
        ips=pulumi.get(__ret__, 'ips'),
        ipv6=pulumi.get(__ret__, 'ipv6'),
        mtu=pulumi.get(__ret__, 'mtu'),
        name=pulumi.get(__ret__, 'name'),
        snippet=pulumi.get(__ret__, 'snippet'),
        tfid=pulumi.get(__ret__, 'tfid'))
def get_loopback_interface_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                                  name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLoopbackInterfaceResult]:
    """
    LoopbackInterface data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    # Look up loopback interface by its ID.
    scm_loopback_intf_ds = scm.get_loopback_interface(id="ddad1e64-0b64-41a4-b361-c6199769a8f1")
    pulumi.export("scmLoopbackInterfaceDataSourceResults", {
        "id": scm_loopback_intf_ds.id,
        "name": scm_loopback_intf_ds.name,
        "comment": scm_loopback_intf_ds.comment,
        "ip": scm_loopback_intf_ds.ips,
        "folder": scm_loopback_intf_ds.folder,
    })
    ```


    :param _builtins.str id: UUID of the resource
    :param _builtins.str name: Loopback Interface name
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scm:index/getLoopbackInterface:getLoopbackInterface', __args__, opts=opts, typ=GetLoopbackInterfaceResult)
    return __ret__.apply(lambda __response__: GetLoopbackInterfaceResult(
        comment=pulumi.get(__response__, 'comment'),
        default_value=pulumi.get(__response__, 'default_value'),
        device=pulumi.get(__response__, 'device'),
        folder=pulumi.get(__response__, 'folder'),
        id=pulumi.get(__response__, 'id'),
        interface_management_profile=pulumi.get(__response__, 'interface_management_profile'),
        ips=pulumi.get(__response__, 'ips'),
        ipv6=pulumi.get(__response__, 'ipv6'),
        mtu=pulumi.get(__response__, 'mtu'),
        name=pulumi.get(__response__, 'name'),
        snippet=pulumi.get(__response__, 'snippet'),
        tfid=pulumi.get(__response__, 'tfid')))
