# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetPbfRuleResult',
    'AwaitableGetPbfRuleResult',
    'get_pbf_rule',
    'get_pbf_rule_output',
]

@pulumi.output_type
class GetPbfRuleResult:
    """
    A collection of values returned by getPbfRule.
    """
    def __init__(__self__, action=None, applications=None, description=None, destinations=None, device=None, enforce_symmetric_return=None, folder=None, from_=None, id=None, name=None, schedule=None, services=None, snippet=None, source_users=None, sources=None, tags=None, tfid=None):
        if action and not isinstance(action, dict):
            raise TypeError("Expected argument 'action' to be a dict")
        pulumi.set(__self__, "action", action)
        if applications and not isinstance(applications, list):
            raise TypeError("Expected argument 'applications' to be a list")
        pulumi.set(__self__, "applications", applications)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if destinations and not isinstance(destinations, list):
            raise TypeError("Expected argument 'destinations' to be a list")
        pulumi.set(__self__, "destinations", destinations)
        if device and not isinstance(device, str):
            raise TypeError("Expected argument 'device' to be a str")
        pulumi.set(__self__, "device", device)
        if enforce_symmetric_return and not isinstance(enforce_symmetric_return, dict):
            raise TypeError("Expected argument 'enforce_symmetric_return' to be a dict")
        pulumi.set(__self__, "enforce_symmetric_return", enforce_symmetric_return)
        if folder and not isinstance(folder, str):
            raise TypeError("Expected argument 'folder' to be a str")
        pulumi.set(__self__, "folder", folder)
        if from_ and not isinstance(from_, dict):
            raise TypeError("Expected argument 'from_' to be a dict")
        pulumi.set(__self__, "from_", from_)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if schedule and not isinstance(schedule, str):
            raise TypeError("Expected argument 'schedule' to be a str")
        pulumi.set(__self__, "schedule", schedule)
        if services and not isinstance(services, list):
            raise TypeError("Expected argument 'services' to be a list")
        pulumi.set(__self__, "services", services)
        if snippet and not isinstance(snippet, str):
            raise TypeError("Expected argument 'snippet' to be a str")
        pulumi.set(__self__, "snippet", snippet)
        if source_users and not isinstance(source_users, list):
            raise TypeError("Expected argument 'source_users' to be a list")
        pulumi.set(__self__, "source_users", source_users)
        if sources and not isinstance(sources, list):
            raise TypeError("Expected argument 'sources' to be a list")
        pulumi.set(__self__, "sources", sources)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if tfid and not isinstance(tfid, str):
            raise TypeError("Expected argument 'tfid' to be a str")
        pulumi.set(__self__, "tfid", tfid)

    @_builtins.property
    @pulumi.getter
    def action(self) -> 'outputs.GetPbfRuleActionResult':
        """
        Action
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def applications(self) -> Sequence[_builtins.str]:
        """
        Applications
        """
        return pulumi.get(self, "applications")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> Sequence[_builtins.str]:
        """
        Destination addresses
        """
        return pulumi.get(self, "destinations")

    @_builtins.property
    @pulumi.getter
    def device(self) -> _builtins.str:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter(name="enforceSymmetricReturn")
    def enforce_symmetric_return(self) -> 'outputs.GetPbfRuleEnforceSymmetricReturnResult':
        """
        Enforce symmetric return
        """
        return pulumi.get(self, "enforce_symmetric_return")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> _builtins.str:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter(name="from")
    def from_(self) -> 'outputs.GetPbfRuleFromResult':
        """
        From
        """
        return pulumi.get(self, "from_")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        UUID of the resource
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        PBF rule name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> _builtins.str:
        """
        Schedule
        """
        return pulumi.get(self, "schedule")

    @_builtins.property
    @pulumi.getter
    def services(self) -> Sequence[_builtins.str]:
        """
        Services
        """
        return pulumi.get(self, "services")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> _builtins.str:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter(name="sourceUsers")
    def source_users(self) -> Sequence[_builtins.str]:
        """
        Source users
        """
        return pulumi.get(self, "source_users")

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Sequence[_builtins.str]:
        """
        Source addresses
        """
        return pulumi.get(self, "sources")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        Tags
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> _builtins.str:
        return pulumi.get(self, "tfid")


class AwaitableGetPbfRuleResult(GetPbfRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPbfRuleResult(
            action=self.action,
            applications=self.applications,
            description=self.description,
            destinations=self.destinations,
            device=self.device,
            enforce_symmetric_return=self.enforce_symmetric_return,
            folder=self.folder,
            from_=self.from_,
            id=self.id,
            name=self.name,
            schedule=self.schedule,
            services=self.services,
            snippet=self.snippet,
            source_users=self.source_users,
            sources=self.sources,
            tags=self.tags,
            tfid=self.tfid)


def get_pbf_rule(id: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPbfRuleResult:
    """
    PbfRule data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    example_tag = scm.Tag("example_tag",
        folder="All",
        name="pbf-rule-tag-ds-test-1",
        color="Red")
    # --- PBF Rule Resource with discard action---
    example_pbf_rule = scm.PbfRule("example_pbf_rule",
        name="pbf-test-ds-rule-discard",
        folder="All",
        description="Data Source testing pbf rule.",
        from_={
            "zones": ["zone-untrust"],
        },
        sources=["any"],
        destinations=["any"],
        applications=["any"],
        services=["service-http"],
        source_users=["any"],
        action={
            "discard": {},
        },
        tags=[example_tag.name],
        enforce_symmetric_return={
            "enabled": False,
        },
        schedule="non-work-hours")
    # Define the data source (the item to be retrieved via API GET)
    pbf_external_web_test_get = scm.get_pbf_rule_output(id=example_pbf_rule.id)
    pulumi.export("retrievedIDAndName", {
        "id": pbf_external_web_test_get.id,
        "name": pbf_external_web_test_get.name,
    })
    pulumi.export("recievedResponse", pbf_external_web_test_get)
    ```


    :param _builtins.str id: UUID of the resource
    :param _builtins.str name: PBF rule name
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scm:index/getPbfRule:getPbfRule', __args__, opts=opts, typ=GetPbfRuleResult).value

    return AwaitableGetPbfRuleResult(
        action=pulumi.get(__ret__, 'action'),
        applications=pulumi.get(__ret__, 'applications'),
        description=pulumi.get(__ret__, 'description'),
        destinations=pulumi.get(__ret__, 'destinations'),
        device=pulumi.get(__ret__, 'device'),
        enforce_symmetric_return=pulumi.get(__ret__, 'enforce_symmetric_return'),
        folder=pulumi.get(__ret__, 'folder'),
        from_=pulumi.get(__ret__, 'from_'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        schedule=pulumi.get(__ret__, 'schedule'),
        services=pulumi.get(__ret__, 'services'),
        snippet=pulumi.get(__ret__, 'snippet'),
        source_users=pulumi.get(__ret__, 'source_users'),
        sources=pulumi.get(__ret__, 'sources'),
        tags=pulumi.get(__ret__, 'tags'),
        tfid=pulumi.get(__ret__, 'tfid'))
def get_pbf_rule_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                        name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPbfRuleResult]:
    """
    PbfRule data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    example_tag = scm.Tag("example_tag",
        folder="All",
        name="pbf-rule-tag-ds-test-1",
        color="Red")
    # --- PBF Rule Resource with discard action---
    example_pbf_rule = scm.PbfRule("example_pbf_rule",
        name="pbf-test-ds-rule-discard",
        folder="All",
        description="Data Source testing pbf rule.",
        from_={
            "zones": ["zone-untrust"],
        },
        sources=["any"],
        destinations=["any"],
        applications=["any"],
        services=["service-http"],
        source_users=["any"],
        action={
            "discard": {},
        },
        tags=[example_tag.name],
        enforce_symmetric_return={
            "enabled": False,
        },
        schedule="non-work-hours")
    # Define the data source (the item to be retrieved via API GET)
    pbf_external_web_test_get = scm.get_pbf_rule_output(id=example_pbf_rule.id)
    pulumi.export("retrievedIDAndName", {
        "id": pbf_external_web_test_get.id,
        "name": pbf_external_web_test_get.name,
    })
    pulumi.export("recievedResponse", pbf_external_web_test_get)
    ```


    :param _builtins.str id: UUID of the resource
    :param _builtins.str name: PBF rule name
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scm:index/getPbfRule:getPbfRule', __args__, opts=opts, typ=GetPbfRuleResult)
    return __ret__.apply(lambda __response__: GetPbfRuleResult(
        action=pulumi.get(__response__, 'action'),
        applications=pulumi.get(__response__, 'applications'),
        description=pulumi.get(__response__, 'description'),
        destinations=pulumi.get(__response__, 'destinations'),
        device=pulumi.get(__response__, 'device'),
        enforce_symmetric_return=pulumi.get(__response__, 'enforce_symmetric_return'),
        folder=pulumi.get(__response__, 'folder'),
        from_=pulumi.get(__response__, 'from_'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        schedule=pulumi.get(__response__, 'schedule'),
        services=pulumi.get(__response__, 'services'),
        snippet=pulumi.get(__response__, 'snippet'),
        source_users=pulumi.get(__response__, 'source_users'),
        sources=pulumi.get(__response__, 'sources'),
        tags=pulumi.get(__response__, 'tags'),
        tfid=pulumi.get(__response__, 'tfid')))
