# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetQosPolicyRuleResult',
    'AwaitableGetQosPolicyRuleResult',
    'get_qos_policy_rule',
    'get_qos_policy_rule_output',
]

@pulumi.output_type
class GetQosPolicyRuleResult:
    """
    A collection of values returned by getQosPolicyRule.
    """
    def __init__(__self__, action=None, description=None, device=None, dscp_tos=None, folder=None, id=None, name=None, position=None, relative_position=None, schedule=None, snippet=None, target_rule=None, tfid=None):
        if action and not isinstance(action, dict):
            raise TypeError("Expected argument 'action' to be a dict")
        pulumi.set(__self__, "action", action)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if device and not isinstance(device, str):
            raise TypeError("Expected argument 'device' to be a str")
        pulumi.set(__self__, "device", device)
        if dscp_tos and not isinstance(dscp_tos, dict):
            raise TypeError("Expected argument 'dscp_tos' to be a dict")
        pulumi.set(__self__, "dscp_tos", dscp_tos)
        if folder and not isinstance(folder, str):
            raise TypeError("Expected argument 'folder' to be a str")
        pulumi.set(__self__, "folder", folder)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if position and not isinstance(position, str):
            raise TypeError("Expected argument 'position' to be a str")
        pulumi.set(__self__, "position", position)
        if relative_position and not isinstance(relative_position, str):
            raise TypeError("Expected argument 'relative_position' to be a str")
        pulumi.set(__self__, "relative_position", relative_position)
        if schedule and not isinstance(schedule, str):
            raise TypeError("Expected argument 'schedule' to be a str")
        pulumi.set(__self__, "schedule", schedule)
        if snippet and not isinstance(snippet, str):
            raise TypeError("Expected argument 'snippet' to be a str")
        pulumi.set(__self__, "snippet", snippet)
        if target_rule and not isinstance(target_rule, str):
            raise TypeError("Expected argument 'target_rule' to be a str")
        pulumi.set(__self__, "target_rule", target_rule)
        if tfid and not isinstance(tfid, str):
            raise TypeError("Expected argument 'tfid' to be a str")
        pulumi.set(__self__, "tfid", tfid)

    @_builtins.property
    @pulumi.getter
    def action(self) -> 'outputs.GetQosPolicyRuleActionResult':
        """
        Action
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def device(self) -> _builtins.str:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter(name="dscpTos")
    def dscp_tos(self) -> 'outputs.GetQosPolicyRuleDscpTosResult':
        """
        Dscp tos
        """
        return pulumi.get(self, "dscp_tos")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> _builtins.str:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        UUID of the resource
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def position(self) -> _builtins.str:
        """
        The relative position of the rule
        """
        return pulumi.get(self, "position")

    @_builtins.property
    @pulumi.getter(name="relativePosition")
    def relative_position(self) -> _builtins.str:
        """
        Relative positioning rule. String must be one of these: `"before"`, `"after"`, `"top"`, `"bottom"`. If not specified, rule is created at the bottom of the ruleset.
        """
        return pulumi.get(self, "relative_position")

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> _builtins.str:
        """
        Schedule
        """
        return pulumi.get(self, "schedule")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> _builtins.str:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter(name="targetRule")
    def target_rule(self) -> _builtins.str:
        """
        The name or UUID of the rule to position this rule relative to. Required when `relative_position` is `"before"` or `"after"`.
        """
        return pulumi.get(self, "target_rule")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> _builtins.str:
        return pulumi.get(self, "tfid")


class AwaitableGetQosPolicyRuleResult(GetQosPolicyRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetQosPolicyRuleResult(
            action=self.action,
            description=self.description,
            device=self.device,
            dscp_tos=self.dscp_tos,
            folder=self.folder,
            id=self.id,
            name=self.name,
            position=self.position,
            relative_position=self.relative_position,
            schedule=self.schedule,
            snippet=self.snippet,
            target_rule=self.target_rule,
            tfid=self.tfid)


def get_qos_policy_rule(id: Optional[_builtins.str] = None,
                        name: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetQosPolicyRuleResult:
    """
    QosPolicyRule data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    test_qos_policy_rule = scm.QosPolicyRule("test_qos_policy_rule",
        name="data-source-qos-test",
        description="Rule created specifically for data source testing with DSCP/TOS.",
        folder="All",
        position="pre",
        schedule="non-work-hours",
        action={
            "class_": "1",
        },
        dscp_tos={
            "codepoints": [{
                "name": "Expedited Forwarding",
                "type": {
                    "ef": {},
                },
            }],
        })
    single_rule_by_id = scm.get_qos_policy_rule_output(id=test_qos_policy_rule.id)
    pulumi.export("singleQosPolicyRuleDump", single_rule_by_id)
    ```


    :param _builtins.str id: UUID of the resource
    :param _builtins.str name: Name
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scm:index/getQosPolicyRule:getQosPolicyRule', __args__, opts=opts, typ=GetQosPolicyRuleResult).value

    return AwaitableGetQosPolicyRuleResult(
        action=pulumi.get(__ret__, 'action'),
        description=pulumi.get(__ret__, 'description'),
        device=pulumi.get(__ret__, 'device'),
        dscp_tos=pulumi.get(__ret__, 'dscp_tos'),
        folder=pulumi.get(__ret__, 'folder'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        position=pulumi.get(__ret__, 'position'),
        relative_position=pulumi.get(__ret__, 'relative_position'),
        schedule=pulumi.get(__ret__, 'schedule'),
        snippet=pulumi.get(__ret__, 'snippet'),
        target_rule=pulumi.get(__ret__, 'target_rule'),
        tfid=pulumi.get(__ret__, 'tfid'))
def get_qos_policy_rule_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                               name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetQosPolicyRuleResult]:
    """
    QosPolicyRule data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    test_qos_policy_rule = scm.QosPolicyRule("test_qos_policy_rule",
        name="data-source-qos-test",
        description="Rule created specifically for data source testing with DSCP/TOS.",
        folder="All",
        position="pre",
        schedule="non-work-hours",
        action={
            "class_": "1",
        },
        dscp_tos={
            "codepoints": [{
                "name": "Expedited Forwarding",
                "type": {
                    "ef": {},
                },
            }],
        })
    single_rule_by_id = scm.get_qos_policy_rule_output(id=test_qos_policy_rule.id)
    pulumi.export("singleQosPolicyRuleDump", single_rule_by_id)
    ```


    :param _builtins.str id: UUID of the resource
    :param _builtins.str name: Name
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scm:index/getQosPolicyRule:getQosPolicyRule', __args__, opts=opts, typ=GetQosPolicyRuleResult)
    return __ret__.apply(lambda __response__: GetQosPolicyRuleResult(
        action=pulumi.get(__response__, 'action'),
        description=pulumi.get(__response__, 'description'),
        device=pulumi.get(__response__, 'device'),
        dscp_tos=pulumi.get(__response__, 'dscp_tos'),
        folder=pulumi.get(__response__, 'folder'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        position=pulumi.get(__response__, 'position'),
        relative_position=pulumi.get(__response__, 'relative_position'),
        schedule=pulumi.get(__response__, 'schedule'),
        snippet=pulumi.get(__response__, 'snippet'),
        target_rule=pulumi.get(__response__, 'target_rule'),
        tfid=pulumi.get(__response__, 'tfid')))
