# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetServiceConnectionResult',
    'AwaitableGetServiceConnectionResult',
    'get_service_connection',
    'get_service_connection_output',
]

@pulumi.output_type
class GetServiceConnectionResult:
    """
    A collection of values returned by getServiceConnection.
    """
    def __init__(__self__, backup_sc=None, bgp_peer=None, encrypted_values=None, id=None, ipsec_tunnel=None, name=None, nat_pool=None, no_export_community=None, onboarding_type=None, protocol=None, qos=None, region=None, secondary_ipsec_tunnel=None, source_nat=None, subnets=None, tfid=None):
        if backup_sc and not isinstance(backup_sc, str):
            raise TypeError("Expected argument 'backup_sc' to be a str")
        pulumi.set(__self__, "backup_sc", backup_sc)
        if bgp_peer and not isinstance(bgp_peer, dict):
            raise TypeError("Expected argument 'bgp_peer' to be a dict")
        pulumi.set(__self__, "bgp_peer", bgp_peer)
        if encrypted_values and not isinstance(encrypted_values, dict):
            raise TypeError("Expected argument 'encrypted_values' to be a dict")
        pulumi.set(__self__, "encrypted_values", encrypted_values)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ipsec_tunnel and not isinstance(ipsec_tunnel, str):
            raise TypeError("Expected argument 'ipsec_tunnel' to be a str")
        pulumi.set(__self__, "ipsec_tunnel", ipsec_tunnel)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if nat_pool and not isinstance(nat_pool, str):
            raise TypeError("Expected argument 'nat_pool' to be a str")
        pulumi.set(__self__, "nat_pool", nat_pool)
        if no_export_community and not isinstance(no_export_community, str):
            raise TypeError("Expected argument 'no_export_community' to be a str")
        pulumi.set(__self__, "no_export_community", no_export_community)
        if onboarding_type and not isinstance(onboarding_type, str):
            raise TypeError("Expected argument 'onboarding_type' to be a str")
        pulumi.set(__self__, "onboarding_type", onboarding_type)
        if protocol and not isinstance(protocol, dict):
            raise TypeError("Expected argument 'protocol' to be a dict")
        pulumi.set(__self__, "protocol", protocol)
        if qos and not isinstance(qos, dict):
            raise TypeError("Expected argument 'qos' to be a dict")
        pulumi.set(__self__, "qos", qos)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if secondary_ipsec_tunnel and not isinstance(secondary_ipsec_tunnel, str):
            raise TypeError("Expected argument 'secondary_ipsec_tunnel' to be a str")
        pulumi.set(__self__, "secondary_ipsec_tunnel", secondary_ipsec_tunnel)
        if source_nat and not isinstance(source_nat, bool):
            raise TypeError("Expected argument 'source_nat' to be a bool")
        pulumi.set(__self__, "source_nat", source_nat)
        if subnets and not isinstance(subnets, list):
            raise TypeError("Expected argument 'subnets' to be a list")
        pulumi.set(__self__, "subnets", subnets)
        if tfid and not isinstance(tfid, str):
            raise TypeError("Expected argument 'tfid' to be a str")
        pulumi.set(__self__, "tfid", tfid)

    @_builtins.property
    @pulumi.getter(name="backupSc")
    def backup_sc(self) -> _builtins.str:
        """
        Backup s c
        """
        return pulumi.get(self, "backup_sc")

    @_builtins.property
    @pulumi.getter(name="bgpPeer")
    def bgp_peer(self) -> 'outputs.GetServiceConnectionBgpPeerResult':
        """
        Bgp peer
        """
        return pulumi.get(self, "bgp_peer")

    @_builtins.property
    @pulumi.getter(name="encryptedValues")
    def encrypted_values(self) -> Mapping[str, _builtins.str]:
        """
        Map of sensitive values returned from the API.
        """
        return pulumi.get(self, "encrypted_values")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The UUID of the service connection
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipsecTunnel")
    def ipsec_tunnel(self) -> _builtins.str:
        """
        Ipsec tunnel
        """
        return pulumi.get(self, "ipsec_tunnel")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the service connection
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="natPool")
    def nat_pool(self) -> _builtins.str:
        """
        Nat pool
        """
        return pulumi.get(self, "nat_pool")

    @_builtins.property
    @pulumi.getter(name="noExportCommunity")
    def no_export_community(self) -> _builtins.str:
        """
        No export community
        """
        return pulumi.get(self, "no_export_community")

    @_builtins.property
    @pulumi.getter(name="onboardingType")
    def onboarding_type(self) -> _builtins.str:
        """
        Onboarding type
        """
        return pulumi.get(self, "onboarding_type")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> 'outputs.GetServiceConnectionProtocolResult':
        """
        Protocol
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def qos(self) -> 'outputs.GetServiceConnectionQosResult':
        """
        Qos
        """
        return pulumi.get(self, "qos")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        Region
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="secondaryIpsecTunnel")
    def secondary_ipsec_tunnel(self) -> _builtins.str:
        """
        Secondary ipsec tunnel
        """
        return pulumi.get(self, "secondary_ipsec_tunnel")

    @_builtins.property
    @pulumi.getter(name="sourceNat")
    def source_nat(self) -> _builtins.bool:
        """
        Source nat
        """
        return pulumi.get(self, "source_nat")

    @_builtins.property
    @pulumi.getter
    def subnets(self) -> Sequence[_builtins.str]:
        """
        Subnets
        """
        return pulumi.get(self, "subnets")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> _builtins.str:
        return pulumi.get(self, "tfid")


class AwaitableGetServiceConnectionResult(GetServiceConnectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceConnectionResult(
            backup_sc=self.backup_sc,
            bgp_peer=self.bgp_peer,
            encrypted_values=self.encrypted_values,
            id=self.id,
            ipsec_tunnel=self.ipsec_tunnel,
            name=self.name,
            nat_pool=self.nat_pool,
            no_export_community=self.no_export_community,
            onboarding_type=self.onboarding_type,
            protocol=self.protocol,
            qos=self.qos,
            region=self.region,
            secondary_ipsec_tunnel=self.secondary_ipsec_tunnel,
            source_nat=self.source_nat,
            subnets=self.subnets,
            tfid=self.tfid)


def get_service_connection(id: Optional[_builtins.str] = None,
                           name: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceConnectionResult:
    """
    ServiceConnection data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    config = pulumi.Config()
    # The folder scope for the SCM resource (e.g., 'Shared', 'Predefined', or a specific folder name).
    folder_scope = config.get("folderScope")
    if folder_scope is None:
        folder_scope = "Service Connections"
    ## 1. Define the IKE Crypto Profile (IKE Phase 1)
    # Note: The resource name is plural: "scm_ike_crypto_profile"
    example = scm.IkeCryptoProfile("example",
        name="example-ike-crypto_data",
        folder=folder_scope,
        hashes=["sha256"],
        dh_groups=["group14"],
        encryptions=["aes-256-cbc"])
    ## 2. Define the IPsec Crypto Profile (IKE Phase 2)
    # Note: The resource name is plural and nested blocks now use an equals sign (=).
    example_ipsec_crypto_profile = scm.IpsecCryptoProfile("example",
        name="panw-IPSec-Crypto_data",
        folder=folder_scope,
        esp={
            "encryptions": ["aes-256-gcm"],
            "authentications": ["sha256"],
        },
        dh_group="group14",
        lifetime={
            "hours": 8,
        })
    ## 3. Define the IKE Gateway
    # Note: The resource name is plural and nested blocks now use an equals sign (=).
    example_ike_gateway = scm.IkeGateway("example",
        name="example-gateway_data",
        folder=folder_scope,
        peer_address={
            "ip": "1.1.1.1",
        },
        authentication={
            "pre_shared_key": {
                "key": "secret",
            },
        },
        protocol={
            "ikev1": {
                "ike_crypto_profile": example.name,
            },
        })
    ## 4. Define the IPsec Tunnel
    # Note: Nested 'auto_key' block uses an equals sign (=).
    example_ipsec_tunnel = scm.IpsecTunnel("example",
        name="example-tunnel_data",
        folder=folder_scope,
        tunnel_interface="tunnel",
        anti_replay=True,
        copy_tos=False,
        enable_gre_encapsulation=False,
        auto_key={
            "ike_gateways": [{
                "name": example_ike_gateway.name,
            }],
            "ipsec_crypto_profile": example_ipsec_crypto_profile.name,
        },
        opts = pulumi.ResourceOptions(depends_on=[example_ike_gateway]))
    site_a_vpn_sc = scm.ServiceConnection("site_a_vpn_sc",
        name="creating_a_service_connection_data",
        region="us-west-1",
        ipsec_tunnel=example_ipsec_tunnel.name,
        subnets=[
            "10.1.0.0/16",
            "172.16.0.0/24",
        ],
        source_nat=True)
    #------------------------------------------------------
    # Data Soruce
    #------------------------------------------------------
    created_conn_lookup = scm.get_service_connection_output(id=site_a_vpn_sc.id)
    pulumi.export("createdServiceConnectionId", created_conn_lookup.id)
    pulumi.export("createdServiceConnectionRegion", created_conn_lookup.region)
    pulumi.export("createdServiceConnectionSubnets", created_conn_lookup.subnets)
    ```


    :param _builtins.str id: The UUID of the service connection
    :param _builtins.str name: The name of the service connection
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scm:index/getServiceConnection:getServiceConnection', __args__, opts=opts, typ=GetServiceConnectionResult).value

    return AwaitableGetServiceConnectionResult(
        backup_sc=pulumi.get(__ret__, 'backup_sc'),
        bgp_peer=pulumi.get(__ret__, 'bgp_peer'),
        encrypted_values=pulumi.get(__ret__, 'encrypted_values'),
        id=pulumi.get(__ret__, 'id'),
        ipsec_tunnel=pulumi.get(__ret__, 'ipsec_tunnel'),
        name=pulumi.get(__ret__, 'name'),
        nat_pool=pulumi.get(__ret__, 'nat_pool'),
        no_export_community=pulumi.get(__ret__, 'no_export_community'),
        onboarding_type=pulumi.get(__ret__, 'onboarding_type'),
        protocol=pulumi.get(__ret__, 'protocol'),
        qos=pulumi.get(__ret__, 'qos'),
        region=pulumi.get(__ret__, 'region'),
        secondary_ipsec_tunnel=pulumi.get(__ret__, 'secondary_ipsec_tunnel'),
        source_nat=pulumi.get(__ret__, 'source_nat'),
        subnets=pulumi.get(__ret__, 'subnets'),
        tfid=pulumi.get(__ret__, 'tfid'))
def get_service_connection_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                                  name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServiceConnectionResult]:
    """
    ServiceConnection data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    config = pulumi.Config()
    # The folder scope for the SCM resource (e.g., 'Shared', 'Predefined', or a specific folder name).
    folder_scope = config.get("folderScope")
    if folder_scope is None:
        folder_scope = "Service Connections"
    ## 1. Define the IKE Crypto Profile (IKE Phase 1)
    # Note: The resource name is plural: "scm_ike_crypto_profile"
    example = scm.IkeCryptoProfile("example",
        name="example-ike-crypto_data",
        folder=folder_scope,
        hashes=["sha256"],
        dh_groups=["group14"],
        encryptions=["aes-256-cbc"])
    ## 2. Define the IPsec Crypto Profile (IKE Phase 2)
    # Note: The resource name is plural and nested blocks now use an equals sign (=).
    example_ipsec_crypto_profile = scm.IpsecCryptoProfile("example",
        name="panw-IPSec-Crypto_data",
        folder=folder_scope,
        esp={
            "encryptions": ["aes-256-gcm"],
            "authentications": ["sha256"],
        },
        dh_group="group14",
        lifetime={
            "hours": 8,
        })
    ## 3. Define the IKE Gateway
    # Note: The resource name is plural and nested blocks now use an equals sign (=).
    example_ike_gateway = scm.IkeGateway("example",
        name="example-gateway_data",
        folder=folder_scope,
        peer_address={
            "ip": "1.1.1.1",
        },
        authentication={
            "pre_shared_key": {
                "key": "secret",
            },
        },
        protocol={
            "ikev1": {
                "ike_crypto_profile": example.name,
            },
        })
    ## 4. Define the IPsec Tunnel
    # Note: Nested 'auto_key' block uses an equals sign (=).
    example_ipsec_tunnel = scm.IpsecTunnel("example",
        name="example-tunnel_data",
        folder=folder_scope,
        tunnel_interface="tunnel",
        anti_replay=True,
        copy_tos=False,
        enable_gre_encapsulation=False,
        auto_key={
            "ike_gateways": [{
                "name": example_ike_gateway.name,
            }],
            "ipsec_crypto_profile": example_ipsec_crypto_profile.name,
        },
        opts = pulumi.ResourceOptions(depends_on=[example_ike_gateway]))
    site_a_vpn_sc = scm.ServiceConnection("site_a_vpn_sc",
        name="creating_a_service_connection_data",
        region="us-west-1",
        ipsec_tunnel=example_ipsec_tunnel.name,
        subnets=[
            "10.1.0.0/16",
            "172.16.0.0/24",
        ],
        source_nat=True)
    #------------------------------------------------------
    # Data Soruce
    #------------------------------------------------------
    created_conn_lookup = scm.get_service_connection_output(id=site_a_vpn_sc.id)
    pulumi.export("createdServiceConnectionId", created_conn_lookup.id)
    pulumi.export("createdServiceConnectionRegion", created_conn_lookup.region)
    pulumi.export("createdServiceConnectionSubnets", created_conn_lookup.subnets)
    ```


    :param _builtins.str id: The UUID of the service connection
    :param _builtins.str name: The name of the service connection
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scm:index/getServiceConnection:getServiceConnection', __args__, opts=opts, typ=GetServiceConnectionResult)
    return __ret__.apply(lambda __response__: GetServiceConnectionResult(
        backup_sc=pulumi.get(__response__, 'backup_sc'),
        bgp_peer=pulumi.get(__response__, 'bgp_peer'),
        encrypted_values=pulumi.get(__response__, 'encrypted_values'),
        id=pulumi.get(__response__, 'id'),
        ipsec_tunnel=pulumi.get(__response__, 'ipsec_tunnel'),
        name=pulumi.get(__response__, 'name'),
        nat_pool=pulumi.get(__response__, 'nat_pool'),
        no_export_community=pulumi.get(__response__, 'no_export_community'),
        onboarding_type=pulumi.get(__response__, 'onboarding_type'),
        protocol=pulumi.get(__response__, 'protocol'),
        qos=pulumi.get(__response__, 'qos'),
        region=pulumi.get(__response__, 'region'),
        secondary_ipsec_tunnel=pulumi.get(__response__, 'secondary_ipsec_tunnel'),
        source_nat=pulumi.get(__response__, 'source_nat'),
        subnets=pulumi.get(__response__, 'subnets'),
        tfid=pulumi.get(__response__, 'tfid')))
