# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetUrlAccessProfileResult',
    'AwaitableGetUrlAccessProfileResult',
    'get_url_access_profile',
    'get_url_access_profile_output',
]

@pulumi.output_type
class GetUrlAccessProfileResult:
    """
    A collection of values returned by getUrlAccessProfile.
    """
    def __init__(__self__, alerts=None, allows=None, blocks=None, cloud_inline_cat=None, continues=None, credential_enforcement=None, description=None, device=None, folder=None, id=None, local_inline_cat=None, log_container_page_only=None, log_http_hdr_referer=None, log_http_hdr_user_agent=None, log_http_hdr_xff=None, mlav_category_exceptions=None, name=None, redirects=None, safe_search_enforcement=None, snippet=None, tfid=None):
        if alerts and not isinstance(alerts, list):
            raise TypeError("Expected argument 'alerts' to be a list")
        pulumi.set(__self__, "alerts", alerts)
        if allows and not isinstance(allows, list):
            raise TypeError("Expected argument 'allows' to be a list")
        pulumi.set(__self__, "allows", allows)
        if blocks and not isinstance(blocks, list):
            raise TypeError("Expected argument 'blocks' to be a list")
        pulumi.set(__self__, "blocks", blocks)
        if cloud_inline_cat and not isinstance(cloud_inline_cat, bool):
            raise TypeError("Expected argument 'cloud_inline_cat' to be a bool")
        pulumi.set(__self__, "cloud_inline_cat", cloud_inline_cat)
        if continues and not isinstance(continues, list):
            raise TypeError("Expected argument 'continues' to be a list")
        pulumi.set(__self__, "continues", continues)
        if credential_enforcement and not isinstance(credential_enforcement, dict):
            raise TypeError("Expected argument 'credential_enforcement' to be a dict")
        pulumi.set(__self__, "credential_enforcement", credential_enforcement)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if device and not isinstance(device, str):
            raise TypeError("Expected argument 'device' to be a str")
        pulumi.set(__self__, "device", device)
        if folder and not isinstance(folder, str):
            raise TypeError("Expected argument 'folder' to be a str")
        pulumi.set(__self__, "folder", folder)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if local_inline_cat and not isinstance(local_inline_cat, bool):
            raise TypeError("Expected argument 'local_inline_cat' to be a bool")
        pulumi.set(__self__, "local_inline_cat", local_inline_cat)
        if log_container_page_only and not isinstance(log_container_page_only, bool):
            raise TypeError("Expected argument 'log_container_page_only' to be a bool")
        pulumi.set(__self__, "log_container_page_only", log_container_page_only)
        if log_http_hdr_referer and not isinstance(log_http_hdr_referer, bool):
            raise TypeError("Expected argument 'log_http_hdr_referer' to be a bool")
        pulumi.set(__self__, "log_http_hdr_referer", log_http_hdr_referer)
        if log_http_hdr_user_agent and not isinstance(log_http_hdr_user_agent, bool):
            raise TypeError("Expected argument 'log_http_hdr_user_agent' to be a bool")
        pulumi.set(__self__, "log_http_hdr_user_agent", log_http_hdr_user_agent)
        if log_http_hdr_xff and not isinstance(log_http_hdr_xff, bool):
            raise TypeError("Expected argument 'log_http_hdr_xff' to be a bool")
        pulumi.set(__self__, "log_http_hdr_xff", log_http_hdr_xff)
        if mlav_category_exceptions and not isinstance(mlav_category_exceptions, list):
            raise TypeError("Expected argument 'mlav_category_exceptions' to be a list")
        pulumi.set(__self__, "mlav_category_exceptions", mlav_category_exceptions)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if redirects and not isinstance(redirects, list):
            raise TypeError("Expected argument 'redirects' to be a list")
        pulumi.set(__self__, "redirects", redirects)
        if safe_search_enforcement and not isinstance(safe_search_enforcement, bool):
            raise TypeError("Expected argument 'safe_search_enforcement' to be a bool")
        pulumi.set(__self__, "safe_search_enforcement", safe_search_enforcement)
        if snippet and not isinstance(snippet, str):
            raise TypeError("Expected argument 'snippet' to be a str")
        pulumi.set(__self__, "snippet", snippet)
        if tfid and not isinstance(tfid, str):
            raise TypeError("Expected argument 'tfid' to be a str")
        pulumi.set(__self__, "tfid", tfid)

    @_builtins.property
    @pulumi.getter
    def alerts(self) -> Sequence[_builtins.str]:
        """
        Alert
        """
        return pulumi.get(self, "alerts")

    @_builtins.property
    @pulumi.getter
    def allows(self) -> Sequence[_builtins.str]:
        """
        Allow
        """
        return pulumi.get(self, "allows")

    @_builtins.property
    @pulumi.getter
    def blocks(self) -> Sequence[_builtins.str]:
        """
        Block
        """
        return pulumi.get(self, "blocks")

    @_builtins.property
    @pulumi.getter(name="cloudInlineCat")
    def cloud_inline_cat(self) -> _builtins.bool:
        """
        Cloud inline cat
        """
        return pulumi.get(self, "cloud_inline_cat")

    @_builtins.property
    @pulumi.getter
    def continues(self) -> Sequence[_builtins.str]:
        """
        Continue
        """
        return pulumi.get(self, "continues")

    @_builtins.property
    @pulumi.getter(name="credentialEnforcement")
    def credential_enforcement(self) -> 'outputs.GetUrlAccessProfileCredentialEnforcementResult':
        """
        Credential enforcement
        """
        return pulumi.get(self, "credential_enforcement")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def device(self) -> _builtins.str:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> _builtins.str:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        UUID of the resource
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="localInlineCat")
    def local_inline_cat(self) -> _builtins.bool:
        """
        Local inline cat
        """
        return pulumi.get(self, "local_inline_cat")

    @_builtins.property
    @pulumi.getter(name="logContainerPageOnly")
    def log_container_page_only(self) -> _builtins.bool:
        """
        Log container page only
        """
        return pulumi.get(self, "log_container_page_only")

    @_builtins.property
    @pulumi.getter(name="logHttpHdrReferer")
    def log_http_hdr_referer(self) -> _builtins.bool:
        """
        Log http hdr referer
        """
        return pulumi.get(self, "log_http_hdr_referer")

    @_builtins.property
    @pulumi.getter(name="logHttpHdrUserAgent")
    def log_http_hdr_user_agent(self) -> _builtins.bool:
        """
        Log http hdr user agent
        """
        return pulumi.get(self, "log_http_hdr_user_agent")

    @_builtins.property
    @pulumi.getter(name="logHttpHdrXff")
    def log_http_hdr_xff(self) -> _builtins.bool:
        """
        Log http hdr xff
        """
        return pulumi.get(self, "log_http_hdr_xff")

    @_builtins.property
    @pulumi.getter(name="mlavCategoryExceptions")
    def mlav_category_exceptions(self) -> Sequence[_builtins.str]:
        """
        Mlav category exception
        """
        return pulumi.get(self, "mlav_category_exceptions")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def redirects(self) -> Sequence[_builtins.str]:
        """
        Redirect
        """
        return pulumi.get(self, "redirects")

    @_builtins.property
    @pulumi.getter(name="safeSearchEnforcement")
    def safe_search_enforcement(self) -> _builtins.bool:
        """
        Safe search enforcement
        """
        return pulumi.get(self, "safe_search_enforcement")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> _builtins.str:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> _builtins.str:
        return pulumi.get(self, "tfid")


class AwaitableGetUrlAccessProfileResult(GetUrlAccessProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUrlAccessProfileResult(
            alerts=self.alerts,
            allows=self.allows,
            blocks=self.blocks,
            cloud_inline_cat=self.cloud_inline_cat,
            continues=self.continues,
            credential_enforcement=self.credential_enforcement,
            description=self.description,
            device=self.device,
            folder=self.folder,
            id=self.id,
            local_inline_cat=self.local_inline_cat,
            log_container_page_only=self.log_container_page_only,
            log_http_hdr_referer=self.log_http_hdr_referer,
            log_http_hdr_user_agent=self.log_http_hdr_user_agent,
            log_http_hdr_xff=self.log_http_hdr_xff,
            mlav_category_exceptions=self.mlav_category_exceptions,
            name=self.name,
            redirects=self.redirects,
            safe_search_enforcement=self.safe_search_enforcement,
            snippet=self.snippet,
            tfid=self.tfid)


def get_url_access_profile(id: Optional[_builtins.str] = None,
                           name: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUrlAccessProfileResult:
    """
    UrlAccessProfile data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    #
    # Data source to retrieve a single URL Access Profile object by its ID.
    #
    # Replace the ID with the UUID of the URL Access Profile you want to find.
    example = scm.get_url_access_profile(id="e97c7e7e-9906-42d6-90a8-606ed5527125")
    pulumi.export("urlAccessProfileDetails", example)
    ```


    :param _builtins.str id: UUID of the resource
    :param _builtins.str name: Name
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scm:index/getUrlAccessProfile:getUrlAccessProfile', __args__, opts=opts, typ=GetUrlAccessProfileResult).value

    return AwaitableGetUrlAccessProfileResult(
        alerts=pulumi.get(__ret__, 'alerts'),
        allows=pulumi.get(__ret__, 'allows'),
        blocks=pulumi.get(__ret__, 'blocks'),
        cloud_inline_cat=pulumi.get(__ret__, 'cloud_inline_cat'),
        continues=pulumi.get(__ret__, 'continues'),
        credential_enforcement=pulumi.get(__ret__, 'credential_enforcement'),
        description=pulumi.get(__ret__, 'description'),
        device=pulumi.get(__ret__, 'device'),
        folder=pulumi.get(__ret__, 'folder'),
        id=pulumi.get(__ret__, 'id'),
        local_inline_cat=pulumi.get(__ret__, 'local_inline_cat'),
        log_container_page_only=pulumi.get(__ret__, 'log_container_page_only'),
        log_http_hdr_referer=pulumi.get(__ret__, 'log_http_hdr_referer'),
        log_http_hdr_user_agent=pulumi.get(__ret__, 'log_http_hdr_user_agent'),
        log_http_hdr_xff=pulumi.get(__ret__, 'log_http_hdr_xff'),
        mlav_category_exceptions=pulumi.get(__ret__, 'mlav_category_exceptions'),
        name=pulumi.get(__ret__, 'name'),
        redirects=pulumi.get(__ret__, 'redirects'),
        safe_search_enforcement=pulumi.get(__ret__, 'safe_search_enforcement'),
        snippet=pulumi.get(__ret__, 'snippet'),
        tfid=pulumi.get(__ret__, 'tfid'))
def get_url_access_profile_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                                  name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUrlAccessProfileResult]:
    """
    UrlAccessProfile data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    #
    # Data source to retrieve a single URL Access Profile object by its ID.
    #
    # Replace the ID with the UUID of the URL Access Profile you want to find.
    example = scm.get_url_access_profile(id="e97c7e7e-9906-42d6-90a8-606ed5527125")
    pulumi.export("urlAccessProfileDetails", example)
    ```


    :param _builtins.str id: UUID of the resource
    :param _builtins.str name: Name
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scm:index/getUrlAccessProfile:getUrlAccessProfile', __args__, opts=opts, typ=GetUrlAccessProfileResult)
    return __ret__.apply(lambda __response__: GetUrlAccessProfileResult(
        alerts=pulumi.get(__response__, 'alerts'),
        allows=pulumi.get(__response__, 'allows'),
        blocks=pulumi.get(__response__, 'blocks'),
        cloud_inline_cat=pulumi.get(__response__, 'cloud_inline_cat'),
        continues=pulumi.get(__response__, 'continues'),
        credential_enforcement=pulumi.get(__response__, 'credential_enforcement'),
        description=pulumi.get(__response__, 'description'),
        device=pulumi.get(__response__, 'device'),
        folder=pulumi.get(__response__, 'folder'),
        id=pulumi.get(__response__, 'id'),
        local_inline_cat=pulumi.get(__response__, 'local_inline_cat'),
        log_container_page_only=pulumi.get(__response__, 'log_container_page_only'),
        log_http_hdr_referer=pulumi.get(__response__, 'log_http_hdr_referer'),
        log_http_hdr_user_agent=pulumi.get(__response__, 'log_http_hdr_user_agent'),
        log_http_hdr_xff=pulumi.get(__response__, 'log_http_hdr_xff'),
        mlav_category_exceptions=pulumi.get(__response__, 'mlav_category_exceptions'),
        name=pulumi.get(__response__, 'name'),
        redirects=pulumi.get(__response__, 'redirects'),
        safe_search_enforcement=pulumi.get(__response__, 'safe_search_enforcement'),
        snippet=pulumi.get(__response__, 'snippet'),
        tfid=pulumi.get(__response__, 'tfid')))
