# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetVulnerabilityProtectionProfileResult',
    'AwaitableGetVulnerabilityProtectionProfileResult',
    'get_vulnerability_protection_profile',
    'get_vulnerability_protection_profile_output',
]

@pulumi.output_type
class GetVulnerabilityProtectionProfileResult:
    """
    A collection of values returned by getVulnerabilityProtectionProfile.
    """
    def __init__(__self__, description=None, device=None, folder=None, id=None, name=None, rules=None, snippet=None, tfid=None, threat_exceptions=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if device and not isinstance(device, str):
            raise TypeError("Expected argument 'device' to be a str")
        pulumi.set(__self__, "device", device)
        if folder and not isinstance(folder, str):
            raise TypeError("Expected argument 'folder' to be a str")
        pulumi.set(__self__, "folder", folder)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if rules and not isinstance(rules, list):
            raise TypeError("Expected argument 'rules' to be a list")
        pulumi.set(__self__, "rules", rules)
        if snippet and not isinstance(snippet, str):
            raise TypeError("Expected argument 'snippet' to be a str")
        pulumi.set(__self__, "snippet", snippet)
        if tfid and not isinstance(tfid, str):
            raise TypeError("Expected argument 'tfid' to be a str")
        pulumi.set(__self__, "tfid", tfid)
        if threat_exceptions and not isinstance(threat_exceptions, list):
            raise TypeError("Expected argument 'threat_exceptions' to be a list")
        pulumi.set(__self__, "threat_exceptions", threat_exceptions)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def device(self) -> _builtins.str:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> _builtins.str:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        UUID of the resource
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetVulnerabilityProtectionProfileRuleResult']:
        """
        Rules
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> _builtins.str:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> _builtins.str:
        return pulumi.get(self, "tfid")

    @_builtins.property
    @pulumi.getter(name="threatExceptions")
    def threat_exceptions(self) -> Sequence['outputs.GetVulnerabilityProtectionProfileThreatExceptionResult']:
        """
        Threat exception
        """
        return pulumi.get(self, "threat_exceptions")


class AwaitableGetVulnerabilityProtectionProfileResult(GetVulnerabilityProtectionProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVulnerabilityProtectionProfileResult(
            description=self.description,
            device=self.device,
            folder=self.folder,
            id=self.id,
            name=self.name,
            rules=self.rules,
            snippet=self.snippet,
            tfid=self.tfid,
            threat_exceptions=self.threat_exceptions)


def get_vulnerability_protection_profile(id: Optional[_builtins.str] = None,
                                         name: Optional[_builtins.str] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVulnerabilityProtectionProfileResult:
    """
    VulnerabilityProtectionProfile data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    #
    # Data source to retrieve a single SCM Vulnerability Protection Profile object by its ID.
    #
    # Replace the ID with the UUID of the SCM Vulnerability Protection Profile you want to find.
    scm_vp_profile = scm.get_vulnerability_protection_profile(id="f2a337e2-f3a6-45aa-9273-de3d216f8d9c")
    pulumi.export("scmVulnerabilityProtectionProfileDetails", {
        "profileId": scm_vp_profile.id,
        "folder": scm_vp_profile.folder,
        "name": scm_vp_profile.name,
    })
    ```


    :param _builtins.str id: UUID of the resource
    :param _builtins.str name: Name
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scm:index/getVulnerabilityProtectionProfile:getVulnerabilityProtectionProfile', __args__, opts=opts, typ=GetVulnerabilityProtectionProfileResult).value

    return AwaitableGetVulnerabilityProtectionProfileResult(
        description=pulumi.get(__ret__, 'description'),
        device=pulumi.get(__ret__, 'device'),
        folder=pulumi.get(__ret__, 'folder'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        rules=pulumi.get(__ret__, 'rules'),
        snippet=pulumi.get(__ret__, 'snippet'),
        tfid=pulumi.get(__ret__, 'tfid'),
        threat_exceptions=pulumi.get(__ret__, 'threat_exceptions'))
def get_vulnerability_protection_profile_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                                                name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVulnerabilityProtectionProfileResult]:
    """
    VulnerabilityProtectionProfile data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    #
    # Data source to retrieve a single SCM Vulnerability Protection Profile object by its ID.
    #
    # Replace the ID with the UUID of the SCM Vulnerability Protection Profile you want to find.
    scm_vp_profile = scm.get_vulnerability_protection_profile(id="f2a337e2-f3a6-45aa-9273-de3d216f8d9c")
    pulumi.export("scmVulnerabilityProtectionProfileDetails", {
        "profileId": scm_vp_profile.id,
        "folder": scm_vp_profile.folder,
        "name": scm_vp_profile.name,
    })
    ```


    :param _builtins.str id: UUID of the resource
    :param _builtins.str name: Name
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scm:index/getVulnerabilityProtectionProfile:getVulnerabilityProtectionProfile', __args__, opts=opts, typ=GetVulnerabilityProtectionProfileResult)
    return __ret__.apply(lambda __response__: GetVulnerabilityProtectionProfileResult(
        description=pulumi.get(__response__, 'description'),
        device=pulumi.get(__response__, 'device'),
        folder=pulumi.get(__response__, 'folder'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        rules=pulumi.get(__response__, 'rules'),
        snippet=pulumi.get(__response__, 'snippet'),
        tfid=pulumi.get(__response__, 'tfid'),
        threat_exceptions=pulumi.get(__response__, 'threat_exceptions')))
