# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetZoneResult',
    'AwaitableGetZoneResult',
    'get_zone',
    'get_zone_output',
]

@pulumi.output_type
class GetZoneResult:
    """
    A collection of values returned by getZone.
    """
    def __init__(__self__, device=None, device_acl=None, dos_log_setting=None, dos_profile=None, enable_device_identification=None, enable_user_identification=None, folder=None, id=None, name=None, network=None, snippet=None, tfid=None, user_acl=None):
        if device and not isinstance(device, str):
            raise TypeError("Expected argument 'device' to be a str")
        pulumi.set(__self__, "device", device)
        if device_acl and not isinstance(device_acl, dict):
            raise TypeError("Expected argument 'device_acl' to be a dict")
        pulumi.set(__self__, "device_acl", device_acl)
        if dos_log_setting and not isinstance(dos_log_setting, str):
            raise TypeError("Expected argument 'dos_log_setting' to be a str")
        pulumi.set(__self__, "dos_log_setting", dos_log_setting)
        if dos_profile and not isinstance(dos_profile, str):
            raise TypeError("Expected argument 'dos_profile' to be a str")
        pulumi.set(__self__, "dos_profile", dos_profile)
        if enable_device_identification and not isinstance(enable_device_identification, bool):
            raise TypeError("Expected argument 'enable_device_identification' to be a bool")
        pulumi.set(__self__, "enable_device_identification", enable_device_identification)
        if enable_user_identification and not isinstance(enable_user_identification, bool):
            raise TypeError("Expected argument 'enable_user_identification' to be a bool")
        pulumi.set(__self__, "enable_user_identification", enable_user_identification)
        if folder and not isinstance(folder, str):
            raise TypeError("Expected argument 'folder' to be a str")
        pulumi.set(__self__, "folder", folder)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network and not isinstance(network, dict):
            raise TypeError("Expected argument 'network' to be a dict")
        pulumi.set(__self__, "network", network)
        if snippet and not isinstance(snippet, str):
            raise TypeError("Expected argument 'snippet' to be a str")
        pulumi.set(__self__, "snippet", snippet)
        if tfid and not isinstance(tfid, str):
            raise TypeError("Expected argument 'tfid' to be a str")
        pulumi.set(__self__, "tfid", tfid)
        if user_acl and not isinstance(user_acl, dict):
            raise TypeError("Expected argument 'user_acl' to be a dict")
        pulumi.set(__self__, "user_acl", user_acl)

    @_builtins.property
    @pulumi.getter
    def device(self) -> _builtins.str:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter(name="deviceAcl")
    def device_acl(self) -> 'outputs.GetZoneDeviceAclResult':
        """
        Device acl
        """
        return pulumi.get(self, "device_acl")

    @_builtins.property
    @pulumi.getter(name="dosLogSetting")
    def dos_log_setting(self) -> _builtins.str:
        """
        Dos log setting
        """
        return pulumi.get(self, "dos_log_setting")

    @_builtins.property
    @pulumi.getter(name="dosProfile")
    def dos_profile(self) -> _builtins.str:
        """
        Dos profile
        """
        return pulumi.get(self, "dos_profile")

    @_builtins.property
    @pulumi.getter(name="enableDeviceIdentification")
    def enable_device_identification(self) -> _builtins.bool:
        """
        Enable device identification
        """
        return pulumi.get(self, "enable_device_identification")

    @_builtins.property
    @pulumi.getter(name="enableUserIdentification")
    def enable_user_identification(self) -> _builtins.bool:
        """
        Enable user identification
        """
        return pulumi.get(self, "enable_user_identification")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> _builtins.str:
        """
        Folder
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        UUID of the resource
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Alphanumeric string begin with letter: [0-9a-zA-Z._-]
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def network(self) -> 'outputs.GetZoneNetworkResult':
        """
        Network
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> _builtins.str:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> _builtins.str:
        return pulumi.get(self, "tfid")

    @_builtins.property
    @pulumi.getter(name="userAcl")
    def user_acl(self) -> 'outputs.GetZoneUserAclResult':
        """
        User acl
        """
        return pulumi.get(self, "user_acl")


class AwaitableGetZoneResult(GetZoneResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZoneResult(
            device=self.device,
            device_acl=self.device_acl,
            dos_log_setting=self.dos_log_setting,
            dos_profile=self.dos_profile,
            enable_device_identification=self.enable_device_identification,
            enable_user_identification=self.enable_user_identification,
            folder=self.folder,
            id=self.id,
            name=self.name,
            network=self.network,
            snippet=self.snippet,
            tfid=self.tfid,
            user_acl=self.user_acl)


def get_zone(id: Optional[_builtins.str] = None,
             name: Optional[_builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZoneResult:
    """
    Zone data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    # Look up zone by its ID.
    scm_zone_ds = scm.get_zone(id="50f1f0f3-a420-4989-9770-c927f1467a9a")
    pulumi.export("zoneDataSourceResults", {
        "id": scm_zone_ds.id,
        "name": scm_zone_ds.name,
        "network": scm_zone_ds.network,
        "enableDeviceIdentification": scm_zone_ds.enable_device_identification,
        "enableUserIdentification": scm_zone_ds.enable_user_identification,
        "userAcl": scm_zone_ds.user_acl,
        "deviceAcl": scm_zone_ds.device_acl,
        "folder": scm_zone_ds.folder,
    })
    ```


    :param _builtins.str id: UUID of the resource
    :param _builtins.str name: Alphanumeric string begin with letter: [0-9a-zA-Z._-]
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scm:index/getZone:getZone', __args__, opts=opts, typ=GetZoneResult).value

    return AwaitableGetZoneResult(
        device=pulumi.get(__ret__, 'device'),
        device_acl=pulumi.get(__ret__, 'device_acl'),
        dos_log_setting=pulumi.get(__ret__, 'dos_log_setting'),
        dos_profile=pulumi.get(__ret__, 'dos_profile'),
        enable_device_identification=pulumi.get(__ret__, 'enable_device_identification'),
        enable_user_identification=pulumi.get(__ret__, 'enable_user_identification'),
        folder=pulumi.get(__ret__, 'folder'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        network=pulumi.get(__ret__, 'network'),
        snippet=pulumi.get(__ret__, 'snippet'),
        tfid=pulumi.get(__ret__, 'tfid'),
        user_acl=pulumi.get(__ret__, 'user_acl'))
def get_zone_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                    name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZoneResult]:
    """
    Zone data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    # Look up zone by its ID.
    scm_zone_ds = scm.get_zone(id="50f1f0f3-a420-4989-9770-c927f1467a9a")
    pulumi.export("zoneDataSourceResults", {
        "id": scm_zone_ds.id,
        "name": scm_zone_ds.name,
        "network": scm_zone_ds.network,
        "enableDeviceIdentification": scm_zone_ds.enable_device_identification,
        "enableUserIdentification": scm_zone_ds.enable_user_identification,
        "userAcl": scm_zone_ds.user_acl,
        "deviceAcl": scm_zone_ds.device_acl,
        "folder": scm_zone_ds.folder,
    })
    ```


    :param _builtins.str id: UUID of the resource
    :param _builtins.str name: Alphanumeric string begin with letter: [0-9a-zA-Z._-]
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scm:index/getZone:getZone', __args__, opts=opts, typ=GetZoneResult)
    return __ret__.apply(lambda __response__: GetZoneResult(
        device=pulumi.get(__response__, 'device'),
        device_acl=pulumi.get(__response__, 'device_acl'),
        dos_log_setting=pulumi.get(__response__, 'dos_log_setting'),
        dos_profile=pulumi.get(__response__, 'dos_profile'),
        enable_device_identification=pulumi.get(__response__, 'enable_device_identification'),
        enable_user_identification=pulumi.get(__response__, 'enable_user_identification'),
        folder=pulumi.get(__response__, 'folder'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        network=pulumi.get(__response__, 'network'),
        snippet=pulumi.get(__response__, 'snippet'),
        tfid=pulumi.get(__response__, 'tfid'),
        user_acl=pulumi.get(__response__, 'user_acl')))
