# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IkeCryptoProfileArgs', 'IkeCryptoProfile']

@pulumi.input_type
class IkeCryptoProfileArgs:
    def __init__(__self__, *,
                 dh_groups: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 encryptions: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 hashes: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 authentication_multiple: Optional[pulumi.Input[_builtins.int]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 lifetime: Optional[pulumi.Input['IkeCryptoProfileLifetimeArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a IkeCryptoProfile resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dh_groups: Dh group
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] encryptions: Encryption algorithm
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] hashes: Hash
        :param pulumi.Input[_builtins.int] authentication_multiple: IKEv2 SA reauthentication interval equals authetication-multiple * rekey-lifetime; 0 means reauthentication disabled
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input['IkeCryptoProfileLifetimeArgs'] lifetime: Ike crypto profile lifetime
        :param pulumi.Input[_builtins.str] name: Alphanumeric string begin with letter: [0-9a-zA-Z._-]
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        """
        pulumi.set(__self__, "dh_groups", dh_groups)
        pulumi.set(__self__, "encryptions", encryptions)
        pulumi.set(__self__, "hashes", hashes)
        if authentication_multiple is not None:
            pulumi.set(__self__, "authentication_multiple", authentication_multiple)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if lifetime is not None:
            pulumi.set(__self__, "lifetime", lifetime)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)

    @_builtins.property
    @pulumi.getter(name="dhGroups")
    def dh_groups(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Dh group
        """
        return pulumi.get(self, "dh_groups")

    @dh_groups.setter
    def dh_groups(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "dh_groups", value)

    @_builtins.property
    @pulumi.getter
    def encryptions(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Encryption algorithm
        """
        return pulumi.get(self, "encryptions")

    @encryptions.setter
    def encryptions(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "encryptions", value)

    @_builtins.property
    @pulumi.getter
    def hashes(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Hash
        """
        return pulumi.get(self, "hashes")

    @hashes.setter
    def hashes(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "hashes", value)

    @_builtins.property
    @pulumi.getter(name="authenticationMultiple")
    def authentication_multiple(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        IKEv2 SA reauthentication interval equals authetication-multiple * rekey-lifetime; 0 means reauthentication disabled
        """
        return pulumi.get(self, "authentication_multiple")

    @authentication_multiple.setter
    def authentication_multiple(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "authentication_multiple", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def lifetime(self) -> Optional[pulumi.Input['IkeCryptoProfileLifetimeArgs']]:
        """
        Ike crypto profile lifetime
        """
        return pulumi.get(self, "lifetime")

    @lifetime.setter
    def lifetime(self, value: Optional[pulumi.Input['IkeCryptoProfileLifetimeArgs']]):
        pulumi.set(self, "lifetime", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alphanumeric string begin with letter: [0-9a-zA-Z._-]
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)


@pulumi.input_type
class _IkeCryptoProfileState:
    def __init__(__self__, *,
                 authentication_multiple: Optional[pulumi.Input[_builtins.int]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 dh_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 encryptions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 hashes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 lifetime: Optional[pulumi.Input['IkeCryptoProfileLifetimeArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 tfid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering IkeCryptoProfile resources.
        :param pulumi.Input[_builtins.int] authentication_multiple: IKEv2 SA reauthentication interval equals authetication-multiple * rekey-lifetime; 0 means reauthentication disabled
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dh_groups: Dh group
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] encryptions: Encryption algorithm
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] hashes: Hash
        :param pulumi.Input['IkeCryptoProfileLifetimeArgs'] lifetime: Ike crypto profile lifetime
        :param pulumi.Input[_builtins.str] name: Alphanumeric string begin with letter: [0-9a-zA-Z._-]
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        """
        if authentication_multiple is not None:
            pulumi.set(__self__, "authentication_multiple", authentication_multiple)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if dh_groups is not None:
            pulumi.set(__self__, "dh_groups", dh_groups)
        if encryptions is not None:
            pulumi.set(__self__, "encryptions", encryptions)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if hashes is not None:
            pulumi.set(__self__, "hashes", hashes)
        if lifetime is not None:
            pulumi.set(__self__, "lifetime", lifetime)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if tfid is not None:
            pulumi.set(__self__, "tfid", tfid)

    @_builtins.property
    @pulumi.getter(name="authenticationMultiple")
    def authentication_multiple(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        IKEv2 SA reauthentication interval equals authetication-multiple * rekey-lifetime; 0 means reauthentication disabled
        """
        return pulumi.get(self, "authentication_multiple")

    @authentication_multiple.setter
    def authentication_multiple(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "authentication_multiple", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter(name="dhGroups")
    def dh_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Dh group
        """
        return pulumi.get(self, "dh_groups")

    @dh_groups.setter
    def dh_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dh_groups", value)

    @_builtins.property
    @pulumi.getter
    def encryptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Encryption algorithm
        """
        return pulumi.get(self, "encryptions")

    @encryptions.setter
    def encryptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "encryptions", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def hashes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Hash
        """
        return pulumi.get(self, "hashes")

    @hashes.setter
    def hashes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "hashes", value)

    @_builtins.property
    @pulumi.getter
    def lifetime(self) -> Optional[pulumi.Input['IkeCryptoProfileLifetimeArgs']]:
        """
        Ike crypto profile lifetime
        """
        return pulumi.get(self, "lifetime")

    @lifetime.setter
    def lifetime(self, value: Optional[pulumi.Input['IkeCryptoProfileLifetimeArgs']]):
        pulumi.set(self, "lifetime", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alphanumeric string begin with letter: [0-9a-zA-Z._-]
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tfid")

    @tfid.setter
    def tfid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tfid", value)


@pulumi.type_token("scm:index/ikeCryptoProfile:IkeCryptoProfile")
class IkeCryptoProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_multiple: Optional[pulumi.Input[_builtins.int]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 dh_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 encryptions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 hashes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 lifetime: Optional[pulumi.Input[Union['IkeCryptoProfileLifetimeArgs', 'IkeCryptoProfileLifetimeArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        IkeCryptoProfile resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        # The resource block defines a new IKE Crypto Profile.
        scm_ike_crypto_profile2 = scm.IkeCryptoProfile("scm_ike_crypto_profile_2",
            name="scm_ike_crypto_profile_2",
            folder="Prisma Access",
            hashes=[
                "sha256",
                "sha384",
            ],
            dh_groups=[
                "group14",
                "group5",
            ],
            encryptions=[
                "aes-256-cbc",
                "aes-128-cbc",
            ],
            lifetime={
                "hours": 8,
            },
            authentication_multiple=10)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] authentication_multiple: IKEv2 SA reauthentication interval equals authetication-multiple * rekey-lifetime; 0 means reauthentication disabled
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dh_groups: Dh group
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] encryptions: Encryption algorithm
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] hashes: Hash
        :param pulumi.Input[Union['IkeCryptoProfileLifetimeArgs', 'IkeCryptoProfileLifetimeArgsDict']] lifetime: Ike crypto profile lifetime
        :param pulumi.Input[_builtins.str] name: Alphanumeric string begin with letter: [0-9a-zA-Z._-]
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IkeCryptoProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        IkeCryptoProfile resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        # The resource block defines a new IKE Crypto Profile.
        scm_ike_crypto_profile2 = scm.IkeCryptoProfile("scm_ike_crypto_profile_2",
            name="scm_ike_crypto_profile_2",
            folder="Prisma Access",
            hashes=[
                "sha256",
                "sha384",
            ],
            dh_groups=[
                "group14",
                "group5",
            ],
            encryptions=[
                "aes-256-cbc",
                "aes-128-cbc",
            ],
            lifetime={
                "hours": 8,
            },
            authentication_multiple=10)
        ```

        :param str resource_name: The name of the resource.
        :param IkeCryptoProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IkeCryptoProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_multiple: Optional[pulumi.Input[_builtins.int]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 dh_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 encryptions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 hashes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 lifetime: Optional[pulumi.Input[Union['IkeCryptoProfileLifetimeArgs', 'IkeCryptoProfileLifetimeArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IkeCryptoProfileArgs.__new__(IkeCryptoProfileArgs)

            __props__.__dict__["authentication_multiple"] = authentication_multiple
            __props__.__dict__["device"] = device
            if dh_groups is None and not opts.urn:
                raise TypeError("Missing required property 'dh_groups'")
            __props__.__dict__["dh_groups"] = dh_groups
            if encryptions is None and not opts.urn:
                raise TypeError("Missing required property 'encryptions'")
            __props__.__dict__["encryptions"] = encryptions
            __props__.__dict__["folder"] = folder
            if hashes is None and not opts.urn:
                raise TypeError("Missing required property 'hashes'")
            __props__.__dict__["hashes"] = hashes
            __props__.__dict__["lifetime"] = lifetime
            __props__.__dict__["name"] = name
            __props__.__dict__["snippet"] = snippet
            __props__.__dict__["tfid"] = None
        super(IkeCryptoProfile, __self__).__init__(
            'scm:index/ikeCryptoProfile:IkeCryptoProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication_multiple: Optional[pulumi.Input[_builtins.int]] = None,
            device: Optional[pulumi.Input[_builtins.str]] = None,
            dh_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            encryptions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            folder: Optional[pulumi.Input[_builtins.str]] = None,
            hashes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            lifetime: Optional[pulumi.Input[Union['IkeCryptoProfileLifetimeArgs', 'IkeCryptoProfileLifetimeArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            snippet: Optional[pulumi.Input[_builtins.str]] = None,
            tfid: Optional[pulumi.Input[_builtins.str]] = None) -> 'IkeCryptoProfile':
        """
        Get an existing IkeCryptoProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] authentication_multiple: IKEv2 SA reauthentication interval equals authetication-multiple * rekey-lifetime; 0 means reauthentication disabled
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dh_groups: Dh group
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] encryptions: Encryption algorithm
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] hashes: Hash
        :param pulumi.Input[Union['IkeCryptoProfileLifetimeArgs', 'IkeCryptoProfileLifetimeArgsDict']] lifetime: Ike crypto profile lifetime
        :param pulumi.Input[_builtins.str] name: Alphanumeric string begin with letter: [0-9a-zA-Z._-]
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IkeCryptoProfileState.__new__(_IkeCryptoProfileState)

        __props__.__dict__["authentication_multiple"] = authentication_multiple
        __props__.__dict__["device"] = device
        __props__.__dict__["dh_groups"] = dh_groups
        __props__.__dict__["encryptions"] = encryptions
        __props__.__dict__["folder"] = folder
        __props__.__dict__["hashes"] = hashes
        __props__.__dict__["lifetime"] = lifetime
        __props__.__dict__["name"] = name
        __props__.__dict__["snippet"] = snippet
        __props__.__dict__["tfid"] = tfid
        return IkeCryptoProfile(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authenticationMultiple")
    def authentication_multiple(self) -> pulumi.Output[_builtins.int]:
        """
        IKEv2 SA reauthentication interval equals authetication-multiple * rekey-lifetime; 0 means reauthentication disabled
        """
        return pulumi.get(self, "authentication_multiple")

    @_builtins.property
    @pulumi.getter
    def device(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter(name="dhGroups")
    def dh_groups(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Dh group
        """
        return pulumi.get(self, "dh_groups")

    @_builtins.property
    @pulumi.getter
    def encryptions(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Encryption algorithm
        """
        return pulumi.get(self, "encryptions")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def hashes(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Hash
        """
        return pulumi.get(self, "hashes")

    @_builtins.property
    @pulumi.getter
    def lifetime(self) -> pulumi.Output[Optional['outputs.IkeCryptoProfileLifetime']]:
        """
        Ike crypto profile lifetime
        """
        return pulumi.get(self, "lifetime")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Alphanumeric string begin with letter: [0-9a-zA-Z._-]
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tfid")

