# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IkeGatewayArgs', 'IkeGateway']

@pulumi.input_type
class IkeGatewayArgs:
    def __init__(__self__, *,
                 authentication: pulumi.Input['IkeGatewayAuthenticationArgs'],
                 peer_address: pulumi.Input['IkeGatewayPeerAddressArgs'],
                 protocol: pulumi.Input['IkeGatewayProtocolArgs'],
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 local_address: Optional[pulumi.Input['IkeGatewayLocalAddressArgs']] = None,
                 local_id: Optional[pulumi.Input['IkeGatewayLocalIdArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_id: Optional[pulumi.Input['IkeGatewayPeerIdArgs']] = None,
                 protocol_common: Optional[pulumi.Input['IkeGatewayProtocolCommonArgs']] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a IkeGateway resource.
        :param pulumi.Input['IkeGatewayAuthenticationArgs'] authentication: Authentication
        :param pulumi.Input['IkeGatewayPeerAddressArgs'] peer_address: Peer address
        :param pulumi.Input['IkeGatewayProtocolArgs'] protocol: Protocol
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input['IkeGatewayLocalAddressArgs'] local_address: Local address
        :param pulumi.Input['IkeGatewayLocalIdArgs'] local_id: Local id
        :param pulumi.Input[_builtins.str] name: Alphanumeric string begin with letter: [0-9a-zA-Z._-]
        :param pulumi.Input['IkeGatewayPeerIdArgs'] peer_id: Peer id
        :param pulumi.Input['IkeGatewayProtocolCommonArgs'] protocol_common: Protocol common
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        """
        pulumi.set(__self__, "authentication", authentication)
        pulumi.set(__self__, "peer_address", peer_address)
        pulumi.set(__self__, "protocol", protocol)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if local_address is not None:
            pulumi.set(__self__, "local_address", local_address)
        if local_id is not None:
            pulumi.set(__self__, "local_id", local_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peer_id is not None:
            pulumi.set(__self__, "peer_id", peer_id)
        if protocol_common is not None:
            pulumi.set(__self__, "protocol_common", protocol_common)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)

    @_builtins.property
    @pulumi.getter
    def authentication(self) -> pulumi.Input['IkeGatewayAuthenticationArgs']:
        """
        Authentication
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: pulumi.Input['IkeGatewayAuthenticationArgs']):
        pulumi.set(self, "authentication", value)

    @_builtins.property
    @pulumi.getter(name="peerAddress")
    def peer_address(self) -> pulumi.Input['IkeGatewayPeerAddressArgs']:
        """
        Peer address
        """
        return pulumi.get(self, "peer_address")

    @peer_address.setter
    def peer_address(self, value: pulumi.Input['IkeGatewayPeerAddressArgs']):
        pulumi.set(self, "peer_address", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Input['IkeGatewayProtocolArgs']:
        """
        Protocol
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input['IkeGatewayProtocolArgs']):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter(name="localAddress")
    def local_address(self) -> Optional[pulumi.Input['IkeGatewayLocalAddressArgs']]:
        """
        Local address
        """
        return pulumi.get(self, "local_address")

    @local_address.setter
    def local_address(self, value: Optional[pulumi.Input['IkeGatewayLocalAddressArgs']]):
        pulumi.set(self, "local_address", value)

    @_builtins.property
    @pulumi.getter(name="localId")
    def local_id(self) -> Optional[pulumi.Input['IkeGatewayLocalIdArgs']]:
        """
        Local id
        """
        return pulumi.get(self, "local_id")

    @local_id.setter
    def local_id(self, value: Optional[pulumi.Input['IkeGatewayLocalIdArgs']]):
        pulumi.set(self, "local_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alphanumeric string begin with letter: [0-9a-zA-Z._-]
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="peerId")
    def peer_id(self) -> Optional[pulumi.Input['IkeGatewayPeerIdArgs']]:
        """
        Peer id
        """
        return pulumi.get(self, "peer_id")

    @peer_id.setter
    def peer_id(self, value: Optional[pulumi.Input['IkeGatewayPeerIdArgs']]):
        pulumi.set(self, "peer_id", value)

    @_builtins.property
    @pulumi.getter(name="protocolCommon")
    def protocol_common(self) -> Optional[pulumi.Input['IkeGatewayProtocolCommonArgs']]:
        """
        Protocol common
        """
        return pulumi.get(self, "protocol_common")

    @protocol_common.setter
    def protocol_common(self, value: Optional[pulumi.Input['IkeGatewayProtocolCommonArgs']]):
        pulumi.set(self, "protocol_common", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)


@pulumi.input_type
class _IkeGatewayState:
    def __init__(__self__, *,
                 authentication: Optional[pulumi.Input['IkeGatewayAuthenticationArgs']] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypted_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 local_address: Optional[pulumi.Input['IkeGatewayLocalAddressArgs']] = None,
                 local_id: Optional[pulumi.Input['IkeGatewayLocalIdArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_address: Optional[pulumi.Input['IkeGatewayPeerAddressArgs']] = None,
                 peer_id: Optional[pulumi.Input['IkeGatewayPeerIdArgs']] = None,
                 protocol: Optional[pulumi.Input['IkeGatewayProtocolArgs']] = None,
                 protocol_common: Optional[pulumi.Input['IkeGatewayProtocolCommonArgs']] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 tfid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering IkeGateway resources.
        :param pulumi.Input['IkeGatewayAuthenticationArgs'] authentication: Authentication
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] encrypted_values: Map of sensitive values returned from the API.
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input['IkeGatewayLocalAddressArgs'] local_address: Local address
        :param pulumi.Input['IkeGatewayLocalIdArgs'] local_id: Local id
        :param pulumi.Input[_builtins.str] name: Alphanumeric string begin with letter: [0-9a-zA-Z._-]
        :param pulumi.Input['IkeGatewayPeerAddressArgs'] peer_address: Peer address
        :param pulumi.Input['IkeGatewayPeerIdArgs'] peer_id: Peer id
        :param pulumi.Input['IkeGatewayProtocolArgs'] protocol: Protocol
        :param pulumi.Input['IkeGatewayProtocolCommonArgs'] protocol_common: Protocol common
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        """
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if encrypted_values is not None:
            pulumi.set(__self__, "encrypted_values", encrypted_values)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if local_address is not None:
            pulumi.set(__self__, "local_address", local_address)
        if local_id is not None:
            pulumi.set(__self__, "local_id", local_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peer_address is not None:
            pulumi.set(__self__, "peer_address", peer_address)
        if peer_id is not None:
            pulumi.set(__self__, "peer_id", peer_id)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if protocol_common is not None:
            pulumi.set(__self__, "protocol_common", protocol_common)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if tfid is not None:
            pulumi.set(__self__, "tfid", tfid)

    @_builtins.property
    @pulumi.getter
    def authentication(self) -> Optional[pulumi.Input['IkeGatewayAuthenticationArgs']]:
        """
        Authentication
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: Optional[pulumi.Input['IkeGatewayAuthenticationArgs']]):
        pulumi.set(self, "authentication", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter(name="encryptedValues")
    def encrypted_values(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of sensitive values returned from the API.
        """
        return pulumi.get(self, "encrypted_values")

    @encrypted_values.setter
    def encrypted_values(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "encrypted_values", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter(name="localAddress")
    def local_address(self) -> Optional[pulumi.Input['IkeGatewayLocalAddressArgs']]:
        """
        Local address
        """
        return pulumi.get(self, "local_address")

    @local_address.setter
    def local_address(self, value: Optional[pulumi.Input['IkeGatewayLocalAddressArgs']]):
        pulumi.set(self, "local_address", value)

    @_builtins.property
    @pulumi.getter(name="localId")
    def local_id(self) -> Optional[pulumi.Input['IkeGatewayLocalIdArgs']]:
        """
        Local id
        """
        return pulumi.get(self, "local_id")

    @local_id.setter
    def local_id(self, value: Optional[pulumi.Input['IkeGatewayLocalIdArgs']]):
        pulumi.set(self, "local_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alphanumeric string begin with letter: [0-9a-zA-Z._-]
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="peerAddress")
    def peer_address(self) -> Optional[pulumi.Input['IkeGatewayPeerAddressArgs']]:
        """
        Peer address
        """
        return pulumi.get(self, "peer_address")

    @peer_address.setter
    def peer_address(self, value: Optional[pulumi.Input['IkeGatewayPeerAddressArgs']]):
        pulumi.set(self, "peer_address", value)

    @_builtins.property
    @pulumi.getter(name="peerId")
    def peer_id(self) -> Optional[pulumi.Input['IkeGatewayPeerIdArgs']]:
        """
        Peer id
        """
        return pulumi.get(self, "peer_id")

    @peer_id.setter
    def peer_id(self, value: Optional[pulumi.Input['IkeGatewayPeerIdArgs']]):
        pulumi.set(self, "peer_id", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input['IkeGatewayProtocolArgs']]:
        """
        Protocol
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input['IkeGatewayProtocolArgs']]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="protocolCommon")
    def protocol_common(self) -> Optional[pulumi.Input['IkeGatewayProtocolCommonArgs']]:
        """
        Protocol common
        """
        return pulumi.get(self, "protocol_common")

    @protocol_common.setter
    def protocol_common(self, value: Optional[pulumi.Input['IkeGatewayProtocolCommonArgs']]):
        pulumi.set(self, "protocol_common", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tfid")

    @tfid.setter
    def tfid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tfid", value)


@pulumi.type_token("scm:index/ikeGateway:IkeGateway")
class IkeGateway(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication: Optional[pulumi.Input[Union['IkeGatewayAuthenticationArgs', 'IkeGatewayAuthenticationArgsDict']]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 local_address: Optional[pulumi.Input[Union['IkeGatewayLocalAddressArgs', 'IkeGatewayLocalAddressArgsDict']]] = None,
                 local_id: Optional[pulumi.Input[Union['IkeGatewayLocalIdArgs', 'IkeGatewayLocalIdArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_address: Optional[pulumi.Input[Union['IkeGatewayPeerAddressArgs', 'IkeGatewayPeerAddressArgsDict']]] = None,
                 peer_id: Optional[pulumi.Input[Union['IkeGatewayPeerIdArgs', 'IkeGatewayPeerIdArgsDict']]] = None,
                 protocol: Optional[pulumi.Input[Union['IkeGatewayProtocolArgs', 'IkeGatewayProtocolArgsDict']]] = None,
                 protocol_common: Optional[pulumi.Input[Union['IkeGatewayProtocolCommonArgs', 'IkeGatewayProtocolCommonArgsDict']]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        IkeGateway resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        # The scm_ike_crypto_profile resource is a prerequisite for the IKE gateway.
        scm_ike_gw_crypto_profile1 = scm.IkeCryptoProfile("scm_ike_gw_crypto_profile_1",
            folder="Remote Networks",
            name="scm_ike_gw_crypto_profile_1",
            hashes=["sha256"],
            dh_groups=["group14"],
            encryptions=["aes-256-cbc"])
        # This is the main scm_ike_gateway resource.
        scm_ike_gateway1 = scm.IkeGateway("scm_ike_gateway_1",
            folder="Remote Networks",
            name="scm_ike_gateway_1",
            authentication={
                "pre_shared_key": {
                    "key": "123456",
                },
            },
            peer_address={
                "ip": "2.2.2.4",
            },
            peer_id={
                "type": "ipaddr",
                "id": "10.3.3.4",
            },
            local_id={
                "type": "ipaddr",
                "id": "10.3.4.4",
            },
            protocol={
                "ikev1": {
                    "ike_crypto_profile": scm_ike_gw_crypto_profile1.name,
                    "dpd": {
                        "enable": True,
                    },
                },
                "ikev2": {
                    "ike_crypto_profile": scm_ike_gw_crypto_profile1.name,
                    "dpd": {
                        "enable": True,
                    },
                },
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['IkeGatewayAuthenticationArgs', 'IkeGatewayAuthenticationArgsDict']] authentication: Authentication
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[Union['IkeGatewayLocalAddressArgs', 'IkeGatewayLocalAddressArgsDict']] local_address: Local address
        :param pulumi.Input[Union['IkeGatewayLocalIdArgs', 'IkeGatewayLocalIdArgsDict']] local_id: Local id
        :param pulumi.Input[_builtins.str] name: Alphanumeric string begin with letter: [0-9a-zA-Z._-]
        :param pulumi.Input[Union['IkeGatewayPeerAddressArgs', 'IkeGatewayPeerAddressArgsDict']] peer_address: Peer address
        :param pulumi.Input[Union['IkeGatewayPeerIdArgs', 'IkeGatewayPeerIdArgsDict']] peer_id: Peer id
        :param pulumi.Input[Union['IkeGatewayProtocolArgs', 'IkeGatewayProtocolArgsDict']] protocol: Protocol
        :param pulumi.Input[Union['IkeGatewayProtocolCommonArgs', 'IkeGatewayProtocolCommonArgsDict']] protocol_common: Protocol common
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IkeGatewayArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        IkeGateway resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        # The scm_ike_crypto_profile resource is a prerequisite for the IKE gateway.
        scm_ike_gw_crypto_profile1 = scm.IkeCryptoProfile("scm_ike_gw_crypto_profile_1",
            folder="Remote Networks",
            name="scm_ike_gw_crypto_profile_1",
            hashes=["sha256"],
            dh_groups=["group14"],
            encryptions=["aes-256-cbc"])
        # This is the main scm_ike_gateway resource.
        scm_ike_gateway1 = scm.IkeGateway("scm_ike_gateway_1",
            folder="Remote Networks",
            name="scm_ike_gateway_1",
            authentication={
                "pre_shared_key": {
                    "key": "123456",
                },
            },
            peer_address={
                "ip": "2.2.2.4",
            },
            peer_id={
                "type": "ipaddr",
                "id": "10.3.3.4",
            },
            local_id={
                "type": "ipaddr",
                "id": "10.3.4.4",
            },
            protocol={
                "ikev1": {
                    "ike_crypto_profile": scm_ike_gw_crypto_profile1.name,
                    "dpd": {
                        "enable": True,
                    },
                },
                "ikev2": {
                    "ike_crypto_profile": scm_ike_gw_crypto_profile1.name,
                    "dpd": {
                        "enable": True,
                    },
                },
            })
        ```

        :param str resource_name: The name of the resource.
        :param IkeGatewayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IkeGatewayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication: Optional[pulumi.Input[Union['IkeGatewayAuthenticationArgs', 'IkeGatewayAuthenticationArgsDict']]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 local_address: Optional[pulumi.Input[Union['IkeGatewayLocalAddressArgs', 'IkeGatewayLocalAddressArgsDict']]] = None,
                 local_id: Optional[pulumi.Input[Union['IkeGatewayLocalIdArgs', 'IkeGatewayLocalIdArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_address: Optional[pulumi.Input[Union['IkeGatewayPeerAddressArgs', 'IkeGatewayPeerAddressArgsDict']]] = None,
                 peer_id: Optional[pulumi.Input[Union['IkeGatewayPeerIdArgs', 'IkeGatewayPeerIdArgsDict']]] = None,
                 protocol: Optional[pulumi.Input[Union['IkeGatewayProtocolArgs', 'IkeGatewayProtocolArgsDict']]] = None,
                 protocol_common: Optional[pulumi.Input[Union['IkeGatewayProtocolCommonArgs', 'IkeGatewayProtocolCommonArgsDict']]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IkeGatewayArgs.__new__(IkeGatewayArgs)

            if authentication is None and not opts.urn:
                raise TypeError("Missing required property 'authentication'")
            __props__.__dict__["authentication"] = authentication
            __props__.__dict__["device"] = device
            __props__.__dict__["folder"] = folder
            __props__.__dict__["local_address"] = local_address
            __props__.__dict__["local_id"] = local_id
            __props__.__dict__["name"] = name
            if peer_address is None and not opts.urn:
                raise TypeError("Missing required property 'peer_address'")
            __props__.__dict__["peer_address"] = peer_address
            __props__.__dict__["peer_id"] = peer_id
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["protocol_common"] = protocol_common
            __props__.__dict__["snippet"] = snippet
            __props__.__dict__["encrypted_values"] = None
            __props__.__dict__["tfid"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["encryptedValues"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(IkeGateway, __self__).__init__(
            'scm:index/ikeGateway:IkeGateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication: Optional[pulumi.Input[Union['IkeGatewayAuthenticationArgs', 'IkeGatewayAuthenticationArgsDict']]] = None,
            device: Optional[pulumi.Input[_builtins.str]] = None,
            encrypted_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            folder: Optional[pulumi.Input[_builtins.str]] = None,
            local_address: Optional[pulumi.Input[Union['IkeGatewayLocalAddressArgs', 'IkeGatewayLocalAddressArgsDict']]] = None,
            local_id: Optional[pulumi.Input[Union['IkeGatewayLocalIdArgs', 'IkeGatewayLocalIdArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            peer_address: Optional[pulumi.Input[Union['IkeGatewayPeerAddressArgs', 'IkeGatewayPeerAddressArgsDict']]] = None,
            peer_id: Optional[pulumi.Input[Union['IkeGatewayPeerIdArgs', 'IkeGatewayPeerIdArgsDict']]] = None,
            protocol: Optional[pulumi.Input[Union['IkeGatewayProtocolArgs', 'IkeGatewayProtocolArgsDict']]] = None,
            protocol_common: Optional[pulumi.Input[Union['IkeGatewayProtocolCommonArgs', 'IkeGatewayProtocolCommonArgsDict']]] = None,
            snippet: Optional[pulumi.Input[_builtins.str]] = None,
            tfid: Optional[pulumi.Input[_builtins.str]] = None) -> 'IkeGateway':
        """
        Get an existing IkeGateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['IkeGatewayAuthenticationArgs', 'IkeGatewayAuthenticationArgsDict']] authentication: Authentication
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] encrypted_values: Map of sensitive values returned from the API.
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[Union['IkeGatewayLocalAddressArgs', 'IkeGatewayLocalAddressArgsDict']] local_address: Local address
        :param pulumi.Input[Union['IkeGatewayLocalIdArgs', 'IkeGatewayLocalIdArgsDict']] local_id: Local id
        :param pulumi.Input[_builtins.str] name: Alphanumeric string begin with letter: [0-9a-zA-Z._-]
        :param pulumi.Input[Union['IkeGatewayPeerAddressArgs', 'IkeGatewayPeerAddressArgsDict']] peer_address: Peer address
        :param pulumi.Input[Union['IkeGatewayPeerIdArgs', 'IkeGatewayPeerIdArgsDict']] peer_id: Peer id
        :param pulumi.Input[Union['IkeGatewayProtocolArgs', 'IkeGatewayProtocolArgsDict']] protocol: Protocol
        :param pulumi.Input[Union['IkeGatewayProtocolCommonArgs', 'IkeGatewayProtocolCommonArgsDict']] protocol_common: Protocol common
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IkeGatewayState.__new__(_IkeGatewayState)

        __props__.__dict__["authentication"] = authentication
        __props__.__dict__["device"] = device
        __props__.__dict__["encrypted_values"] = encrypted_values
        __props__.__dict__["folder"] = folder
        __props__.__dict__["local_address"] = local_address
        __props__.__dict__["local_id"] = local_id
        __props__.__dict__["name"] = name
        __props__.__dict__["peer_address"] = peer_address
        __props__.__dict__["peer_id"] = peer_id
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["protocol_common"] = protocol_common
        __props__.__dict__["snippet"] = snippet
        __props__.__dict__["tfid"] = tfid
        return IkeGateway(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def authentication(self) -> pulumi.Output['outputs.IkeGatewayAuthentication']:
        """
        Authentication
        """
        return pulumi.get(self, "authentication")

    @_builtins.property
    @pulumi.getter
    def device(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter(name="encryptedValues")
    def encrypted_values(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of sensitive values returned from the API.
        """
        return pulumi.get(self, "encrypted_values")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter(name="localAddress")
    def local_address(self) -> pulumi.Output['outputs.IkeGatewayLocalAddress']:
        """
        Local address
        """
        return pulumi.get(self, "local_address")

    @_builtins.property
    @pulumi.getter(name="localId")
    def local_id(self) -> pulumi.Output[Optional['outputs.IkeGatewayLocalId']]:
        """
        Local id
        """
        return pulumi.get(self, "local_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Alphanumeric string begin with letter: [0-9a-zA-Z._-]
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="peerAddress")
    def peer_address(self) -> pulumi.Output['outputs.IkeGatewayPeerAddress']:
        """
        Peer address
        """
        return pulumi.get(self, "peer_address")

    @_builtins.property
    @pulumi.getter(name="peerId")
    def peer_id(self) -> pulumi.Output[Optional['outputs.IkeGatewayPeerId']]:
        """
        Peer id
        """
        return pulumi.get(self, "peer_id")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output['outputs.IkeGatewayProtocol']:
        """
        Protocol
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="protocolCommon")
    def protocol_common(self) -> pulumi.Output['outputs.IkeGatewayProtocolCommon']:
        """
        Protocol common
        """
        return pulumi.get(self, "protocol_common")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tfid")

