# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LoopbackInterfaceArgs', 'LoopbackInterface']

@pulumi.input_type
class LoopbackInterfaceArgs:
    def __init__(__self__, *,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 default_value: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 interface_management_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 ips: Optional[pulumi.Input[Sequence[pulumi.Input['LoopbackInterfaceIpArgs']]]] = None,
                 ipv6: Optional[pulumi.Input['LoopbackInterfaceIpv6Args']] = None,
                 mtu: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a LoopbackInterface resource.
        :param pulumi.Input[_builtins.str] comment: Description
        :param pulumi.Input[_builtins.str] default_value: Default interface assignment
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] interface_management_profile: Interface management profile
        :param pulumi.Input[Sequence[pulumi.Input['LoopbackInterfaceIpArgs']]] ips: Loopback IP Parent
        :param pulumi.Input['LoopbackInterfaceIpv6Args'] ipv6: Loopback IPv6 Configuration
        :param pulumi.Input[_builtins.int] mtu: MTU
        :param pulumi.Input[_builtins.str] name: Loopback Interface name
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        """
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if interface_management_profile is not None:
            pulumi.set(__self__, "interface_management_profile", interface_management_profile)
        if ips is not None:
            pulumi.set(__self__, "ips", ips)
        if ipv6 is not None:
            pulumi.set(__self__, "ipv6", ipv6)
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default interface assignment
        """
        return pulumi.get(self, "default_value")

    @default_value.setter
    def default_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_value", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter(name="interfaceManagementProfile")
    def interface_management_profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Interface management profile
        """
        return pulumi.get(self, "interface_management_profile")

    @interface_management_profile.setter
    def interface_management_profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interface_management_profile", value)

    @_builtins.property
    @pulumi.getter
    def ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoopbackInterfaceIpArgs']]]]:
        """
        Loopback IP Parent
        """
        return pulumi.get(self, "ips")

    @ips.setter
    def ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoopbackInterfaceIpArgs']]]]):
        pulumi.set(self, "ips", value)

    @_builtins.property
    @pulumi.getter
    def ipv6(self) -> Optional[pulumi.Input['LoopbackInterfaceIpv6Args']]:
        """
        Loopback IPv6 Configuration
        """
        return pulumi.get(self, "ipv6")

    @ipv6.setter
    def ipv6(self, value: Optional[pulumi.Input['LoopbackInterfaceIpv6Args']]):
        pulumi.set(self, "ipv6", value)

    @_builtins.property
    @pulumi.getter
    def mtu(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        MTU
        """
        return pulumi.get(self, "mtu")

    @mtu.setter
    def mtu(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "mtu", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Loopback Interface name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)


@pulumi.input_type
class _LoopbackInterfaceState:
    def __init__(__self__, *,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 default_value: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 interface_management_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 ips: Optional[pulumi.Input[Sequence[pulumi.Input['LoopbackInterfaceIpArgs']]]] = None,
                 ipv6: Optional[pulumi.Input['LoopbackInterfaceIpv6Args']] = None,
                 mtu: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 tfid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LoopbackInterface resources.
        :param pulumi.Input[_builtins.str] comment: Description
        :param pulumi.Input[_builtins.str] default_value: Default interface assignment
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] interface_management_profile: Interface management profile
        :param pulumi.Input[Sequence[pulumi.Input['LoopbackInterfaceIpArgs']]] ips: Loopback IP Parent
        :param pulumi.Input['LoopbackInterfaceIpv6Args'] ipv6: Loopback IPv6 Configuration
        :param pulumi.Input[_builtins.int] mtu: MTU
        :param pulumi.Input[_builtins.str] name: Loopback Interface name
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        """
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if interface_management_profile is not None:
            pulumi.set(__self__, "interface_management_profile", interface_management_profile)
        if ips is not None:
            pulumi.set(__self__, "ips", ips)
        if ipv6 is not None:
            pulumi.set(__self__, "ipv6", ipv6)
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if tfid is not None:
            pulumi.set(__self__, "tfid", tfid)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default interface assignment
        """
        return pulumi.get(self, "default_value")

    @default_value.setter
    def default_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_value", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter(name="interfaceManagementProfile")
    def interface_management_profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Interface management profile
        """
        return pulumi.get(self, "interface_management_profile")

    @interface_management_profile.setter
    def interface_management_profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interface_management_profile", value)

    @_builtins.property
    @pulumi.getter
    def ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoopbackInterfaceIpArgs']]]]:
        """
        Loopback IP Parent
        """
        return pulumi.get(self, "ips")

    @ips.setter
    def ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoopbackInterfaceIpArgs']]]]):
        pulumi.set(self, "ips", value)

    @_builtins.property
    @pulumi.getter
    def ipv6(self) -> Optional[pulumi.Input['LoopbackInterfaceIpv6Args']]:
        """
        Loopback IPv6 Configuration
        """
        return pulumi.get(self, "ipv6")

    @ipv6.setter
    def ipv6(self, value: Optional[pulumi.Input['LoopbackInterfaceIpv6Args']]):
        pulumi.set(self, "ipv6", value)

    @_builtins.property
    @pulumi.getter
    def mtu(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        MTU
        """
        return pulumi.get(self, "mtu")

    @mtu.setter
    def mtu(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "mtu", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Loopback Interface name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tfid")

    @tfid.setter
    def tfid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tfid", value)


@pulumi.type_token("scm:index/loopbackInterface:LoopbackInterface")
class LoopbackInterface(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 default_value: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 interface_management_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoopbackInterfaceIpArgs', 'LoopbackInterfaceIpArgsDict']]]]] = None,
                 ipv6: Optional[pulumi.Input[Union['LoopbackInterfaceIpv6Args', 'LoopbackInterfaceIpv6ArgsDict']]] = None,
                 mtu: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        LoopbackInterface resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        #
        # Creates a loopback interface with static ipv4 address
        #
        scm_loopback_intf = scm.LoopbackInterface("scm_loopback_intf",
            name="$scm_loopback_intf",
            comment="Managed by Pulumi",
            folder="ngfw-shared",
            ips=[{
                "name": "198.18.1.1/32",
            }])
        #
        # Creates a loopback interface with static ipv4 address, with default value loopback.123
        #
        scm_loopback_intf2 = scm.LoopbackInterface("scm_loopback_intf_2",
            name="$scm_loopback_intf_2",
            comment="Managed by Pulumi",
            folder="ngfw-shared",
            default_value="loopback.123",
            ips=[{
                "name": "198.18.1.2/32",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comment: Description
        :param pulumi.Input[_builtins.str] default_value: Default interface assignment
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] interface_management_profile: Interface management profile
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoopbackInterfaceIpArgs', 'LoopbackInterfaceIpArgsDict']]]] ips: Loopback IP Parent
        :param pulumi.Input[Union['LoopbackInterfaceIpv6Args', 'LoopbackInterfaceIpv6ArgsDict']] ipv6: Loopback IPv6 Configuration
        :param pulumi.Input[_builtins.int] mtu: MTU
        :param pulumi.Input[_builtins.str] name: Loopback Interface name
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[LoopbackInterfaceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        LoopbackInterface resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        #
        # Creates a loopback interface with static ipv4 address
        #
        scm_loopback_intf = scm.LoopbackInterface("scm_loopback_intf",
            name="$scm_loopback_intf",
            comment="Managed by Pulumi",
            folder="ngfw-shared",
            ips=[{
                "name": "198.18.1.1/32",
            }])
        #
        # Creates a loopback interface with static ipv4 address, with default value loopback.123
        #
        scm_loopback_intf2 = scm.LoopbackInterface("scm_loopback_intf_2",
            name="$scm_loopback_intf_2",
            comment="Managed by Pulumi",
            folder="ngfw-shared",
            default_value="loopback.123",
            ips=[{
                "name": "198.18.1.2/32",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param LoopbackInterfaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoopbackInterfaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 default_value: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 interface_management_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoopbackInterfaceIpArgs', 'LoopbackInterfaceIpArgsDict']]]]] = None,
                 ipv6: Optional[pulumi.Input[Union['LoopbackInterfaceIpv6Args', 'LoopbackInterfaceIpv6ArgsDict']]] = None,
                 mtu: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoopbackInterfaceArgs.__new__(LoopbackInterfaceArgs)

            __props__.__dict__["comment"] = comment
            __props__.__dict__["default_value"] = default_value
            __props__.__dict__["device"] = device
            __props__.__dict__["folder"] = folder
            __props__.__dict__["interface_management_profile"] = interface_management_profile
            __props__.__dict__["ips"] = ips
            __props__.__dict__["ipv6"] = ipv6
            __props__.__dict__["mtu"] = mtu
            __props__.__dict__["name"] = name
            __props__.__dict__["snippet"] = snippet
            __props__.__dict__["tfid"] = None
        super(LoopbackInterface, __self__).__init__(
            'scm:index/loopbackInterface:LoopbackInterface',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            default_value: Optional[pulumi.Input[_builtins.str]] = None,
            device: Optional[pulumi.Input[_builtins.str]] = None,
            folder: Optional[pulumi.Input[_builtins.str]] = None,
            interface_management_profile: Optional[pulumi.Input[_builtins.str]] = None,
            ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoopbackInterfaceIpArgs', 'LoopbackInterfaceIpArgsDict']]]]] = None,
            ipv6: Optional[pulumi.Input[Union['LoopbackInterfaceIpv6Args', 'LoopbackInterfaceIpv6ArgsDict']]] = None,
            mtu: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            snippet: Optional[pulumi.Input[_builtins.str]] = None,
            tfid: Optional[pulumi.Input[_builtins.str]] = None) -> 'LoopbackInterface':
        """
        Get an existing LoopbackInterface resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comment: Description
        :param pulumi.Input[_builtins.str] default_value: Default interface assignment
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] interface_management_profile: Interface management profile
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoopbackInterfaceIpArgs', 'LoopbackInterfaceIpArgsDict']]]] ips: Loopback IP Parent
        :param pulumi.Input[Union['LoopbackInterfaceIpv6Args', 'LoopbackInterfaceIpv6ArgsDict']] ipv6: Loopback IPv6 Configuration
        :param pulumi.Input[_builtins.int] mtu: MTU
        :param pulumi.Input[_builtins.str] name: Loopback Interface name
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoopbackInterfaceState.__new__(_LoopbackInterfaceState)

        __props__.__dict__["comment"] = comment
        __props__.__dict__["default_value"] = default_value
        __props__.__dict__["device"] = device
        __props__.__dict__["folder"] = folder
        __props__.__dict__["interface_management_profile"] = interface_management_profile
        __props__.__dict__["ips"] = ips
        __props__.__dict__["ipv6"] = ipv6
        __props__.__dict__["mtu"] = mtu
        __props__.__dict__["name"] = name
        __props__.__dict__["snippet"] = snippet
        __props__.__dict__["tfid"] = tfid
        return LoopbackInterface(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Default interface assignment
        """
        return pulumi.get(self, "default_value")

    @_builtins.property
    @pulumi.getter
    def device(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter(name="interfaceManagementProfile")
    def interface_management_profile(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Interface management profile
        """
        return pulumi.get(self, "interface_management_profile")

    @_builtins.property
    @pulumi.getter
    def ips(self) -> pulumi.Output[Optional[Sequence['outputs.LoopbackInterfaceIp']]]:
        """
        Loopback IP Parent
        """
        return pulumi.get(self, "ips")

    @_builtins.property
    @pulumi.getter
    def ipv6(self) -> pulumi.Output['outputs.LoopbackInterfaceIpv6']:
        """
        Loopback IPv6 Configuration
        """
        return pulumi.get(self, "ipv6")

    @_builtins.property
    @pulumi.getter
    def mtu(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        MTU
        """
        return pulumi.get(self, "mtu")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Loopback Interface name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tfid")

