# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ScepProfileArgs', 'ScepProfile']

@pulumi.input_type
class ScepProfileArgs:
    def __init__(__self__, *,
                 algorithm: pulumi.Input['ScepProfileAlgorithmArgs'],
                 ca_identity_name: pulumi.Input[_builtins.str],
                 digest: pulumi.Input[_builtins.str],
                 scep_challenge: pulumi.Input['ScepProfileScepChallengeArgs'],
                 scep_url: pulumi.Input[_builtins.str],
                 subject: pulumi.Input[_builtins.str],
                 certificate_attributes: Optional[pulumi.Input['ScepProfileCertificateAttributesArgs']] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 scep_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 scep_client_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 use_as_digital_signature: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_for_key_encipherment: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ScepProfile resource.
        :param pulumi.Input['ScepProfileAlgorithmArgs'] algorithm: Algorithm
        :param pulumi.Input[_builtins.str] ca_identity_name: Certificate Authority identity
        :param pulumi.Input[_builtins.str] digest: Digest for CSR
        :param pulumi.Input['ScepProfileScepChallengeArgs'] scep_challenge: One Time Password challenge
        :param pulumi.Input[_builtins.str] scep_url: SCEP server URL
        :param pulumi.Input[_builtins.str] subject: Subject
        :param pulumi.Input['ScepProfileCertificateAttributesArgs'] certificate_attributes: Subject Alternative name type
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] fingerprint: CA certificate fingerprint
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] name: The name of the SCEP profile
        :param pulumi.Input[_builtins.str] scep_ca_cert: SCEP server CA certificate
        :param pulumi.Input[_builtins.str] scep_client_cert: SCEP client ceertificate
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[_builtins.bool] use_as_digital_signature: Use as digital signature?
        :param pulumi.Input[_builtins.bool] use_for_key_encipherment: Use for key encipherment?
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "ca_identity_name", ca_identity_name)
        pulumi.set(__self__, "digest", digest)
        pulumi.set(__self__, "scep_challenge", scep_challenge)
        pulumi.set(__self__, "scep_url", scep_url)
        pulumi.set(__self__, "subject", subject)
        if certificate_attributes is not None:
            pulumi.set(__self__, "certificate_attributes", certificate_attributes)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if scep_ca_cert is not None:
            pulumi.set(__self__, "scep_ca_cert", scep_ca_cert)
        if scep_client_cert is not None:
            pulumi.set(__self__, "scep_client_cert", scep_client_cert)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if use_as_digital_signature is not None:
            pulumi.set(__self__, "use_as_digital_signature", use_as_digital_signature)
        if use_for_key_encipherment is not None:
            pulumi.set(__self__, "use_for_key_encipherment", use_for_key_encipherment)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> pulumi.Input['ScepProfileAlgorithmArgs']:
        """
        Algorithm
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: pulumi.Input['ScepProfileAlgorithmArgs']):
        pulumi.set(self, "algorithm", value)

    @_builtins.property
    @pulumi.getter(name="caIdentityName")
    def ca_identity_name(self) -> pulumi.Input[_builtins.str]:
        """
        Certificate Authority identity
        """
        return pulumi.get(self, "ca_identity_name")

    @ca_identity_name.setter
    def ca_identity_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ca_identity_name", value)

    @_builtins.property
    @pulumi.getter
    def digest(self) -> pulumi.Input[_builtins.str]:
        """
        Digest for CSR
        """
        return pulumi.get(self, "digest")

    @digest.setter
    def digest(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "digest", value)

    @_builtins.property
    @pulumi.getter(name="scepChallenge")
    def scep_challenge(self) -> pulumi.Input['ScepProfileScepChallengeArgs']:
        """
        One Time Password challenge
        """
        return pulumi.get(self, "scep_challenge")

    @scep_challenge.setter
    def scep_challenge(self, value: pulumi.Input['ScepProfileScepChallengeArgs']):
        pulumi.set(self, "scep_challenge", value)

    @_builtins.property
    @pulumi.getter(name="scepUrl")
    def scep_url(self) -> pulumi.Input[_builtins.str]:
        """
        SCEP server URL
        """
        return pulumi.get(self, "scep_url")

    @scep_url.setter
    def scep_url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "scep_url", value)

    @_builtins.property
    @pulumi.getter
    def subject(self) -> pulumi.Input[_builtins.str]:
        """
        Subject
        """
        return pulumi.get(self, "subject")

    @subject.setter
    def subject(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subject", value)

    @_builtins.property
    @pulumi.getter(name="certificateAttributes")
    def certificate_attributes(self) -> Optional[pulumi.Input['ScepProfileCertificateAttributesArgs']]:
        """
        Subject Alternative name type
        """
        return pulumi.get(self, "certificate_attributes")

    @certificate_attributes.setter
    def certificate_attributes(self, value: Optional[pulumi.Input['ScepProfileCertificateAttributesArgs']]):
        pulumi.set(self, "certificate_attributes", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CA certificate fingerprint
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fingerprint", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the SCEP profile
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="scepCaCert")
    def scep_ca_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SCEP server CA certificate
        """
        return pulumi.get(self, "scep_ca_cert")

    @scep_ca_cert.setter
    def scep_ca_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scep_ca_cert", value)

    @_builtins.property
    @pulumi.getter(name="scepClientCert")
    def scep_client_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SCEP client ceertificate
        """
        return pulumi.get(self, "scep_client_cert")

    @scep_client_cert.setter
    def scep_client_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scep_client_cert", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter(name="useAsDigitalSignature")
    def use_as_digital_signature(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Use as digital signature?
        """
        return pulumi.get(self, "use_as_digital_signature")

    @use_as_digital_signature.setter
    def use_as_digital_signature(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_as_digital_signature", value)

    @_builtins.property
    @pulumi.getter(name="useForKeyEncipherment")
    def use_for_key_encipherment(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Use for key encipherment?
        """
        return pulumi.get(self, "use_for_key_encipherment")

    @use_for_key_encipherment.setter
    def use_for_key_encipherment(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_for_key_encipherment", value)


@pulumi.input_type
class _ScepProfileState:
    def __init__(__self__, *,
                 algorithm: Optional[pulumi.Input['ScepProfileAlgorithmArgs']] = None,
                 ca_identity_name: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_attributes: Optional[pulumi.Input['ScepProfileCertificateAttributesArgs']] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 digest: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypted_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 scep_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 scep_challenge: Optional[pulumi.Input['ScepProfileScepChallengeArgs']] = None,
                 scep_client_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 scep_url: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 subject: Optional[pulumi.Input[_builtins.str]] = None,
                 tfid: Optional[pulumi.Input[_builtins.str]] = None,
                 use_as_digital_signature: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_for_key_encipherment: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ScepProfile resources.
        :param pulumi.Input['ScepProfileAlgorithmArgs'] algorithm: Algorithm
        :param pulumi.Input[_builtins.str] ca_identity_name: Certificate Authority identity
        :param pulumi.Input['ScepProfileCertificateAttributesArgs'] certificate_attributes: Subject Alternative name type
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] digest: Digest for CSR
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] encrypted_values: Map of sensitive values returned from the API.
        :param pulumi.Input[_builtins.str] fingerprint: CA certificate fingerprint
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] name: The name of the SCEP profile
        :param pulumi.Input[_builtins.str] scep_ca_cert: SCEP server CA certificate
        :param pulumi.Input['ScepProfileScepChallengeArgs'] scep_challenge: One Time Password challenge
        :param pulumi.Input[_builtins.str] scep_client_cert: SCEP client ceertificate
        :param pulumi.Input[_builtins.str] scep_url: SCEP server URL
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[_builtins.str] subject: Subject
        :param pulumi.Input[_builtins.bool] use_as_digital_signature: Use as digital signature?
        :param pulumi.Input[_builtins.bool] use_for_key_encipherment: Use for key encipherment?
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if ca_identity_name is not None:
            pulumi.set(__self__, "ca_identity_name", ca_identity_name)
        if certificate_attributes is not None:
            pulumi.set(__self__, "certificate_attributes", certificate_attributes)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if digest is not None:
            pulumi.set(__self__, "digest", digest)
        if encrypted_values is not None:
            pulumi.set(__self__, "encrypted_values", encrypted_values)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if scep_ca_cert is not None:
            pulumi.set(__self__, "scep_ca_cert", scep_ca_cert)
        if scep_challenge is not None:
            pulumi.set(__self__, "scep_challenge", scep_challenge)
        if scep_client_cert is not None:
            pulumi.set(__self__, "scep_client_cert", scep_client_cert)
        if scep_url is not None:
            pulumi.set(__self__, "scep_url", scep_url)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if tfid is not None:
            pulumi.set(__self__, "tfid", tfid)
        if use_as_digital_signature is not None:
            pulumi.set(__self__, "use_as_digital_signature", use_as_digital_signature)
        if use_for_key_encipherment is not None:
            pulumi.set(__self__, "use_for_key_encipherment", use_for_key_encipherment)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> Optional[pulumi.Input['ScepProfileAlgorithmArgs']]:
        """
        Algorithm
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input['ScepProfileAlgorithmArgs']]):
        pulumi.set(self, "algorithm", value)

    @_builtins.property
    @pulumi.getter(name="caIdentityName")
    def ca_identity_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Certificate Authority identity
        """
        return pulumi.get(self, "ca_identity_name")

    @ca_identity_name.setter
    def ca_identity_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ca_identity_name", value)

    @_builtins.property
    @pulumi.getter(name="certificateAttributes")
    def certificate_attributes(self) -> Optional[pulumi.Input['ScepProfileCertificateAttributesArgs']]:
        """
        Subject Alternative name type
        """
        return pulumi.get(self, "certificate_attributes")

    @certificate_attributes.setter
    def certificate_attributes(self, value: Optional[pulumi.Input['ScepProfileCertificateAttributesArgs']]):
        pulumi.set(self, "certificate_attributes", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def digest(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Digest for CSR
        """
        return pulumi.get(self, "digest")

    @digest.setter
    def digest(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "digest", value)

    @_builtins.property
    @pulumi.getter(name="encryptedValues")
    def encrypted_values(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of sensitive values returned from the API.
        """
        return pulumi.get(self, "encrypted_values")

    @encrypted_values.setter
    def encrypted_values(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "encrypted_values", value)

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CA certificate fingerprint
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fingerprint", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the SCEP profile
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="scepCaCert")
    def scep_ca_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SCEP server CA certificate
        """
        return pulumi.get(self, "scep_ca_cert")

    @scep_ca_cert.setter
    def scep_ca_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scep_ca_cert", value)

    @_builtins.property
    @pulumi.getter(name="scepChallenge")
    def scep_challenge(self) -> Optional[pulumi.Input['ScepProfileScepChallengeArgs']]:
        """
        One Time Password challenge
        """
        return pulumi.get(self, "scep_challenge")

    @scep_challenge.setter
    def scep_challenge(self, value: Optional[pulumi.Input['ScepProfileScepChallengeArgs']]):
        pulumi.set(self, "scep_challenge", value)

    @_builtins.property
    @pulumi.getter(name="scepClientCert")
    def scep_client_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SCEP client ceertificate
        """
        return pulumi.get(self, "scep_client_cert")

    @scep_client_cert.setter
    def scep_client_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scep_client_cert", value)

    @_builtins.property
    @pulumi.getter(name="scepUrl")
    def scep_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SCEP server URL
        """
        return pulumi.get(self, "scep_url")

    @scep_url.setter
    def scep_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scep_url", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter
    def subject(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Subject
        """
        return pulumi.get(self, "subject")

    @subject.setter
    def subject(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subject", value)

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tfid")

    @tfid.setter
    def tfid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tfid", value)

    @_builtins.property
    @pulumi.getter(name="useAsDigitalSignature")
    def use_as_digital_signature(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Use as digital signature?
        """
        return pulumi.get(self, "use_as_digital_signature")

    @use_as_digital_signature.setter
    def use_as_digital_signature(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_as_digital_signature", value)

    @_builtins.property
    @pulumi.getter(name="useForKeyEncipherment")
    def use_for_key_encipherment(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Use for key encipherment?
        """
        return pulumi.get(self, "use_for_key_encipherment")

    @use_for_key_encipherment.setter
    def use_for_key_encipherment(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_for_key_encipherment", value)


@pulumi.type_token("scm:index/scepProfile:ScepProfile")
class ScepProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 algorithm: Optional[pulumi.Input[Union['ScepProfileAlgorithmArgs', 'ScepProfileAlgorithmArgsDict']]] = None,
                 ca_identity_name: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_attributes: Optional[pulumi.Input[Union['ScepProfileCertificateAttributesArgs', 'ScepProfileCertificateAttributesArgsDict']]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 digest: Optional[pulumi.Input[_builtins.str]] = None,
                 fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 scep_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 scep_challenge: Optional[pulumi.Input[Union['ScepProfileScepChallengeArgs', 'ScepProfileScepChallengeArgsDict']]] = None,
                 scep_client_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 scep_url: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 subject: Optional[pulumi.Input[_builtins.str]] = None,
                 use_as_digital_signature: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_for_key_encipherment: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        ScepProfile resource

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ScepProfileAlgorithmArgs', 'ScepProfileAlgorithmArgsDict']] algorithm: Algorithm
        :param pulumi.Input[_builtins.str] ca_identity_name: Certificate Authority identity
        :param pulumi.Input[Union['ScepProfileCertificateAttributesArgs', 'ScepProfileCertificateAttributesArgsDict']] certificate_attributes: Subject Alternative name type
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] digest: Digest for CSR
        :param pulumi.Input[_builtins.str] fingerprint: CA certificate fingerprint
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] name: The name of the SCEP profile
        :param pulumi.Input[_builtins.str] scep_ca_cert: SCEP server CA certificate
        :param pulumi.Input[Union['ScepProfileScepChallengeArgs', 'ScepProfileScepChallengeArgsDict']] scep_challenge: One Time Password challenge
        :param pulumi.Input[_builtins.str] scep_client_cert: SCEP client ceertificate
        :param pulumi.Input[_builtins.str] scep_url: SCEP server URL
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[_builtins.str] subject: Subject
        :param pulumi.Input[_builtins.bool] use_as_digital_signature: Use as digital signature?
        :param pulumi.Input[_builtins.bool] use_for_key_encipherment: Use for key encipherment?
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScepProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ScepProfile resource

        :param str resource_name: The name of the resource.
        :param ScepProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScepProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 algorithm: Optional[pulumi.Input[Union['ScepProfileAlgorithmArgs', 'ScepProfileAlgorithmArgsDict']]] = None,
                 ca_identity_name: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_attributes: Optional[pulumi.Input[Union['ScepProfileCertificateAttributesArgs', 'ScepProfileCertificateAttributesArgsDict']]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 digest: Optional[pulumi.Input[_builtins.str]] = None,
                 fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 scep_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 scep_challenge: Optional[pulumi.Input[Union['ScepProfileScepChallengeArgs', 'ScepProfileScepChallengeArgsDict']]] = None,
                 scep_client_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 scep_url: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 subject: Optional[pulumi.Input[_builtins.str]] = None,
                 use_as_digital_signature: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_for_key_encipherment: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScepProfileArgs.__new__(ScepProfileArgs)

            if algorithm is None and not opts.urn:
                raise TypeError("Missing required property 'algorithm'")
            __props__.__dict__["algorithm"] = algorithm
            if ca_identity_name is None and not opts.urn:
                raise TypeError("Missing required property 'ca_identity_name'")
            __props__.__dict__["ca_identity_name"] = ca_identity_name
            __props__.__dict__["certificate_attributes"] = certificate_attributes
            __props__.__dict__["device"] = device
            if digest is None and not opts.urn:
                raise TypeError("Missing required property 'digest'")
            __props__.__dict__["digest"] = digest
            __props__.__dict__["fingerprint"] = fingerprint
            __props__.__dict__["folder"] = folder
            __props__.__dict__["name"] = name
            __props__.__dict__["scep_ca_cert"] = scep_ca_cert
            if scep_challenge is None and not opts.urn:
                raise TypeError("Missing required property 'scep_challenge'")
            __props__.__dict__["scep_challenge"] = scep_challenge
            __props__.__dict__["scep_client_cert"] = scep_client_cert
            if scep_url is None and not opts.urn:
                raise TypeError("Missing required property 'scep_url'")
            __props__.__dict__["scep_url"] = scep_url
            __props__.__dict__["snippet"] = snippet
            if subject is None and not opts.urn:
                raise TypeError("Missing required property 'subject'")
            __props__.__dict__["subject"] = subject
            __props__.__dict__["use_as_digital_signature"] = use_as_digital_signature
            __props__.__dict__["use_for_key_encipherment"] = use_for_key_encipherment
            __props__.__dict__["encrypted_values"] = None
            __props__.__dict__["tfid"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["encryptedValues"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ScepProfile, __self__).__init__(
            'scm:index/scepProfile:ScepProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            algorithm: Optional[pulumi.Input[Union['ScepProfileAlgorithmArgs', 'ScepProfileAlgorithmArgsDict']]] = None,
            ca_identity_name: Optional[pulumi.Input[_builtins.str]] = None,
            certificate_attributes: Optional[pulumi.Input[Union['ScepProfileCertificateAttributesArgs', 'ScepProfileCertificateAttributesArgsDict']]] = None,
            device: Optional[pulumi.Input[_builtins.str]] = None,
            digest: Optional[pulumi.Input[_builtins.str]] = None,
            encrypted_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
            folder: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            scep_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
            scep_challenge: Optional[pulumi.Input[Union['ScepProfileScepChallengeArgs', 'ScepProfileScepChallengeArgsDict']]] = None,
            scep_client_cert: Optional[pulumi.Input[_builtins.str]] = None,
            scep_url: Optional[pulumi.Input[_builtins.str]] = None,
            snippet: Optional[pulumi.Input[_builtins.str]] = None,
            subject: Optional[pulumi.Input[_builtins.str]] = None,
            tfid: Optional[pulumi.Input[_builtins.str]] = None,
            use_as_digital_signature: Optional[pulumi.Input[_builtins.bool]] = None,
            use_for_key_encipherment: Optional[pulumi.Input[_builtins.bool]] = None) -> 'ScepProfile':
        """
        Get an existing ScepProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ScepProfileAlgorithmArgs', 'ScepProfileAlgorithmArgsDict']] algorithm: Algorithm
        :param pulumi.Input[_builtins.str] ca_identity_name: Certificate Authority identity
        :param pulumi.Input[Union['ScepProfileCertificateAttributesArgs', 'ScepProfileCertificateAttributesArgsDict']] certificate_attributes: Subject Alternative name type
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] digest: Digest for CSR
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] encrypted_values: Map of sensitive values returned from the API.
        :param pulumi.Input[_builtins.str] fingerprint: CA certificate fingerprint
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] name: The name of the SCEP profile
        :param pulumi.Input[_builtins.str] scep_ca_cert: SCEP server CA certificate
        :param pulumi.Input[Union['ScepProfileScepChallengeArgs', 'ScepProfileScepChallengeArgsDict']] scep_challenge: One Time Password challenge
        :param pulumi.Input[_builtins.str] scep_client_cert: SCEP client ceertificate
        :param pulumi.Input[_builtins.str] scep_url: SCEP server URL
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[_builtins.str] subject: Subject
        :param pulumi.Input[_builtins.bool] use_as_digital_signature: Use as digital signature?
        :param pulumi.Input[_builtins.bool] use_for_key_encipherment: Use for key encipherment?
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScepProfileState.__new__(_ScepProfileState)

        __props__.__dict__["algorithm"] = algorithm
        __props__.__dict__["ca_identity_name"] = ca_identity_name
        __props__.__dict__["certificate_attributes"] = certificate_attributes
        __props__.__dict__["device"] = device
        __props__.__dict__["digest"] = digest
        __props__.__dict__["encrypted_values"] = encrypted_values
        __props__.__dict__["fingerprint"] = fingerprint
        __props__.__dict__["folder"] = folder
        __props__.__dict__["name"] = name
        __props__.__dict__["scep_ca_cert"] = scep_ca_cert
        __props__.__dict__["scep_challenge"] = scep_challenge
        __props__.__dict__["scep_client_cert"] = scep_client_cert
        __props__.__dict__["scep_url"] = scep_url
        __props__.__dict__["snippet"] = snippet
        __props__.__dict__["subject"] = subject
        __props__.__dict__["tfid"] = tfid
        __props__.__dict__["use_as_digital_signature"] = use_as_digital_signature
        __props__.__dict__["use_for_key_encipherment"] = use_for_key_encipherment
        return ScepProfile(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> pulumi.Output['outputs.ScepProfileAlgorithm']:
        """
        Algorithm
        """
        return pulumi.get(self, "algorithm")

    @_builtins.property
    @pulumi.getter(name="caIdentityName")
    def ca_identity_name(self) -> pulumi.Output[_builtins.str]:
        """
        Certificate Authority identity
        """
        return pulumi.get(self, "ca_identity_name")

    @_builtins.property
    @pulumi.getter(name="certificateAttributes")
    def certificate_attributes(self) -> pulumi.Output[Optional['outputs.ScepProfileCertificateAttributes']]:
        """
        Subject Alternative name type
        """
        return pulumi.get(self, "certificate_attributes")

    @_builtins.property
    @pulumi.getter
    def device(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter
    def digest(self) -> pulumi.Output[_builtins.str]:
        """
        Digest for CSR
        """
        return pulumi.get(self, "digest")

    @_builtins.property
    @pulumi.getter(name="encryptedValues")
    def encrypted_values(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of sensitive values returned from the API.
        """
        return pulumi.get(self, "encrypted_values")

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        CA certificate fingerprint
        """
        return pulumi.get(self, "fingerprint")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the SCEP profile
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="scepCaCert")
    def scep_ca_cert(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        SCEP server CA certificate
        """
        return pulumi.get(self, "scep_ca_cert")

    @_builtins.property
    @pulumi.getter(name="scepChallenge")
    def scep_challenge(self) -> pulumi.Output['outputs.ScepProfileScepChallenge']:
        """
        One Time Password challenge
        """
        return pulumi.get(self, "scep_challenge")

    @_builtins.property
    @pulumi.getter(name="scepClientCert")
    def scep_client_cert(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        SCEP client ceertificate
        """
        return pulumi.get(self, "scep_client_cert")

    @_builtins.property
    @pulumi.getter(name="scepUrl")
    def scep_url(self) -> pulumi.Output[_builtins.str]:
        """
        SCEP server URL
        """
        return pulumi.get(self, "scep_url")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def subject(self) -> pulumi.Output[_builtins.str]:
        """
        Subject
        """
        return pulumi.get(self, "subject")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tfid")

    @_builtins.property
    @pulumi.getter(name="useAsDigitalSignature")
    def use_as_digital_signature(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Use as digital signature?
        """
        return pulumi.get(self, "use_as_digital_signature")

    @_builtins.property
    @pulumi.getter(name="useForKeyEncipherment")
    def use_for_key_encipherment(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Use for key encipherment?
        """
        return pulumi.get(self, "use_for_key_encipherment")

