# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TacacsServerProfileArgs', 'TacacsServerProfile']

@pulumi.input_type
class TacacsServerProfileArgs:
    def __init__(__self__, *,
                 protocol: pulumi.Input[_builtins.str],
                 servers: pulumi.Input[Sequence[pulumi.Input['TacacsServerProfileServerArgs']]],
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 use_single_connection: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a TacacsServerProfile resource.
        :param pulumi.Input[_builtins.str] protocol: The TACACS+ authentication protocol
        :param pulumi.Input[Sequence[pulumi.Input['TacacsServerProfileServerArgs']]] servers: The TACACS+ server configuration
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] name: The name of the TACACS+ server profile
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[_builtins.int] timeout: The TACACS+ timeout (seconds)
        :param pulumi.Input[_builtins.bool] use_single_connection: Use a single TACACS+ connection?
        """
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "servers", servers)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if use_single_connection is not None:
            pulumi.set(__self__, "use_single_connection", use_single_connection)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[_builtins.str]:
        """
        The TACACS+ authentication protocol
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter
    def servers(self) -> pulumi.Input[Sequence[pulumi.Input['TacacsServerProfileServerArgs']]]:
        """
        The TACACS+ server configuration
        """
        return pulumi.get(self, "servers")

    @servers.setter
    def servers(self, value: pulumi.Input[Sequence[pulumi.Input['TacacsServerProfileServerArgs']]]):
        pulumi.set(self, "servers", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the TACACS+ server profile
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The TACACS+ timeout (seconds)
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)

    @_builtins.property
    @pulumi.getter(name="useSingleConnection")
    def use_single_connection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Use a single TACACS+ connection?
        """
        return pulumi.get(self, "use_single_connection")

    @use_single_connection.setter
    def use_single_connection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_single_connection", value)


@pulumi.input_type
class _TacacsServerProfileState:
    def __init__(__self__, *,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input['TacacsServerProfileServerArgs']]]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 tfid: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 use_single_connection: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering TacacsServerProfile resources.
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] name: The name of the TACACS+ server profile
        :param pulumi.Input[_builtins.str] protocol: The TACACS+ authentication protocol
        :param pulumi.Input[Sequence[pulumi.Input['TacacsServerProfileServerArgs']]] servers: The TACACS+ server configuration
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[_builtins.int] timeout: The TACACS+ timeout (seconds)
        :param pulumi.Input[_builtins.bool] use_single_connection: Use a single TACACS+ connection?
        """
        if device is not None:
            pulumi.set(__self__, "device", device)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if servers is not None:
            pulumi.set(__self__, "servers", servers)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if tfid is not None:
            pulumi.set(__self__, "tfid", tfid)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if use_single_connection is not None:
            pulumi.set(__self__, "use_single_connection", use_single_connection)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the TACACS+ server profile
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The TACACS+ authentication protocol
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter
    def servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TacacsServerProfileServerArgs']]]]:
        """
        The TACACS+ server configuration
        """
        return pulumi.get(self, "servers")

    @servers.setter
    def servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TacacsServerProfileServerArgs']]]]):
        pulumi.set(self, "servers", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tfid")

    @tfid.setter
    def tfid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tfid", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The TACACS+ timeout (seconds)
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)

    @_builtins.property
    @pulumi.getter(name="useSingleConnection")
    def use_single_connection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Use a single TACACS+ connection?
        """
        return pulumi.get(self, "use_single_connection")

    @use_single_connection.setter
    def use_single_connection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_single_connection", value)


@pulumi.type_token("scm:index/tacacsServerProfile:TacacsServerProfile")
class TacacsServerProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TacacsServerProfileServerArgs', 'TacacsServerProfileServerArgsDict']]]]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 use_single_connection: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        TacacsServerProfile resource

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] name: The name of the TACACS+ server profile
        :param pulumi.Input[_builtins.str] protocol: The TACACS+ authentication protocol
        :param pulumi.Input[Sequence[pulumi.Input[Union['TacacsServerProfileServerArgs', 'TacacsServerProfileServerArgsDict']]]] servers: The TACACS+ server configuration
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[_builtins.int] timeout: The TACACS+ timeout (seconds)
        :param pulumi.Input[_builtins.bool] use_single_connection: Use a single TACACS+ connection?
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TacacsServerProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        TacacsServerProfile resource

        :param str resource_name: The name of the resource.
        :param TacacsServerProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TacacsServerProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TacacsServerProfileServerArgs', 'TacacsServerProfileServerArgsDict']]]]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 use_single_connection: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TacacsServerProfileArgs.__new__(TacacsServerProfileArgs)

            __props__.__dict__["device"] = device
            __props__.__dict__["folder"] = folder
            __props__.__dict__["name"] = name
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            if servers is None and not opts.urn:
                raise TypeError("Missing required property 'servers'")
            __props__.__dict__["servers"] = servers
            __props__.__dict__["snippet"] = snippet
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["use_single_connection"] = use_single_connection
            __props__.__dict__["tfid"] = None
        super(TacacsServerProfile, __self__).__init__(
            'scm:index/tacacsServerProfile:TacacsServerProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            device: Optional[pulumi.Input[_builtins.str]] = None,
            folder: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            protocol: Optional[pulumi.Input[_builtins.str]] = None,
            servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TacacsServerProfileServerArgs', 'TacacsServerProfileServerArgsDict']]]]] = None,
            snippet: Optional[pulumi.Input[_builtins.str]] = None,
            tfid: Optional[pulumi.Input[_builtins.str]] = None,
            timeout: Optional[pulumi.Input[_builtins.int]] = None,
            use_single_connection: Optional[pulumi.Input[_builtins.bool]] = None) -> 'TacacsServerProfile':
        """
        Get an existing TacacsServerProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] name: The name of the TACACS+ server profile
        :param pulumi.Input[_builtins.str] protocol: The TACACS+ authentication protocol
        :param pulumi.Input[Sequence[pulumi.Input[Union['TacacsServerProfileServerArgs', 'TacacsServerProfileServerArgsDict']]]] servers: The TACACS+ server configuration
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[_builtins.int] timeout: The TACACS+ timeout (seconds)
        :param pulumi.Input[_builtins.bool] use_single_connection: Use a single TACACS+ connection?
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TacacsServerProfileState.__new__(_TacacsServerProfileState)

        __props__.__dict__["device"] = device
        __props__.__dict__["folder"] = folder
        __props__.__dict__["name"] = name
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["servers"] = servers
        __props__.__dict__["snippet"] = snippet
        __props__.__dict__["tfid"] = tfid
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["use_single_connection"] = use_single_connection
        return TacacsServerProfile(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def device(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the TACACS+ server profile
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[_builtins.str]:
        """
        The TACACS+ authentication protocol
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def servers(self) -> pulumi.Output[Sequence['outputs.TacacsServerProfileServer']]:
        """
        The TACACS+ server configuration
        """
        return pulumi.get(self, "servers")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tfid")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The TACACS+ timeout (seconds)
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter(name="useSingleConnection")
    def use_single_connection(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Use a single TACACS+ connection?
        """
        return pulumi.get(self, "use_single_connection")

