# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ZoneArgs', 'Zone']

@pulumi.input_type
class ZoneArgs:
    def __init__(__self__, *,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 device_acl: Optional[pulumi.Input['ZoneDeviceAclArgs']] = None,
                 dos_log_setting: Optional[pulumi.Input[_builtins.str]] = None,
                 dos_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_device_identification: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_user_identification: Optional[pulumi.Input[_builtins.bool]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input['ZoneNetworkArgs']] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 user_acl: Optional[pulumi.Input['ZoneUserAclArgs']] = None):
        """
        The set of arguments for constructing a Zone resource.
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input['ZoneDeviceAclArgs'] device_acl: Device acl
        :param pulumi.Input[_builtins.str] dos_log_setting: Dos log setting
        :param pulumi.Input[_builtins.str] dos_profile: Dos profile
        :param pulumi.Input[_builtins.bool] enable_device_identification: Enable device identification
        :param pulumi.Input[_builtins.bool] enable_user_identification: Enable user identification
        :param pulumi.Input[_builtins.str] folder: Folder
        :param pulumi.Input[_builtins.str] name: Alphanumeric string begin with letter: [0-9a-zA-Z._-]
        :param pulumi.Input['ZoneNetworkArgs'] network: Network
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input['ZoneUserAclArgs'] user_acl: User acl
        """
        if device is not None:
            pulumi.set(__self__, "device", device)
        if device_acl is not None:
            pulumi.set(__self__, "device_acl", device_acl)
        if dos_log_setting is not None:
            pulumi.set(__self__, "dos_log_setting", dos_log_setting)
        if dos_profile is not None:
            pulumi.set(__self__, "dos_profile", dos_profile)
        if enable_device_identification is not None:
            pulumi.set(__self__, "enable_device_identification", enable_device_identification)
        if enable_user_identification is not None:
            pulumi.set(__self__, "enable_user_identification", enable_user_identification)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if user_acl is not None:
            pulumi.set(__self__, "user_acl", user_acl)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter(name="deviceAcl")
    def device_acl(self) -> Optional[pulumi.Input['ZoneDeviceAclArgs']]:
        """
        Device acl
        """
        return pulumi.get(self, "device_acl")

    @device_acl.setter
    def device_acl(self, value: Optional[pulumi.Input['ZoneDeviceAclArgs']]):
        pulumi.set(self, "device_acl", value)

    @_builtins.property
    @pulumi.getter(name="dosLogSetting")
    def dos_log_setting(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Dos log setting
        """
        return pulumi.get(self, "dos_log_setting")

    @dos_log_setting.setter
    def dos_log_setting(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dos_log_setting", value)

    @_builtins.property
    @pulumi.getter(name="dosProfile")
    def dos_profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Dos profile
        """
        return pulumi.get(self, "dos_profile")

    @dos_profile.setter
    def dos_profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dos_profile", value)

    @_builtins.property
    @pulumi.getter(name="enableDeviceIdentification")
    def enable_device_identification(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable device identification
        """
        return pulumi.get(self, "enable_device_identification")

    @enable_device_identification.setter
    def enable_device_identification(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_device_identification", value)

    @_builtins.property
    @pulumi.getter(name="enableUserIdentification")
    def enable_user_identification(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable user identification
        """
        return pulumi.get(self, "enable_user_identification")

    @enable_user_identification.setter
    def enable_user_identification(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_user_identification", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Folder
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alphanumeric string begin with letter: [0-9a-zA-Z._-]
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input['ZoneNetworkArgs']]:
        """
        Network
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input['ZoneNetworkArgs']]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter(name="userAcl")
    def user_acl(self) -> Optional[pulumi.Input['ZoneUserAclArgs']]:
        """
        User acl
        """
        return pulumi.get(self, "user_acl")

    @user_acl.setter
    def user_acl(self, value: Optional[pulumi.Input['ZoneUserAclArgs']]):
        pulumi.set(self, "user_acl", value)


@pulumi.input_type
class _ZoneState:
    def __init__(__self__, *,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 device_acl: Optional[pulumi.Input['ZoneDeviceAclArgs']] = None,
                 dos_log_setting: Optional[pulumi.Input[_builtins.str]] = None,
                 dos_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_device_identification: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_user_identification: Optional[pulumi.Input[_builtins.bool]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input['ZoneNetworkArgs']] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 tfid: Optional[pulumi.Input[_builtins.str]] = None,
                 user_acl: Optional[pulumi.Input['ZoneUserAclArgs']] = None):
        """
        Input properties used for looking up and filtering Zone resources.
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input['ZoneDeviceAclArgs'] device_acl: Device acl
        :param pulumi.Input[_builtins.str] dos_log_setting: Dos log setting
        :param pulumi.Input[_builtins.str] dos_profile: Dos profile
        :param pulumi.Input[_builtins.bool] enable_device_identification: Enable device identification
        :param pulumi.Input[_builtins.bool] enable_user_identification: Enable user identification
        :param pulumi.Input[_builtins.str] folder: Folder
        :param pulumi.Input[_builtins.str] name: Alphanumeric string begin with letter: [0-9a-zA-Z._-]
        :param pulumi.Input['ZoneNetworkArgs'] network: Network
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input['ZoneUserAclArgs'] user_acl: User acl
        """
        if device is not None:
            pulumi.set(__self__, "device", device)
        if device_acl is not None:
            pulumi.set(__self__, "device_acl", device_acl)
        if dos_log_setting is not None:
            pulumi.set(__self__, "dos_log_setting", dos_log_setting)
        if dos_profile is not None:
            pulumi.set(__self__, "dos_profile", dos_profile)
        if enable_device_identification is not None:
            pulumi.set(__self__, "enable_device_identification", enable_device_identification)
        if enable_user_identification is not None:
            pulumi.set(__self__, "enable_user_identification", enable_user_identification)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if tfid is not None:
            pulumi.set(__self__, "tfid", tfid)
        if user_acl is not None:
            pulumi.set(__self__, "user_acl", user_acl)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter(name="deviceAcl")
    def device_acl(self) -> Optional[pulumi.Input['ZoneDeviceAclArgs']]:
        """
        Device acl
        """
        return pulumi.get(self, "device_acl")

    @device_acl.setter
    def device_acl(self, value: Optional[pulumi.Input['ZoneDeviceAclArgs']]):
        pulumi.set(self, "device_acl", value)

    @_builtins.property
    @pulumi.getter(name="dosLogSetting")
    def dos_log_setting(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Dos log setting
        """
        return pulumi.get(self, "dos_log_setting")

    @dos_log_setting.setter
    def dos_log_setting(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dos_log_setting", value)

    @_builtins.property
    @pulumi.getter(name="dosProfile")
    def dos_profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Dos profile
        """
        return pulumi.get(self, "dos_profile")

    @dos_profile.setter
    def dos_profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dos_profile", value)

    @_builtins.property
    @pulumi.getter(name="enableDeviceIdentification")
    def enable_device_identification(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable device identification
        """
        return pulumi.get(self, "enable_device_identification")

    @enable_device_identification.setter
    def enable_device_identification(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_device_identification", value)

    @_builtins.property
    @pulumi.getter(name="enableUserIdentification")
    def enable_user_identification(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable user identification
        """
        return pulumi.get(self, "enable_user_identification")

    @enable_user_identification.setter
    def enable_user_identification(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_user_identification", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Folder
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alphanumeric string begin with letter: [0-9a-zA-Z._-]
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input['ZoneNetworkArgs']]:
        """
        Network
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input['ZoneNetworkArgs']]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tfid")

    @tfid.setter
    def tfid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tfid", value)

    @_builtins.property
    @pulumi.getter(name="userAcl")
    def user_acl(self) -> Optional[pulumi.Input['ZoneUserAclArgs']]:
        """
        User acl
        """
        return pulumi.get(self, "user_acl")

    @user_acl.setter
    def user_acl(self, value: Optional[pulumi.Input['ZoneUserAclArgs']]):
        pulumi.set(self, "user_acl", value)


@pulumi.type_token("scm:index/zone:Zone")
class Zone(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 device_acl: Optional[pulumi.Input[Union['ZoneDeviceAclArgs', 'ZoneDeviceAclArgsDict']]] = None,
                 dos_log_setting: Optional[pulumi.Input[_builtins.str]] = None,
                 dos_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_device_identification: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_user_identification: Optional[pulumi.Input[_builtins.bool]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[Union['ZoneNetworkArgs', 'ZoneNetworkArgsDict']]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 user_acl: Optional[pulumi.Input[Union['ZoneUserAclArgs', 'ZoneUserAclArgsDict']]] = None,
                 __props__=None):
        """
        Zone resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        #
        # Creates an empty layer3 zone
        #
        scm_layer3_zone = scm.Zone("scm_layer3_zone",
            name="scm_layer3_zone",
            folder="ngfw-shared",
            network={
                "layer3s": [],
            })
        #
        # Creates an empty layer2 zone
        #
        scm_layer2_zone = scm.Zone("scm_layer2_zone",
            name="scm_layer2_zone",
            folder="ngfw-shared",
            network={
                "layer2s": [],
            })
        #
        # Creates an empty tap zone
        #
        scm_tap_zone = scm.Zone("scm_tap_zone",
            name="scm_tap_zone",
            folder="ngfw-shared",
            network={
                "taps": [],
            })
        #
        # Creates an empty vwire zone
        #
        scm_vwire_zone = scm.Zone("scm_vwire_zone",
            name="scm_vwire_zone",
            folder="ngfw-shared",
            network={
                "virtual_wires": [],
            })
        #
        # Creates a layer3 zone
        # Requires Interface $scm_l3_interface to exist
        #
        scm_layer3_zone_complex = scm.Zone("scm_layer3_zone_complex",
            name="scm_layer3_zone_complex",
            folder="ngfw-shared",
            network={
                "layer3s": ["$scm_l3_interface"],
                "zone_protection_profile": "best-practice",
                "enable_packet_buffer_protection": True,
            },
            enable_device_identification=True,
            device_acl={
                "include_lists": ["198.18.1.0/24"],
                "exclude_lists": ["198.18.2.0/24"],
            },
            enable_user_identification=True,
            user_acl={
                "include_lists": ["198.18.3.0/24"],
                "exclude_lists": ["198.18.4.0/24"],
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[Union['ZoneDeviceAclArgs', 'ZoneDeviceAclArgsDict']] device_acl: Device acl
        :param pulumi.Input[_builtins.str] dos_log_setting: Dos log setting
        :param pulumi.Input[_builtins.str] dos_profile: Dos profile
        :param pulumi.Input[_builtins.bool] enable_device_identification: Enable device identification
        :param pulumi.Input[_builtins.bool] enable_user_identification: Enable user identification
        :param pulumi.Input[_builtins.str] folder: Folder
        :param pulumi.Input[_builtins.str] name: Alphanumeric string begin with letter: [0-9a-zA-Z._-]
        :param pulumi.Input[Union['ZoneNetworkArgs', 'ZoneNetworkArgsDict']] network: Network
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Union['ZoneUserAclArgs', 'ZoneUserAclArgsDict']] user_acl: User acl
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ZoneArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Zone resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        #
        # Creates an empty layer3 zone
        #
        scm_layer3_zone = scm.Zone("scm_layer3_zone",
            name="scm_layer3_zone",
            folder="ngfw-shared",
            network={
                "layer3s": [],
            })
        #
        # Creates an empty layer2 zone
        #
        scm_layer2_zone = scm.Zone("scm_layer2_zone",
            name="scm_layer2_zone",
            folder="ngfw-shared",
            network={
                "layer2s": [],
            })
        #
        # Creates an empty tap zone
        #
        scm_tap_zone = scm.Zone("scm_tap_zone",
            name="scm_tap_zone",
            folder="ngfw-shared",
            network={
                "taps": [],
            })
        #
        # Creates an empty vwire zone
        #
        scm_vwire_zone = scm.Zone("scm_vwire_zone",
            name="scm_vwire_zone",
            folder="ngfw-shared",
            network={
                "virtual_wires": [],
            })
        #
        # Creates a layer3 zone
        # Requires Interface $scm_l3_interface to exist
        #
        scm_layer3_zone_complex = scm.Zone("scm_layer3_zone_complex",
            name="scm_layer3_zone_complex",
            folder="ngfw-shared",
            network={
                "layer3s": ["$scm_l3_interface"],
                "zone_protection_profile": "best-practice",
                "enable_packet_buffer_protection": True,
            },
            enable_device_identification=True,
            device_acl={
                "include_lists": ["198.18.1.0/24"],
                "exclude_lists": ["198.18.2.0/24"],
            },
            enable_user_identification=True,
            user_acl={
                "include_lists": ["198.18.3.0/24"],
                "exclude_lists": ["198.18.4.0/24"],
            })
        ```

        :param str resource_name: The name of the resource.
        :param ZoneArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZoneArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 device_acl: Optional[pulumi.Input[Union['ZoneDeviceAclArgs', 'ZoneDeviceAclArgsDict']]] = None,
                 dos_log_setting: Optional[pulumi.Input[_builtins.str]] = None,
                 dos_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_device_identification: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_user_identification: Optional[pulumi.Input[_builtins.bool]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[Union['ZoneNetworkArgs', 'ZoneNetworkArgsDict']]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 user_acl: Optional[pulumi.Input[Union['ZoneUserAclArgs', 'ZoneUserAclArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZoneArgs.__new__(ZoneArgs)

            __props__.__dict__["device"] = device
            __props__.__dict__["device_acl"] = device_acl
            __props__.__dict__["dos_log_setting"] = dos_log_setting
            __props__.__dict__["dos_profile"] = dos_profile
            __props__.__dict__["enable_device_identification"] = enable_device_identification
            __props__.__dict__["enable_user_identification"] = enable_user_identification
            __props__.__dict__["folder"] = folder
            __props__.__dict__["name"] = name
            __props__.__dict__["network"] = network
            __props__.__dict__["snippet"] = snippet
            __props__.__dict__["user_acl"] = user_acl
            __props__.__dict__["tfid"] = None
        super(Zone, __self__).__init__(
            'scm:index/zone:Zone',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            device: Optional[pulumi.Input[_builtins.str]] = None,
            device_acl: Optional[pulumi.Input[Union['ZoneDeviceAclArgs', 'ZoneDeviceAclArgsDict']]] = None,
            dos_log_setting: Optional[pulumi.Input[_builtins.str]] = None,
            dos_profile: Optional[pulumi.Input[_builtins.str]] = None,
            enable_device_identification: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_user_identification: Optional[pulumi.Input[_builtins.bool]] = None,
            folder: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network: Optional[pulumi.Input[Union['ZoneNetworkArgs', 'ZoneNetworkArgsDict']]] = None,
            snippet: Optional[pulumi.Input[_builtins.str]] = None,
            tfid: Optional[pulumi.Input[_builtins.str]] = None,
            user_acl: Optional[pulumi.Input[Union['ZoneUserAclArgs', 'ZoneUserAclArgsDict']]] = None) -> 'Zone':
        """
        Get an existing Zone resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[Union['ZoneDeviceAclArgs', 'ZoneDeviceAclArgsDict']] device_acl: Device acl
        :param pulumi.Input[_builtins.str] dos_log_setting: Dos log setting
        :param pulumi.Input[_builtins.str] dos_profile: Dos profile
        :param pulumi.Input[_builtins.bool] enable_device_identification: Enable device identification
        :param pulumi.Input[_builtins.bool] enable_user_identification: Enable user identification
        :param pulumi.Input[_builtins.str] folder: Folder
        :param pulumi.Input[_builtins.str] name: Alphanumeric string begin with letter: [0-9a-zA-Z._-]
        :param pulumi.Input[Union['ZoneNetworkArgs', 'ZoneNetworkArgsDict']] network: Network
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Union['ZoneUserAclArgs', 'ZoneUserAclArgsDict']] user_acl: User acl
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZoneState.__new__(_ZoneState)

        __props__.__dict__["device"] = device
        __props__.__dict__["device_acl"] = device_acl
        __props__.__dict__["dos_log_setting"] = dos_log_setting
        __props__.__dict__["dos_profile"] = dos_profile
        __props__.__dict__["enable_device_identification"] = enable_device_identification
        __props__.__dict__["enable_user_identification"] = enable_user_identification
        __props__.__dict__["folder"] = folder
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["snippet"] = snippet
        __props__.__dict__["tfid"] = tfid
        __props__.__dict__["user_acl"] = user_acl
        return Zone(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def device(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter(name="deviceAcl")
    def device_acl(self) -> pulumi.Output[Optional['outputs.ZoneDeviceAcl']]:
        """
        Device acl
        """
        return pulumi.get(self, "device_acl")

    @_builtins.property
    @pulumi.getter(name="dosLogSetting")
    def dos_log_setting(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Dos log setting
        """
        return pulumi.get(self, "dos_log_setting")

    @_builtins.property
    @pulumi.getter(name="dosProfile")
    def dos_profile(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Dos profile
        """
        return pulumi.get(self, "dos_profile")

    @_builtins.property
    @pulumi.getter(name="enableDeviceIdentification")
    def enable_device_identification(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable device identification
        """
        return pulumi.get(self, "enable_device_identification")

    @_builtins.property
    @pulumi.getter(name="enableUserIdentification")
    def enable_user_identification(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable user identification
        """
        return pulumi.get(self, "enable_user_identification")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Folder
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Alphanumeric string begin with letter: [0-9a-zA-Z._-]
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Output[Optional['outputs.ZoneNetwork']]:
        """
        Network
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tfid")

    @_builtins.property
    @pulumi.getter(name="userAcl")
    def user_acl(self) -> pulumi.Output[Optional['outputs.ZoneUserAcl']]:
        """
        User acl
        """
        return pulumi.get(self, "user_acl")

