from typing import List
from dataclasses import dataclass

from foundationallm.models.orchestration import ContentArtifact

@dataclass
class FoundationaLLMToolResult:
    """A class to represent the result of a FoundationaLLM tool call."""

    content: str
    """The content of the tool result."""

    content_artifacts: List[ContentArtifact]
    """A list of content artifacts associated with the tool result."""

    input_tokens: int
    """The number of input tokens used in the tool call."""

    output_tokens: int
    """The number of output tokens generated by the tool call."""