/*
This file is a part of FAMSA software distributed under GNU GPL 3 licence.
The homepage of the FAMSA project is https://github.com/refresh-bio/FAMSA

Authors: Sebastian Deorowicz, Agnieszka Debudaj-Grabysz, Adam Gudys

*/

#ifndef _SCORING_MATRIX_H
#define _SCORING_MATRIX_H

#include <array>
#include <cassert>

class ScoringMatrices
{
	inline static std::array<std::array<double, 24>, 24> MIQS = { {
			//	   A     R     N     D     C     Q     E     G     H     I     L     K     M     F     P     S     T     W     Y     V     B     Z     X     *
				{3.2, -1.3, -0.4, -0.4,  1.5, -0.2, -0.4,  0.4, -1.2, -1.3, -1.4, -0.7, -1.0, -2.3, -0.1,  0.8,  0.8, -3.6, -2.4,  0.0, -6.1, -6.1, -6.1, -6.1},	// A
				{ -1.3,  6.2, -0.1, -1.5, -2.7,  1.8, -0.7, -1.9,  0.9, -2.4, -2.5,  3.3, -1.1, -3.3, -1.1, -0.3, -0.9, -3.8, -1.9, -2.3, -6.1, -6.1, -6.1, -6.1},	// R
				{ -0.4, -0.1,  5.1,  2.6, -1.6,  0.9,  0.8,  0.2,  1.0, -3.6, -3.5,  0.7, -2.3, -3.5, -1.4,  0.9,  0.0, -4.5, -1.5, -2.6, -6.1, -6.1, -6.1, -6.1},	// N
				{ -0.4, -1.5,  2.6,  5.7, -3.7,  0.9,  2.7, -0.5,  0.3, -4.5, -4.6,  0.4, -3.3, -5.8, -0.3,  0.3, -0.2, -5.3, -3.9, -3.5, -6.1, -6.1, -6.1, -6.1},	// D
				{  1.5, -2.7, -1.6, -3.7, 11.7, -2.8, -3.2, -1.7, -1.2,  0.2, -2.3, -3.2,  0.1, -2.8, -2.8,  1.0,  0.0, -6.1, -0.7,  1.8, -6.1, -6.1, -6.1, -6.1},	// C
				{ -0.2,  1.8,  0.9,  0.9, -2.8,  3.6,  2.1, -1.6,  1.2, -2.2, -1.9,  1.7, -0.4, -2.4, -0.4,  0.4,  0.1, -5.4, -2.8, -1.8, -6.1, -6.1, -6.1, -6.1},	// Q
				{ -0.4, -0.7,  0.8,  2.7, -3.2,  2.1,  4.3, -1.3, -0.2, -3.3, -2.8,  1.1, -2.3, -4.1,  0.0,  0.4, -0.2, -5.8, -2.4, -2.3, -6.1, -6.1, -6.1, -6.1},	// E
				{  0.4, -1.9,  0.2, -0.5, -1.7, -1.6, -1.3,  7.6, -1.6, -5.4, -4.8, -1.7, -3.6, -4.6, -1.6,  0.0, -1.9, -4.8, -4.5, -3.8, -6.1, -6.1, -6.1, -6.1},	// G
				{ -1.2,  0.9,  1.0,  0.3, -1.2,  1.2, -0.2, -1.6,  7.5, -2.2, -1.9,  0.0, -2.1,  0.0, -1.5,  0.0, -0.2, -0.3,  2.1, -2.3, -6.1, -6.1, -6.1, -6.1},	// H
				{ -1.3, -2.4, -3.6, -4.5,  0.2, -2.2, -3.3, -5.4, -2.2,  4.6,  3.1, -2.3,  1.7,  0.7, -3.7, -2.8, -0.7, -0.7, -0.8,  3.3, -6.1, -6.1, -6.1, -6.1},	// I
				{ -1.4, -2.5, -3.5, -4.6, -2.3, -1.9, -2.8, -4.8, -1.9,  3.1,  4.6, -2.4,  3.2,  2.1, -2.8, -2.9, -1.6, -0.2,  0.0,  2.0, -6.1, -6.1, -6.1, -6.1},	// L
				{ -0.7,  3.3,  0.7,  0.4, -3.2,  1.7,  1.1, -1.7,  0.0, -2.3, -2.4,  3.6, -1.1, -3.7, -0.1,  0.0,  0.0, -4.0, -2.3, -2.0, -6.1, -6.1, -6.1, -6.1},	// K
				{ -1.0, -1.1, -2.3, -3.3,  0.1, -0.4, -2.3, -3.6, -2.1,  1.7,  3.2, -1.1,  5.4,  1.4, -2.8, -1.8, -0.8, -2.1, -0.9,  1.4, -6.1, -6.1, -6.1, -6.1},	// M
				{ -2.3, -3.3, -3.5, -5.8, -2.8, -2.4, -4.1, -4.6,  0.0,  0.7,  2.1, -3.7,  1.4,  7.4, -3.7, -2.6, -2.3,  4.2,  5.2, -0.3, -6.1, -6.1, -6.1, -6.1},	// F
				{ -0.1, -1.1, -1.4, -0.3, -2.8, -0.4,  0.0, -1.6, -1.5, -3.7, -2.8, -0.1, -2.8, -3.7,  8.4, -0.1, -0.5, -3.6, -4.5, -2.5, -6.1, -6.1, -6.1, -6.1},	// P
				{  0.8, -0.3,  0.9,  0.3,  1.0,  0.4,  0.4,  0.0,  0.0, -2.8, -2.9,  0.0, -1.8, -2.6, -0.1,  3.1,  1.6, -3.5, -1.5, -1.4, -6.1, -6.1, -6.1, -6.1},	// S
				{  0.8, -0.9,  0.0, -0.2,  0.0,  0.1, -0.2, -1.9, -0.2, -0.7, -1.6,  0.0, -0.8, -2.3, -0.5,  1.6,  3.8, -5.3, -2.1, -0.1, -6.1, -6.1, -6.1, -6.1},	// T
				{ -3.6, -3.8, -4.5, -5.3, -6.1, -5.4, -5.8, -4.8, -0.3, -0.7, -0.2, -4.0, -2.1,  4.2, -3.6, -3.5, -5.3, 14.8,  4.9, -3.3, -6.1, -6.1, -6.1, -6.1},	// W
				{ -2.4, -1.9, -1.5, -3.9, -0.7, -2.8, -2.4, -4.5,  2.1, -0.8,  0.0, -2.3, -0.9,  5.2, -4.5, -1.5, -2.1,  4.9,  8.3, -1.2, -6.1, -6.1, -6.1, -6.1},	// Y
				{  0.0, -2.3, -2.6, -3.5,  1.8, -1.8, -2.3, -3.8, -2.3,  3.3,  2.0, -2.0,  1.4, -0.3, -2.5, -1.4, -0.1, -3.3, -1.2,  3.5, -6.1, -6.1, -6.1, -6.1},	// V
				{ -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1},	// B
				{ -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1},	// Z
				{ -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1},	// X
				{ -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1, -6.1} 
		} };

	// PFASUM 31
	inline static std::array<std::array<double, 24>, 24> PFASUM31 = { {
		{	3.038250	,	-0.768000	,	-0.968400	,	-1.078725	,	0.511875	,	-0.359175	,	-0.510900	,	0.341100	,	-1.273725	,	-0.624825	,	-0.590475	,	-0.797175	,	-0.157125	,	-1.149675	,	-0.444900	,	0.618375	,	0.100200	,	-1.643550	,	-1.390875	,	0.184950	,	-4.029075	,	-3.451950	,	-13.34130, -10	},
		{	-0.768000	,	5.170050	,	0.355125	,	-0.032175	,	-2.350125	,	1.538700	,	0.861975	,	-1.276350	,	0.778125	,	-2.769525	,	-2.352525	,	2.538825	,	-1.537800	,	-2.799075	,	-0.670200	,	-0.161625	,	-0.269325	,	-1.494375	,	-1.211625	,	-2.260350	,	-2.854725	,	-1.865400	,	-13.34925, -10	},
		{	-0.968400	,	0.355125	,	4.998000	,	2.110725	,	-1.937775	,	0.921150	,	0.812475	,	0.376350	,	0.846450	,	-3.230325	,	-3.170400	,	1.046625	,	-2.008800	,	-2.874900	,	-0.513000	,	1.026975	,	0.429675	,	-2.762400	,	-1.302975	,	-2.781975	,	-0.939300	,	-2.145450	,	-13.26683, -10	},
		{	-1.078725	,	-0.032175	,	2.110725	,	5.775675	,	-3.197250	,	0.930000	,	2.403375	,	-0.236850	,	0.008475	,	-4.251600	,	-4.045725	,	0.671475	,	-3.125700	,	-4.097550	,	-0.054600	,	0.545550	,	-0.170550	,	-3.604125	,	-2.524425	,	-3.527250	,	-0.509025	,	-1.105050	,	-13.41998, -10	},
		{	0.511875	,	-2.350125	,	-1.937775	,	-3.197250	,	11.973525	,	-2.479125	,	-3.222300	,	-1.336425	,	-1.339575	,	-0.049275	,	-0.206700	,	-2.879925	,	0.040425	,	-0.153975	,	-2.479875	,	-0.213150	,	-0.493950	,	-1.225125	,	-0.606075	,	0.492750	,	-5.588625	,	-5.921550	,	-13.40617, -10	},
		{	-0.359175	,	1.538700	,	0.921150	,	0.930000	,	-2.479125	,	4.100700	,	2.018775	,	-1.043400	,	0.866625	,	-2.598075	,	-2.201250	,	1.737675	,	-0.987225	,	-2.781375	,	-0.558975	,	0.339225	,	0.146625	,	-2.154525	,	-1.301625	,	-2.105400	,	-2.073975	,	-1.311300	,	-13.17277, -10	},
		{	-0.510900	,	0.861975	,	0.812475	,	2.403375	,	-3.222300	,	2.018775	,	4.574625	,	-1.117425	,	-0.002775	,	-3.346200	,	-3.157425	,	1.640550	,	-2.265450	,	-3.735900	,	-0.300750	,	0.220650	,	-0.051825	,	-3.211800	,	-2.127900	,	-2.672925	,	-1.236825	,	-1.249350	,	-13.34362, -10	},
		{	0.341100	,	-1.276350	,	0.376350	,	-0.236850	,	-1.336425	,	-1.043400	,	-1.117425	,	6.563025	,	-1.250700	,	-3.325200	,	-3.121275	,	-1.038150	,	-2.195400	,	-2.691300	,	-0.716175	,	0.429600	,	-0.802350	,	-2.504100	,	-2.506950	,	-2.556975	,	-2.951925	,	-4.088850	,	-13.65720, -10	},
		{	-1.273725	,	0.778125	,	0.846450	,	0.008475	,	-1.339575	,	0.866625	,	-0.002775	,	-1.250700	,	8.832225	,	-2.669925	,	-2.294550	,	0.219150	,	-1.477425	,	-1.212450	,	-0.837000	,	-0.335850	,	-0.627225	,	-0.600000	,	1.179750	,	-2.233875	,	-2.596800	,	-2.647875	,	-13.33313, -10	},
		{	-0.624825	,	-2.769525	,	-3.230325	,	-4.251600	,	-0.049275	,	-2.598075	,	-3.346200	,	-3.325200	,	-2.669925	,	3.971925	,	2.315250	,	-2.839725	,	1.665525	,	1.255875	,	-2.489700	,	-2.254125	,	-0.910875	,	-0.708450	,	-0.445125	,	2.815275	,	-6.765075	,	-6.043350	,	-13.34100, -10	},
		{	-0.590475	,	-2.352525	,	-3.170400	,	-4.045725	,	-0.206700	,	-2.201250	,	-3.157425	,	-3.121275	,	-2.294550	,	2.315250	,	3.643275	,	-2.793750	,	2.101725	,	1.717650	,	-2.428200	,	-2.290875	,	-1.284750	,	0.010200	,	-0.176625	,	1.512750	,	-6.632400	,	-5.764800	,	-13.54912, -10	},
		{	-0.797175	,	2.538825	,	1.046625	,	0.671475	,	-2.879925	,	1.737675	,	1.640550	,	-1.038150	,	0.219150	,	-2.839725	,	-2.793750	,	4.461300	,	-1.853100	,	-3.336900	,	-0.303225	,	0.191175	,	0.038325	,	-2.649375	,	-1.724475	,	-2.450325	,	-2.156775	,	-1.321875	,	-13.28603, -10	},
		{	-0.157125	,	-1.537800	,	-2.008800	,	-3.125700	,	0.040425	,	-0.987225	,	-2.265450	,	-2.195400	,	-1.477425	,	1.665525	,	2.101725	,	-1.853100	,	4.752375	,	1.305000	,	-2.191350	,	-1.213275	,	-0.469500	,	-0.012600	,	0.093750	,	1.054500	,	-5.590575	,	-4.728900	,	-13.10655, -10	},
		{	-1.149675	,	-2.799075	,	-2.874900	,	-4.097550	,	-0.153975	,	-2.781375	,	-3.735900	,	-2.691300	,	-1.212450	,	1.255875	,	1.717650	,	-3.336900	,	1.305000	,	5.541375	,	-2.459625	,	-2.109375	,	-1.464900	,	2.424675	,	3.039225	,	0.655725	,	-6.508050	,	-6.343950	,	-13.35952, -10	},
		{	-0.444900	,	-0.670200	,	-0.513000	,	-0.054600	,	-2.479875	,	-0.558975	,	-0.300750	,	-0.716175	,	-0.837000	,	-2.489700	,	-2.428200	,	-0.303225	,	-2.191350	,	-2.459625	,	7.866000	,	0.146700	,	-0.427725	,	-2.175000	,	-2.205525	,	-1.819800	,	-3.253500	,	-3.398175	,	-13.52813, -10	},
		{	0.618375	,	-0.161625	,	1.026975	,	0.545550	,	-0.213150	,	0.339225	,	0.220650	,	0.429600	,	-0.335850	,	-2.254125	,	-2.290875	,	0.191175	,	-1.213275	,	-2.109375	,	0.146700	,	3.081150	,	1.437975	,	-2.192775	,	-1.476075	,	-1.580925	,	-2.232600	,	-2.733450	,	-13.26848, -10	},
		{	0.100200	,	-0.269325	,	0.429675	,	-0.170550	,	-0.493950	,	0.146625	,	-0.051825	,	-0.802350	,	-0.627225	,	-0.910875	,	-1.284750	,	0.038325	,	-0.469500	,	-1.464900	,	-0.427725	,	1.437975	,	3.389325	,	-1.915500	,	-1.140150	,	-0.197700	,	-2.891925	,	-2.974500	,	-13.22812, -10	},
		{	-1.643550	,	-1.494375	,	-2.762400	,	-3.604125	,	-1.225125	,	-2.154525	,	-3.211800	,	-2.504100	,	-0.600000	,	-0.708450	,	0.010200	,	-2.649375	,	-0.012600	,	2.424675	,	-2.175000	,	-2.192775	,	-1.915500	,	11.711775	,	3.085575	,	-0.977025	,	-6.207525	,	-5.774550	,	-13.46588, -10	},
		{	-1.390875	,	-1.211625	,	-1.302975	,	-2.524425	,	-0.606075	,	-1.301625	,	-2.127900	,	-2.506950	,	1.179750	,	-0.445125	,	-0.176625	,	-1.724475	,	0.093750	,	3.039225	,	-2.205525	,	-1.476075	,	-1.140150	,	3.085575	,	6.858075	,	-0.519900	,	-4.935525	,	-4.791600	,	-13.37378, -10	},
		{	0.184950	,	-2.260350	,	-2.781975	,	-3.527250	,	0.492750	,	-2.105400	,	-2.672925	,	-2.556975	,	-2.233875	,	2.815275	,	1.512750	,	-2.450325	,	1.054500	,	0.655725	,	-1.819800	,	-1.580925	,	-0.197700	,	-0.977025	,	-0.519900	,	3.525675	,	-6.178125	,	-5.445975	,	-13.32488, -10	},
		{	-4.029075	,	-2.854725	,	-0.939300	,	-0.509025	,	-5.588625	,	-2.073975	,	-1.236825	,	-2.951925	,	-2.596800	,	-6.765075	,	-6.632400	,	-2.156775	,	-5.590575	,	-6.508050	,	-3.253500	,	-2.232600	,	-2.891925	,	-6.207525	,	-4.935525	,	-6.178125	,	-0.466950	,	-4.539600	,	-16.35172, -10	},
		{	-3.451950	,	-1.865400	,	-2.145450	,	-1.105050	,	-5.921550	,	-1.311300	,	-1.249350	,	-4.088850	,	-2.647875	,	-6.043350	,	-5.764800	,	-1.321875	,	-4.728900	,	-6.343950	,	-3.398175	,	-2.733450	,	-2.974500	,	-5.774550	,	-4.791600	,	-5.445975	,	-4.539600	,	-1.326675	,	-16.27793, -10	},
		{	-13.341300	,	-13.349250	,	-13.266825	,	-13.419975	,	-13.406175	,	-13.172775	,	-13.343625	,	-13.657200	,	-13.333125	,	-13.341000	,	-13.549125	,	-13.286025	,	-13.106550	,	-13.359525	,	-13.528125	,	-13.268475	,	-13.228125	,	-13.465875	,	-13.373775	,	-13.324875	,	-16.351725	,	-16.277925	,	-20.33602, -10	},
		{	-10.000000	,	-10.000000	,	-10.000000	,	-10.000000	,	-10.000000	,	-10.000000	,	-10.000000	,	-10.000000	,	-10.000000	,	-10.000000	,	-10.000000	,	-10.000000	,	-10.000000	,	-10.000000	,	-10.000000	,	-10.000000	,	-10.000000	,	-10.000000	,	-10.000000	,	-10.000000	,	-10.000000	,	-10.000000	,	-10.00000,	12	}
		} };

	// PFASUM 43
	inline static std::array<std::array<double, 24>, 24> PFASUM43 = { {
		{	3.602925	,	-0.945825	,	-1.150350	,	-1.229775	,	0.492375	,	-0.457575	,	-0.574350	,	0.284250	,	-1.438200	,	-0.863925	,	-0.872400	,	-0.921750	,	-0.335475	,	-1.544625	,	-0.513600	,	0.729375	,	0.063900	,	-2.088525	,	-1.773075	,	0.136200	,	-4.194675	,	-3.529575	,	-13.40048	,	-11	},
		{	-0.945825	,	5.731950	,	0.223200	,	-0.320850	,	-2.810025	,	1.603350	,	0.711900	,	-1.578450	,	0.809250	,	-3.125925	,	-2.697225	,	2.750175	,	-1.748550	,	-3.287625	,	-0.984225	,	-0.249525	,	-0.368550	,	-1.833225	,	-1.481550	,	-2.586375	,	-3.073275	,	-1.927425	,	-13.41682	,	-11	},
		{	-1.150350	,	0.223200	,	5.742150	,	2.227200	,	-2.314125	,	0.881700	,	0.696075	,	0.298575	,	1.008825	,	-3.707475	,	-3.654825	,	0.983700	,	-2.317875	,	-3.330300	,	-0.792675	,	1.094775	,	0.375975	,	-3.303450	,	-1.572600	,	-3.231750	,	-0.538875	,	-2.232450	,	-13.31977	,	-11	},
		{	-1.229775	,	-0.320850	,	2.227200	,	6.282675	,	-3.815250	,	0.820200	,	2.495925	,	-0.359625	,	-0.054975	,	-4.862700	,	-4.609425	,	0.470025	,	-3.519000	,	-4.727025	,	-0.274950	,	0.512625	,	-0.317475	,	-4.185000	,	-2.999175	,	-4.046550	,	-0.149850	,	-1.067025	,	-13.48785	,	-11	},
		{	0.492375	,	-2.810025	,	-2.314125	,	-3.815250	,	12.893175	,	-2.953575	,	-3.756600	,	-1.777725	,	-1.587600	,	-0.394950	,	-0.570375	,	-3.355650	,	-0.254625	,	-0.481725	,	-3.072750	,	-0.318150	,	-0.645975	,	-1.529475	,	-0.860250	,	0.284550	,	-6.090825	,	-6.433725	,	-13.54065	,	-11	},
		{	-0.457575	,	1.603350	,	0.881700	,	0.820200	,	-2.953575	,	4.847475	,	2.080800	,	-1.310775	,	0.995475	,	-2.951850	,	-2.489325	,	1.813725	,	-1.058025	,	-3.224100	,	-0.800625	,	0.290250	,	0.063000	,	-2.595900	,	-1.595700	,	-2.407800	,	-2.152650	,	-1.006350	,	-13.21620	,	-11	},
		{	-0.574350	,	0.711900	,	0.696075	,	2.495925	,	-3.756600	,	2.080800	,	5.054325	,	-1.362675	,	-0.078525	,	-3.769125	,	-3.605850	,	1.569225	,	-2.510625	,	-4.279500	,	-0.499200	,	0.155775	,	-0.148425	,	-3.720150	,	-2.520750	,	-2.982000	,	-1.205025	,	-0.935550	,	-13.40407	,	-11	},
		{	0.284250	,	-1.578450	,	0.298575	,	-0.359625	,	-1.777725	,	-1.310775	,	-1.362675	,	7.161150	,	-1.512150	,	-4.017900	,	-3.774375	,	-1.305975	,	-2.744250	,	-3.347925	,	-1.038375	,	0.319950	,	-1.140000	,	-3.206325	,	-3.111900	,	-3.149175	,	-3.057975	,	-4.342875	,	-13.77930	,	-11	},
		{	-1.438200	,	0.809250	,	1.008825	,	-0.054975	,	-1.587600	,	0.995475	,	-0.078525	,	-1.512150	,	9.185925	,	-2.998125	,	-2.551350	,	0.216600	,	-1.609200	,	-1.169175	,	-1.166550	,	-0.320250	,	-0.710775	,	-0.750750	,	1.467300	,	-2.529975	,	-2.555025	,	-2.638575	,	-13.36252	,	-11	},
		{	-0.863925	,	-3.125925	,	-3.707475	,	-4.862700	,	-0.394950	,	-2.951850	,	-3.769125	,	-4.017900	,	-2.998125	,	4.551675	,	2.455800	,	-3.187275	,	1.764675	,	1.134675	,	-2.997900	,	-2.674875	,	-1.084950	,	-1.091325	,	-0.758925	,	3.127800	,	-7.316775	,	-6.440175	,	-13.39050	,	-11	},
		{	-0.872400	,	-2.697225	,	-3.654825	,	-4.609425	,	-0.570375	,	-2.489325	,	-3.605850	,	-3.774375	,	-2.551350	,	2.455800	,	4.201200	,	-3.135975	,	2.358750	,	1.738950	,	-2.916300	,	-2.729250	,	-1.580475	,	-0.241350	,	-0.418725	,	1.519575	,	-7.163775	,	-6.147075	,	-13.62870	,	-11	},
		{	-0.921750	,	2.750175	,	0.983700	,	0.470025	,	-3.355650	,	1.813725	,	1.569225	,	-1.305975	,	0.216600	,	-3.187275	,	-3.135975	,	4.990575	,	-1.984725	,	-3.843525	,	-0.522525	,	0.135300	,	-0.039750	,	-3.106200	,	-2.057400	,	-2.767050	,	-2.296650	,	-1.336275	,	-13.33477	,	-11	},
		{	-0.335475	,	-1.748550	,	-2.317875	,	-3.519000	,	-0.254625	,	-1.058025	,	-2.510625	,	-2.744250	,	-1.609200	,	1.764675	,	2.358750	,	-1.984725	,	5.930100	,	1.296000	,	-2.619675	,	-1.473000	,	-0.594675	,	-0.288750	,	-0.124650	,	1.010100	,	-5.949825	,	-4.900050	,	-13.14907	,	-11	},
		{	-1.544625	,	-3.287625	,	-3.330300	,	-4.727025	,	-0.481725	,	-3.224100	,	-4.279500	,	-3.347925	,	-1.169175	,	1.134675	,	1.738950	,	-3.843525	,	1.296000	,	6.558825	,	-3.067125	,	-2.571750	,	-1.875450	,	2.572575	,	3.492750	,	0.448950	,	-7.057200	,	-6.847650	,	-13.44713	,	-11	},
		{	-0.513600	,	-0.984225	,	-0.792675	,	-0.274950	,	-3.072750	,	-0.800625	,	-0.499200	,	-1.038375	,	-1.166550	,	-2.997900	,	-2.916300	,	-0.522525	,	-2.619675	,	-3.067125	,	8.592600	,	0.061950	,	-0.630750	,	-2.764425	,	-2.763000	,	-2.186775	,	-3.494850	,	-3.611250	,	-13.64633	,	-11	},
		{	0.729375	,	-0.249525	,	1.094775	,	0.512625	,	-0.318150	,	0.290250	,	0.155775	,	0.319950	,	-0.320250	,	-2.674875	,	-2.729250	,	0.135300	,	-1.473000	,	-2.571750	,	0.061950	,	3.619875	,	1.663575	,	-2.666850	,	-1.802325	,	-1.887600	,	-2.221800	,	-2.792625	,	-13.30425	,	-11	},
		{	0.063900	,	-0.368550	,	0.375975	,	-0.317475	,	-0.645975	,	0.063000	,	-0.148425	,	-1.140000	,	-0.710775	,	-1.084950	,	-1.580475	,	-0.039750	,	-0.594675	,	-1.875450	,	-0.630750	,	1.663575	,	4.141875	,	-2.378250	,	-1.507500	,	-0.231225	,	-2.998950	,	-3.066900	,	-13.28070	,	-11	},
		{	-2.088525	,	-1.833225	,	-3.303450	,	-4.185000	,	-1.529475	,	-2.595900	,	-3.720150	,	-3.206325	,	-0.750750	,	-1.091325	,	-0.241350	,	-3.106200	,	-0.288750	,	2.572575	,	-2.764425	,	-2.666850	,	-2.378250	,	12.834675	,	3.237150	,	-1.428300	,	-6.775350	,	-6.258000	,	-13.60485	,	-11	},
		{	-1.773075	,	-1.481550	,	-1.572600	,	-2.999175	,	-0.860250	,	-1.595700	,	-2.520750	,	-3.111900	,	1.467300	,	-0.758925	,	-0.418725	,	-2.057400	,	-0.124650	,	3.492750	,	-2.763000	,	-1.802325	,	-1.507500	,	3.237150	,	7.879725	,	-0.878925	,	-5.313825	,	-5.145675	,	-13.47255	,	-11	},
		{	0.136200	,	-2.586375	,	-3.231750	,	-4.046550	,	0.284550	,	-2.407800	,	-2.982000	,	-3.149175	,	-2.529975	,	3.127800	,	1.519575	,	-2.767050	,	1.010100	,	0.448950	,	-2.186775	,	-1.887600	,	-0.231225	,	-1.428300	,	-0.878925	,	4.141575	,	-6.669450	,	-5.754750	,	-13.38847	,	-11	},
		{	-4.194675	,	-3.073275	,	-0.538875	,	-0.149850	,	-6.090825	,	-2.152650	,	-1.205025	,	-3.057975	,	-2.555025	,	-7.316775	,	-7.163775	,	-2.296650	,	-5.949825	,	-7.057200	,	-3.494850	,	-2.221800	,	-2.998950	,	-6.775350	,	-5.313825	,	-6.669450	,	0.147750	,	-4.541100	,	-16.41383	,	-11	},
		{	-3.529575	,	-1.927425	,	-2.232450	,	-1.067025	,	-6.433725	,	-1.006350	,	-0.935550	,	-4.342875	,	-2.638575	,	-6.440175	,	-6.147075	,	-1.336275	,	-4.900050	,	-6.847650	,	-3.611250	,	-2.792625	,	-3.066900	,	-6.258000	,	-5.145675	,	-5.754750	,	-4.541100	,	-0.758475	,	-16.33230	,	-11	},
		{	-13.400475	,	-13.416825	,	-13.319775	,	-13.487850	,	-13.540650	,	-13.216200	,	-13.404075	,	-13.779300	,	-13.362525	,	-13.390500	,	-13.628700	,	-13.334775	,	-13.149075	,	-13.447125	,	-13.646325	,	-13.304250	,	-13.280700	,	-13.604850	,	-13.472550	,	-13.388475	,	-16.413825	,	-16.332300	,	-20.40450	,	-11	},
		{	-11.000000	,	-11.000000	,	-11.000000	,	-11.000000	,	-11.000000	,	-11.000000	,	-11.000000	,	-11.000000	,	-11.000000	,	-11.000000	,	-11.000000	,	-11.000000	,	-11.000000	,	-11.000000	,	-11.000000	,	-11.000000	,	-11.000000	,	-11.000000	,	-11.000000	,	-11.000000	,	-11.000000	,	-11.000000	,	-11.00000	,	13	}
		} };

	// PFASUM 60
	inline static std::array<std::array<double, 24>, 24> PFASUM60 = { {
		{	4.5976	,	-1.3877	,	-1.5094	,	-1.6200	,	0.3443	,	-0.6794	,	-0.7453	,	0.0690	,	-1.8996	,	-1.3915	,	-1.4982	,	-1.1556	,	-0.8113	,	-2.3356	,	-0.7663	,	0.9273	,	-0.0135	,	-2.9811	,	-2.5751	,	-0.0227	,	-4.5728	,	-3.7205	,	-13.5359	,	-12	},
		{	-1.3877	,	6.9106	,	-0.1147	,	-1.0139	,	-3.5672	,	1.5690	,	0.2656	,	-2.3639	,	0.6761	,	-3.8989	,	-3.3712	,	3.1017	,	-2.2842	,	-4.2747	,	-1.7280	,	-0.6450	,	-0.7979	,	-2.5142	,	-2.1591	,	-3.3035	,	-3.6103	,	-2.1998	,	-13.5927	,	-12	},
		{	-1.5094	,	-0.1147	,	7.1795	,	2.3272	,	-2.7875	,	0.7388	,	0.4108	,	-0.0253	,	1.1905	,	-4.5785	,	-4.4878	,	0.7667	,	-2.9155	,	-4.2340	,	-1.4217	,	1.1340	,	0.2458	,	-4.2144	,	-2.1544	,	-3.9544	,	0.2095	,	-2.4635	,	-13.4408	,	-12	},
		{	-1.6200	,	-1.0139	,	2.3272	,	7.3273	,	-4.8338	,	0.5182	,	2.6609	,	-0.8180	,	-0.3738	,	-6.0523	,	-5.6989	,	-0.0174	,	-4.4314	,	-5.9296	,	-0.8617	,	0.2920	,	-0.7427	,	-5.3418	,	-3.9198	,	-5.0119	,	0.5900	,	-1.0226	,	-13.6520	,	-12	},
		{	0.3443	,	-3.5672	,	-2.7875	,	-4.8338	,	13.9925	,	-3.7218	,	-4.8062	,	-2.4949	,	-2.1914	,	-1.0694	,	-1.2886	,	-4.2415	,	-0.9081	,	-1.1353	,	-4.1343	,	-0.4255	,	-0.9061	,	-2.3463	,	-1.4469	,	-0.1090	,	-6.8477	,	-7.3681	,	-13.7702	,	-12	},
		{	-0.6794	,	1.5690	,	0.7388	,	0.5182	,	-3.7218	,	6.3296	,	2.1719	,	-1.9119	,	1.1628	,	-3.6402	,	-2.9916	,	1.8984	,	-1.2053	,	-4.0896	,	-1.3119	,	0.0634	,	-0.2048	,	-3.4709	,	-2.2453	,	-2.9783	,	-2.3870	,	-0.3580	,	-13.3242	,	-12	},
		{	-0.7453	,	0.2656	,	0.4108	,	2.6609	,	-4.8062	,	2.1719	,	6.0847	,	-1.9454	,	-0.4473	,	-4.6146	,	-4.4421	,	1.3655	,	-3.1309	,	-5.3792	,	-0.9534	,	-0.1465	,	-0.5012	,	-4.7073	,	-3.3903	,	-3.5976	,	-1.1539	,	-0.2346	,	-13.5473	,	-12	},
		{	0.0690	,	-2.3639	,	-0.0253	,	-0.8180	,	-2.4949	,	-1.9119	,	-1.9454	,	8.0546	,	-2.1649	,	-5.3125	,	-4.9841	,	-1.8922	,	-3.7863	,	-4.5760	,	-1.8822	,	0.0352	,	-1.8341	,	-4.3906	,	-4.3156	,	-4.2234	,	-3.4646	,	-4.9328	,	-14.0241	,	-12	},
		{	-1.8996	,	0.6761	,	1.1905	,	-0.3738	,	-2.1914	,	1.1628	,	-0.4473	,	-2.1649	,	10.3294	,	-3.7849	,	-3.1910	,	0.0243	,	-2.1801	,	-1.3831	,	-1.8931	,	-0.5915	,	-1.0901	,	-1.1752	,	1.7666	,	-3.2271	,	-2.6417	,	-2.7730	,	-13.4997	,	-12	},
		{	-1.3915	,	-3.8989	,	-4.5785	,	-6.0523	,	-1.0694	,	-3.6402	,	-4.6146	,	-5.3125	,	-3.7849	,	5.6207	,	2.5500	,	-3.9047	,	1.8592	,	0.6966	,	-3.9096	,	-3.4920	,	-1.3949	,	-1.9049	,	-1.5005	,	3.5736	,	-8.3664	,	-7.2239	,	-13.5020	,	-12	},
		{	-1.4982	,	-3.3712	,	-4.4878	,	-5.6989	,	-1.2886	,	-2.9916	,	-4.4421	,	-4.9841	,	-3.1910	,	2.5500	,	5.1157	,	-3.7741	,	2.6283	,	1.5935	,	-3.7941	,	-3.5456	,	-2.1021	,	-0.8193	,	-0.9773	,	1.4021	,	-8.1444	,	-6.8412	,	-13.7925	,	-12	},
		{	-1.1556	,	3.1017	,	0.7667	,	-0.0174	,	-4.2415	,	1.8984	,	1.3655	,	-1.8922	,	0.0243	,	-3.9047	,	-3.7741	,	6.1100	,	-2.3884	,	-4.8446	,	-1.0099	,	-0.1255	,	-0.2998	,	-4.0253	,	-2.8393	,	-3.3295	,	-2.6680	,	-1.4274	,	-13.4513	,	-12	},
		{	-0.8113	,	-2.2842	,	-2.9155	,	-4.4314	,	-0.9081	,	-1.2053	,	-3.1309	,	-3.7863	,	-2.1801	,	1.8592	,	2.6283	,	-2.3884	,	8.0373	,	1.1265	,	-3.5784	,	-2.0414	,	-0.8782	,	-0.8851	,	-0.6977	,	0.8621	,	-6.7241	,	-5.3072	,	-13.2734	,	-12	},
		{	-2.3356	,	-4.2747	,	-4.2340	,	-5.9296	,	-1.1353	,	-4.0896	,	-5.3792	,	-4.5760	,	-1.3831	,	0.6966	,	1.5935	,	-4.8446	,	1.1265	,	8.0999	,	-4.1891	,	-3.4373	,	-2.6461	,	2.6191	,	4.0711	,	-0.0673	,	-8.1296	,	-7.8508	,	-13.6405	,	-12	},
		{	-0.7663	,	-1.7280	,	-1.4217	,	-0.8617	,	-4.1343	,	-1.3119	,	-0.9534	,	-1.8822	,	-1.8931	,	-3.9096	,	-3.7941	,	-1.0099	,	-3.5784	,	-4.1891	,	9.6820	,	-0.2003	,	-1.1214	,	-3.9011	,	-3.8348	,	-2.9054	,	-4.0899	,	-4.0841	,	-13.8890	,	-12	},
		{	0.9273	,	-0.6450	,	1.1340	,	0.2920	,	-0.4255	,	0.0634	,	-0.1465	,	0.0352	,	-0.5915	,	-3.4920	,	-3.5456	,	-0.1255	,	-2.0414	,	-3.4373	,	-0.2003	,	4.8601	,	1.9856	,	-3.5929	,	-2.5559	,	-2.4570	,	-2.3314	,	-3.0668	,	-13.4053	,	-12	},
		{	-0.0135	,	-0.7979	,	0.2458	,	-0.7427	,	-0.9061	,	-0.2048	,	-0.5012	,	-1.8341	,	-1.0901	,	-1.3949	,	-2.1021	,	-0.2998	,	-0.8782	,	-2.6461	,	-1.1214	,	1.9856	,	5.5810	,	-3.2840	,	-2.2904	,	-0.3126	,	-3.2964	,	-3.3879	,	-13.4062	,	-12	},
		{	-2.9811	,	-2.5142	,	-4.2144	,	-5.3418	,	-2.3463	,	-3.4709	,	-4.7073	,	-4.3906	,	-1.1752	,	-1.9049	,	-0.8193	,	-4.0253	,	-0.8851	,	2.6191	,	-3.9011	,	-3.5929	,	-3.2840	,	14.2399	,	3.3114	,	-2.2632	,	-7.8283	,	-7.2026	,	-13.8662	,	-12	},
		{	-2.5751	,	-2.1591	,	-2.1544	,	-3.9198	,	-1.4469	,	-2.2453	,	-3.3903	,	-4.3156	,	1.7666	,	-1.5005	,	-0.9773	,	-2.8393	,	-0.6977	,	4.0711	,	-3.8348	,	-2.5559	,	-2.2904	,	3.3114	,	9.4574	,	-1.6220	,	-6.0833	,	-5.9258	,	-13.6820	,	-12	},
		{	-0.0227	,	-3.3035	,	-3.9544	,	-5.0119	,	-0.1090	,	-2.9783	,	-3.5976	,	-4.2234	,	-3.2271	,	3.5736	,	1.4021	,	-3.3295	,	0.8621	,	-0.0673	,	-2.9054	,	-2.4570	,	-0.3126	,	-2.2632	,	-1.6220	,	5.1777	,	-7.5324	,	-6.3554	,	-13.5131	,	-12	},
		{	-4.5728	,	-3.6103	,	0.2095	,	0.5900	,	-6.8477	,	-2.3870	,	-1.1539	,	-3.4646	,	-2.6417	,	-8.3664	,	-8.1444	,	-2.6680	,	-6.7241	,	-8.1296	,	-4.0899	,	-2.3314	,	-3.2964	,	-7.8283	,	-6.0833	,	-7.5324	,	1.3768	,	-4.5752	,	-16.5618	,	-12	},
		{	-3.7205	,	-2.1998	,	-2.4635	,	-1.0226	,	-7.3681	,	-0.3580	,	-0.2346	,	-4.9328	,	-2.7730	,	-7.2239	,	-6.8412	,	-1.4274	,	-5.3072	,	-7.8508	,	-4.0841	,	-3.0668	,	-3.3879	,	-7.2026	,	-5.9258	,	-6.3554	,	-4.5752	,	0.4167	,	-16.4630	,	-12	},
		{	-13.5359	,	-13.5927	,	-13.4408	,	-13.6520	,	-13.7702	,	-13.3242	,	-13.5473	,	-14.0241	,	-13.4997	,	-13.5020	,	-13.7925	,	-13.4513	,	-13.2734	,	-13.6405	,	-13.8890	,	-13.4053	,	-13.4062	,	-13.8662	,	-13.6820	,	-13.5131	,	-16.5618	,	-16.4630	,	-20.5590	,	-12	},
		{	-12.0000	,	-12.0000	,	-12.0000	,	-12.0000	,	-12.0000	,	-12.0000	,	-12.0000	,	-12.0000	,	-12.0000	,	-12.0000	,	-12.0000	,	-12.0000	,	-12.0000	,	-12.0000	,	-12.0000	,	-12.0000	,	-12.0000	,	-12.0000	,	-12.0000	,	-12.0000	,	-12.0000	,	-12.0000	,	-12.0000	,	15	}
		} };

	public:
		enum class matrix_type_t { MIQS, PFASUM31, PFASUM43, PFASUM60};

		static inline std::array<std::array<double, 24>, 24>& get_matrix(const matrix_type_t matrix_type)
		{
			switch (matrix_type) {
			case matrix_type_t::MIQS:
				return MIQS;
			case matrix_type_t::PFASUM31:
				return PFASUM31;
			case matrix_type_t::PFASUM43:
				return PFASUM43;
			case matrix_type_t::PFASUM60:
				return PFASUM60;
			default:
				assert(0);
			}
			return PFASUM43;
		}

		static std::string toString(matrix_type_t v) {
			switch (v) {
			case matrix_type_t::MIQS:		return "MIQS";
			case matrix_type_t::PFASUM31:	return "PFASUM31";
			case matrix_type_t::PFASUM43:	return "PFASUM43";
			case matrix_type_t::PFASUM60:	return "PFASUM60";
			default:
				throw new std::runtime_error("Error: Illegal scoring matrix type.");
			}

			return "Unknown";
		}

		static matrix_type_t fromString(const std::string& name) {
			if (name == "MIQS" || name == "miqs") { return matrix_type_t::MIQS; }
			if (name == "PFASUM31" || name == "pfasum31") { return matrix_type_t::PFASUM31; }
			if (name == "PFASUM43" || name == "pfasum43") { return matrix_type_t::PFASUM43; }
			if (name == "PFASUM60" || name == "pfasum60") { return matrix_type_t::PFASUM60; }

			// something went wrong
			throw new std::runtime_error("Error: Illegal scoring matrix type.");

			return matrix_type_t::MIQS;
		}
};
#endif