"""
Integrated Tools for Gravity
============================
A library for handling data extracted from Einstein Toolkit and performing
gravity-related calculations, including black hole orbits, Psi4 data analysis, 
post-Newtonian (PN) and effective one-body (EOB) computations, and more.

Modules:
    - io: Input/output operations for various gravitational data formats.
    - analysis: Analytical tools for gravitational wave data.
    - calculations: Post-Newtonian, EOB, and other gravity-related computations.
    - visualization: Tools for visualizing data such as orbits and waveforms.
    - utils: Helper functions and utilities.
    
"""
