from __future__ import annotations
from dataclasses import dataclass, field
from kiota_abstractions.serialization import AdditionalDataHolder, Parsable, ParseNode, SerializationWriter
from kiota_abstractions.store import BackedModel, BackingStore, BackingStoreFactorySingleton
from typing import Any, Callable, Dict, List, Optional, TYPE_CHECKING, Union

if TYPE_CHECKING:
    from .defender_threat_action import DefenderThreatAction

@dataclass
class DefenderDetectedMalwareActions(AdditionalDataHolder, BackedModel, Parsable):
    """
    Specify Defender’s actions to take on detected Malware per threat level.
    """
    # Stores model information.
    backing_store: BackingStore = field(default_factory=BackingStoreFactorySingleton(backing_store_factory=None).backing_store_factory.create_backing_store, repr=False)

    # Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
    additional_data: Dict[str, Any] = field(default_factory=dict)
    # Defender’s default action to take on detected Malware threats.
    high_severity: Optional[DefenderThreatAction] = None
    # Defender’s default action to take on detected Malware threats.
    low_severity: Optional[DefenderThreatAction] = None
    # Defender’s default action to take on detected Malware threats.
    moderate_severity: Optional[DefenderThreatAction] = None
    # The OdataType property
    odata_type: Optional[str] = None
    # Defender’s default action to take on detected Malware threats.
    severe_severity: Optional[DefenderThreatAction] = None
    
    @staticmethod
    def create_from_discriminator_value(parse_node: ParseNode) -> DefenderDetectedMalwareActions:
        """
        Creates a new instance of the appropriate class based on discriminator value
        param parse_node: The parse node to use to read the discriminator value and create the object
        Returns: DefenderDetectedMalwareActions
        """
        if parse_node is None:
            raise TypeError("parse_node cannot be null.")
        return DefenderDetectedMalwareActions()
    
    def get_field_deserializers(self,) -> Dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: Dict[str, Callable[[ParseNode], None]]
        """
        from .defender_threat_action import DefenderThreatAction

        from .defender_threat_action import DefenderThreatAction

        fields: Dict[str, Callable[[Any], None]] = {
            "highSeverity": lambda n : setattr(self, 'high_severity', n.get_enum_value(DefenderThreatAction)),
            "lowSeverity": lambda n : setattr(self, 'low_severity', n.get_enum_value(DefenderThreatAction)),
            "moderateSeverity": lambda n : setattr(self, 'moderate_severity', n.get_enum_value(DefenderThreatAction)),
            "@odata.type": lambda n : setattr(self, 'odata_type', n.get_str_value()),
            "severeSeverity": lambda n : setattr(self, 'severe_severity', n.get_enum_value(DefenderThreatAction)),
        }
        return fields
    
    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        param writer: Serialization writer to use to serialize this model
        Returns: None
        """
        if writer is None:
            raise TypeError("writer cannot be null.")
        from .defender_threat_action import DefenderThreatAction

        writer.write_enum_value("highSeverity", self.high_severity)
        writer.write_enum_value("lowSeverity", self.low_severity)
        writer.write_enum_value("moderateSeverity", self.moderate_severity)
        writer.write_str_value("@odata.type", self.odata_type)
        writer.write_enum_value("severeSeverity", self.severe_severity)
        writer.write_additional_data_value(self.additional_data)
    

