from __future__ import annotations
import datetime
from dataclasses import dataclass, field
from kiota_abstractions.serialization import Parsable, ParseNode, SerializationWriter
from typing import Any, Callable, Dict, List, Optional, TYPE_CHECKING, Union

if TYPE_CHECKING:
    from .entity import Entity
    from .windows_malware_execution_state import WindowsMalwareExecutionState
    from .windows_malware_threat_state import WindowsMalwareThreatState

from .entity import Entity

@dataclass
class MalwareStateForWindowsDevice(Entity, Parsable):
    """
    Malware state for a windows device
    """
    # Indicates the number of times the malware is detected
    detection_count: Optional[int] = None
    # Indicates the name of the device being evaluated for malware state
    device_name: Optional[str] = None
    # Indicates execution status of the malware. Possible values are: unknown, blocked, allowed, running, notRunning. Defaults to unknown. Possible values are: unknown, blocked, allowed, running, notRunning.
    execution_state: Optional[WindowsMalwareExecutionState] = None
    # Initial detection datetime of the malware
    initial_detection_date_time: Optional[datetime.datetime] = None
    # The last time this particular threat was changed
    last_state_change_date_time: Optional[datetime.datetime] = None
    # The OdataType property
    odata_type: Optional[str] = None
    # Indicates threat status of the malware. Possible values are: active, actionFailed, manualStepsRequired, fullScanRequired, rebootRequired, remediatedWithNonCriticalFailures, quarantined, removed, cleaned, allowed, noStatusCleared. defaults to noStatusCleared. Possible values are: active, actionFailed, manualStepsRequired, fullScanRequired, rebootRequired, remediatedWithNonCriticalFailures, quarantined, removed, cleaned, allowed, noStatusCleared.
    threat_state: Optional[WindowsMalwareThreatState] = None
    
    @staticmethod
    def create_from_discriminator_value(parse_node: ParseNode) -> MalwareStateForWindowsDevice:
        """
        Creates a new instance of the appropriate class based on discriminator value
        param parse_node: The parse node to use to read the discriminator value and create the object
        Returns: MalwareStateForWindowsDevice
        """
        if parse_node is None:
            raise TypeError("parse_node cannot be null.")
        return MalwareStateForWindowsDevice()
    
    def get_field_deserializers(self,) -> Dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: Dict[str, Callable[[ParseNode], None]]
        """
        from .entity import Entity
        from .windows_malware_execution_state import WindowsMalwareExecutionState
        from .windows_malware_threat_state import WindowsMalwareThreatState

        from .entity import Entity
        from .windows_malware_execution_state import WindowsMalwareExecutionState
        from .windows_malware_threat_state import WindowsMalwareThreatState

        fields: Dict[str, Callable[[Any], None]] = {
            "detectionCount": lambda n : setattr(self, 'detection_count', n.get_int_value()),
            "deviceName": lambda n : setattr(self, 'device_name', n.get_str_value()),
            "executionState": lambda n : setattr(self, 'execution_state', n.get_enum_value(WindowsMalwareExecutionState)),
            "initialDetectionDateTime": lambda n : setattr(self, 'initial_detection_date_time', n.get_datetime_value()),
            "lastStateChangeDateTime": lambda n : setattr(self, 'last_state_change_date_time', n.get_datetime_value()),
            "threatState": lambda n : setattr(self, 'threat_state', n.get_enum_value(WindowsMalwareThreatState)),
        }
        super_fields = super().get_field_deserializers()
        fields.update(super_fields)
        return fields
    
    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        param writer: Serialization writer to use to serialize this model
        Returns: None
        """
        if writer is None:
            raise TypeError("writer cannot be null.")
        super().serialize(writer)
        from .entity import Entity
        from .windows_malware_execution_state import WindowsMalwareExecutionState
        from .windows_malware_threat_state import WindowsMalwareThreatState

        writer.write_int_value("detectionCount", self.detection_count)
        writer.write_str_value("deviceName", self.device_name)
        writer.write_enum_value("executionState", self.execution_state)
        writer.write_datetime_value("initialDetectionDateTime", self.initial_detection_date_time)
        writer.write_datetime_value("lastStateChangeDateTime", self.last_state_change_date_time)
        writer.write_enum_value("threatState", self.threat_state)
    

