from __future__ import annotations
from dataclasses import dataclass, field
from kiota_abstractions.serialization import Parsable, ParseNode, SerializationWriter
from typing import Any, Callable, Dict, List, Optional, TYPE_CHECKING, Union

if TYPE_CHECKING:
    from .entity import Entity
    from .extension_schema_property import ExtensionSchemaProperty

from .entity import Entity

@dataclass
class SchemaExtension(Entity, Parsable):
    # Description for the schema extension. Supports $filter (eq).
    description: Optional[str] = None
    # The OdataType property
    odata_type: Optional[str] = None
    # The appId of the application that is the owner of the schema extension. The owner of the schema definition must be explicitly specified during the Create and Update operations, or it will be implied and auto-assigned by Microsoft Entra ID as follows: In delegated access: The signed-in user must be the owner of the app that calls Microsoft Graph to create the schema extension definition.  If the signed-in user isn't the owner of the calling app, they must explicitly specify the owner property, and assign it the appId of an app that they own. In app-only access:  The owner property isn't required in the request body. Instead, the calling app is assigned ownership of the schema extension. So, for example, if creating a new schema extension definition using Graph Explorer, you must supply the owner property. Once set, this property is read-only and cannot be changed. Supports $filter (eq).
    owner: Optional[str] = None
    # The collection of property names and types that make up the schema extension definition.
    properties: Optional[List[ExtensionSchemaProperty]] = None
    # The lifecycle state of the schema extension. Possible states are InDevelopment, Available, and Deprecated. Automatically set to InDevelopment on creation. For more information about the possible state transitions and behaviors, see Schema extensions lifecycle. Supports $filter (eq).
    status: Optional[str] = None
    # Set of Microsoft Graph types (that can support extensions) that the schema extension can be applied to. Select from administrativeUnit, contact, device, event, group, message, organization, post, todoTask, todoTaskList, or user.
    target_types: Optional[List[str]] = None
    
    @staticmethod
    def create_from_discriminator_value(parse_node: ParseNode) -> SchemaExtension:
        """
        Creates a new instance of the appropriate class based on discriminator value
        param parse_node: The parse node to use to read the discriminator value and create the object
        Returns: SchemaExtension
        """
        if parse_node is None:
            raise TypeError("parse_node cannot be null.")
        return SchemaExtension()
    
    def get_field_deserializers(self,) -> Dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: Dict[str, Callable[[ParseNode], None]]
        """
        from .entity import Entity
        from .extension_schema_property import ExtensionSchemaProperty

        from .entity import Entity
        from .extension_schema_property import ExtensionSchemaProperty

        fields: Dict[str, Callable[[Any], None]] = {
            "description": lambda n : setattr(self, 'description', n.get_str_value()),
            "owner": lambda n : setattr(self, 'owner', n.get_str_value()),
            "properties": lambda n : setattr(self, 'properties', n.get_collection_of_object_values(ExtensionSchemaProperty)),
            "status": lambda n : setattr(self, 'status', n.get_str_value()),
            "targetTypes": lambda n : setattr(self, 'target_types', n.get_collection_of_primitive_values(str)),
        }
        super_fields = super().get_field_deserializers()
        fields.update(super_fields)
        return fields
    
    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        param writer: Serialization writer to use to serialize this model
        Returns: None
        """
        if writer is None:
            raise TypeError("writer cannot be null.")
        super().serialize(writer)
        from .entity import Entity
        from .extension_schema_property import ExtensionSchemaProperty

        writer.write_str_value("description", self.description)
        writer.write_str_value("owner", self.owner)
        writer.write_collection_of_object_values("properties", self.properties)
        writer.write_str_value("status", self.status)
        writer.write_collection_of_primitive_values("targetTypes", self.target_types)
    

