from __future__ import annotations
from dataclasses import dataclass, field
from kiota_abstractions.serialization import Parsable, ParseNode, SerializationWriter
from typing import Any, Callable, Dict, List, Optional, TYPE_CHECKING, Union

if TYPE_CHECKING:
    from .alert_evidence import AlertEvidence

from .alert_evidence import AlertEvidence

@dataclass
class MailClusterEvidence(AlertEvidence, Parsable):
    # The OdataType property
    odata_type: Optional[str] = "#microsoft.graph.security.mailClusterEvidence"
    # The clustering logic of the emails inside the cluster.
    cluster_by: Optional[str] = None
    # The value utilized to cluster the similar emails.
    cluster_by_value: Optional[str] = None
    # Count of emails in the email cluster.
    email_count: Optional[int] = None
    # Unique identifiers for the emails in the cluster, generated by Microsoft 365.
    network_message_ids: Optional[List[str]] = None
    # The query used to identify the email cluster.
    query: Optional[str] = None
    # Uniform resource name (URN) of the automated investigation where the cluster was identified.
    urn: Optional[str] = None
    
    @staticmethod
    def create_from_discriminator_value(parse_node: ParseNode) -> MailClusterEvidence:
        """
        Creates a new instance of the appropriate class based on discriminator value
        param parse_node: The parse node to use to read the discriminator value and create the object
        Returns: MailClusterEvidence
        """
        if parse_node is None:
            raise TypeError("parse_node cannot be null.")
        return MailClusterEvidence()
    
    def get_field_deserializers(self,) -> Dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: Dict[str, Callable[[ParseNode], None]]
        """
        from .alert_evidence import AlertEvidence

        from .alert_evidence import AlertEvidence

        fields: Dict[str, Callable[[Any], None]] = {
            "clusterBy": lambda n : setattr(self, 'cluster_by', n.get_str_value()),
            "clusterByValue": lambda n : setattr(self, 'cluster_by_value', n.get_str_value()),
            "emailCount": lambda n : setattr(self, 'email_count', n.get_int_value()),
            "networkMessageIds": lambda n : setattr(self, 'network_message_ids', n.get_collection_of_primitive_values(str)),
            "query": lambda n : setattr(self, 'query', n.get_str_value()),
            "urn": lambda n : setattr(self, 'urn', n.get_str_value()),
        }
        super_fields = super().get_field_deserializers()
        fields.update(super_fields)
        return fields
    
    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        param writer: Serialization writer to use to serialize this model
        Returns: None
        """
        if writer is None:
            raise TypeError("writer cannot be null.")
        super().serialize(writer)
        from .alert_evidence import AlertEvidence

        writer.write_str_value("clusterBy", self.cluster_by)
        writer.write_str_value("clusterByValue", self.cluster_by_value)
        writer.write_int_value("emailCount", self.email_count)
        writer.write_collection_of_primitive_values("networkMessageIds", self.network_message_ids)
        writer.write_str_value("query", self.query)
        writer.write_str_value("urn", self.urn)
    

