from __future__ import annotations
import datetime
from dataclasses import dataclass, field
from kiota_abstractions.serialization import Parsable, ParseNode, SerializationWriter
from typing import Any, Callable, Dict, List, Optional, TYPE_CHECKING, Union

if TYPE_CHECKING:
    from ..entity import Entity
    from .article import Article
    from .cvss_summary import CvssSummary
    from .formatted_content import FormattedContent
    from .hyperlink import Hyperlink
    from .vulnerability_component import VulnerabilityComponent
    from .vulnerability_severity import VulnerabilitySeverity

from ..entity import Entity

@dataclass
class Vulnerability(Entity, Parsable):
    # Indicates whether this vulnerability has any known exploits associated to known bad actors.
    active_exploits_observed: Optional[bool] = None
    # Articles related to this vulnerability.
    articles: Optional[List[Article]] = None
    # Community-defined common weakness enumerations (CWE).
    common_weakness_enumeration_ids: Optional[List[str]] = None
    # Components related to this vulnerability article.
    components: Optional[List[VulnerabilityComponent]] = None
    # The date and time when this vulnerability article was first created.
    created_date_time: Optional[datetime.datetime] = None
    # The cvss2Summary property
    cvss2_summary: Optional[CvssSummary] = None
    # The cvss3Summary property
    cvss3_summary: Optional[CvssSummary] = None
    # The description property
    description: Optional[FormattedContent] = None
    # Known exploits for this vulnerability.
    exploits: Optional[List[Hyperlink]] = None
    # Indicates whether this vulnerability has exploits in public sources (such as Packetstorm or Exploit-DB) online.
    exploits_available: Optional[bool] = None
    # Indicates whether chatter about this vulnerability has been discovered online.
    has_chatter: Optional[bool] = None
    # The date and time when this vulnerability article was most recently updated.
    last_modified_date_time: Optional[datetime.datetime] = None
    # The OdataType property
    odata_type: Optional[str] = None
    # A unique algorithm that reflects the priority of a vulnerability based on the CVSS score, exploits, chatter, and linkage to malware. This property also evaluates the recency of these components so users can understand which vulnerability should be remediated first.
    priority_score: Optional[int] = None
    # The date and time when this vulnerability article was published.
    published_date_time: Optional[datetime.datetime] = None
    # Reference links where further information can be learned about this vulnerability.
    references: Optional[List[Hyperlink]] = None
    # Any known remediation steps.
    remediation: Optional[FormattedContent] = None
    # The severity property
    severity: Optional[VulnerabilitySeverity] = None
    
    @staticmethod
    def create_from_discriminator_value(parse_node: ParseNode) -> Vulnerability:
        """
        Creates a new instance of the appropriate class based on discriminator value
        param parse_node: The parse node to use to read the discriminator value and create the object
        Returns: Vulnerability
        """
        if parse_node is None:
            raise TypeError("parse_node cannot be null.")
        return Vulnerability()
    
    def get_field_deserializers(self,) -> Dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: Dict[str, Callable[[ParseNode], None]]
        """
        from ..entity import Entity
        from .article import Article
        from .cvss_summary import CvssSummary
        from .formatted_content import FormattedContent
        from .hyperlink import Hyperlink
        from .vulnerability_component import VulnerabilityComponent
        from .vulnerability_severity import VulnerabilitySeverity

        from ..entity import Entity
        from .article import Article
        from .cvss_summary import CvssSummary
        from .formatted_content import FormattedContent
        from .hyperlink import Hyperlink
        from .vulnerability_component import VulnerabilityComponent
        from .vulnerability_severity import VulnerabilitySeverity

        fields: Dict[str, Callable[[Any], None]] = {
            "activeExploitsObserved": lambda n : setattr(self, 'active_exploits_observed', n.get_bool_value()),
            "articles": lambda n : setattr(self, 'articles', n.get_collection_of_object_values(Article)),
            "commonWeaknessEnumerationIds": lambda n : setattr(self, 'common_weakness_enumeration_ids', n.get_collection_of_primitive_values(str)),
            "components": lambda n : setattr(self, 'components', n.get_collection_of_object_values(VulnerabilityComponent)),
            "createdDateTime": lambda n : setattr(self, 'created_date_time', n.get_datetime_value()),
            "cvss2Summary": lambda n : setattr(self, 'cvss2_summary', n.get_object_value(CvssSummary)),
            "cvss3Summary": lambda n : setattr(self, 'cvss3_summary', n.get_object_value(CvssSummary)),
            "description": lambda n : setattr(self, 'description', n.get_object_value(FormattedContent)),
            "exploits": lambda n : setattr(self, 'exploits', n.get_collection_of_object_values(Hyperlink)),
            "exploitsAvailable": lambda n : setattr(self, 'exploits_available', n.get_bool_value()),
            "hasChatter": lambda n : setattr(self, 'has_chatter', n.get_bool_value()),
            "lastModifiedDateTime": lambda n : setattr(self, 'last_modified_date_time', n.get_datetime_value()),
            "priorityScore": lambda n : setattr(self, 'priority_score', n.get_int_value()),
            "publishedDateTime": lambda n : setattr(self, 'published_date_time', n.get_datetime_value()),
            "references": lambda n : setattr(self, 'references', n.get_collection_of_object_values(Hyperlink)),
            "remediation": lambda n : setattr(self, 'remediation', n.get_object_value(FormattedContent)),
            "severity": lambda n : setattr(self, 'severity', n.get_enum_value(VulnerabilitySeverity)),
        }
        super_fields = super().get_field_deserializers()
        fields.update(super_fields)
        return fields
    
    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        param writer: Serialization writer to use to serialize this model
        Returns: None
        """
        if writer is None:
            raise TypeError("writer cannot be null.")
        super().serialize(writer)
        from ..entity import Entity
        from .article import Article
        from .cvss_summary import CvssSummary
        from .formatted_content import FormattedContent
        from .hyperlink import Hyperlink
        from .vulnerability_component import VulnerabilityComponent
        from .vulnerability_severity import VulnerabilitySeverity

        writer.write_bool_value("activeExploitsObserved", self.active_exploits_observed)
        writer.write_collection_of_object_values("articles", self.articles)
        writer.write_collection_of_primitive_values("commonWeaknessEnumerationIds", self.common_weakness_enumeration_ids)
        writer.write_collection_of_object_values("components", self.components)
        writer.write_datetime_value("createdDateTime", self.created_date_time)
        writer.write_object_value("cvss2Summary", self.cvss2_summary)
        writer.write_object_value("cvss3Summary", self.cvss3_summary)
        writer.write_object_value("description", self.description)
        writer.write_collection_of_object_values("exploits", self.exploits)
        writer.write_bool_value("exploitsAvailable", self.exploits_available)
        writer.write_bool_value("hasChatter", self.has_chatter)
        writer.write_datetime_value("lastModifiedDateTime", self.last_modified_date_time)
        writer.write_int_value("priorityScore", self.priority_score)
        writer.write_datetime_value("publishedDateTime", self.published_date_time)
        writer.write_collection_of_object_values("references", self.references)
        writer.write_object_value("remediation", self.remediation)
        writer.write_enum_value("severity", self.severity)
    

