from __future__ import annotations
from dataclasses import dataclass, field
from kiota_abstractions.serialization import Parsable, ParseNode, SerializationWriter
from typing import Any, Callable, Dict, List, Optional, TYPE_CHECKING, Union

if TYPE_CHECKING:
    from .whois_base_record import WhoisBaseRecord
    from .whois_history_record import WhoisHistoryRecord

from .whois_base_record import WhoisBaseRecord

@dataclass
class WhoisRecord(WhoisBaseRecord, Parsable):
    # The OdataType property
    odata_type: Optional[str] = "#microsoft.graph.security.whoisRecord"
    # The collection of historical records associated to this WHOIS object.
    history: Optional[List[WhoisHistoryRecord]] = None
    
    @staticmethod
    def create_from_discriminator_value(parse_node: ParseNode) -> WhoisRecord:
        """
        Creates a new instance of the appropriate class based on discriminator value
        param parse_node: The parse node to use to read the discriminator value and create the object
        Returns: WhoisRecord
        """
        if parse_node is None:
            raise TypeError("parse_node cannot be null.")
        return WhoisRecord()
    
    def get_field_deserializers(self,) -> Dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: Dict[str, Callable[[ParseNode], None]]
        """
        from .whois_base_record import WhoisBaseRecord
        from .whois_history_record import WhoisHistoryRecord

        from .whois_base_record import WhoisBaseRecord
        from .whois_history_record import WhoisHistoryRecord

        fields: Dict[str, Callable[[Any], None]] = {
            "history": lambda n : setattr(self, 'history', n.get_collection_of_object_values(WhoisHistoryRecord)),
        }
        super_fields = super().get_field_deserializers()
        fields.update(super_fields)
        return fields
    
    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        param writer: Serialization writer to use to serialize this model
        Returns: None
        """
        if writer is None:
            raise TypeError("writer cannot be null.")
        super().serialize(writer)
        from .whois_base_record import WhoisBaseRecord
        from .whois_history_record import WhoisHistoryRecord

        writer.write_collection_of_object_values("history", self.history)
    

