from __future__ import annotations
import datetime
from dataclasses import dataclass, field
from kiota_abstractions.serialization import Parsable, ParseNode, SerializationWriter
from typing import Any, Callable, Dict, List, Optional, TYPE_CHECKING, Union

if TYPE_CHECKING:
    from .entity import Entity
    from .windows_malware_category import WindowsMalwareCategory
    from .windows_malware_execution_state import WindowsMalwareExecutionState
    from .windows_malware_severity import WindowsMalwareSeverity
    from .windows_malware_state import WindowsMalwareState
    from .windows_malware_threat_state import WindowsMalwareThreatState

from .entity import Entity

@dataclass
class WindowsDeviceMalwareState(Entity, Parsable):
    """
    Malware detection entity.
    """
    # Information URL to learn more about the malware
    additional_information_url: Optional[str] = None
    # Category of the malware. Possible values are: invalid, adware, spyware, passwordStealer, trojanDownloader, worm, backdoor, remoteAccessTrojan, trojan, emailFlooder, keylogger, dialer, monitoringSoftware, browserModifier, cookie, browserPlugin, aolExploit, nuker, securityDisabler, jokeProgram, hostileActiveXControl, softwareBundler, stealthNotifier, settingsModifier, toolBar, remoteControlSoftware, trojanFtp, potentialUnwantedSoftware, icqExploit, trojanTelnet, exploit, filesharingProgram, malwareCreationTool, remoteControlSoftware, tool, trojanDenialOfService, trojanDropper, trojanMassMailer, trojanMonitoringSoftware, trojanProxyServer, virus, known, unknown, spp, behavior, vulnerability, policy, enterpriseUnwantedSoftware, ransom, hipsRule.
    category: Optional[WindowsMalwareCategory] = None
    # Number of times the malware is detected
    detection_count: Optional[int] = None
    # Malware name
    display_name: Optional[str] = None
    # Execution status of the malware like blocked/executing etc. Possible values are: unknown, blocked, allowed, running, notRunning.
    execution_state: Optional[WindowsMalwareExecutionState] = None
    # Initial detection datetime of the malware
    initial_detection_date_time: Optional[datetime.datetime] = None
    # The last time this particular threat was changed
    last_state_change_date_time: Optional[datetime.datetime] = None
    # The OdataType property
    odata_type: Optional[str] = None
    # Severity of the malware. Possible values are: unknown, low, moderate, high, severe.
    severity: Optional[WindowsMalwareSeverity] = None
    # Current status of the malware like cleaned/quarantined/allowed etc. Possible values are: unknown, detected, cleaned, quarantined, removed, allowed, blocked, cleanFailed, quarantineFailed, removeFailed, allowFailed, abandoned, blockFailed.
    state: Optional[WindowsMalwareState] = None
    # Current status of the malware like cleaned/quarantined/allowed etc. Possible values are: active, actionFailed, manualStepsRequired, fullScanRequired, rebootRequired, remediatedWithNonCriticalFailures, quarantined, removed, cleaned, allowed, noStatusCleared.
    threat_state: Optional[WindowsMalwareThreatState] = None
    
    @staticmethod
    def create_from_discriminator_value(parse_node: ParseNode) -> WindowsDeviceMalwareState:
        """
        Creates a new instance of the appropriate class based on discriminator value
        param parse_node: The parse node to use to read the discriminator value and create the object
        Returns: WindowsDeviceMalwareState
        """
        if parse_node is None:
            raise TypeError("parse_node cannot be null.")
        return WindowsDeviceMalwareState()
    
    def get_field_deserializers(self,) -> Dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: Dict[str, Callable[[ParseNode], None]]
        """
        from .entity import Entity
        from .windows_malware_category import WindowsMalwareCategory
        from .windows_malware_execution_state import WindowsMalwareExecutionState
        from .windows_malware_severity import WindowsMalwareSeverity
        from .windows_malware_state import WindowsMalwareState
        from .windows_malware_threat_state import WindowsMalwareThreatState

        from .entity import Entity
        from .windows_malware_category import WindowsMalwareCategory
        from .windows_malware_execution_state import WindowsMalwareExecutionState
        from .windows_malware_severity import WindowsMalwareSeverity
        from .windows_malware_state import WindowsMalwareState
        from .windows_malware_threat_state import WindowsMalwareThreatState

        fields: Dict[str, Callable[[Any], None]] = {
            "additionalInformationUrl": lambda n : setattr(self, 'additional_information_url', n.get_str_value()),
            "category": lambda n : setattr(self, 'category', n.get_enum_value(WindowsMalwareCategory)),
            "detectionCount": lambda n : setattr(self, 'detection_count', n.get_int_value()),
            "displayName": lambda n : setattr(self, 'display_name', n.get_str_value()),
            "executionState": lambda n : setattr(self, 'execution_state', n.get_enum_value(WindowsMalwareExecutionState)),
            "initialDetectionDateTime": lambda n : setattr(self, 'initial_detection_date_time', n.get_datetime_value()),
            "lastStateChangeDateTime": lambda n : setattr(self, 'last_state_change_date_time', n.get_datetime_value()),
            "severity": lambda n : setattr(self, 'severity', n.get_enum_value(WindowsMalwareSeverity)),
            "state": lambda n : setattr(self, 'state', n.get_enum_value(WindowsMalwareState)),
            "threatState": lambda n : setattr(self, 'threat_state', n.get_enum_value(WindowsMalwareThreatState)),
        }
        super_fields = super().get_field_deserializers()
        fields.update(super_fields)
        return fields
    
    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        param writer: Serialization writer to use to serialize this model
        Returns: None
        """
        if writer is None:
            raise TypeError("writer cannot be null.")
        super().serialize(writer)
        from .entity import Entity
        from .windows_malware_category import WindowsMalwareCategory
        from .windows_malware_execution_state import WindowsMalwareExecutionState
        from .windows_malware_severity import WindowsMalwareSeverity
        from .windows_malware_state import WindowsMalwareState
        from .windows_malware_threat_state import WindowsMalwareThreatState

        writer.write_str_value("additionalInformationUrl", self.additional_information_url)
        writer.write_enum_value("category", self.category)
        writer.write_int_value("detectionCount", self.detection_count)
        writer.write_str_value("displayName", self.display_name)
        writer.write_enum_value("executionState", self.execution_state)
        writer.write_datetime_value("initialDetectionDateTime", self.initial_detection_date_time)
        writer.write_datetime_value("lastStateChangeDateTime", self.last_state_change_date_time)
        writer.write_enum_value("severity", self.severity)
        writer.write_enum_value("state", self.state)
        writer.write_enum_value("threatState", self.threat_state)
    

