from __future__ import annotations
import datetime
from dataclasses import dataclass, field
from kiota_abstractions.serialization import AdditionalDataHolder, Parsable, ParseNode, SerializationWriter
from kiota_abstractions.store import BackedModel, BackingStore, BackingStoreFactorySingleton
from typing import Any, Callable, Dict, List, Optional, TYPE_CHECKING, Union

if TYPE_CHECKING:
    from .windows_malware_category import WindowsMalwareCategory

@dataclass
class WindowsMalwareCategoryCount(AdditionalDataHolder, BackedModel, Parsable):
    """
    Malware category device count
    """
    # Stores model information.
    backing_store: BackingStore = field(default_factory=BackingStoreFactorySingleton(backing_store_factory=None).backing_store_factory.create_backing_store, repr=False)

    # Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
    additional_data: Dict[str, Any] = field(default_factory=dict)
    # Count of active malware detections for this malware category. Valid values -2147483648 to 2147483647
    active_malware_detection_count: Optional[int] = None
    # Malware category id
    category: Optional[WindowsMalwareCategory] = None
    # Count of devices with malware detections for this malware category
    device_count: Optional[int] = None
    # Count of distinct active malwares for this malware category. Valid values -2147483648 to 2147483647
    distinct_active_malware_count: Optional[int] = None
    # The Timestamp of the last update for the device count in UTC
    last_update_date_time: Optional[datetime.datetime] = None
    # The OdataType property
    odata_type: Optional[str] = None
    
    @staticmethod
    def create_from_discriminator_value(parse_node: ParseNode) -> WindowsMalwareCategoryCount:
        """
        Creates a new instance of the appropriate class based on discriminator value
        param parse_node: The parse node to use to read the discriminator value and create the object
        Returns: WindowsMalwareCategoryCount
        """
        if parse_node is None:
            raise TypeError("parse_node cannot be null.")
        return WindowsMalwareCategoryCount()
    
    def get_field_deserializers(self,) -> Dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: Dict[str, Callable[[ParseNode], None]]
        """
        from .windows_malware_category import WindowsMalwareCategory

        from .windows_malware_category import WindowsMalwareCategory

        fields: Dict[str, Callable[[Any], None]] = {
            "activeMalwareDetectionCount": lambda n : setattr(self, 'active_malware_detection_count', n.get_int_value()),
            "category": lambda n : setattr(self, 'category', n.get_enum_value(WindowsMalwareCategory)),
            "deviceCount": lambda n : setattr(self, 'device_count', n.get_int_value()),
            "distinctActiveMalwareCount": lambda n : setattr(self, 'distinct_active_malware_count', n.get_int_value()),
            "lastUpdateDateTime": lambda n : setattr(self, 'last_update_date_time', n.get_datetime_value()),
            "@odata.type": lambda n : setattr(self, 'odata_type', n.get_str_value()),
        }
        return fields
    
    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        param writer: Serialization writer to use to serialize this model
        Returns: None
        """
        if writer is None:
            raise TypeError("writer cannot be null.")
        from .windows_malware_category import WindowsMalwareCategory

        writer.write_int_value("activeMalwareDetectionCount", self.active_malware_detection_count)
        writer.write_enum_value("category", self.category)
        writer.write_int_value("deviceCount", self.device_count)
        writer.write_int_value("distinctActiveMalwareCount", self.distinct_active_malware_count)
        writer.write_datetime_value("lastUpdateDateTime", self.last_update_date_time)
        writer.write_str_value("@odata.type", self.odata_type)
        writer.write_additional_data_value(self.additional_data)
    

