from __future__ import annotations
from dataclasses import dataclass, field
from kiota_abstractions.serialization import AdditionalDataHolder, Parsable, ParseNode, SerializationWriter
from kiota_abstractions.store import BackedModel, BackingStore, BackingStoreFactorySingleton
from typing import Any, Callable, Dict, List, Optional, TYPE_CHECKING, Union

if TYPE_CHECKING:
    from .os_version_count import OsVersionCount
    from .windows_malware_category_count import WindowsMalwareCategoryCount
    from .windows_malware_execution_state_count import WindowsMalwareExecutionStateCount
    from .windows_malware_name_count import WindowsMalwareNameCount
    from .windows_malware_severity_count import WindowsMalwareSeverityCount
    from .windows_malware_state_count import WindowsMalwareStateCount

@dataclass
class WindowsMalwareOverview(AdditionalDataHolder, BackedModel, Parsable):
    """
    Windows device malware overview.
    """
    # Stores model information.
    backing_store: BackingStore = field(default_factory=BackingStoreFactorySingleton(backing_store_factory=None).backing_store_factory.create_backing_store, repr=False)

    # Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
    additional_data: Dict[str, Any] = field(default_factory=dict)
    # List of device counts per malware category
    malware_category_summary: Optional[List[WindowsMalwareCategoryCount]] = None
    # Count of devices with malware detected in the last 30 days
    malware_detected_device_count: Optional[int] = None
    # List of device counts per malware execution state
    malware_execution_state_summary: Optional[List[WindowsMalwareExecutionStateCount]] = None
    # List of device counts per malware
    malware_name_summary: Optional[List[WindowsMalwareNameCount]] = None
    # List of active malware counts per malware severity
    malware_severity_summary: Optional[List[WindowsMalwareSeverityCount]] = None
    # List of device counts per malware state
    malware_state_summary: Optional[List[WindowsMalwareStateCount]] = None
    # The OdataType property
    odata_type: Optional[str] = None
    # List of device counts with malware per windows OS version
    os_versions_summary: Optional[List[OsVersionCount]] = None
    # Count of all distinct malwares detected across all devices. Valid values -2147483648 to 2147483647
    total_distinct_malware_count: Optional[int] = None
    # Count of all malware detections across all devices. Valid values -2147483648 to 2147483647
    total_malware_count: Optional[int] = None
    
    @staticmethod
    def create_from_discriminator_value(parse_node: ParseNode) -> WindowsMalwareOverview:
        """
        Creates a new instance of the appropriate class based on discriminator value
        param parse_node: The parse node to use to read the discriminator value and create the object
        Returns: WindowsMalwareOverview
        """
        if parse_node is None:
            raise TypeError("parse_node cannot be null.")
        return WindowsMalwareOverview()
    
    def get_field_deserializers(self,) -> Dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: Dict[str, Callable[[ParseNode], None]]
        """
        from .os_version_count import OsVersionCount
        from .windows_malware_category_count import WindowsMalwareCategoryCount
        from .windows_malware_execution_state_count import WindowsMalwareExecutionStateCount
        from .windows_malware_name_count import WindowsMalwareNameCount
        from .windows_malware_severity_count import WindowsMalwareSeverityCount
        from .windows_malware_state_count import WindowsMalwareStateCount

        from .os_version_count import OsVersionCount
        from .windows_malware_category_count import WindowsMalwareCategoryCount
        from .windows_malware_execution_state_count import WindowsMalwareExecutionStateCount
        from .windows_malware_name_count import WindowsMalwareNameCount
        from .windows_malware_severity_count import WindowsMalwareSeverityCount
        from .windows_malware_state_count import WindowsMalwareStateCount

        fields: Dict[str, Callable[[Any], None]] = {
            "malwareCategorySummary": lambda n : setattr(self, 'malware_category_summary', n.get_collection_of_object_values(WindowsMalwareCategoryCount)),
            "malwareDetectedDeviceCount": lambda n : setattr(self, 'malware_detected_device_count', n.get_int_value()),
            "malwareExecutionStateSummary": lambda n : setattr(self, 'malware_execution_state_summary', n.get_collection_of_object_values(WindowsMalwareExecutionStateCount)),
            "malwareNameSummary": lambda n : setattr(self, 'malware_name_summary', n.get_collection_of_object_values(WindowsMalwareNameCount)),
            "malwareSeveritySummary": lambda n : setattr(self, 'malware_severity_summary', n.get_collection_of_object_values(WindowsMalwareSeverityCount)),
            "malwareStateSummary": lambda n : setattr(self, 'malware_state_summary', n.get_collection_of_object_values(WindowsMalwareStateCount)),
            "@odata.type": lambda n : setattr(self, 'odata_type', n.get_str_value()),
            "osVersionsSummary": lambda n : setattr(self, 'os_versions_summary', n.get_collection_of_object_values(OsVersionCount)),
            "totalDistinctMalwareCount": lambda n : setattr(self, 'total_distinct_malware_count', n.get_int_value()),
            "totalMalwareCount": lambda n : setattr(self, 'total_malware_count', n.get_int_value()),
        }
        return fields
    
    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        param writer: Serialization writer to use to serialize this model
        Returns: None
        """
        if writer is None:
            raise TypeError("writer cannot be null.")
        from .os_version_count import OsVersionCount
        from .windows_malware_category_count import WindowsMalwareCategoryCount
        from .windows_malware_execution_state_count import WindowsMalwareExecutionStateCount
        from .windows_malware_name_count import WindowsMalwareNameCount
        from .windows_malware_severity_count import WindowsMalwareSeverityCount
        from .windows_malware_state_count import WindowsMalwareStateCount

        writer.write_collection_of_object_values("malwareCategorySummary", self.malware_category_summary)
        writer.write_int_value("malwareDetectedDeviceCount", self.malware_detected_device_count)
        writer.write_collection_of_object_values("malwareExecutionStateSummary", self.malware_execution_state_summary)
        writer.write_collection_of_object_values("malwareNameSummary", self.malware_name_summary)
        writer.write_collection_of_object_values("malwareSeveritySummary", self.malware_severity_summary)
        writer.write_collection_of_object_values("malwareStateSummary", self.malware_state_summary)
        writer.write_str_value("@odata.type", self.odata_type)
        writer.write_collection_of_object_values("osVersionsSummary", self.os_versions_summary)
        writer.write_int_value("totalDistinctMalwareCount", self.total_distinct_malware_count)
        writer.write_int_value("totalMalwareCount", self.total_malware_count)
        writer.write_additional_data_value(self.additional_data)
    

