<img alt="Shows the CASM logo" src="https://raw.githubusercontent.com/prisms-center/CASMcode_global/main/python/doc/_static/logo.svg" width="600" />

#### libcasm-mapping

The libcasm-mapping package is the CASM structure mapping module. This includes:

- Methods for searching for low-cost lattice, atom, and structure mappings, taking into account symmetry, based on the approach described in the paper [*Thomas, Natarajan, and Van der Ven, npj Computational Materials, **7** (2021), 164*](https://doi.org/10.1038/s41524-021-00627-0).
- Methods for generating interpolated structures based on mapping results
- Methods for generating symmetrically equivalent mappings
- Data structures and methods for creating custom mapping searches


#### Install

    pip install libcasm-mapping


#### Usage

See the [libcasm docs](https://prisms-center.github.io/CASMcode_pydocs/libcasm/overview/latest/).


#### About CASM

The libcasm-mapping package is part of the [CASM](https://github.com/prisms-center/CASMcode) open source software package, which is designed to perform first-principles statistical mechanical studies of multi-component crystalline solids.

CASM is developed by the Van der Ven group, originally at the University of Michigan and currently at the University of California Santa Barbara.

For more information, see the [CASM homepage](https://prisms-center.github.io/CASMcode_docs/).


#### License

GNU Lesser General Public License (LGPL). Please see the file LICENSE for details.


#### For Contributors

See the [CASM contribution guide](https://github.com/prisms-center/CASMcode_global/blob/main/CONTRIBUTE.md)
