"""Base classes for automatically generated WeMo service types.

These classes do nothing at run-time.

mypy, however, uses the wemo_services.pyi stub typing file to find basic type
information for the services and actions supported by WeMo devices. This type
information is generated by scripts/generate_wemo_service.py.
"""


class WeMoServiceTypesMixin:  # pylint: disable=too-few-public-methods
    """Mixin for the Device base class.

    Provides type information for the service properties that are dynamically
    set at run-time via `setattr(self, service_name, Service(...))`.
    """


class WeMoAllActionsMixin:  # pylint: disable=too-few-public-methods
    """Mixin for the Service base class.

    Provides type information for every known service action method. These
    methods are set as properties of the Service instance at run-time via
    `setattr(self, action_name, Action(...))`.
    """
