"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Project2 = exports.Project2Property = void 0;
const ros = require("@alicloud/ros-cdk-core");
const imm_generated_1 = require("./imm.generated");
Object.defineProperty(exports, "Project2Property", { enumerable: true, get: function () { return imm_generated_1.RosProject2; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::IMM::Project2`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosProject2`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-imm-project2
 */
class Project2 extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosProject2 = new imm_generated_1.RosProject2(this, id, {
            description: props.description,
            serviceRole: props.serviceRole,
            projectName: props.projectName,
            datasetMaxBindCount: props.datasetMaxBindCount,
            datasetMaxEntityCount: props.datasetMaxEntityCount,
            projectMaxDatasetCount: props.projectMaxDatasetCount,
            datasetMaxTotalFileSize: props.datasetMaxTotalFileSize,
            datasetMaxRelationCount: props.datasetMaxRelationCount,
            datasetMaxFileCount: props.datasetMaxFileCount,
            templateId: props.templateId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosProject2;
        this.attrProjectName = rosProject2.attrProjectName;
    }
}
exports.Project2 = Project2;
//# sourceMappingURL=data:application/json;base64,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