"""
CivilPy
Copyright (C) 2019 - Dane Parks

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

"""
This module contains the definitions for various tables used in the civilpy.structural modules. There are no functions
or classes defined within this file.
"""

A325_bolt_weights = {
    1: {
        0.5: 16.5,
        0.625: 29.4,
        0.75: 47.0,
        0.875: "DNE",
        1: "DNE",
        1.125: "DNE",
        1.25: "DNE",
        1.375: "DNE",
        1.5: "DNE",
    },
    1.25: {
        0.5: 17.8,
        0.625: 31.3,
        0.75: 49.6,
        0.875: 74.4,
        1: 104,
        1.125: "DNE",
        1.25: "DNE",
        1.375: "DNE",
        1.5: "DNE",
    },
    1.5: {
        0.5: 19.2,
        0.625: 33.1,
        0.75: 52.2,
        0.875: 78,
        1: 109,
        1.125: 148,
        1.25: 197,
        1.375: "DNE",
        1.5: "DNE",
    },
    1.75: {
        0.5: 20.5,
        0.625: 35.3,
        0.75: 55.3,
        0.875: 81.9,
        1: 114,
        1.125: 154,
        1.25: 205,
        1.375: 261,
        1.5: 333,
    },
    2: {
        0.5: 21.9,
        0.625: 37.4,
        0.75: 58.4,
        0.875: 86.1,
        1: 119,
        1.125: 160,
        1.25: 212,
        1.375: 270,
        1.5: 344,
    },
    2.25: {
        0.5: 23.3,
        0.625: 39.8,
        0.75: 61.6,
        0.875: 90.3,
        1: 124,
        1.125: 167,
        1.25: 220,
        1.375: 279,
        1.5: 355,
    },
    2.5: {
        0.5: 24.7,
        0.625: 41.7,
        0.75: 64.7,
        0.875: 94.6,
        1: 130,
        1.125: 174,
        1.25: 229,
        1.375: 290,
        1.5: 366,
    },
    2.75: {
        0.5: 26.1,
        0.625: 43.9,
        0.75: 67.8,
        0.875: 98.8,
        1.0: 135,
        1.125: 181,
        1.25: 237,
        1.375: 300,
        1.5: 379,
    },
    3.00: {
        0.5: 27.4,
        0.625: 46.1,
        0.75: 70.9,
        0.875: 103,
        1.0: 141,
        1.125: 188,
        1.25: 246,
        1.375: 310,
        1.5: 391,
    },
    3.25: {
        0.5: 28.8,
        0.625: 48.2,
        0.75: 74,
        0.875: 107,
        1.0: 146,
        1.125: 195,
        1.25: 255,
        1.375: 321,
        1.5: 403,
    },
    3.50: {
        0.5: 30.2,
        0.625: 50.4,
        0.75: 77.1,
        0.875: 111,
        1.0: 151,
        1.125: 202,
        1.25: 263,
        1.375: 332,
        1.5: 416,
    },
    3.75: {
        0.5: 31.6,
        0.625: 52.5,
        0.75: 80.2,
        0.875: 116,
        1.0: 157,
        1.125: 209,
        1.25: 272,
        1.375: 342,
        1.5: 428,
    },
    4.00: {
        0.5: 33,
        0.625: 54.7,
        0.75: 83.3,
        0.875: 120,
        1.0: 162,
        1.125: 216,
        1.25: 280,
        1.375: 353,
        1.5: 441,
    },
    4.25: {
        0.5: 34.3,
        0.625: 56.9,
        0.75: 86.4,
        0.875: 124,
        1.0: 168,
        1.125: 223,
        1.25: 289,
        1.375: 363,
        1.5: 453,
    },
    4.50: {
        0.5: 35.7,
        0.625: 59,
        0.75: 89.5,
        0.875: 128,
        1.0: 173,
        1.125: 230,
        1.25: 298,
        1.375: 374,
        1.5: 465,
    },
    4.75: {
        0.5: 37.1,
        0.625: 61.2,
        0.75: 92.7,
        0.875: 133,
        1.0: 179,
        1.125: 237,
        1.25: 306,
        1.375: 384,
        1.5: 478,
    },
    5.00: {
        0.5: 38.5,
        0.625: 63.3,
        0.75: 95.8,
        0.875: 137,
        1.0: 184,
        1.125: 244,
        1.25: 315,
        1.375: 395,
        1.5: 490,
    },
    5.25: {
        0.5: 39.9,
        0.625: 65.5,
        0.75: 98.9,
        0.875: 141,
        1.0: 190,
        1.125: 251,
        1.25: 324,
        1.375: 405,
        1.5: 503,
    },
    5.50: {
        0.5: 41.2,
        0.625: 67.7,
        0.75: 102,
        0.875: 146,
        1.0: 196,
        1.125: 258,
        1.25: 332,
        1.375: 416,
        1.5: 515,
    },
    5.75: {
        0.5: 42.6,
        0.625: 69.8,
        0.75: 105,
        0.875: 150,
        1.0: 201,
        1.125: 265,
        1.25: 341,
        1.375: 426,
        1.5: 527,
    },
    6.00: {
        0.5: 44,
        0.625: 71.9,
        0.75: 108,
        0.875: 154,
        1.0: 207,
        1.125: 272,
        1.25: 349,
        1.375: 437,
        1.5: 540,
    },
    6.25: {
        0.5: "DNE",
        0.625: 74.1,
        0.75: 111,
        0.875: 158,
        1.0: 212,
        1.125: 279,
        1.25: 358,
        1.375: 447,
        1.5: 552,
    },
    6.50: {
        0.5: "DNE",
        0.625: 76.3,
        0.75: 114,
        0.875: 163,
        1.0: 218,
        1.125: 286,
        1.25: 367,
        1.375: 458,
        1.5: 565,
    },
    6.75: {
        0.5: "DNE",
        0.625: 78.5,
        0.75: 118,
        0.875: 167,
        1.0: 223,
        1.125: 293,
        1.25: 375,
        1.375: 468,
        1.5: 577,
    },
    7.00: {
        0.5: "DNE",
        0.625: 80.6,
        0.75: 121,
        0.875: 171,
        1.0: 229,
        1.125: 300,
        1.25: 384,
        1.375: 479,
        1.5: 589,
    },
    7.25: {
        0.5: "DNE",
        0.625: 82.8,
        0.75: 124,
        0.875: 175,
        1.0: 234,
        1.125: 307,
        1.25: 392,
        1.375: 489,
        1.5: 602,
    },
    7.50: {
        0.5: "DNE",
        0.625: 84.9,
        0.75: 127,
        0.875: 179,
        1.0: 240,
        1.125: 314,
        1.25: 401,
        1.375: 500,
        1.5: 614,
    },
    7.75: {
        0.5: "DNE",
        0.625: 87.1,
        0.75: 130,
        0.875: 183,
        1.0: 246,
        1.125: 321,
        1.25: 410,
        1.375: 510,
        1.5: 626,
    },
    8.00: {
        0.5: "DNE",
        0.625: 89.2,
        0.75: 133,
        0.875: 187,
        1.0: 251,
        1.125: 328,
        1.25: 418,
        1.375: 521,
        1.5: 639,
    },
    8.25: {
        0.5: "DNE",
        0.625: "DNE",
        0.75: "DNE",
        0.875: 192,
        1.0: 257,
        1.125: 335,
        1.25: 427,
        1.375: 531,
        1.5: 651,
    },
    8.50: {
        0.5: "DNE",
        0.625: "DNE",
        0.75: "DNE",
        0.875: 196,
        1.0: 262,
        1.125: 342,
        1.25: 435,
        1.375: 542,
        1.5: 664,
    },
    8.75: {
        0.5: "DNE",
        0.625: "DNE",
        0.75: "DNE",
        0.875: "DNE",
        1.0: "DNE",
        1.125: "DNE",
        1.25: 444,
        1.375: 552,
        1.5: 676,
    },
    9.00: {
        0.5: "DNE",
        0.625: "DNE",
        0.75: "DNE",
        0.875: "DNE",
        1.0: "DNE",
        1.125: "DNE",
        1.25: 453,
        1.375: 563,
        1.5: 689,
    },
}
