"""
CivilPy
Copyright (C) 2019 - Dane Parks

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

class OhioCulvertDesign:
    def __init__(self, hw_type="A", des_h="6.5", span=14, wall_theta="All"):
        self.hw_type = hw_type
        self.des_h = des_h
        self.span = span
        self.wall_theta = wall_theta
        self.footing = {
            1: {"v_size": 5, "v_spa": 18, "w,z_size": 5, "w,z_spa": 18},
            2: {"v_size": 5, "v_spa": 15, "w,z_size": 5, "w,z_spa": 18},
            3: {"v_size": 5, "v_spa": 12, "w,z_size": 5, "w,z_spa": 15},
            4: {"v_size": 5, "v_spa": 18, "w,z_size": 5, "w,z_spa": 12},
            5: {"v_size": 5, "v_spa": 15, "w,z_size": 5, "w,z_spa": 9},
            6: {"v_size": 6, "v_spa": 18, "w,z_size": 6, "w,z_spa": 18},
            7: {"v_size": 6, "v_spa": 15, "w,z_size": 6, "w,z_spa": 15},
            8: {"v_size": 6, "v_spa": 9, "w,z_size": 6, "w,z_spa": 18},
            9: {"v_size": 6, "v_spa": 9, "w,z_size": 6, "w,z_spa": 12},
            10: {"v_size": 7, "v_spa": 12, "w,z_size": 7, "w,z_spa": 12},
        }

        self.Headwall_Dimensions = {
            "A": {
                "6.5": {
                    "footing_design": 1,
                    "L": 7.25,
                    "h": 4.0,
                    "wf": 4.50,
                    "hf": 1.5,
                    "hcw": 2.5,
                    "a": 1.1666,
                    "b": 1.00,
                    "x_size": 5.00,
                    "x_spa": 18.0,
                    "y_size": 5,
                    "y_spa": 18.0,
                    "c": 2.416666,
                    "WW_Conc": 3.02,
                    "WW_Reinf": 446,
                    "WW_Foot_Conc": 6.00,
                    "WW_Foot_Reinf": 598,
                    "Culv_Foot_Conc": 0.43,
                    "Culv_Foot_Reinf": 24.55,
                },
                "7.5": {
                    "footing_design": 1,
                    "L": 8.5,
                    "h": 4.5,
                    "wf": 5.00,
                    "hf": 1.5,
                    "hcw": 2.5,
                    "a": 1.5,
                    "b": 1.00,
                    "x_size": 5.00,
                    "x_spa": 18.0,
                    "y_size": 5,
                    "y_spa": 18.0,
                    "c": 2.416666,
                    "WW_Conc": 4.01,
                    "WW_Reinf": 533,
                    "WW_Foot_Conc": 7.38,
                    "WW_Foot_Reinf": 733,
                    "Culv_Foot_Conc": 0.48,
                    "Culv_Foot_Reinf": 27.58,
                },
                "8.5": {
                    "footing_design": 1,
                    "L": 10.0,
                    "h": 5.0,
                    "wf": 5.50,
                    "hf": 1.5,
                    "hcw": 2.5,
                    "a": 1.917,
                    "b": 1.00,
                    "x_size": 5.00,
                    "x_spa": 16.5,
                    "y_size": 5,
                    "y_spa": 16.5,
                    "c": 2.416666,
                    "WW_Conc": 5.27,
                    "WW_Reinf": 726,
                    "WW_Foot_Conc": 9.05,
                    "WW_Foot_Reinf": 830,
                    "Culv_Foot_Conc": 0.52,
                    "Culv_Foot_Reinf": 28.61,
                },
                "9.5": {
                    "footing_design": 2,
                    "L": 11.5,
                    "h": 5.5,
                    "wf": 6.25,
                    "hf": 1.5,
                    "hcw": 2.5,
                    "a": 2.250,
                    "b": 1.00,
                    "x_size": 5.00,
                    "x_spa": 18.0,
                    "y_size": 5,
                    "y_spa": 9.0,
                    "c": 3.833,
                    "WW_Conc": 6.69,
                    "WW_Reinf": 934,
                    "WW_Foot_Conc": 11.35,
                    "WW_Foot_Reinf": 1113,
                    "Culv_Foot_Conc": 0.57,
                    "Culv_Foot_Reinf": 30.11,
                },
                "10.5": {
                    "footing_design": 1,
                    "L": 12.75,
                    "h": 6.0,
                    "wf": 7.00,
                    "hf": 2.0,
                    "hcw": 2.0,
                    "a": 2.917,
                    "b": 1.25,
                    "x_size": 5.00,
                    "x_spa": 18.0,
                    "y_size": 5,
                    "y_spa": 9.0,
                    "c": 4.167,
                    "WW_Conc": 10.25,
                    "WW_Reinf": 1104,
                    "WW_Foot_Conc": 16.19,
                    "WW_Foot_Reinf": 1087,
                    "Culv_Foot_Conc": 0.74,
                    "Culv_Foot_Reinf": 33.95,
                },
                "11.5": {
                    "footing_design": 1,
                    "L": 14.25,
                    "h": 6.5,
                    "wf": 7.50,
                    "hf": 2.0,
                    "hcw": 2.0,
                    "a": 3.417,
                    "b": 1.25,
                    "x_size": 5.00,
                    "x_spa": 17.0,
                    "y_size": 5,
                    "y_spa": 8.5,
                    "c": 5.0,
                    "WW_Conc": 12.43,
                    "WW_Reinf": 1404,
                    "WW_Foot_Conc": 18.87,
                    "WW_Foot_Reinf": 1205,
                    "Culv_Foot_Conc": 0.80,
                    "Culv_Foot_Reinf": 35.06,
                },
                "12.5": {
                    "footing_design": 8,
                    "L": 15.75,
                    "h": 7.0,
                    "wf": 8.75,
                    "hf": 2.0,
                    "hcw": 2.0,
                    "a": 3.5,
                    "b": 1.25,
                    "x_size": 5.00,
                    "x_spa": 17.0,
                    "y_size": 5,
                    "y_spa": 8.5,
                    "c": 5.250,
                    "WW_Conc": 14.82,
                    "WW_Reinf": 1580,
                    "WW_Foot_Conc": 24.41,
                    "WW_Foot_Reinf": 2246,
                    "Culv_Foot_Conc": 0.89,
                    "Culv_Foot_Reinf": 52.90,
                },
                "13.5": {
                    "footing_design": 8,
                    "L": 17.0,
                    "h": 7.5,
                    "wf": 9.5,
                    "hf": 2.0,
                    "hcw": 2.0,
                    "a": 3.917,
                    "b": 1.25,
                    "x_size": 6.00,
                    "x_spa": 18.0,
                    "y_size": 6,
                    "y_spa": 9.0,
                    "c": 6.167,
                    "WW_Conc": 17.18,
                    "WW_Reinf": 2139,
                    "WW_Foot_Conc": 28.17,
                    "WW_Foot_Reinf": 2630,
                    "Culv_Foot_Conc": 0.97,
                    "Culv_Foot_Reinf": 56.94,
                },
            },
            "B": {
                "All": {
                    "6.5": {
                        "footing_design": 1.0,
                        "wf": 4.75,
                        "hf": 1.5,
                        "hcw": 2.5,
                        "a": 1.660,
                        "b": 1.00,
                        "x_size": 5.00,
                        "x_spa": 18.0,
                        "y_size": 5,
                        "y_spa": 18.0,
                        "c": 2.416666,
                    },
                    "7.5": {
                        "footing_design": 1.0,
                        "wf": 5.5,
                        "hf": 1.5,
                        "hcw": 2.5,
                        "a": 2.083,
                        "b": 1.00,
                        "x_size": 5.00,
                        "x_spa": 15.0,
                        "y_size": 5,
                        "y_spa": 15.0,
                        "c": 2.416666,
                    },
                    "8.5": {
                        "footing_design": 2.0,
                        "wf": 6.25,
                        "hf": 1.5,
                        "hcw": 2.5,
                        "a": 2.500,
                        "b": 1.00,
                        "x_size": 5.00,
                        "x_spa": 18.0,
                        "y_size": 5,
                        "y_spa": 9.0,
                        "c": 2.8333333,
                    },
                    "9.5": {
                        "footing_design": 3.0,
                        "wf": 7.0,
                        "hf": 1.5,
                        "hcw": 2.5,
                        "a": 2.917,
                        "b": 1.00,
                        "x_size": 5.00,
                        "x_spa": 18.0,
                        "y_size": 5,
                        "y_spa": 9.0,
                        "c": 3.1666666,
                    },
                    "10.5": {
                        "footing_design": 3.0,
                        "wf": 8.0,
                        "hf": 2.0,
                        "hcw": 2.0,
                        "a": 3.750,
                        "b": 1.25,
                        "x_size": 5.00,
                        "x_spa": 14.5,
                        "y_size": 5,
                        "y_spa": 7.25,
                        "c": 3.583333,
                    },
                    "11.5": {
                        "footing_design": 7.0,
                        "wf": 9.0,
                        "hf": 2.0,
                        "hcw": 2.0,
                        "a": 4.083,
                        "b": 1.25,
                        "x_size": 5.00,
                        "x_spa": 14.5,
                        "y_size": 5,
                        "y_spa": 7.25,
                        "c": 3.750000,
                    },
                    "12.5": {
                        "footing_design": 9.0,
                        "wf": 10.0,
                        "hf": 2.0,
                        "hcw": 2.0,
                        "a": 4.500,
                        "b": 1.25,
                        "x_size": 6.00,
                        "x_spa": 16.0,
                        "y_size": 6,
                        "y_spa": 8.0,
                        "c": 4.7500000,
                    },
                    "13.5": {
                        "footing_design": 10.0,
                        "wf": 11.25,
                        "hf": 2.0,
                        "hcw": 2.0,
                        "a": 4.833,
                        "b": 1.25,
                        "x_size": 6.0,
                        "x_spa": 12.5,
                        "y_size": 6,
                        "y_spa": 6.25,
                        "c": 4.916666,
                    },
                },
                "0": {
                    "6.5": {
                        "L1": 7.083,
                        "L2": 10.0,
                        "h1": 4.0,
                        "h2": 6.5,
                        "WW_Conc": 3.89,
                        "WW_Reinf": 512,
                        "WW_Foot_Conc": 6.94,
                        "WW_Foot_Reinf": 552,
                        "Culv_Foot_Conc": 0.47,
                        "Culv_Foot_Reinf": 25.31,
                    },
                    "7.5": {
                        "L1": 8.50,
                        "L2": 12.0,
                        "h1": 4.5,
                        "h2": 7.5,
                        "WW_Conc": 5.34,
                        "WW_Reinf": 667,
                        "WW_Foot_Conc": 9.13,
                        "WW_Foot_Reinf": 684,
                        "Culv_Foot_Conc": 0.53,
                        "Culv_Foot_Reinf": 28.77,
                    },
                    "8.5": {
                        "L1": 9.917,
                        "L2": 14.0,
                        "h1": 5.0,
                        "h2": 8.5,
                        "WW_Conc": 7.02,
                        "WW_Reinf": 921,
                        "WW_Foot_Conc": 11.62,
                        "WW_Foot_Reinf": 1028,
                        "Culv_Foot_Conc": 0.58,
                        "Culv_Foot_Reinf": 30.40,
                    },
                    "9.5": {
                        "L1": 11.333,
                        "L2": 16.0,
                        "h1": 5.5,
                        "h2": 9.5,
                        "WW_Conc": 8.93,
                        "WW_Reinf": 1118,
                        "WW_Foot_Conc": 14.39,
                        "WW_Foot_Reinf": 1373,
                        "Culv_Foot_Conc": 0.64,
                        "Culv_Foot_Reinf": 36.79,
                    },
                    "10.5": {
                        "L1": 12.750,
                        "L2": 18.0,
                        "h1": 6.0,
                        "h2": 10.5,
                        "WW_Conc": 13.88,
                        "WW_Reinf": 1464,
                        "WW_Foot_Conc": 21.52,
                        "WW_Foot_Reinf": 1677,
                        "Culv_Foot_Conc": 0.85,
                        "Culv_Foot_Reinf": 41.10,
                    },
                    "11.5": {
                        "L1": 14.167,
                        "L2": 20.0,
                        "h1": 6.5,
                        "h2": 11.5,
                        "WW_Conc": 16.83,
                        "WW_Reinf": 1787,
                        "WW_Foot_Conc": 26.54,
                        "WW_Foot_Reinf": 2144,
                        "Culv_Foot_Conc": 0.93,
                        "Culv_Foot_Reinf": 50.56,
                    },
                    "12.5": {
                        "L1": 15.583,
                        "L2": 22.0,
                        "h1": 7.0,
                        "h2": 12.5,
                        "WW_Conc": 20.07,
                        "WW_Reinf": 2321,
                        "WW_Foot_Conc": 32.04,
                        "WW_Foot_Reinf": 3030,
                        "Culv_Foot_Conc": 1.03,
                        "Culv_Foot_Reinf": 67.81,
                    },
                    "13.5": {
                        "L1": 17.0,
                        "L2": 24.0,
                        "h1": 7.5,
                        "h2": 13.5,
                        "WW_Conc": 23.59,
                        "WW_Reinf": 2928,
                        "WW_Foot_Conc": 38.97,
                        "WW_Foot_Reinf": 4023,
                        "Culv_Foot_Conc": 1.13,
                        "Culv_Foot_Reinf": 84.51,
                    },
                },
                "15": {
                    "6.5": {
                        "L1": 8.250,
                        "L2": 6.333,
                        "h1": 4.0,
                        "h2": 4.750,
                        "WW_Conc": 3.05,
                        "WW_Reinf": 422,
                        "WW_Foot_Conc": 5.94,
                        "WW_Foot_Reinf": 493,
                        "Culv_Foot_Conc": 0.47,
                        "Culv_Foot_Reinf": 25.31,
                    },
                    "7.5": {
                        "L1": 9.917,
                        "L2": 7.917,
                        "h1": 4.5,
                        "h2": 5.5,
                        "WW_Conc": 4.05,
                        "WW_Reinf": 582,
                        "WW_Foot_Conc": 7.95,
                        "WW_Foot_Reinf": 631,
                        "Culv_Foot_Conc": 0.53,
                        "Culv_Foot_Reinf": 28.77,
                    },
                    "8.5": {
                        "L1": 11.5,
                        "L2": 9.5,
                        "h1": 5.0,
                        "h2": 6.250,
                        "WW_Conc": 5.63,
                        "WW_Reinf": 783,
                        "WW_Foot_Conc": 10.20,
                        "WW_Foot_Reinf": 935,
                        "Culv_Foot_Conc": 0.58,
                        "Culv_Foot_Reinf": 30.40,
                    },
                    "9.5": {
                        "L1": 13.167,
                        "L2": 11.083,
                        "h1": 5.5,
                        "h2": 7.0,
                        "WW_Conc": 7.22,
                        "WW_Reinf": 960,
                        "WW_Foot_Conc": 12.76,
                        "WW_Foot_Reinf": 1240,
                        "Culv_Foot_Conc": 0.64,
                        "Culv_Foot_Reinf": 36.79,
                    },
                    "10.5": {
                        "L1": 14.833,
                        "L2": 12.667,
                        "h1": 6.0,
                        "h2": 7.750,
                        "WW_Conc": 11.32,
                        "WW_Reinf": 1245,
                        "WW_Foot_Conc": 19.23,
                        "WW_Foot_Reinf": 1517,
                        "Culv_Foot_Conc": 0.85,
                        "Culv_Foot_Reinf": 41.10,
                    },
                    "11.5": {
                        "L1": 16.5,
                        "L2": 14.250,
                        "h1": 6.5,
                        "h2": 8.750,
                        "WW_Conc": 13.89,
                        "WW_Reinf": 1535,
                        "WW_Foot_Conc": 23.91,
                        "WW_Foot_Reinf": 1947,
                        "Culv_Foot_Conc": 0.93,
                        "Culv_Foot_Reinf": 50.56,
                    },
                    "12.5": {
                        "L1": 18.083,
                        "L2": 15.833,
                        "h1": 7.0,
                        "h2": 9.5,
                        "WW_Conc": 16.59,
                        "WW_Reinf": 2020,
                        "WW_Foot_Conc": 28.96,
                        "WW_Foot_Reinf": 2722,
                        "Culv_Foot_Conc": 1.03,
                        "Culv_Foot_Reinf": 67.81,
                    },
                    "13.5": {
                        "L1": 19.750,
                        "L2": 17.5,
                        "h1": 7.5,
                        "h2": 10.25,
                        "WW_Conc": 19.61,
                        "WW_Reinf": 2587,
                        "WW_Foot_Conc": 35.52,
                        "WW_Foot_Reinf": 3669,
                        "Culv_Foot_Conc": 1.13,
                        "Culv_Foot_Reinf": 84.51,
                    },
                },
                "30": {
                    "6.5": {
                        "L1": 10.0,
                        "L2": 4.0,
                        "h1": 4.0,
                        "h2": 3.5,
                        "WW_Conc": 2.83,
                        "WW_Reinf": 407,
                        "WW_Foot_Conc": 5.71,
                        "WW_Foot_Reinf": 468,
                        "Culv_Foot_Conc": 0.47,
                        "Culv_Foot_Reinf": 25.31,
                    },
                    "7.5": {
                        "L1": 12.0,
                        "L2": 5.333,
                        "h1": 4.5,
                        "h2": 4.25,
                        "WW_Conc": 3.99,
                        "WW_Reinf": 531,
                        "WW_Foot_Conc": 7.74,
                        "WW_Foot_Reinf": 625,
                        "Culv_Foot_Conc": 0.53,
                        "Culv_Foot_Reinf": 28.77,
                    },
                    "8.5": {
                        "L1": 14.0,
                        "L2": 6.667,
                        "h1": 5.0,
                        "h2": 5.0,
                        "WW_Conc": 5.35,
                        "WW_Reinf": 772,
                        "WW_Foot_Conc": 10.05,
                        "WW_Foot_Reinf": 922,
                        "Culv_Foot_Conc": 0.58,
                        "Culv_Foot_Reinf": 30.40,
                    },
                    "9.5": {
                        "L1": 16.0,
                        "L2": 8.0,
                        "h1": 5.5,
                        "h2": 5.5,
                        "WW_Conc": 6.87,
                        "WW_Reinf": 917,
                        "WW_Foot_Conc": 12.64,
                        "WW_Foot_Reinf": 1229,
                        "Culv_Foot_Conc": 0.64,
                        "Culv_Foot_Reinf": 36.79,
                    },
                    "10.5": {
                        "L1": 18.0,
                        "L2": 9.333,
                        "h1": 6.0,
                        "h2": 6.25,
                        "WW_Conc": 10.85,
                        "WW_Reinf": 1189,
                        "WW_Foot_Conc": 19.13,
                        "WW_Foot_Reinf": 1487,
                        "Culv_Foot_Conc": 0.85,
                        "Culv_Foot_Reinf": 41.10,
                    },
                    "11.5": {
                        "L1": 20.0,
                        "L2": 10.667,
                        "h1": 6.5,
                        "h2": 7.0,
                        "WW_Conc": 13.29,
                        "WW_Reinf": 1483,
                        "WW_Foot_Conc": 23.89,
                        "WW_Foot_Reinf": 1908,
                        "Culv_Foot_Conc": 0.93,
                        "Culv_Foot_Reinf": 50.56,
                    },
                    "12.5": {
                        "L1": 22.0,
                        "L2": 12.0,
                        "h1": 7.0,
                        "h2": 7.5,
                        "WW_Conc": 15.91,
                        "WW_Reinf": 1957,
                        "WW_Foot_Conc": 29.11,
                        "WW_Foot_Reinf": 2683,
                        "Culv_Foot_Conc": 1.03,
                        "Culv_Foot_Reinf": 67.81,
                    },
                    "13.5": {
                        "L1": 24.0,
                        "L2": 13.333,
                        "h1": 7.5,
                        "h2": 8.25,
                        "WW_Conc": 18.84,
                        "WW_Reinf": 2520,
                        "WW_Foot_Conc": 35.74,
                        "WW_Foot_Reinf": 3674,
                        "Culv_Foot_Conc": 1.13,
                        "Culv_Foot_Reinf": 84.51,
                    },
                },
                "45": {
                    "6.5": {
                        "L1": 13.083,
                        "L2": 4.0,
                        "h1": 4.0,
                        "h2": 2.75,
                        "WW_Conc": 3.40,
                        "WW_Reinf": 469,
                        "WW_Foot_Conc": 6.97,
                        "WW_Foot_Reinf": 535,
                        "Culv_Foot_Conc": 0.47,
                        "Culv_Foot_Reinf": 25.31,
                    },
                    "7.5": {
                        "L1": 15.750,
                        "L2": 4.0,
                        "h1": 4.5,
                        "h2": 3.5,
                        "WW_Conc": 4.51,
                        "WW_Reinf": 590,
                        "WW_Foot_Conc": 8.82,
                        "WW_Foot_Reinf": 676,
                        "Culv_Foot_Conc": 0.53,
                        "Culv_Foot_Reinf": 28.77,
                    },
                    "8.5": {
                        "L1": 18.333,
                        "L2": 4.917,
                        "h1": 5.0,
                        "h2": 4.0,
                        "WW_Conc": 5.94,
                        "WW_Reinf": 825,
                        "WW_Foot_Conc": 11.32,
                        "WW_Foot_Reinf": 982,
                        "Culv_Foot_Conc": 0.58,
                        "Culv_Foot_Reinf": 30.40,
                    },
                    "9.5": {
                        "L1": 20.917,
                        "L2": 6.083,
                        "h1": 5.5,
                        "h2": 4.5,
                        "WW_Conc": 7.63,
                        "WW_Reinf": 983,
                        "WW_Foot_Conc": 14.26,
                        "WW_Foot_Reinf": 1337,
                        "Culv_Foot_Conc": 0.64,
                        "Culv_Foot_Reinf": 36.79,
                    },
                    "10.5": {
                        "L1": 23.583,
                        "L2": 7.250,
                        "h1": 6.0,
                        "h2": 5.25,
                        "WW_Conc": 12.06,
                        "WW_Reinf": 1325,
                        "WW_Foot_Conc": 21.66,
                        "WW_Foot_Reinf": 1628,
                        "Culv_Foot_Conc": 0.85,
                        "Culv_Foot_Reinf": 41.10,
                    },
                    "11.5": {
                        "L1": 26.167,
                        "L2": 8.417,
                        "h1": 6.5,
                        "h2": 5.75,
                        "WW_Conc": 14.71,
                        "WW_Reinf": 1622,
                        "WW_Foot_Conc": 27.05,
                        "WW_Foot_Reinf": 2116,
                        "Culv_Foot_Conc": 0.93,
                        "Culv_Foot_Reinf": 50.56,
                    },
                    "12.5": {
                        "L1": 28.750,
                        "L2": 9.583,
                        "h1": 7.0,
                        "h2": 6.25,
                        "WW_Conc": 17.63,
                        "WW_Reinf": 2157,
                        "WW_Foot_Conc": 32.96,
                        "WW_Foot_Reinf": 2995,
                        "Culv_Foot_Conc": 1.03,
                        "Culv_Foot_Reinf": 67.81,
                    },
                    "13.5": {
                        "L1": 31.417,
                        "L2": 10.75,
                        "h1": 7.5,
                        "h2": 6.75,
                        "WW_Conc": 20.84,
                        "WW_Reinf": 2772,
                        "WW_Foot_Conc": 40.55,
                        "WW_Foot_Reinf": 4064,
                        "Culv_Foot_Conc": 1.13,
                        "Culv_Foot_Reinf": 84.51,
                    },
                },
            },
            "C": {
                "6.5": {
                    "footing_design": 1,
                    "L": 10,
                    "wf": 5.25,
                    "hf": 1.5,
                    "hcw": 2.5,
                    "a": 1.417,
                    "b": 1.00,
                    "x_size": 5.00,
                    "x_spa": 17.5,
                    "y_size": 5,
                    "y_spa": 17.5,
                    "c": 2.416666,
                    "WW_Conc": 4.82,
                    "WW_Reinf": 528,
                    "WW_Foot_Conc": 8.62,
                    "WW_Foot_Reinf": 587,
                    "Culv_Foot_Conc": 0.49,
                    "Culv_Foot_Reinf": 27.84,
                },
                "7.5": {
                    "footing_design": 1,
                    "L": 12,
                    "wf": 5.75,
                    "hf": 1.5,
                    "hcw": 2.5,
                    "a": 2.0,
                    "b": 1.00,
                    "x_size": 5.00,
                    "x_spa": 12.0,
                    "y_size": 5,
                    "y_spa": 12.0,
                    "c": 2.416666,
                    "WW_Conc": 6.67,
                    "WW_Reinf": 749,
                    "WW_Foot_Conc": 11.00,
                    "WW_Foot_Reinf": 695,
                    "Culv_Foot_Conc": 0.55,
                    "Culv_Foot_Reinf": 29.04,
                },
                "8.5": {
                    "footing_design": 1,
                    "L": 14,
                    "wf": 6.25,
                    "hf": 1.5,
                    "hcw": 2.5,
                    "a": 2.583,
                    "b": 1.00,
                    "x_size": 5.00,
                    "x_spa": 17.5,
                    "y_size": 5,
                    "y_spa": 8.75,
                    "c": 3.5,
                    "WW_Conc": 8.82,
                    "WW_Reinf": 1012,
                    "WW_Foot_Conc": 13.62,
                    "WW_Foot_Reinf": 823,
                    "Culv_Foot_Conc": 0.59,
                    "Culv_Foot_Reinf": 30.15,
                },
                "9.5": {
                    "footing_design": 3,
                    "L": 16,
                    "wf": 7.0,
                    "hf": 1.5,
                    "hcw": 2.5,
                    "a": 2.917,
                    "b": 1.00,
                    "x_size": 5.00,
                    "x_spa": 17.5,
                    "y_size": 5,
                    "y_spa": 8.75,
                    "c": 3.667,
                    "WW_Conc": 11.26,
                    "WW_Reinf": 1261,
                    "WW_Foot_Conc": 16.89,
                    "WW_Foot_Reinf": 1448,
                    "Culv_Foot_Conc": 0.64,
                    "Culv_Foot_Reinf": 36.68,
                },
                "10.5": {
                    "footing_design": 3,
                    "L": 18,
                    "wf": 8.0,
                    "hf": 2.0,
                    "hcw": 2.0,
                    "a": 3.667,
                    "b": 1.25,
                    "x_size": 5.00,
                    "x_spa": 18.0,
                    "y_size": 5,
                    "y_spa": 9.0,
                    "c": 3.917,
                    "WW_Conc": 17.50,
                    "WW_Reinf": 1485,
                    "WW_Foot_Conc": 25.34,
                    "WW_Foot_Reinf": 1803,
                    "Culv_Foot_Conc": 0.85,
                    "Culv_Foot_Reinf": 40.93,
                },
                "11.5": {
                    "footing_design": 7,
                    "L": 20,
                    "wf": 9.0,
                    "hf": 2.0,
                    "hcw": 2.0,
                    "a": 3.833,
                    "b": 1.25,
                    "x_size": 6.00,
                    "x_spa": 18.0,
                    "y_size": 6,
                    "y_spa": 9.0,
                    "c": 4.5,
                    "WW_Conc": 21.30,
                    "WW_Reinf": 2201,
                    "WW_Foot_Conc": 31.12,
                    "WW_Foot_Reinf": 2250,
                    "Culv_Foot_Conc": 0.92,
                    "Culv_Foot_Reinf": 46.94,
                },
                "12.5": {
                    "footing_design": 9,
                    "L": 22,
                    "wf": 9.75,
                    "hf": 2.0,
                    "hcw": 2.0,
                    "a": 4.250,
                    "b": 1.25,
                    "x_size": 6.00,
                    "x_spa": 16.0,
                    "y_size": 6,
                    "y_spa": 8.0,
                    "c": 5.167,
                    "WW_Conc": 25.47,
                    "WW_Reinf": 2775,
                    "WW_Foot_Conc": 36.67,
                    "WW_Foot_Reinf": 3378,
                    "Culv_Foot_Conc": 1.00,
                    "Culv_Foot_Reinf": 66.64,
                },
                "13.5": {
                    "footing_design": 9,
                    "L": 24,
                    "wf": 10.5,
                    "hf": 2.0,
                    "hcw": 2.0,
                    "a": 4.667,
                    "b": 1.25,
                    "x_size": 6.00,
                    "x_spa": 13.0,
                    "y_size": 6,
                    "y_spa": 6.5,
                    "c": 5.333,
                    "WW_Conc": 30.0,
                    "WW_Reinf": 3454,
                    "WW_Foot_Conc": 42.67,
                    "WW_Foot_Reinf": 3789,
                    "Culv_Foot_Conc": 1.06,
                    "Culv_Foot_Reinf": 69.56,
                },
            },
        }
        self.wall_thickness = 0

        if self.span <= 8:
            self.wall_thickness = 8
        elif self.span <= 10:
            self.wall_thickness = 10
        else:
            self.wall_thickness = 12
