# 文件IO操作模块
# 提供文件读写、下载、文件夹操作等功能
# 该模块封装了常用的文件操作功能，包括文件保存、加载、下载和文件夹管理

# 文件保存相关
from .save import save_df, save_json, save_txt

# 文件加载相关  
from .load import load_txt, load_yaml, load_excel, load_json, load_base64

# 文件下载相关
# 使用括号格式是为了提高多函数导入的可读性
from .down_load import (
    download_file,
    download_files,
    download_encode_base64,
    batch_download_encode_base64,
    check_url_valid,
)

# 文件夹操作相关
from .folder import (
    find_files, 
    clear_folder, 
    find_parent_folder, 
    print_folder_tree 
)

# 定义 __all__ 列表，明确指定哪些符号会被导出
__all__ = [
    # 文件保存
    'save_df',
    'save_json', 
    'save_txt',
    
    # 文件加载
    'load_txt',
    'load_yaml',
    'load_excel',
    'load_json',
    'load_base64',
    
    # 文件下载
    'download_file',
    'download_files',
    'download_encode_base64',
    'batch_download_encode_base64',
    'check_url_valid',
    
    # 文件夹操作
    'find_files',
    'clear_folder',
    'find_parent_folder',
    'print_folder_tree'
]