"""
Currency
"""

from typing import Union

from bitpay.models.bitpay_model import BitPayModel


class Currency(BitPayModel):
    """
    Currency: Crypto and fiat
    """

    # Crypto
    BCH: str = "BCH"
    BTC: str = "BTC"
    ETH: str = "ETH"
    USDC: str = "USDC"
    GUSD: str = "GUSD"
    PAX: str = "PAX"
    XRP: str = "XRP"
    BUSD: str = "BUSD"
    DOGE: str = "DOGE"
    WBTC: str = "WBTC"
    DAI: str = "DAI"
    LTC: str = "LTC"
    SHIB: str = "SHIB"

    # Fiat
    AED: str = "AED"
    AFN: str = "AFN"
    ALL: str = "ALL"
    AMD: str = "AMD"
    ANG: str = "ANG"
    AOA: str = "AOA"
    ARS: str = "ARS"
    AUD: str = "AUD"
    AWG: str = "AWG"
    AZN: str = "AZN"
    BAM: str = "BAM"
    BBD: str = "BBD"
    BDT: str = "BDT"
    BGN: str = "BGN"
    BHD: str = "BHD"
    BIF: str = "BIF"
    BMD: str = "BMD"
    BND: str = "BND"
    BOB: str = "BOB"
    BOV: str = "BOV"
    BRL: str = "BRL"
    BSD: str = "BSD"
    BTN: str = "BTN"
    BWP: str = "BWP"
    BYR: str = "BYR"
    BZD: str = "BZD"
    CAD: str = "CAD"
    CDF: str = "CDF"
    CHE: str = "CHE"
    CHF: str = "CHF"
    CHW: str = "CHW"
    CLF: str = "CLF"
    CLP: str = "CLP"
    CNY: str = "CNY"
    COP: str = "COP"
    COU: str = "COU"
    CRC: str = "CRC"
    CUC: str = "CUC"
    CUP: str = "CUP"
    CVE: str = "CVE"
    CZK: str = "CZK"
    DJF: str = "DJF"
    DKK: str = "DKK"
    DOP: str = "DOP"
    DZD: str = "DZD"
    EGP: str = "EGP"
    ERN: str = "ERN"
    ETB: str = "ETB"
    EUR: str = "EUR"
    FJD: str = "FJD"
    FKP: str = "FKP"
    GBP: str = "GBP"
    GEL: str = "GEL"
    GHS: str = "GHS"
    GIP: str = "GIP"
    GMD: str = "GMD"
    GNF: str = "GNF"
    GTQ: str = "GTQ"
    GYD: str = "GYD"
    HKD: str = "HKD"
    HNL: str = "HNL"
    HRK: str = "HRK"
    HTG: str = "HTG"
    HUF: str = "HUF"
    IDR: str = "IDR"
    ILS: str = "ILS"
    INR: str = "INR"
    IQD: str = "IQD"
    IRR: str = "IRR"
    ISK: str = "ISK"
    JMD: str = "JMD"
    JOD: str = "JOD"
    JPY: str = "JPY"
    KES: str = "KES"
    KGS: str = "KGS"
    KHR: str = "KHR"
    KMF: str = "KMF"
    KPW: str = "KPW"
    KRW: str = "KRW"
    KWD: str = "KWD"
    KYD: str = "KYD"
    KZT: str = "KZT"
    LAK: str = "LAK"
    LBP: str = "LBP"
    LKR: str = "LKR"
    LRD: str = "LRD"
    LSL: str = "LSL"
    LYD: str = "LYD"
    MAD: str = "MAD"
    MDL: str = "MDL"
    MGA: str = "MGA"
    MKD: str = "MKD"
    MMK: str = "MMK"
    MNT: str = "MNT"
    MOP: str = "MOP"
    MRU: str = "MRU"
    MUR: str = "MUR"
    MVR: str = "MVR"
    MWK: str = "MWK"
    MXN: str = "MXN"
    MXV: str = "MXV"
    MYR: str = "MYR"
    MZN: str = "MZN"
    NAD: str = "NAD"
    NGN: str = "NGN"
    NIO: str = "NIO"
    NOK: str = "NOK"
    NPR: str = "NPR"
    NZD: str = "NZD"
    OMR: str = "OMR"
    PAB: str = "PAB"
    PEN: str = "PEN"
    PGK: str = "PGK"
    PHP: str = "PHP"
    PKR: str = "PKR"
    PLN: str = "PLN"
    PYG: str = "PYG"
    QAR: str = "QAR"
    RON: str = "RON"
    RSD: str = "RSD"
    RUB: str = "RUB"
    RWF: str = "RWF"
    SAR: str = "SAR"
    SBD: str = "SBD"
    SCR: str = "SCR"
    SDG: str = "SDG"
    SEK: str = "SEK"
    SGD: str = "SGD"
    SHP: str = "SHP"
    SLL: str = "SLL"
    SOS: str = "SOS"
    SRD: str = "SRD"
    SSP: str = "SSP"
    STN: str = "STN"
    SVC: str = "SVC"
    SYP: str = "SYP"
    SZL: str = "SZL"
    THB: str = "THB"
    TJS: str = "TJS"
    TMT: str = "TMT"
    TND: str = "TND"
    TOP: str = "TOP"
    TRY: str = "TRY"
    TTD: str = "TTD"
    TWD: str = "TWD"
    TZS: str = "TZS"
    UAH: str = "UAH"
    UGX: str = "UGX"
    USD: str = "USD"
    USN: str = "USN"
    UYI: str = "UYI"
    UYU: str = "UYU"
    UZS: str = "UZS"
    VEF: str = "VEF"
    VND: str = "VND"
    VUV: str = "VUV"
    WST: str = "WST"
    XAF: str = "XAF"
    XCD: str = "XCD"
    XDR: str = "XDR"
    XOF: str = "XOF"
    XPF: str = "XPF"
    XSU: str = "XSU"
    XUA: str = "XUA"
    YER: str = "YER"
    ZAR: str = "ZAR"
    ZMW: str = "ZMW"
    ZWL: str = "ZWL"

    code: str
    symbol: Union[str, None] = None
    precision: int
    name: str
    plural: str
    alts: str
    minimum: float
    sanctioned: bool = False
    decimals: int
    display_code: Union[str, None] = None
    chain: Union[str, None] = None
    max_supply: Union[float, None] = None
    tranche_decimals: Union[int, None] = None
    contract_address: Union[str, None] = None

    @classmethod
    def is_valid(cls, value: str) -> bool:
        if cls.model_fields.get(value) is None:
            return False
        return True
