__version__: str
try:
    # _version.py is auto-generated by hatch-vcs during build from git tags
    from cyclopts._version import __version__  # type: ignore[import-not-found]
except ImportError:
    __version__ = "0.0.0.dev0"

__all__ = [
    "__version__",
    "App",
    "Argument",
    "ArgumentCollection",
    "ArgumentOrderError",
    "Token",
    "CoercionError",
    "CombinedShortOptionError",
    "CommandCollisionError",
    "CycloptsError",
    "CycloptsPanel",
    "Dispatcher",
    "DocstringError",
    "EditorError",
    "EditorNotFoundError",
    "EditorDidNotSaveError",
    "EditorDidNotChangeError",
    "Group",
    "UnknownCommandError",
    "MissingArgumentError",
    "MixedArgumentError",
    "RepeatArgumentError",
    "Parameter",
    "ResultAction",
    "UnknownOptionError",
    "UnusedCliTokensError",
    "UNSET",
    "ValidationError",
    "config",
    "convert",
    "default_name_transform",
    "edit",
    "env_var_split",
    "types",
    "validators",
    "run",
]

from cyclopts._convert import convert
from cyclopts._env_var import env_var_split
from cyclopts._result_action import ResultAction
from cyclopts._run import run
from cyclopts.argument import Argument, ArgumentCollection
from cyclopts.core import App
from cyclopts.exceptions import (
    ArgumentOrderError,
    CoercionError,
    CombinedShortOptionError,
    CommandCollisionError,
    CycloptsError,
    DocstringError,
    MissingArgumentError,
    MixedArgumentError,
    RepeatArgumentError,
    UnknownCommandError,
    UnknownOptionError,
    UnusedCliTokensError,
    ValidationError,
)
from cyclopts.group import Group
from cyclopts.panel import CycloptsPanel
from cyclopts.parameter import Parameter
from cyclopts.protocols import Dispatcher
from cyclopts.token import Token
from cyclopts.utils import UNSET, default_name_transform

# Lazy imports for opt-in features (saves ~6ms on import)
# These modules are only loaded when explicitly accessed by user code
_LAZY_IMPORTS = {
    # Submodules - opt-in features not needed for basic CLI parsing
    "config": "cyclopts.config",  # Configuration file parsing (JSON, TOML, YAML, env)
    "types": "cyclopts.types",  # ~3ms - special types like ResolvedExistingPath
    "validators": "cyclopts.validators",  # ~2ms - validators like Number, Path
    # Editor functionality - rarely used
    "edit": "cyclopts._edit",  # ~4ms
    "EditorError": "cyclopts._edit",
    "EditorNotFoundError": "cyclopts._edit",
    "EditorDidNotSaveError": "cyclopts._edit",
    "EditorDidNotChangeError": "cyclopts._edit",
}


def __getattr__(name: str):
    """Lazy-load opt-in features and rarely-used functionality."""
    if name in _LAZY_IMPORTS:
        import importlib

        module_path = _LAZY_IMPORTS[name]
        if name in ("config", "types", "validators"):
            # These are submodules, import the module itself
            module = importlib.import_module(module_path)
            globals()[name] = module
            return module
        else:
            # These are attributes from modules (e.g., edit, EditorError)
            module = importlib.import_module(module_path)
            value = getattr(module, name)
            globals()[name] = value
            return value
    raise AttributeError(f"module {__name__!r} has no attribute {name!r}")
