import enum

__all__ = (
    "BanTypes",
    "ChatTypes",
    "FlagTypes",
    "LeaderboardTypes",
    "ObjectTypes",
    "OnlineTypes",
    "UserTypes",
    "WsMessageTypes"
)


class EnumBase(enum.Enum):
    def __str__(self) -> str:
        return str(self.value)


class ObjectTypes(int, EnumBase):
    USER = 0
    BLOG = 1
    WIKI = 2
    CHAT = 12


class ChatTypes(str, EnumBase):
    LATEST = "latest"
    POPULAR = "popular"
    RECOMMENDED = "recommended"


class LeaderboardTypes(int, EnumBase):
    ACTIVE24H = 1
    ACTIVE7D = 2
    HALL_OF_FAME = 3
    CHECK_IN = 4
    QUIZ = 5


class UserTypes(str, EnumBase):
    LEADERS = "leaders"
    CURATORS = "curators"
    RECENT = "recent"
    FEATURED = "featured"
    BANNED = "banned"


class FlagTypes(int, EnumBase):
    AGGRESSION = 0
    SPAM = 2
    OFFTOPIC = 4
    VIOLENCE = 106
    INTOLERANCE = 107
    SUICIDE = 108
    TROLLING = 109
    PORNOGRAPHY = 110


class OnlineTypes(int, EnumBase):
    ONLINE = 1
    OFFLINE = 2


class BanTypes(int, EnumBase):
    SEXUALLY_EXPLICIT = 100
    SPAM = 2
    OUT_OF_CONTEXT = 4
    HARASSMENT = 0
    INNAPROPIATE_SOLICITUDE = 102
    EXTREME_VIOLENCE = 101
    OTHER = 200


class WsMessageTypes(int, EnumBase):
    ERROR_MESSAGE = 1
    CHANNEL_ORGANIZER_LEFT = 2
    CHANNEL_NOT_AVAILABLE = 3
    USER_PROFILE_BANNED = 4
    CHANNEL_MEMBERSHIP_BANNED = 5
    CHANNEL_NO_PRESENTER = 6

    PUSH_NOTIFICATION_DTO = 10

    CHANNEL_PRIVATE_NOT_ACCEPT = 99
    CHANNEL_JOIN_REQUEST = 100
    CHANNEL_JOIN_RESPONSE = 101
    CHANNEL_USER_LIST_RESPONSE = 102
    CHANNEL_LEAVE_REQUEST = 103
    CHANNEL_LEAVE_RESPONSE = 104
    CHANNEL_USER_LIST_REQUEST = 105
    CHANNEL_USER_JOINED_MESSAGE = 106
    CHANNEL_USER_LEFT_MESSAGE = 107
    CHANNEL_UPDATE_REQUEST = 108
    CHANNEL_UPDATE_RESPONSE = 109

    CHANNEL_STATUS_CHANGED_MESSAGE = 111  # CHANNEL_UPDATE_MESSAGE ?
    CHANNEL_UPDATE_JOIN_ROLE_REQUEST = 112
    CHANNEL_UPDATE_JOIN_ROLE_RESPONSE = 113
    CHANNEL_USER_STATUS_CHANGED_MESSAGE = 114
    CHANNEL_FORCE_QUIT_MESSAGE = 115
    CHANNEL_USER_PING_REQUEST = 116
    CHANNEL_USER_PING_RESPONSE = 117
    MULTI_DEVICE_ERROR = 118
    SCREEN_ROOM_PLAY_LIST_RESPONSE = 119
    SCREEN_ROOM_PLAY_LIST_UPDATE_REQUEST = 120
    SCREEN_ROOM_PLAY_LIST_UPDATE_RESPONSE = 121
    SCREEN_ROOM_PLAY_LIST_REQUEST = 122

    CHANNEL_FORCE_UPDATE_USER_ROLE_REQUEST = 126
    CHANNEL_FORCE_UPDATE_USER_ROLE_RESPONSE = 127
    CHANNEL_FORCE_UPDATE_USER_ROLE_MESSAGE = 128

    CHANNEL_WAIT_LIST_APPROVE_MESSAGE = 130
    CHANNEL_WAIT_LIST_CHANGED_MESSAGE = 131
    CHANNEL_WAIT_LIST_CLEAN_REQUEST = 132
    CHANNEL_WAIT_LIST_CLEAN_RESPONSE = 133
    CHANNEL_WAIT_LIST_JOIN_APPROVE_REQUEST = 134
    CHANNEL_WAIT_LIST_JOIN_APPROVE_RESPONSE = 135
    CHANNEL_WAIT_LIST_JOIN_CANCEL_REQUEST = 136
    CHANNEL_WAIT_LIST_JOIN_CANCEL_RESPONSE = 137
    CHANNEL_WAIT_LIST_JOIN_REQUEST = 138
    CHANNEL_WAIT_LIST_JOIN_RESPONSE = 139

    AGORA_TOKEN_REQUEST = 200
    AGORA_TOKEN_RESPONSE = 201

    LIVE_LAYER_SUBSCRIBE_REQUEST = 300
    LIVE_LAYER_SUBSCRIBE_RESPONSE = 301
    LIVE_LAYER_UNSUBSCRIBE_REQUEST = 302
    LIVE_LAYER_UNSUBSCRIBE_RESPONSE = 303
    LIVE_LAYER_REPORT_ACTIVE_REQUEST = 304
    LIVE_LAYER_REPORT_ACTIVE_RESPONSE = 305
    LIVE_LAYER_REPORT_INACTIVE_REQUEST = 306
    LIVE_LAYER_REPORT_INACTIVE_RESPONSE = 307

    LIVE_LAYER_USER_JOINED_EVENT = 400
    LIVE_LAYER_USER_LEFT_EVENT = 401

    CHAT_MESSAGE_DTO = 1000
    CHAT_MESSAGE_ACK_DTO = 1001
