# Generated by Django 2.0.5 on 2019-10-08 15:51

import django.contrib.gis.db.models.fields
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import localcosmos_server.datasets.models
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Dataset',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('taxon_uuid', models.UUIDField(null=True)),
                ('taxon_nuid', models.CharField(max_length=255, null=True)),
                ('taxon_latname', models.CharField(max_length=255, null=True)),
                ('taxon_source', models.CharField(max_length=255, null=True)),
                ('taxon_include_descendants', models.BooleanField(default=False)),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, unique=True)),
                ('data', django.contrib.postgres.fields.jsonb.JSONField()),
                ('coordinates', django.contrib.gis.db.models.fields.PointField(null=True, srid=3857)),
                ('geographic_reference', django.contrib.gis.db.models.fields.GeometryField(blank=True, null=True, srid=3857)),
                ('app_uuid', models.UUIDField()),
                ('timestamp', models.DateTimeField(null=True)),
                ('client_id', models.CharField(editable=False, max_length=255)),
                ('validation_step', models.CharField(max_length=255, null=True)),
                ('validation_errors', django.contrib.postgres.fields.jsonb.JSONField(null=True)),
                ('is_valid', models.BooleanField(default=False)),
                ('created_at', models.DateTimeField(editable=False)),
                ('last_modified', models.DateTimeField(null=True)),
            ],
            options={
                'ordering': ['-pk'],
            },
        ),
        migrations.CreateModel(
            name='DatasetImages',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('field_uuid', models.UUIDField()),
                ('image', models.ImageField(max_length=255, upload_to=localcosmos_server.datasets.models.dataset_image_path)),
            ],
        ),
        migrations.CreateModel(
            name='DatasetValidationRoutine',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('taxon_uuid', models.UUIDField(null=True)),
                ('taxon_nuid', models.CharField(max_length=255, null=True)),
                ('taxon_latname', models.CharField(max_length=255, null=True)),
                ('taxon_source', models.CharField(max_length=255, null=True)),
                ('taxon_include_descendants', models.BooleanField(default=False)),
                ('validation_class', models.CharField(choices=[('localcosmos_server.datasets.validation.ExpertReviewValidator', 'Expert Review')], max_length=255)),
                ('position', models.IntegerField(default=0)),
            ],
            options={
                'ordering': ['position'],
            },
        ),
    ]
