# WARNING!
# This is an autogenerated file.
# Do NOT edit this file directly, your changes will be overwritten.

from __future__ import annotations

from typing import Union, Optional, List

from . import core

from .types import (
	Update,
	WebhookInfo,
	User,
	Chat,
	ChatFullInfo,
	Message,
	MessageId,
	InaccessibleMessage,
	MaybeInaccessibleMessage,
	MaybeInaccessibleMessageAdapter,
	MessageEntity,
	TextQuote,
	ExternalReplyInfo,
	ReplyParameters,
	MessageOrigin,
	MessageOriginAdapter,
	MessageOriginUser,
	MessageOriginHiddenUser,
	MessageOriginChat,
	MessageOriginChannel,
	PhotoSize,
	Animation,
	Audio,
	Document,
	Story,
	Video,
	VideoNote,
	Voice,
	PaidMediaInfo,
	PaidMedia,
	PaidMediaAdapter,
	PaidMediaPreview,
	PaidMediaPhoto,
	PaidMediaVideo,
	Contact,
	Dice,
	PollOption,
	InputPollOption,
	PollAnswer,
	Poll,
	ChecklistTask,
	Checklist,
	InputChecklistTask,
	InputChecklist,
	ChecklistTasksDone,
	ChecklistTasksAdded,
	Location,
	Venue,
	WebAppData,
	ProximityAlertTriggered,
	MessageAutoDeleteTimerChanged,
	ChatBoostAdded,
	BackgroundFill,
	BackgroundFillAdapter,
	BackgroundFillSolid,
	BackgroundFillGradient,
	BackgroundFillFreeformGradient,
	BackgroundType,
	BackgroundTypeAdapter,
	BackgroundTypeFill,
	BackgroundTypeWallpaper,
	BackgroundTypePattern,
	BackgroundTypeChatTheme,
	ChatBackground,
	ForumTopicCreated,
	ForumTopicClosed,
	ForumTopicEdited,
	ForumTopicReopened,
	GeneralForumTopicHidden,
	GeneralForumTopicUnhidden,
	SharedUser,
	UsersShared,
	ChatShared,
	WriteAccessAllowed,
	VideoChatScheduled,
	VideoChatStarted,
	VideoChatEnded,
	VideoChatParticipantsInvited,
	PaidMessagePriceChanged,
	DirectMessagePriceChanged,
	SuggestedPostApproved,
	SuggestedPostApprovalFailed,
	SuggestedPostDeclined,
	SuggestedPostPaid,
	SuggestedPostRefunded,
	GiveawayCreated,
	Giveaway,
	GiveawayWinners,
	GiveawayCompleted,
	LinkPreviewOptions,
	SuggestedPostPrice,
	SuggestedPostInfo,
	SuggestedPostParameters,
	DirectMessagesTopic,
	UserProfilePhotos,
	File,
	WebAppInfo,
	ReplyKeyboardMarkup,
	KeyboardButton,
	KeyboardButtonRequestUsers,
	KeyboardButtonRequestChat,
	KeyboardButtonPollType,
	ReplyKeyboardRemove,
	InlineKeyboardMarkup,
	InlineKeyboardButton,
	LoginUrl,
	SwitchInlineQueryChosenChat,
	CopyTextButton,
	CallbackQuery,
	ForceReply,
	ChatPhoto,
	ChatInviteLink,
	ChatAdministratorRights,
	ChatMemberUpdated,
	ChatMember,
	ChatMemberAdapter,
	ChatMemberOwner,
	ChatMemberAdministrator,
	ChatMemberMember,
	ChatMemberRestricted,
	ChatMemberLeft,
	ChatMemberBanned,
	ChatJoinRequest,
	ChatPermissions,
	Birthdate,
	BusinessIntro,
	BusinessLocation,
	BusinessOpeningHoursInterval,
	BusinessOpeningHours,
	StoryAreaPosition,
	LocationAddress,
	StoryAreaType,
	StoryAreaTypeAdapter,
	StoryAreaTypeLocation,
	StoryAreaTypeSuggestedReaction,
	StoryAreaTypeLink,
	StoryAreaTypeWeather,
	StoryAreaTypeUniqueGift,
	StoryArea,
	ChatLocation,
	ReactionType,
	ReactionTypeAdapter,
	ReactionTypeEmoji,
	ReactionTypeCustomEmoji,
	ReactionTypePaid,
	ReactionCount,
	MessageReactionUpdated,
	MessageReactionCountUpdated,
	ForumTopic,
	Gift,
	Gifts,
	UniqueGiftModel,
	UniqueGiftSymbol,
	UniqueGiftBackdropColors,
	UniqueGiftBackdrop,
	UniqueGift,
	GiftInfo,
	UniqueGiftInfo,
	OwnedGift,
	OwnedGiftAdapter,
	OwnedGiftRegular,
	OwnedGiftUnique,
	OwnedGifts,
	AcceptedGiftTypes,
	StarAmount,
	BotCommand,
	BotCommandScope,
	BotCommandScopeAdapter,
	BotCommandScopeDefault,
	BotCommandScopeAllPrivateChats,
	BotCommandScopeAllGroupChats,
	BotCommandScopeAllChatAdministrators,
	BotCommandScopeChat,
	BotCommandScopeChatAdministrators,
	BotCommandScopeChatMember,
	BotName,
	BotDescription,
	BotShortDescription,
	MenuButton,
	MenuButtonAdapter,
	MenuButtonCommands,
	MenuButtonWebApp,
	MenuButtonDefault,
	ChatBoostSource,
	ChatBoostSourceAdapter,
	ChatBoostSourcePremium,
	ChatBoostSourceGiftCode,
	ChatBoostSourceGiveaway,
	ChatBoost,
	ChatBoostUpdated,
	ChatBoostRemoved,
	UserChatBoosts,
	BusinessBotRights,
	BusinessConnection,
	BusinessMessagesDeleted,
	ResponseParameters,
	InputMedia,
	InputMediaAdapter,
	InputMediaPhoto,
	InputMediaVideo,
	InputMediaAnimation,
	InputMediaAudio,
	InputMediaDocument,
	InputFile,
	InputPaidMedia,
	InputPaidMediaAdapter,
	InputPaidMediaPhoto,
	InputPaidMediaVideo,
	InputProfilePhoto,
	InputProfilePhotoAdapter,
	InputProfilePhotoStatic,
	InputProfilePhotoAnimated,
	InputStoryContent,
	InputStoryContentAdapter,
	InputStoryContentPhoto,
	InputStoryContentVideo,
	Sticker,
	StickerSet,
	MaskPosition,
	InputSticker,
	InlineQuery,
	InlineQueryResultsButton,
	InlineQueryResult,
	InlineQueryResultAdapter,
	InlineQueryResultArticle,
	InlineQueryResultPhoto,
	InlineQueryResultGif,
	InlineQueryResultMpeg4Gif,
	InlineQueryResultVideo,
	InlineQueryResultAudio,
	InlineQueryResultVoice,
	InlineQueryResultDocument,
	InlineQueryResultLocation,
	InlineQueryResultVenue,
	InlineQueryResultContact,
	InlineQueryResultGame,
	InlineQueryResultCachedPhoto,
	InlineQueryResultCachedGif,
	InlineQueryResultCachedMpeg4Gif,
	InlineQueryResultCachedSticker,
	InlineQueryResultCachedDocument,
	InlineQueryResultCachedVideo,
	InlineQueryResultCachedVoice,
	InlineQueryResultCachedAudio,
	InputMessageContent,
	InputMessageContentAdapter,
	InputTextMessageContent,
	InputLocationMessageContent,
	InputVenueMessageContent,
	InputContactMessageContent,
	InputInvoiceMessageContent,
	ChosenInlineResult,
	SentWebAppMessage,
	PreparedInlineMessage,
	LabeledPrice,
	Invoice,
	ShippingAddress,
	OrderInfo,
	ShippingOption,
	SuccessfulPayment,
	RefundedPayment,
	ShippingQuery,
	PreCheckoutQuery,
	PaidMediaPurchased,
	RevenueWithdrawalState,
	RevenueWithdrawalStateAdapter,
	RevenueWithdrawalStatePending,
	RevenueWithdrawalStateSucceeded,
	RevenueWithdrawalStateFailed,
	AffiliateInfo,
	TransactionPartner,
	TransactionPartnerAdapter,
	TransactionPartnerUser,
	TransactionPartnerChat,
	TransactionPartnerAffiliateProgram,
	TransactionPartnerFragment,
	TransactionPartnerTelegramAds,
	TransactionPartnerTelegramApi,
	TransactionPartnerOther,
	StarTransaction,
	StarTransactions,
	PassportData,
	PassportFile,
	EncryptedPassportElement,
	EncryptedCredentials,
	PassportElementError,
	PassportElementErrorAdapter,
	PassportElementErrorDataField,
	PassportElementErrorFrontSide,
	PassportElementErrorReverseSide,
	PassportElementErrorSelfie,
	PassportElementErrorFile,
	PassportElementErrorFiles,
	PassportElementErrorTranslationFile,
	PassportElementErrorTranslationFiles,
	PassportElementErrorUnspecified,
	Game,
	CallbackGame,
	GameHighScore,
	IntAdapter,
	StrAdapter,
	FloatAdapter,
	BoolAdapter,
)

class BotAPI(core.BaseBotAPI):
	'''
	Creates an instance of a new Bot API client.

	_Remember to pass an existing `httpx.AsyncClient` instance
	to avoid significant performance degradation in production._
	'''

	async def get_updates(
		self,
		offset: Optional[int] = None,
		limit: Optional[int] = None,
		timeout: Optional[int] = None,
		allowed_updates: Optional[List[str]] = None,
	) -> List[Update]:
		'''
        Use this method to receive incoming updates using
        long polling (wiki). Returns an Array of Update
        objects.

        Reference: https://core.telegram.org/bots/api#getupdates
		'''

		response = await self._send_request('getUpdates', {
			'offset': offset,
			'limit': limit,
			'timeout': timeout,
			'allowed_updates': allowed_updates,
		})
		return [Update.model_validate(x) for x in response]

	async def set_webhook(
		self,
		url: str,
		certificate: Optional[InputFile] = None,
		ip_address: Optional[str] = None,
		max_connections: Optional[int] = None,
		allowed_updates: Optional[List[str]] = None,
		drop_pending_updates: Optional[bool] = None,
		secret_token: Optional[str] = None,
	) -> bool:
		'''
        Use this method to specify a URL and
        receive incoming updates via an outgoing webhook. Whenever
        there is an update for the bot, we
        will send an HTTPS POST request to the
        specified URL, containing a JSON-serialized Update. In case
        of an unsuccessful request (a request with response
        HTTP status code different from 2XY), we will
        repeat the request and give up after a
        reasonable amount of attempts. Returns True on success.

        Reference: https://core.telegram.org/bots/api#setwebhook
		'''

		response = await self._send_request('setWebhook', {
			'url': url,
			'certificate': certificate,
			'ip_address': ip_address,
			'max_connections': max_connections,
			'allowed_updates': allowed_updates,
			'drop_pending_updates': drop_pending_updates,
			'secret_token': secret_token,
		})
		return BoolAdapter.validate_python(response)

	async def delete_webhook(
		self,
		drop_pending_updates: Optional[bool] = None,
	) -> bool:
		'''
        Use this method to remove webhook integration if
        you decide to switch back to getUpdates. Returns
        True on success.

        Reference: https://core.telegram.org/bots/api#deletewebhook
		'''

		response = await self._send_request('deleteWebhook', {
			'drop_pending_updates': drop_pending_updates,
		})
		return BoolAdapter.validate_python(response)

	async def get_webhook_info(
		self,
	) -> WebhookInfo:
		'''
        Use this method to get current webhook status.
        Requires no parameters. On success, returns a WebhookInfo
        object. If the bot is using getUpdates, will
        return an object with the url field empty.

        Reference: https://core.telegram.org/bots/api#getwebhookinfo
		'''

		response = await self._send_request('getWebhookInfo', {})
		return WebhookInfo.model_validate(response)

	async def get_me(
		self,
	) -> User:
		'''
        A simple method for testing your bot's authentication
        token. Requires no parameters. Returns basic information about
        the bot in form of a User object.

        Reference: https://core.telegram.org/bots/api#getme
		'''

		response = await self._send_request('getMe', {})
		return User.model_validate(response)

	async def log_out(
		self,
	) -> bool:
		'''
        Use this method to log out from the
        cloud Bot API server before launching the bot
        locally. You must log out the bot before
        running it locally, otherwise there is no guarantee
        that the bot will receive updates. After a
        successful call, you can immediately log in on
        a local server, but will not be able
        to log in back to the cloud Bot
        API server for 10 minutes. Returns True on
        success. Requires no parameters.

        Reference: https://core.telegram.org/bots/api#logout
		'''

		response = await self._send_request('logOut', {})
		return BoolAdapter.validate_python(response)

	async def close(
		self,
	) -> bool:
		'''
        Use this method to close the bot instance
        before moving it from one local server to
        another. You need to delete the webhook before
        calling this method to ensure that the bot
        isn't launched again after server restart. The method
        will return error 429 in the first 10
        minutes after the bot is launched. Returns True
        on success. Requires no parameters.

        Reference: https://core.telegram.org/bots/api#close
		'''

		response = await self._send_request('close', {})
		return BoolAdapter.validate_python(response)

	async def send_message(
		self,
		chat_id: Union[int, str],
		text: str,
		business_connection_id: Optional[str] = None,
		message_thread_id: Optional[int] = None,
		direct_messages_topic_id: Optional[int] = None,
		parse_mode: Optional[str] = 'HTML',
		entities: Optional[List[MessageEntity]] = None,
		link_preview_options: Optional[LinkPreviewOptions] = None,
		disable_notification: Optional[bool] = None,
		protect_content: Optional[bool] = None,
		allow_paid_broadcast: Optional[bool] = None,
		message_effect_id: Optional[str] = None,
		suggested_post_parameters: Optional[SuggestedPostParameters] = None,
		reply_parameters: Optional[ReplyParameters] = None,
		reply_markup: Optional[Union[InlineKeyboardMarkup, ReplyKeyboardMarkup, ReplyKeyboardRemove, ForceReply]] = None,
	) -> Message:
		'''
        Use this method to send text messages. On
        success, the sent Message is returned.

        Reference: https://core.telegram.org/bots/api#sendmessage
		'''

		response = await self._send_request('sendMessage', {
			'business_connection_id': business_connection_id,
			'chat_id': chat_id,
			'message_thread_id': message_thread_id,
			'direct_messages_topic_id': direct_messages_topic_id,
			'text': text,
			'parse_mode': parse_mode if not entities else None, # FIX,
			'entities': entities,
			'link_preview_options': link_preview_options,
			'disable_notification': disable_notification,
			'protect_content': protect_content,
			'allow_paid_broadcast': allow_paid_broadcast,
			'message_effect_id': message_effect_id,
			'suggested_post_parameters': suggested_post_parameters,
			'reply_parameters': reply_parameters,
			'reply_markup': reply_markup,
		})
		return Message.model_validate(response)

	async def forward_message(
		self,
		chat_id: Union[int, str],
		from_chat_id: Union[int, str],
		message_id: int,
		message_thread_id: Optional[int] = None,
		direct_messages_topic_id: Optional[int] = None,
		video_start_timestamp: Optional[int] = None,
		disable_notification: Optional[bool] = None,
		protect_content: Optional[bool] = None,
		suggested_post_parameters: Optional[SuggestedPostParameters] = None,
	) -> Message:
		'''
        Use this method to forward messages of any
        kind. Service messages and messages with protected content
        can't be forwarded. On success, the sent Message
        is returned.

        Reference: https://core.telegram.org/bots/api#forwardmessage
		'''

		response = await self._send_request('forwardMessage', {
			'chat_id': chat_id,
			'message_thread_id': message_thread_id,
			'direct_messages_topic_id': direct_messages_topic_id,
			'from_chat_id': from_chat_id,
			'video_start_timestamp': video_start_timestamp,
			'disable_notification': disable_notification,
			'protect_content': protect_content,
			'suggested_post_parameters': suggested_post_parameters,
			'message_id': message_id,
		})
		return Message.model_validate(response)

	async def forward_messages(
		self,
		chat_id: Union[int, str],
		from_chat_id: Union[int, str],
		message_ids: List[int],
		message_thread_id: Optional[int] = None,
		direct_messages_topic_id: Optional[int] = None,
		disable_notification: Optional[bool] = None,
		protect_content: Optional[bool] = None,
	) -> List[MessageId]:
		'''
        Use this method to forward multiple messages of
        any kind. If some of the specified messages
        can't be found or forwarded, they are skipped.
        Service messages and messages with protected content can't
        be forwarded. Album grouping is kept for forwarded
        messages. On success, an array of MessageId of
        the sent messages is returned.

        Reference: https://core.telegram.org/bots/api#forwardmessages
		'''

		response = await self._send_request('forwardMessages', {
			'chat_id': chat_id,
			'message_thread_id': message_thread_id,
			'direct_messages_topic_id': direct_messages_topic_id,
			'from_chat_id': from_chat_id,
			'message_ids': message_ids,
			'disable_notification': disable_notification,
			'protect_content': protect_content,
		})
		return [MessageId.model_validate(x) for x in response]

	async def copy_message(
		self,
		chat_id: Union[int, str],
		from_chat_id: Union[int, str],
		message_id: int,
		message_thread_id: Optional[int] = None,
		direct_messages_topic_id: Optional[int] = None,
		video_start_timestamp: Optional[int] = None,
		caption: Optional[str] = None,
		parse_mode: Optional[str] = 'HTML',
		caption_entities: Optional[List[MessageEntity]] = None,
		show_caption_above_media: Optional[bool] = None,
		disable_notification: Optional[bool] = None,
		protect_content: Optional[bool] = None,
		allow_paid_broadcast: Optional[bool] = None,
		suggested_post_parameters: Optional[SuggestedPostParameters] = None,
		reply_parameters: Optional[ReplyParameters] = None,
		reply_markup: Optional[Union[InlineKeyboardMarkup, ReplyKeyboardMarkup, ReplyKeyboardRemove, ForceReply]] = None,
	) -> MessageId:
		'''
        Use this method to copy messages of any
        kind. Service messages, paid media messages, giveaway messages,
        giveaway winners messages, and invoice messages can't be
        copied. A quiz poll can be copied only
        if the value of the field correct_option_id is
        known to the bot. The method is analogous
        to the method forwardMessage, but the copied message
        doesn't have a link to the original message.
        Returns the MessageId of the sent message on
        success.

        Reference: https://core.telegram.org/bots/api#copymessage
		'''

		response = await self._send_request('copyMessage', {
			'chat_id': chat_id,
			'message_thread_id': message_thread_id,
			'direct_messages_topic_id': direct_messages_topic_id,
			'from_chat_id': from_chat_id,
			'message_id': message_id,
			'video_start_timestamp': video_start_timestamp,
			'caption': caption,
			'parse_mode': parse_mode if not caption_entities else None, # FIX,
			'caption_entities': caption_entities,
			'show_caption_above_media': show_caption_above_media,
			'disable_notification': disable_notification,
			'protect_content': protect_content,
			'allow_paid_broadcast': allow_paid_broadcast,
			'suggested_post_parameters': suggested_post_parameters,
			'reply_parameters': reply_parameters,
			'reply_markup': reply_markup,
		})
		return MessageId.model_validate(response)

	async def copy_messages(
		self,
		chat_id: Union[int, str],
		from_chat_id: Union[int, str],
		message_ids: List[int],
		message_thread_id: Optional[int] = None,
		direct_messages_topic_id: Optional[int] = None,
		disable_notification: Optional[bool] = None,
		protect_content: Optional[bool] = None,
		remove_caption: Optional[bool] = None,
	) -> List[MessageId]:
		'''
        Use this method to copy messages of any
        kind. If some of the specified messages can't
        be found or copied, they are skipped. Service
        messages, paid media messages, giveaway messages, giveaway winners
        messages, and invoice messages can't be copied. A
        quiz poll can be copied only if the
        value of the field correct_option_id is known to
        the bot. The method is analogous to the
        method forwardMessages, but the copied messages don't have
        a link to the original message. Album grouping
        is kept for copied messages. On success, an
        array of MessageId of the sent messages is
        returned.

        Reference: https://core.telegram.org/bots/api#copymessages
		'''

		response = await self._send_request('copyMessages', {
			'chat_id': chat_id,
			'message_thread_id': message_thread_id,
			'direct_messages_topic_id': direct_messages_topic_id,
			'from_chat_id': from_chat_id,
			'message_ids': message_ids,
			'disable_notification': disable_notification,
			'protect_content': protect_content,
			'remove_caption': remove_caption,
		})
		return [MessageId.model_validate(x) for x in response]

	async def send_photo(
		self,
		chat_id: Union[int, str],
		photo: Union[InputFile, str],
		business_connection_id: Optional[str] = None,
		message_thread_id: Optional[int] = None,
		direct_messages_topic_id: Optional[int] = None,
		caption: Optional[str] = None,
		parse_mode: Optional[str] = 'HTML',
		caption_entities: Optional[List[MessageEntity]] = None,
		show_caption_above_media: Optional[bool] = None,
		has_spoiler: Optional[bool] = None,
		disable_notification: Optional[bool] = None,
		protect_content: Optional[bool] = None,
		allow_paid_broadcast: Optional[bool] = None,
		message_effect_id: Optional[str] = None,
		suggested_post_parameters: Optional[SuggestedPostParameters] = None,
		reply_parameters: Optional[ReplyParameters] = None,
		reply_markup: Optional[Union[InlineKeyboardMarkup, ReplyKeyboardMarkup, ReplyKeyboardRemove, ForceReply]] = None,
	) -> Message:
		'''
        Use this method to send photos. On success,
        the sent Message is returned.

        Reference: https://core.telegram.org/bots/api#sendphoto
		'''

		response = await self._send_request('sendPhoto', {
			'business_connection_id': business_connection_id,
			'chat_id': chat_id,
			'message_thread_id': message_thread_id,
			'direct_messages_topic_id': direct_messages_topic_id,
			'photo': photo,
			'caption': caption,
			'parse_mode': parse_mode if not caption_entities else None, # FIX,
			'caption_entities': caption_entities,
			'show_caption_above_media': show_caption_above_media,
			'has_spoiler': has_spoiler,
			'disable_notification': disable_notification,
			'protect_content': protect_content,
			'allow_paid_broadcast': allow_paid_broadcast,
			'message_effect_id': message_effect_id,
			'suggested_post_parameters': suggested_post_parameters,
			'reply_parameters': reply_parameters,
			'reply_markup': reply_markup,
		})
		return Message.model_validate(response)

	async def send_audio(
		self,
		chat_id: Union[int, str],
		audio: Union[InputFile, str],
		business_connection_id: Optional[str] = None,
		message_thread_id: Optional[int] = None,
		direct_messages_topic_id: Optional[int] = None,
		caption: Optional[str] = None,
		parse_mode: Optional[str] = 'HTML',
		caption_entities: Optional[List[MessageEntity]] = None,
		duration: Optional[int] = None,
		performer: Optional[str] = None,
		title: Optional[str] = None,
		thumbnail: Optional[Union[InputFile, str]] = None,
		disable_notification: Optional[bool] = None,
		protect_content: Optional[bool] = None,
		allow_paid_broadcast: Optional[bool] = None,
		message_effect_id: Optional[str] = None,
		suggested_post_parameters: Optional[SuggestedPostParameters] = None,
		reply_parameters: Optional[ReplyParameters] = None,
		reply_markup: Optional[Union[InlineKeyboardMarkup, ReplyKeyboardMarkup, ReplyKeyboardRemove, ForceReply]] = None,
	) -> Message:
		'''
        Use this method to send audio files, if
        you want Telegram clients to display them in
        the music player. Your audio must be in
        the .MP3 or .M4A format. On success, the
        sent Message is returned. Bots can currently send
        audio files of up to 50 MB in
        size, this limit may be changed in the
        future.

        Reference: https://core.telegram.org/bots/api#sendaudio
		'''

		response = await self._send_request('sendAudio', {
			'business_connection_id': business_connection_id,
			'chat_id': chat_id,
			'message_thread_id': message_thread_id,
			'direct_messages_topic_id': direct_messages_topic_id,
			'audio': audio,
			'caption': caption,
			'parse_mode': parse_mode if not caption_entities else None, # FIX,
			'caption_entities': caption_entities,
			'duration': duration,
			'performer': performer,
			'title': title,
			'thumbnail': thumbnail,
			'disable_notification': disable_notification,
			'protect_content': protect_content,
			'allow_paid_broadcast': allow_paid_broadcast,
			'message_effect_id': message_effect_id,
			'suggested_post_parameters': suggested_post_parameters,
			'reply_parameters': reply_parameters,
			'reply_markup': reply_markup,
		})
		return Message.model_validate(response)

	async def send_document(
		self,
		chat_id: Union[int, str],
		document: Union[InputFile, str],
		business_connection_id: Optional[str] = None,
		message_thread_id: Optional[int] = None,
		direct_messages_topic_id: Optional[int] = None,
		thumbnail: Optional[Union[InputFile, str]] = None,
		caption: Optional[str] = None,
		parse_mode: Optional[str] = 'HTML',
		caption_entities: Optional[List[MessageEntity]] = None,
		disable_content_type_detection: Optional[bool] = None,
		disable_notification: Optional[bool] = None,
		protect_content: Optional[bool] = None,
		allow_paid_broadcast: Optional[bool] = None,
		message_effect_id: Optional[str] = None,
		suggested_post_parameters: Optional[SuggestedPostParameters] = None,
		reply_parameters: Optional[ReplyParameters] = None,
		reply_markup: Optional[Union[InlineKeyboardMarkup, ReplyKeyboardMarkup, ReplyKeyboardRemove, ForceReply]] = None,
	) -> Message:
		'''
        Use this method to send general files. On
        success, the sent Message is returned. Bots can
        currently send files of any type of up
        to 50 MB in size, this limit may
        be changed in the future.

        Reference: https://core.telegram.org/bots/api#senddocument
		'''

		response = await self._send_request('sendDocument', {
			'business_connection_id': business_connection_id,
			'chat_id': chat_id,
			'message_thread_id': message_thread_id,
			'direct_messages_topic_id': direct_messages_topic_id,
			'document': document,
			'thumbnail': thumbnail,
			'caption': caption,
			'parse_mode': parse_mode if not caption_entities else None, # FIX,
			'caption_entities': caption_entities,
			'disable_content_type_detection': disable_content_type_detection,
			'disable_notification': disable_notification,
			'protect_content': protect_content,
			'allow_paid_broadcast': allow_paid_broadcast,
			'message_effect_id': message_effect_id,
			'suggested_post_parameters': suggested_post_parameters,
			'reply_parameters': reply_parameters,
			'reply_markup': reply_markup,
		})
		return Message.model_validate(response)

	async def send_video(
		self,
		chat_id: Union[int, str],
		video: Union[InputFile, str],
		business_connection_id: Optional[str] = None,
		message_thread_id: Optional[int] = None,
		direct_messages_topic_id: Optional[int] = None,
		duration: Optional[int] = None,
		width: Optional[int] = None,
		height: Optional[int] = None,
		thumbnail: Optional[Union[InputFile, str]] = None,
		cover: Optional[Union[InputFile, str]] = None,
		start_timestamp: Optional[int] = None,
		caption: Optional[str] = None,
		parse_mode: Optional[str] = 'HTML',
		caption_entities: Optional[List[MessageEntity]] = None,
		show_caption_above_media: Optional[bool] = None,
		has_spoiler: Optional[bool] = None,
		supports_streaming: Optional[bool] = None,
		disable_notification: Optional[bool] = None,
		protect_content: Optional[bool] = None,
		allow_paid_broadcast: Optional[bool] = None,
		message_effect_id: Optional[str] = None,
		suggested_post_parameters: Optional[SuggestedPostParameters] = None,
		reply_parameters: Optional[ReplyParameters] = None,
		reply_markup: Optional[Union[InlineKeyboardMarkup, ReplyKeyboardMarkup, ReplyKeyboardRemove, ForceReply]] = None,
	) -> Message:
		'''
        Use this method to send video files, Telegram
        clients support MPEG4 videos (other formats may be
        sent as Document). On success, the sent Message
        is returned. Bots can currently send video files
        of up to 50 MB in size, this
        limit may be changed in the future.

        Reference: https://core.telegram.org/bots/api#sendvideo
		'''

		response = await self._send_request('sendVideo', {
			'business_connection_id': business_connection_id,
			'chat_id': chat_id,
			'message_thread_id': message_thread_id,
			'direct_messages_topic_id': direct_messages_topic_id,
			'video': video,
			'duration': duration,
			'width': width,
			'height': height,
			'thumbnail': thumbnail,
			'cover': cover,
			'start_timestamp': start_timestamp,
			'caption': caption,
			'parse_mode': parse_mode if not caption_entities else None, # FIX,
			'caption_entities': caption_entities,
			'show_caption_above_media': show_caption_above_media,
			'has_spoiler': has_spoiler,
			'supports_streaming': supports_streaming,
			'disable_notification': disable_notification,
			'protect_content': protect_content,
			'allow_paid_broadcast': allow_paid_broadcast,
			'message_effect_id': message_effect_id,
			'suggested_post_parameters': suggested_post_parameters,
			'reply_parameters': reply_parameters,
			'reply_markup': reply_markup,
		})
		return Message.model_validate(response)

	async def send_animation(
		self,
		chat_id: Union[int, str],
		animation: Union[InputFile, str],
		business_connection_id: Optional[str] = None,
		message_thread_id: Optional[int] = None,
		direct_messages_topic_id: Optional[int] = None,
		duration: Optional[int] = None,
		width: Optional[int] = None,
		height: Optional[int] = None,
		thumbnail: Optional[Union[InputFile, str]] = None,
		caption: Optional[str] = None,
		parse_mode: Optional[str] = 'HTML',
		caption_entities: Optional[List[MessageEntity]] = None,
		show_caption_above_media: Optional[bool] = None,
		has_spoiler: Optional[bool] = None,
		disable_notification: Optional[bool] = None,
		protect_content: Optional[bool] = None,
		allow_paid_broadcast: Optional[bool] = None,
		message_effect_id: Optional[str] = None,
		suggested_post_parameters: Optional[SuggestedPostParameters] = None,
		reply_parameters: Optional[ReplyParameters] = None,
		reply_markup: Optional[Union[InlineKeyboardMarkup, ReplyKeyboardMarkup, ReplyKeyboardRemove, ForceReply]] = None,
	) -> Message:
		'''
        Use this method to send animation files (GIF
        or H.264/MPEG-4 AVC video without sound). On success,
        the sent Message is returned. Bots can currently
        send animation files of up to 50 MB
        in size, this limit may be changed in
        the future.

        Reference: https://core.telegram.org/bots/api#sendanimation
		'''

		response = await self._send_request('sendAnimation', {
			'business_connection_id': business_connection_id,
			'chat_id': chat_id,
			'message_thread_id': message_thread_id,
			'direct_messages_topic_id': direct_messages_topic_id,
			'animation': animation,
			'duration': duration,
			'width': width,
			'height': height,
			'thumbnail': thumbnail,
			'caption': caption,
			'parse_mode': parse_mode if not caption_entities else None, # FIX,
			'caption_entities': caption_entities,
			'show_caption_above_media': show_caption_above_media,
			'has_spoiler': has_spoiler,
			'disable_notification': disable_notification,
			'protect_content': protect_content,
			'allow_paid_broadcast': allow_paid_broadcast,
			'message_effect_id': message_effect_id,
			'suggested_post_parameters': suggested_post_parameters,
			'reply_parameters': reply_parameters,
			'reply_markup': reply_markup,
		})
		return Message.model_validate(response)

	async def send_voice(
		self,
		chat_id: Union[int, str],
		voice: Union[InputFile, str],
		business_connection_id: Optional[str] = None,
		message_thread_id: Optional[int] = None,
		direct_messages_topic_id: Optional[int] = None,
		caption: Optional[str] = None,
		parse_mode: Optional[str] = 'HTML',
		caption_entities: Optional[List[MessageEntity]] = None,
		duration: Optional[int] = None,
		disable_notification: Optional[bool] = None,
		protect_content: Optional[bool] = None,
		allow_paid_broadcast: Optional[bool] = None,
		message_effect_id: Optional[str] = None,
		suggested_post_parameters: Optional[SuggestedPostParameters] = None,
		reply_parameters: Optional[ReplyParameters] = None,
		reply_markup: Optional[Union[InlineKeyboardMarkup, ReplyKeyboardMarkup, ReplyKeyboardRemove, ForceReply]] = None,
	) -> Message:
		'''
        Use this method to send audio files, if
        you want Telegram clients to display the file
        as a playable voice message. For this to
        work, your audio must be in an .OGG
        file encoded with OPUS, or in .MP3 format,
        or in .M4A format (other formats may be
        sent as Audio or Document). On success, the
        sent Message is returned. Bots can currently send
        voice messages of up to 50 MB in
        size, this limit may be changed in the
        future.

        Reference: https://core.telegram.org/bots/api#sendvoice
		'''

		response = await self._send_request('sendVoice', {
			'business_connection_id': business_connection_id,
			'chat_id': chat_id,
			'message_thread_id': message_thread_id,
			'direct_messages_topic_id': direct_messages_topic_id,
			'voice': voice,
			'caption': caption,
			'parse_mode': parse_mode if not caption_entities else None, # FIX,
			'caption_entities': caption_entities,
			'duration': duration,
			'disable_notification': disable_notification,
			'protect_content': protect_content,
			'allow_paid_broadcast': allow_paid_broadcast,
			'message_effect_id': message_effect_id,
			'suggested_post_parameters': suggested_post_parameters,
			'reply_parameters': reply_parameters,
			'reply_markup': reply_markup,
		})
		return Message.model_validate(response)

	async def send_video_note(
		self,
		chat_id: Union[int, str],
		video_note: Union[InputFile, str],
		business_connection_id: Optional[str] = None,
		message_thread_id: Optional[int] = None,
		direct_messages_topic_id: Optional[int] = None,
		duration: Optional[int] = None,
		length: Optional[int] = None,
		thumbnail: Optional[Union[InputFile, str]] = None,
		disable_notification: Optional[bool] = None,
		protect_content: Optional[bool] = None,
		allow_paid_broadcast: Optional[bool] = None,
		message_effect_id: Optional[str] = None,
		suggested_post_parameters: Optional[SuggestedPostParameters] = None,
		reply_parameters: Optional[ReplyParameters] = None,
		reply_markup: Optional[Union[InlineKeyboardMarkup, ReplyKeyboardMarkup, ReplyKeyboardRemove, ForceReply]] = None,
	) -> Message:
		'''
        As of v.4.0, Telegram clients support rounded square
        MPEG4 videos of up to 1 minute long.
        Use this method to send video messages. On
        success, the sent Message is returned.

        Reference: https://core.telegram.org/bots/api#sendvideonote
		'''

		response = await self._send_request('sendVideoNote', {
			'business_connection_id': business_connection_id,
			'chat_id': chat_id,
			'message_thread_id': message_thread_id,
			'direct_messages_topic_id': direct_messages_topic_id,
			'video_note': video_note,
			'duration': duration,
			'length': length,
			'thumbnail': thumbnail,
			'disable_notification': disable_notification,
			'protect_content': protect_content,
			'allow_paid_broadcast': allow_paid_broadcast,
			'message_effect_id': message_effect_id,
			'suggested_post_parameters': suggested_post_parameters,
			'reply_parameters': reply_parameters,
			'reply_markup': reply_markup,
		})
		return Message.model_validate(response)

	async def send_paid_media(
		self,
		chat_id: Union[int, str],
		star_count: int,
		media: List[InputPaidMedia],
		business_connection_id: Optional[str] = None,
		message_thread_id: Optional[int] = None,
		direct_messages_topic_id: Optional[int] = None,
		payload: Optional[str] = None,
		caption: Optional[str] = None,
		parse_mode: Optional[str] = 'HTML',
		caption_entities: Optional[List[MessageEntity]] = None,
		show_caption_above_media: Optional[bool] = None,
		disable_notification: Optional[bool] = None,
		protect_content: Optional[bool] = None,
		allow_paid_broadcast: Optional[bool] = None,
		suggested_post_parameters: Optional[SuggestedPostParameters] = None,
		reply_parameters: Optional[ReplyParameters] = None,
		reply_markup: Optional[Union[InlineKeyboardMarkup, ReplyKeyboardMarkup, ReplyKeyboardRemove, ForceReply]] = None,
	) -> Message:
		'''
        Use this method to send paid media. On
        success, the sent Message is returned.

        Reference: https://core.telegram.org/bots/api#sendpaidmedia
		'''

		response = await self._send_request('sendPaidMedia', {
			'business_connection_id': business_connection_id,
			'chat_id': chat_id,
			'message_thread_id': message_thread_id,
			'direct_messages_topic_id': direct_messages_topic_id,
			'star_count': star_count,
			'media': media,
			'payload': payload,
			'caption': caption,
			'parse_mode': parse_mode if not caption_entities else None, # FIX,
			'caption_entities': caption_entities,
			'show_caption_above_media': show_caption_above_media,
			'disable_notification': disable_notification,
			'protect_content': protect_content,
			'allow_paid_broadcast': allow_paid_broadcast,
			'suggested_post_parameters': suggested_post_parameters,
			'reply_parameters': reply_parameters,
			'reply_markup': reply_markup,
		})
		return Message.model_validate(response)

	async def send_media_group(
		self,
		chat_id: Union[int, str],
		media: List[Union[InputMediaAudio, InputMediaDocument, InputMediaPhoto, InputMediaVideo]],
		business_connection_id: Optional[str] = None,
		message_thread_id: Optional[int] = None,
		direct_messages_topic_id: Optional[int] = None,
		disable_notification: Optional[bool] = None,
		protect_content: Optional[bool] = None,
		allow_paid_broadcast: Optional[bool] = None,
		message_effect_id: Optional[str] = None,
		reply_parameters: Optional[ReplyParameters] = None,
	) -> List[Message]:
		'''
        Use this method to send a group of
        photos, videos, documents or audios as an album.
        Documents and audio files can be only grouped
        in an album with messages of the same
        type. On success, an array of Message objects
        that were sent is returned.

        Reference: https://core.telegram.org/bots/api#sendmediagroup
		'''

		response = await self._send_request('sendMediaGroup', {
			'business_connection_id': business_connection_id,
			'chat_id': chat_id,
			'message_thread_id': message_thread_id,
			'direct_messages_topic_id': direct_messages_topic_id,
			'media': media,
			'disable_notification': disable_notification,
			'protect_content': protect_content,
			'allow_paid_broadcast': allow_paid_broadcast,
			'message_effect_id': message_effect_id,
			'reply_parameters': reply_parameters,
		})
		return [Message.model_validate(x) for x in response]

	async def send_location(
		self,
		chat_id: Union[int, str],
		latitude: float,
		longitude: float,
		business_connection_id: Optional[str] = None,
		message_thread_id: Optional[int] = None,
		direct_messages_topic_id: Optional[int] = None,
		horizontal_accuracy: Optional[float] = None,
		live_period: Optional[int] = None,
		heading: Optional[int] = None,
		proximity_alert_radius: Optional[int] = None,
		disable_notification: Optional[bool] = None,
		protect_content: Optional[bool] = None,
		allow_paid_broadcast: Optional[bool] = None,
		message_effect_id: Optional[str] = None,
		suggested_post_parameters: Optional[SuggestedPostParameters] = None,
		reply_parameters: Optional[ReplyParameters] = None,
		reply_markup: Optional[Union[InlineKeyboardMarkup, ReplyKeyboardMarkup, ReplyKeyboardRemove, ForceReply]] = None,
	) -> Message:
		'''
        Use this method to send point on the
        map. On success, the sent Message is returned.

        Reference: https://core.telegram.org/bots/api#sendlocation
		'''

		response = await self._send_request('sendLocation', {
			'business_connection_id': business_connection_id,
			'chat_id': chat_id,
			'message_thread_id': message_thread_id,
			'direct_messages_topic_id': direct_messages_topic_id,
			'latitude': latitude,
			'longitude': longitude,
			'horizontal_accuracy': horizontal_accuracy,
			'live_period': live_period,
			'heading': heading,
			'proximity_alert_radius': proximity_alert_radius,
			'disable_notification': disable_notification,
			'protect_content': protect_content,
			'allow_paid_broadcast': allow_paid_broadcast,
			'message_effect_id': message_effect_id,
			'suggested_post_parameters': suggested_post_parameters,
			'reply_parameters': reply_parameters,
			'reply_markup': reply_markup,
		})
		return Message.model_validate(response)

	async def send_venue(
		self,
		chat_id: Union[int, str],
		latitude: float,
		longitude: float,
		title: str,
		address: str,
		business_connection_id: Optional[str] = None,
		message_thread_id: Optional[int] = None,
		direct_messages_topic_id: Optional[int] = None,
		foursquare_id: Optional[str] = None,
		foursquare_type: Optional[str] = None,
		google_place_id: Optional[str] = None,
		google_place_type: Optional[str] = None,
		disable_notification: Optional[bool] = None,
		protect_content: Optional[bool] = None,
		allow_paid_broadcast: Optional[bool] = None,
		message_effect_id: Optional[str] = None,
		suggested_post_parameters: Optional[SuggestedPostParameters] = None,
		reply_parameters: Optional[ReplyParameters] = None,
		reply_markup: Optional[Union[InlineKeyboardMarkup, ReplyKeyboardMarkup, ReplyKeyboardRemove, ForceReply]] = None,
	) -> Message:
		'''
        Use this method to send information about a
        venue. On success, the sent Message is returned.

        Reference: https://core.telegram.org/bots/api#sendvenue
		'''

		response = await self._send_request('sendVenue', {
			'business_connection_id': business_connection_id,
			'chat_id': chat_id,
			'message_thread_id': message_thread_id,
			'direct_messages_topic_id': direct_messages_topic_id,
			'latitude': latitude,
			'longitude': longitude,
			'title': title,
			'address': address,
			'foursquare_id': foursquare_id,
			'foursquare_type': foursquare_type,
			'google_place_id': google_place_id,
			'google_place_type': google_place_type,
			'disable_notification': disable_notification,
			'protect_content': protect_content,
			'allow_paid_broadcast': allow_paid_broadcast,
			'message_effect_id': message_effect_id,
			'suggested_post_parameters': suggested_post_parameters,
			'reply_parameters': reply_parameters,
			'reply_markup': reply_markup,
		})
		return Message.model_validate(response)

	async def send_contact(
		self,
		chat_id: Union[int, str],
		phone_number: str,
		first_name: str,
		business_connection_id: Optional[str] = None,
		message_thread_id: Optional[int] = None,
		direct_messages_topic_id: Optional[int] = None,
		last_name: Optional[str] = None,
		vcard: Optional[str] = None,
		disable_notification: Optional[bool] = None,
		protect_content: Optional[bool] = None,
		allow_paid_broadcast: Optional[bool] = None,
		message_effect_id: Optional[str] = None,
		suggested_post_parameters: Optional[SuggestedPostParameters] = None,
		reply_parameters: Optional[ReplyParameters] = None,
		reply_markup: Optional[Union[InlineKeyboardMarkup, ReplyKeyboardMarkup, ReplyKeyboardRemove, ForceReply]] = None,
	) -> Message:
		'''
        Use this method to send phone contacts. On
        success, the sent Message is returned.

        Reference: https://core.telegram.org/bots/api#sendcontact
		'''

		response = await self._send_request('sendContact', {
			'business_connection_id': business_connection_id,
			'chat_id': chat_id,
			'message_thread_id': message_thread_id,
			'direct_messages_topic_id': direct_messages_topic_id,
			'phone_number': phone_number,
			'first_name': first_name,
			'last_name': last_name,
			'vcard': vcard,
			'disable_notification': disable_notification,
			'protect_content': protect_content,
			'allow_paid_broadcast': allow_paid_broadcast,
			'message_effect_id': message_effect_id,
			'suggested_post_parameters': suggested_post_parameters,
			'reply_parameters': reply_parameters,
			'reply_markup': reply_markup,
		})
		return Message.model_validate(response)

	async def send_poll(
		self,
		chat_id: Union[int, str],
		question: str,
		options: List[InputPollOption],
		business_connection_id: Optional[str] = None,
		message_thread_id: Optional[int] = None,
		question_parse_mode: Optional[str] = None,
		question_entities: Optional[List[MessageEntity]] = None,
		is_anonymous: Optional[bool] = None,
		type: Optional[str] = None,
		allows_multiple_answers: Optional[bool] = None,
		correct_option_id: Optional[int] = None,
		explanation: Optional[str] = None,
		explanation_parse_mode: Optional[str] = None,
		explanation_entities: Optional[List[MessageEntity]] = None,
		open_period: Optional[int] = None,
		close_date: Optional[int] = None,
		is_closed: Optional[bool] = None,
		disable_notification: Optional[bool] = None,
		protect_content: Optional[bool] = None,
		allow_paid_broadcast: Optional[bool] = None,
		message_effect_id: Optional[str] = None,
		reply_parameters: Optional[ReplyParameters] = None,
		reply_markup: Optional[Union[InlineKeyboardMarkup, ReplyKeyboardMarkup, ReplyKeyboardRemove, ForceReply]] = None,
	) -> Message:
		'''
        Use this method to send a native poll.
        On success, the sent Message is returned.

        Reference: https://core.telegram.org/bots/api#sendpoll
		'''

		response = await self._send_request('sendPoll', {
			'business_connection_id': business_connection_id,
			'chat_id': chat_id,
			'message_thread_id': message_thread_id,
			'question': question,
			'question_parse_mode': question_parse_mode,
			'question_entities': question_entities,
			'options': options,
			'is_anonymous': is_anonymous,
			'type': type,
			'allows_multiple_answers': allows_multiple_answers,
			'correct_option_id': correct_option_id,
			'explanation': explanation,
			'explanation_parse_mode': explanation_parse_mode,
			'explanation_entities': explanation_entities,
			'open_period': open_period,
			'close_date': close_date,
			'is_closed': is_closed,
			'disable_notification': disable_notification,
			'protect_content': protect_content,
			'allow_paid_broadcast': allow_paid_broadcast,
			'message_effect_id': message_effect_id,
			'reply_parameters': reply_parameters,
			'reply_markup': reply_markup,
		})
		return Message.model_validate(response)

	async def send_checklist(
		self,
		business_connection_id: str,
		chat_id: int,
		checklist: InputChecklist,
		disable_notification: Optional[bool] = None,
		protect_content: Optional[bool] = None,
		message_effect_id: Optional[str] = None,
		reply_parameters: Optional[ReplyParameters] = None,
		reply_markup: Optional[InlineKeyboardMarkup] = None,
	) -> Message:
		'''
        Use this method to send a checklist on
        behalf of a connected business account. On success,
        the sent Message is returned.

        Reference: https://core.telegram.org/bots/api#sendchecklist
		'''

		response = await self._send_request('sendChecklist', {
			'business_connection_id': business_connection_id,
			'chat_id': chat_id,
			'checklist': checklist,
			'disable_notification': disable_notification,
			'protect_content': protect_content,
			'message_effect_id': message_effect_id,
			'reply_parameters': reply_parameters,
			'reply_markup': reply_markup,
		})
		return Message.model_validate(response)

	async def send_dice(
		self,
		chat_id: Union[int, str],
		business_connection_id: Optional[str] = None,
		message_thread_id: Optional[int] = None,
		direct_messages_topic_id: Optional[int] = None,
		emoji: Optional[str] = None,
		disable_notification: Optional[bool] = None,
		protect_content: Optional[bool] = None,
		allow_paid_broadcast: Optional[bool] = None,
		message_effect_id: Optional[str] = None,
		suggested_post_parameters: Optional[SuggestedPostParameters] = None,
		reply_parameters: Optional[ReplyParameters] = None,
		reply_markup: Optional[Union[InlineKeyboardMarkup, ReplyKeyboardMarkup, ReplyKeyboardRemove, ForceReply]] = None,
	) -> Message:
		'''
        Use this method to send an animated emoji
        that will display a random value. On success,
        the sent Message is returned.

        Reference: https://core.telegram.org/bots/api#senddice
		'''

		response = await self._send_request('sendDice', {
			'business_connection_id': business_connection_id,
			'chat_id': chat_id,
			'message_thread_id': message_thread_id,
			'direct_messages_topic_id': direct_messages_topic_id,
			'emoji': emoji,
			'disable_notification': disable_notification,
			'protect_content': protect_content,
			'allow_paid_broadcast': allow_paid_broadcast,
			'message_effect_id': message_effect_id,
			'suggested_post_parameters': suggested_post_parameters,
			'reply_parameters': reply_parameters,
			'reply_markup': reply_markup,
		})
		return Message.model_validate(response)

	async def send_chat_action(
		self,
		chat_id: Union[int, str],
		action: str,
		business_connection_id: Optional[str] = None,
		message_thread_id: Optional[int] = None,
	) -> bool:
		'''
        Use this method when you need to tell
        the user that something is happening on the
        bot's side. The status is set for 5
        seconds or less (when a message arrives from
        your bot, Telegram clients clear its typing status).
        Returns True on success.

        Reference: https://core.telegram.org/bots/api#sendchataction
		'''

		response = await self._send_request('sendChatAction', {
			'business_connection_id': business_connection_id,
			'chat_id': chat_id,
			'message_thread_id': message_thread_id,
			'action': action,
		})
		return BoolAdapter.validate_python(response)

	async def set_message_reaction(
		self,
		chat_id: Union[int, str],
		message_id: int,
		reaction: Optional[List[ReactionType]] = None,
		is_big: Optional[bool] = None,
	) -> bool:
		'''
        Use this method to change the chosen reactions
        on a message. Service messages of some types
        can't be reacted to. Automatically forwarded messages from
        a channel to its discussion group have the
        same available reactions as messages in the channel.
        Bots can't use paid reactions. Returns True on
        success.

        Reference: https://core.telegram.org/bots/api#setmessagereaction
		'''

		response = await self._send_request('setMessageReaction', {
			'chat_id': chat_id,
			'message_id': message_id,
			'reaction': reaction,
			'is_big': is_big,
		})
		return BoolAdapter.validate_python(response)

	async def get_user_profile_photos(
		self,
		user_id: int,
		offset: Optional[int] = None,
		limit: Optional[int] = None,
	) -> UserProfilePhotos:
		'''
        Use this method to get a list of
        profile pictures for a user. Returns a UserProfilePhotos
        object.

        Reference: https://core.telegram.org/bots/api#getuserprofilephotos
		'''

		response = await self._send_request('getUserProfilePhotos', {
			'user_id': user_id,
			'offset': offset,
			'limit': limit,
		})
		return UserProfilePhotos.model_validate(response)

	async def set_user_emoji_status(
		self,
		user_id: int,
		emoji_status_custom_emoji_id: Optional[str] = None,
		emoji_status_expiration_date: Optional[int] = None,
	) -> bool:
		'''
        Changes the emoji status for a given user
        that previously allowed the bot to manage their
        emoji status via the Mini App method requestEmojiStatusAccess.
        Returns True on success.

        Reference: https://core.telegram.org/bots/api#setuseremojistatus
		'''

		response = await self._send_request('setUserEmojiStatus', {
			'user_id': user_id,
			'emoji_status_custom_emoji_id': emoji_status_custom_emoji_id,
			'emoji_status_expiration_date': emoji_status_expiration_date,
		})
		return BoolAdapter.validate_python(response)

	async def get_file(
		self,
		file_id: str,
	) -> File:
		'''
        Use this method to get basic information about
        a file and prepare it for downloading. For
        the moment, bots can download files of up
        to 20MB in size. On success, a File
        object is returned. The file can then be
        downloaded via the link https://api.telegram.org/file/bot<token>/<file_path>, where <file_path> is
        taken from the response. It is guaranteed that
        the link will be valid for at least
        1 hour. When the link expires, a new
        one can be requested by calling getFile again.

        Reference: https://core.telegram.org/bots/api#getfile
		'''

		response = await self._send_request('getFile', {
			'file_id': file_id,
		})
		return File.model_validate(response)

	async def ban_chat_member(
		self,
		chat_id: Union[int, str],
		user_id: int,
		until_date: Optional[int] = None,
		revoke_messages: Optional[bool] = None,
	) -> bool:
		'''
        Use this method to ban a user in
        a group, a supergroup or a channel. In
        the case of supergroups and channels, the user
        will not be able to return to the
        chat on their own using invite links, etc.,
        unless unbanned first. The bot must be an
        administrator in the chat for this to work
        and must have the appropriate administrator rights. Returns
        True on success.

        Reference: https://core.telegram.org/bots/api#banchatmember
		'''

		response = await self._send_request('banChatMember', {
			'chat_id': chat_id,
			'user_id': user_id,
			'until_date': until_date,
			'revoke_messages': revoke_messages,
		})
		return BoolAdapter.validate_python(response)

	async def unban_chat_member(
		self,
		chat_id: Union[int, str],
		user_id: int,
		only_if_banned: Optional[bool] = None,
	) -> bool:
		'''
        Use this method to unban a previously banned
        user in a supergroup or channel. The user
        will not return to the group or channel
        automatically, but will be able to join via
        link, etc. The bot must be an administrator
        for this to work. By default, this method
        guarantees that after the call the user is
        not a member of the chat, but will
        be able to join it. So if the
        user is a member of the chat they
        will also be removed from the chat. If
        you don't want this, use the parameter only_if_banned.
        Returns True on success.

        Reference: https://core.telegram.org/bots/api#unbanchatmember
		'''

		response = await self._send_request('unbanChatMember', {
			'chat_id': chat_id,
			'user_id': user_id,
			'only_if_banned': only_if_banned,
		})
		return BoolAdapter.validate_python(response)

	async def restrict_chat_member(
		self,
		chat_id: Union[int, str],
		user_id: int,
		permissions: ChatPermissions,
		use_independent_chat_permissions: Optional[bool] = None,
		until_date: Optional[int] = None,
	) -> bool:
		'''
        Use this method to restrict a user in
        a supergroup. The bot must be an administrator
        in the supergroup for this to work and
        must have the appropriate administrator rights. Pass True
        for all permissions to lift restrictions from a
        user. Returns True on success.

        Reference: https://core.telegram.org/bots/api#restrictchatmember
		'''

		response = await self._send_request('restrictChatMember', {
			'chat_id': chat_id,
			'user_id': user_id,
			'permissions': permissions,
			'use_independent_chat_permissions': use_independent_chat_permissions,
			'until_date': until_date,
		})
		return BoolAdapter.validate_python(response)

	async def promote_chat_member(
		self,
		chat_id: Union[int, str],
		user_id: int,
		is_anonymous: Optional[bool] = None,
		can_manage_chat: Optional[bool] = None,
		can_delete_messages: Optional[bool] = None,
		can_manage_video_chats: Optional[bool] = None,
		can_restrict_members: Optional[bool] = None,
		can_promote_members: Optional[bool] = None,
		can_change_info: Optional[bool] = None,
		can_invite_users: Optional[bool] = None,
		can_post_stories: Optional[bool] = None,
		can_edit_stories: Optional[bool] = None,
		can_delete_stories: Optional[bool] = None,
		can_post_messages: Optional[bool] = None,
		can_edit_messages: Optional[bool] = None,
		can_pin_messages: Optional[bool] = None,
		can_manage_topics: Optional[bool] = None,
		can_manage_direct_messages: Optional[bool] = None,
	) -> bool:
		'''
        Use this method to promote or demote a
        user in a supergroup or a channel. The
        bot must be an administrator in the chat
        for this to work and must have the
        appropriate administrator rights. Pass False for all boolean
        parameters to demote a user. Returns True on
        success.

        Reference: https://core.telegram.org/bots/api#promotechatmember
		'''

		response = await self._send_request('promoteChatMember', {
			'chat_id': chat_id,
			'user_id': user_id,
			'is_anonymous': is_anonymous,
			'can_manage_chat': can_manage_chat,
			'can_delete_messages': can_delete_messages,
			'can_manage_video_chats': can_manage_video_chats,
			'can_restrict_members': can_restrict_members,
			'can_promote_members': can_promote_members,
			'can_change_info': can_change_info,
			'can_invite_users': can_invite_users,
			'can_post_stories': can_post_stories,
			'can_edit_stories': can_edit_stories,
			'can_delete_stories': can_delete_stories,
			'can_post_messages': can_post_messages,
			'can_edit_messages': can_edit_messages,
			'can_pin_messages': can_pin_messages,
			'can_manage_topics': can_manage_topics,
			'can_manage_direct_messages': can_manage_direct_messages,
		})
		return BoolAdapter.validate_python(response)

	async def set_chat_administrator_custom_title(
		self,
		chat_id: Union[int, str],
		user_id: int,
		custom_title: str,
	) -> bool:
		'''
        Use this method to set a custom title
        for an administrator in a supergroup promoted by
        the bot. Returns True on success.

        Reference: https://core.telegram.org/bots/api#setchatadministratorcustomtitle
		'''

		response = await self._send_request('setChatAdministratorCustomTitle', {
			'chat_id': chat_id,
			'user_id': user_id,
			'custom_title': custom_title,
		})
		return BoolAdapter.validate_python(response)

	async def ban_chat_sender_chat(
		self,
		chat_id: Union[int, str],
		sender_chat_id: int,
	) -> bool:
		'''
        Use this method to ban a channel chat
        in a supergroup or a channel. Until the
        chat is unbanned, the owner of the banned
        chat won't be able to send messages on
        behalf of any of their channels. The bot
        must be an administrator in the supergroup or
        channel for this to work and must have
        the appropriate administrator rights. Returns True on success.

        Reference: https://core.telegram.org/bots/api#banchatsenderchat
		'''

		response = await self._send_request('banChatSenderChat', {
			'chat_id': chat_id,
			'sender_chat_id': sender_chat_id,
		})
		return BoolAdapter.validate_python(response)

	async def unban_chat_sender_chat(
		self,
		chat_id: Union[int, str],
		sender_chat_id: int,
	) -> bool:
		'''
        Use this method to unban a previously banned
        channel chat in a supergroup or channel. The
        bot must be an administrator for this to
        work and must have the appropriate administrator rights.
        Returns True on success.

        Reference: https://core.telegram.org/bots/api#unbanchatsenderchat
		'''

		response = await self._send_request('unbanChatSenderChat', {
			'chat_id': chat_id,
			'sender_chat_id': sender_chat_id,
		})
		return BoolAdapter.validate_python(response)

	async def set_chat_permissions(
		self,
		chat_id: Union[int, str],
		permissions: ChatPermissions,
		use_independent_chat_permissions: Optional[bool] = None,
	) -> bool:
		'''
        Use this method to set default chat permissions
        for all members. The bot must be an
        administrator in the group or a supergroup for
        this to work and must have the can_restrict_members
        administrator rights. Returns True on success.

        Reference: https://core.telegram.org/bots/api#setchatpermissions
		'''

		response = await self._send_request('setChatPermissions', {
			'chat_id': chat_id,
			'permissions': permissions,
			'use_independent_chat_permissions': use_independent_chat_permissions,
		})
		return BoolAdapter.validate_python(response)

	async def export_chat_invite_link(
		self,
		chat_id: Union[int, str],
	) -> str:
		'''
        Use this method to generate a new primary
        invite link for a chat; any previously generated
        primary link is revoked. The bot must be
        an administrator in the chat for this to
        work and must have the appropriate administrator rights.
        Returns the new invite link as String on
        success.

        Reference: https://core.telegram.org/bots/api#exportchatinvitelink
		'''

		response = await self._send_request('exportChatInviteLink', {
			'chat_id': chat_id,
		})
		return StrAdapter.validate_python(response)

	async def create_chat_invite_link(
		self,
		chat_id: Union[int, str],
		name: Optional[str] = None,
		expire_date: Optional[int] = None,
		member_limit: Optional[int] = None,
		creates_join_request: Optional[bool] = None,
	) -> ChatInviteLink:
		'''
        Use this method to create an additional invite
        link for a chat. The bot must be
        an administrator in the chat for this to
        work and must have the appropriate administrator rights.
        The link can be revoked using the method
        revokeChatInviteLink. Returns the new invite link as ChatInviteLink
        object.

        Reference: https://core.telegram.org/bots/api#createchatinvitelink
		'''

		response = await self._send_request('createChatInviteLink', {
			'chat_id': chat_id,
			'name': name,
			'expire_date': expire_date,
			'member_limit': member_limit,
			'creates_join_request': creates_join_request,
		})
		return ChatInviteLink.model_validate(response)

	async def edit_chat_invite_link(
		self,
		chat_id: Union[int, str],
		invite_link: str,
		name: Optional[str] = None,
		expire_date: Optional[int] = None,
		member_limit: Optional[int] = None,
		creates_join_request: Optional[bool] = None,
	) -> ChatInviteLink:
		'''
        Use this method to edit a non-primary invite
        link created by the bot. The bot must
        be an administrator in the chat for this
        to work and must have the appropriate administrator
        rights. Returns the edited invite link as a
        ChatInviteLink object.

        Reference: https://core.telegram.org/bots/api#editchatinvitelink
		'''

		response = await self._send_request('editChatInviteLink', {
			'chat_id': chat_id,
			'invite_link': invite_link,
			'name': name,
			'expire_date': expire_date,
			'member_limit': member_limit,
			'creates_join_request': creates_join_request,
		})
		return ChatInviteLink.model_validate(response)

	async def create_chat_subscription_invite_link(
		self,
		chat_id: Union[int, str],
		subscription_period: int,
		subscription_price: int,
		name: Optional[str] = None,
	) -> ChatInviteLink:
		'''
        Use this method to create a subscription invite
        link for a channel chat. The bot must
        have the can_invite_users administrator rights. The link can
        be edited using the method editChatSubscriptionInviteLink or revoked
        using the method revokeChatInviteLink. Returns the new invite
        link as a ChatInviteLink object.

        Reference: https://core.telegram.org/bots/api#createchatsubscriptioninvitelink
		'''

		response = await self._send_request('createChatSubscriptionInviteLink', {
			'chat_id': chat_id,
			'name': name,
			'subscription_period': subscription_period,
			'subscription_price': subscription_price,
		})
		return ChatInviteLink.model_validate(response)

	async def edit_chat_subscription_invite_link(
		self,
		chat_id: Union[int, str],
		invite_link: str,
		name: Optional[str] = None,
	) -> ChatInviteLink:
		'''
        Use this method to edit a subscription invite
        link created by the bot. The bot must
        have the can_invite_users administrator rights. Returns the edited
        invite link as a ChatInviteLink object.

        Reference: https://core.telegram.org/bots/api#editchatsubscriptioninvitelink
		'''

		response = await self._send_request('editChatSubscriptionInviteLink', {
			'chat_id': chat_id,
			'invite_link': invite_link,
			'name': name,
		})
		return ChatInviteLink.model_validate(response)

	async def revoke_chat_invite_link(
		self,
		chat_id: Union[int, str],
		invite_link: str,
	) -> ChatInviteLink:
		'''
        Use this method to revoke an invite link
        created by the bot. If the primary link
        is revoked, a new link is automatically generated.
        The bot must be an administrator in the
        chat for this to work and must have
        the appropriate administrator rights. Returns the revoked invite
        link as ChatInviteLink object.

        Reference: https://core.telegram.org/bots/api#revokechatinvitelink
		'''

		response = await self._send_request('revokeChatInviteLink', {
			'chat_id': chat_id,
			'invite_link': invite_link,
		})
		return ChatInviteLink.model_validate(response)

	async def approve_chat_join_request(
		self,
		chat_id: Union[int, str],
		user_id: int,
	) -> bool:
		'''
        Use this method to approve a chat join
        request. The bot must be an administrator in
        the chat for this to work and must
        have the can_invite_users administrator right. Returns True on
        success.

        Reference: https://core.telegram.org/bots/api#approvechatjoinrequest
		'''

		response = await self._send_request('approveChatJoinRequest', {
			'chat_id': chat_id,
			'user_id': user_id,
		})
		return BoolAdapter.validate_python(response)

	async def decline_chat_join_request(
		self,
		chat_id: Union[int, str],
		user_id: int,
	) -> bool:
		'''
        Use this method to decline a chat join
        request. The bot must be an administrator in
        the chat for this to work and must
        have the can_invite_users administrator right. Returns True on
        success.

        Reference: https://core.telegram.org/bots/api#declinechatjoinrequest
		'''

		response = await self._send_request('declineChatJoinRequest', {
			'chat_id': chat_id,
			'user_id': user_id,
		})
		return BoolAdapter.validate_python(response)

	async def set_chat_photo(
		self,
		chat_id: Union[int, str],
		photo: InputFile,
	) -> bool:
		'''
        Use this method to set a new profile
        photo for the chat. Photos can't be changed
        for private chats. The bot must be an
        administrator in the chat for this to work
        and must have the appropriate administrator rights. Returns
        True on success.

        Reference: https://core.telegram.org/bots/api#setchatphoto
		'''

		response = await self._send_request('setChatPhoto', {
			'chat_id': chat_id,
			'photo': photo,
		})
		return BoolAdapter.validate_python(response)

	async def delete_chat_photo(
		self,
		chat_id: Union[int, str],
	) -> bool:
		'''
        Use this method to delete a chat photo.
        Photos can't be changed for private chats. The
        bot must be an administrator in the chat
        for this to work and must have the
        appropriate administrator rights. Returns True on success.

        Reference: https://core.telegram.org/bots/api#deletechatphoto
		'''

		response = await self._send_request('deleteChatPhoto', {
			'chat_id': chat_id,
		})
		return BoolAdapter.validate_python(response)

	async def set_chat_title(
		self,
		chat_id: Union[int, str],
		title: str,
	) -> bool:
		'''
        Use this method to change the title of
        a chat. Titles can't be changed for private
        chats. The bot must be an administrator in
        the chat for this to work and must
        have the appropriate administrator rights. Returns True on
        success.

        Reference: https://core.telegram.org/bots/api#setchattitle
		'''

		response = await self._send_request('setChatTitle', {
			'chat_id': chat_id,
			'title': title,
		})
		return BoolAdapter.validate_python(response)

	async def set_chat_description(
		self,
		chat_id: Union[int, str],
		description: Optional[str] = None,
	) -> bool:
		'''
        Use this method to change the description of
        a group, a supergroup or a channel. The
        bot must be an administrator in the chat
        for this to work and must have the
        appropriate administrator rights. Returns True on success.

        Reference: https://core.telegram.org/bots/api#setchatdescription
		'''

		response = await self._send_request('setChatDescription', {
			'chat_id': chat_id,
			'description': description,
		})
		return BoolAdapter.validate_python(response)

	async def pin_chat_message(
		self,
		chat_id: Union[int, str],
		message_id: int,
		business_connection_id: Optional[str] = None,
		disable_notification: Optional[bool] = None,
	) -> bool:
		'''
        Use this method to add a message to
        the list of pinned messages in a chat.
        In private chats and channel direct messages chats,
        all non-service messages can be pinned. Conversely, the
        bot must be an administrator with the 'can_pin_messages'
        right or the 'can_edit_messages' right to pin messages
        in groups and channels respectively. Returns True on
        success.

        Reference: https://core.telegram.org/bots/api#pinchatmessage
		'''

		response = await self._send_request('pinChatMessage', {
			'business_connection_id': business_connection_id,
			'chat_id': chat_id,
			'message_id': message_id,
			'disable_notification': disable_notification,
		})
		return BoolAdapter.validate_python(response)

	async def unpin_chat_message(
		self,
		chat_id: Union[int, str],
		business_connection_id: Optional[str] = None,
		message_id: Optional[int] = None,
	) -> bool:
		'''
        Use this method to remove a message from
        the list of pinned messages in a chat.
        In private chats and channel direct messages chats,
        all messages can be unpinned. Conversely, the bot
        must be an administrator with the 'can_pin_messages' right
        or the 'can_edit_messages' right to unpin messages in
        groups and channels respectively. Returns True on success.

        Reference: https://core.telegram.org/bots/api#unpinchatmessage
		'''

		response = await self._send_request('unpinChatMessage', {
			'business_connection_id': business_connection_id,
			'chat_id': chat_id,
			'message_id': message_id,
		})
		return BoolAdapter.validate_python(response)

	async def unpin_all_chat_messages(
		self,
		chat_id: Union[int, str],
	) -> bool:
		'''
        Use this method to clear the list of
        pinned messages in a chat. In private chats
        and channel direct messages chats, no additional rights
        are required to unpin all pinned messages. Conversely,
        the bot must be an administrator with the
        'can_pin_messages' right or the 'can_edit_messages' right to unpin
        all pinned messages in groups and channels respectively.
        Returns True on success.

        Reference: https://core.telegram.org/bots/api#unpinallchatmessages
		'''

		response = await self._send_request('unpinAllChatMessages', {
			'chat_id': chat_id,
		})
		return BoolAdapter.validate_python(response)

	async def leave_chat(
		self,
		chat_id: Union[int, str],
	) -> bool:
		'''
        Use this method for your bot to leave
        a group, supergroup or channel. Returns True on
        success.

        Reference: https://core.telegram.org/bots/api#leavechat
		'''

		response = await self._send_request('leaveChat', {
			'chat_id': chat_id,
		})
		return BoolAdapter.validate_python(response)

	async def get_chat(
		self,
		chat_id: Union[int, str],
	) -> ChatFullInfo:
		'''
        Use this method to get up-to-date information about
        the chat. Returns a ChatFullInfo object on success.

        Reference: https://core.telegram.org/bots/api#getchat
		'''

		response = await self._send_request('getChat', {
			'chat_id': chat_id,
		})
		return ChatFullInfo.model_validate(response)

	async def get_chat_administrators(
		self,
		chat_id: Union[int, str],
	) -> List[ChatMember]:
		'''
        Use this method to get a list of
        administrators in a chat, which aren't bots. Returns
        an Array of ChatMember objects.

        Reference: https://core.telegram.org/bots/api#getchatadministrators
		'''

		response = await self._send_request('getChatAdministrators', {
			'chat_id': chat_id,
		})
		return [ChatMemberAdapter.validate_python(x) for x in response]

	async def get_chat_member_count(
		self,
		chat_id: Union[int, str],
	) -> int:
		'''
        Use this method to get the number of
        members in a chat. Returns Int on success.

        Reference: https://core.telegram.org/bots/api#getchatmembercount
		'''

		response = await self._send_request('getChatMemberCount', {
			'chat_id': chat_id,
		})
		return IntAdapter.validate_python(response)

	async def get_chat_member(
		self,
		chat_id: Union[int, str],
		user_id: int,
	) -> ChatMember:
		'''
        Use this method to get information about a
        member of a chat. The method is only
        guaranteed to work for other users if the
        bot is an administrator in the chat. Returns
        a ChatMember object on success.

        Reference: https://core.telegram.org/bots/api#getchatmember
		'''

		response = await self._send_request('getChatMember', {
			'chat_id': chat_id,
			'user_id': user_id,
		})
		return ChatMemberAdapter.validate_python(response)

	async def set_chat_sticker_set(
		self,
		chat_id: Union[int, str],
		sticker_set_name: str,
	) -> bool:
		'''
        Use this method to set a new group
        sticker set for a supergroup. The bot must
        be an administrator in the chat for this
        to work and must have the appropriate administrator
        rights. Use the field can_set_sticker_set optionally returned in
        getChat requests to check if the bot can
        use this method. Returns True on success.

        Reference: https://core.telegram.org/bots/api#setchatstickerset
		'''

		response = await self._send_request('setChatStickerSet', {
			'chat_id': chat_id,
			'sticker_set_name': sticker_set_name,
		})
		return BoolAdapter.validate_python(response)

	async def delete_chat_sticker_set(
		self,
		chat_id: Union[int, str],
	) -> bool:
		'''
        Use this method to delete a group sticker
        set from a supergroup. The bot must be
        an administrator in the chat for this to
        work and must have the appropriate administrator rights.
        Use the field can_set_sticker_set optionally returned in getChat
        requests to check if the bot can use
        this method. Returns True on success.

        Reference: https://core.telegram.org/bots/api#deletechatstickerset
		'''

		response = await self._send_request('deleteChatStickerSet', {
			'chat_id': chat_id,
		})
		return BoolAdapter.validate_python(response)

	async def get_forum_topic_icon_stickers(
		self,
	) -> List[Sticker]:
		'''
        Use this method to get custom emoji stickers,
        which can be used as a forum topic
        icon by any user. Requires no parameters. Returns
        an Array of Sticker objects.

        Reference: https://core.telegram.org/bots/api#getforumtopiciconstickers
		'''

		response = await self._send_request('getForumTopicIconStickers', {})
		return [Sticker.model_validate(x) for x in response]

	async def create_forum_topic(
		self,
		chat_id: Union[int, str],
		name: str,
		icon_color: Optional[int] = None,
		icon_custom_emoji_id: Optional[str] = None,
	) -> ForumTopic:
		'''
        Use this method to create a topic in
        a forum supergroup chat. The bot must be
        an administrator in the chat for this to
        work and must have the can_manage_topics administrator rights.
        Returns information about the created topic as a
        ForumTopic object.

        Reference: https://core.telegram.org/bots/api#createforumtopic
		'''

		response = await self._send_request('createForumTopic', {
			'chat_id': chat_id,
			'name': name,
			'icon_color': icon_color,
			'icon_custom_emoji_id': icon_custom_emoji_id,
		})
		return ForumTopic.model_validate(response)

	async def edit_forum_topic(
		self,
		chat_id: Union[int, str],
		message_thread_id: int,
		name: Optional[str] = None,
		icon_custom_emoji_id: Optional[str] = None,
	) -> bool:
		'''
        Use this method to edit name and icon
        of a topic in a forum supergroup chat.
        The bot must be an administrator in the
        chat for this to work and must have
        the can_manage_topics administrator rights, unless it is the
        creator of the topic. Returns True on success.

        Reference: https://core.telegram.org/bots/api#editforumtopic
		'''

		response = await self._send_request('editForumTopic', {
			'chat_id': chat_id,
			'message_thread_id': message_thread_id,
			'name': name,
			'icon_custom_emoji_id': icon_custom_emoji_id,
		})
		return BoolAdapter.validate_python(response)

	async def close_forum_topic(
		self,
		chat_id: Union[int, str],
		message_thread_id: int,
	) -> bool:
		'''
        Use this method to close an open topic
        in a forum supergroup chat. The bot must
        be an administrator in the chat for this
        to work and must have the can_manage_topics administrator
        rights, unless it is the creator of the
        topic. Returns True on success.

        Reference: https://core.telegram.org/bots/api#closeforumtopic
		'''

		response = await self._send_request('closeForumTopic', {
			'chat_id': chat_id,
			'message_thread_id': message_thread_id,
		})
		return BoolAdapter.validate_python(response)

	async def reopen_forum_topic(
		self,
		chat_id: Union[int, str],
		message_thread_id: int,
	) -> bool:
		'''
        Use this method to reopen a closed topic
        in a forum supergroup chat. The bot must
        be an administrator in the chat for this
        to work and must have the can_manage_topics administrator
        rights, unless it is the creator of the
        topic. Returns True on success.

        Reference: https://core.telegram.org/bots/api#reopenforumtopic
		'''

		response = await self._send_request('reopenForumTopic', {
			'chat_id': chat_id,
			'message_thread_id': message_thread_id,
		})
		return BoolAdapter.validate_python(response)

	async def delete_forum_topic(
		self,
		chat_id: Union[int, str],
		message_thread_id: int,
	) -> bool:
		'''
        Use this method to delete a forum topic
        along with all its messages in a forum
        supergroup chat. The bot must be an administrator
        in the chat for this to work and
        must have the can_delete_messages administrator rights. Returns True
        on success.

        Reference: https://core.telegram.org/bots/api#deleteforumtopic
		'''

		response = await self._send_request('deleteForumTopic', {
			'chat_id': chat_id,
			'message_thread_id': message_thread_id,
		})
		return BoolAdapter.validate_python(response)

	async def unpin_all_forum_topic_messages(
		self,
		chat_id: Union[int, str],
		message_thread_id: int,
	) -> bool:
		'''
        Use this method to clear the list of
        pinned messages in a forum topic. The bot
        must be an administrator in the chat for
        this to work and must have the can_pin_messages
        administrator right in the supergroup. Returns True on
        success.

        Reference: https://core.telegram.org/bots/api#unpinallforumtopicmessages
		'''

		response = await self._send_request('unpinAllForumTopicMessages', {
			'chat_id': chat_id,
			'message_thread_id': message_thread_id,
		})
		return BoolAdapter.validate_python(response)

	async def edit_general_forum_topic(
		self,
		chat_id: Union[int, str],
		name: str,
	) -> bool:
		'''
        Use this method to edit the name of
        the 'General' topic in a forum supergroup chat.
        The bot must be an administrator in the
        chat for this to work and must have
        the can_manage_topics administrator rights. Returns True on success.

        Reference: https://core.telegram.org/bots/api#editgeneralforumtopic
		'''

		response = await self._send_request('editGeneralForumTopic', {
			'chat_id': chat_id,
			'name': name,
		})
		return BoolAdapter.validate_python(response)

	async def close_general_forum_topic(
		self,
		chat_id: Union[int, str],
	) -> bool:
		'''
        Use this method to close an open 'General'
        topic in a forum supergroup chat. The bot
        must be an administrator in the chat for
        this to work and must have the can_manage_topics
        administrator rights. Returns True on success.

        Reference: https://core.telegram.org/bots/api#closegeneralforumtopic
		'''

		response = await self._send_request('closeGeneralForumTopic', {
			'chat_id': chat_id,
		})
		return BoolAdapter.validate_python(response)

	async def reopen_general_forum_topic(
		self,
		chat_id: Union[int, str],
	) -> bool:
		'''
        Use this method to reopen a closed 'General'
        topic in a forum supergroup chat. The bot
        must be an administrator in the chat for
        this to work and must have the can_manage_topics
        administrator rights. The topic will be automatically unhidden
        if it was hidden. Returns True on success.

        Reference: https://core.telegram.org/bots/api#reopengeneralforumtopic
		'''

		response = await self._send_request('reopenGeneralForumTopic', {
			'chat_id': chat_id,
		})
		return BoolAdapter.validate_python(response)

	async def hide_general_forum_topic(
		self,
		chat_id: Union[int, str],
	) -> bool:
		'''
        Use this method to hide the 'General' topic
        in a forum supergroup chat. The bot must
        be an administrator in the chat for this
        to work and must have the can_manage_topics administrator
        rights. The topic will be automatically closed if
        it was open. Returns True on success.

        Reference: https://core.telegram.org/bots/api#hidegeneralforumtopic
		'''

		response = await self._send_request('hideGeneralForumTopic', {
			'chat_id': chat_id,
		})
		return BoolAdapter.validate_python(response)

	async def unhide_general_forum_topic(
		self,
		chat_id: Union[int, str],
	) -> bool:
		'''
        Use this method to unhide the 'General' topic
        in a forum supergroup chat. The bot must
        be an administrator in the chat for this
        to work and must have the can_manage_topics administrator
        rights. Returns True on success.

        Reference: https://core.telegram.org/bots/api#unhidegeneralforumtopic
		'''

		response = await self._send_request('unhideGeneralForumTopic', {
			'chat_id': chat_id,
		})
		return BoolAdapter.validate_python(response)

	async def unpin_all_general_forum_topic_messages(
		self,
		chat_id: Union[int, str],
	) -> bool:
		'''
        Use this method to clear the list of
        pinned messages in a General forum topic. The
        bot must be an administrator in the chat
        for this to work and must have the
        can_pin_messages administrator right in the supergroup. Returns True
        on success.

        Reference: https://core.telegram.org/bots/api#unpinallgeneralforumtopicmessages
		'''

		response = await self._send_request('unpinAllGeneralForumTopicMessages', {
			'chat_id': chat_id,
		})
		return BoolAdapter.validate_python(response)

	async def answer_callback_query(
		self,
		callback_query_id: str,
		text: Optional[str] = None,
		show_alert: Optional[bool] = None,
		url: Optional[str] = None,
		cache_time: Optional[int] = None,
	) -> bool:
		'''
        Use this method to send answers to callback
        queries sent from inline keyboards. The answer will
        be displayed to the user as a notification
        at the top of the chat screen or
        as an alert. On success, True is returned.

        Reference: https://core.telegram.org/bots/api#answercallbackquery
		'''

		response = await self._send_request('answerCallbackQuery', {
			'callback_query_id': callback_query_id,
			'text': text,
			'show_alert': show_alert,
			'url': url,
			'cache_time': cache_time,
		})
		return BoolAdapter.validate_python(response)

	async def get_user_chat_boosts(
		self,
		chat_id: Union[int, str],
		user_id: int,
	) -> UserChatBoosts:
		'''
        Use this method to get the list of
        boosts added to a chat by a user.
        Requires administrator rights in the chat. Returns a
        UserChatBoosts object.

        Reference: https://core.telegram.org/bots/api#getuserchatboosts
		'''

		response = await self._send_request('getUserChatBoosts', {
			'chat_id': chat_id,
			'user_id': user_id,
		})
		return UserChatBoosts.model_validate(response)

	async def get_business_connection(
		self,
		business_connection_id: str,
	) -> BusinessConnection:
		'''
        Use this method to get information about the
        connection of the bot with a business account.
        Returns a BusinessConnection object on success.

        Reference: https://core.telegram.org/bots/api#getbusinessconnection
		'''

		response = await self._send_request('getBusinessConnection', {
			'business_connection_id': business_connection_id,
		})
		return BusinessConnection.model_validate(response)

	async def set_my_commands(
		self,
		commands: List[BotCommand],
		scope: Optional[BotCommandScope] = None,
		language_code: Optional[str] = None,
	) -> bool:
		'''
        Use this method to change the list of
        the bot's commands. See this manual for more
        details about bot commands. Returns True on success.

        Reference: https://core.telegram.org/bots/api#setmycommands
		'''

		response = await self._send_request('setMyCommands', {
			'commands': commands,
			'scope': scope,
			'language_code': language_code,
		})
		return BoolAdapter.validate_python(response)

	async def delete_my_commands(
		self,
		scope: Optional[BotCommandScope] = None,
		language_code: Optional[str] = None,
	) -> bool:
		'''
        Use this method to delete the list of
        the bot's commands for the given scope and
        user language. After deletion, higher level commands will
        be shown to affected users. Returns True on
        success.

        Reference: https://core.telegram.org/bots/api#deletemycommands
		'''

		response = await self._send_request('deleteMyCommands', {
			'scope': scope,
			'language_code': language_code,
		})
		return BoolAdapter.validate_python(response)

	async def get_my_commands(
		self,
		scope: Optional[BotCommandScope] = None,
		language_code: Optional[str] = None,
	) -> List[BotCommand]:
		'''
        Use this method to get the current list
        of the bot's commands for the given scope
        and user language. Returns an Array of BotCommand
        objects. If commands aren't set, an empty list
        is returned.

        Reference: https://core.telegram.org/bots/api#getmycommands
		'''

		response = await self._send_request('getMyCommands', {
			'scope': scope,
			'language_code': language_code,
		})
		return [BotCommand.model_validate(x) for x in response]

	async def set_my_name(
		self,
		name: Optional[str] = None,
		language_code: Optional[str] = None,
	) -> bool:
		'''
        Use this method to change the bot's name.
        Returns True on success.

        Reference: https://core.telegram.org/bots/api#setmyname
		'''

		response = await self._send_request('setMyName', {
			'name': name,
			'language_code': language_code,
		})
		return BoolAdapter.validate_python(response)

	async def get_my_name(
		self,
		language_code: Optional[str] = None,
	) -> BotName:
		'''
        Use this method to get the current bot
        name for the given user language. Returns BotName
        on success.

        Reference: https://core.telegram.org/bots/api#getmyname
		'''

		response = await self._send_request('getMyName', {
			'language_code': language_code,
		})
		return BotName.model_validate(response)

	async def set_my_description(
		self,
		description: Optional[str] = None,
		language_code: Optional[str] = None,
	) -> bool:
		'''
        Use this method to change the bot's description,
        which is shown in the chat with the
        bot if the chat is empty. Returns True
        on success.

        Reference: https://core.telegram.org/bots/api#setmydescription
		'''

		response = await self._send_request('setMyDescription', {
			'description': description,
			'language_code': language_code,
		})
		return BoolAdapter.validate_python(response)

	async def get_my_description(
		self,
		language_code: Optional[str] = None,
	) -> BotDescription:
		'''
        Use this method to get the current bot
        description for the given user language. Returns BotDescription
        on success.

        Reference: https://core.telegram.org/bots/api#getmydescription
		'''

		response = await self._send_request('getMyDescription', {
			'language_code': language_code,
		})
		return BotDescription.model_validate(response)

	async def set_my_short_description(
		self,
		short_description: Optional[str] = None,
		language_code: Optional[str] = None,
	) -> bool:
		'''
        Use this method to change the bot's short
        description, which is shown on the bot's profile
        page and is sent together with the link
        when users share the bot. Returns True on
        success.

        Reference: https://core.telegram.org/bots/api#setmyshortdescription
		'''

		response = await self._send_request('setMyShortDescription', {
			'short_description': short_description,
			'language_code': language_code,
		})
		return BoolAdapter.validate_python(response)

	async def get_my_short_description(
		self,
		language_code: Optional[str] = None,
	) -> BotShortDescription:
		'''
        Use this method to get the current bot
        short description for the given user language. Returns
        BotShortDescription on success.

        Reference: https://core.telegram.org/bots/api#getmyshortdescription
		'''

		response = await self._send_request('getMyShortDescription', {
			'language_code': language_code,
		})
		return BotShortDescription.model_validate(response)

	async def set_chat_menu_button(
		self,
		chat_id: Optional[int] = None,
		menu_button: Optional[MenuButton] = None,
	) -> bool:
		'''
        Use this method to change the bot's menu
        button in a private chat, or the default
        menu button. Returns True on success.

        Reference: https://core.telegram.org/bots/api#setchatmenubutton
		'''

		response = await self._send_request('setChatMenuButton', {
			'chat_id': chat_id,
			'menu_button': menu_button,
		})
		return BoolAdapter.validate_python(response)

	async def get_chat_menu_button(
		self,
		chat_id: Optional[int] = None,
	) -> MenuButton:
		'''
        Use this method to get the current value
        of the bot's menu button in a private
        chat, or the default menu button. Returns MenuButton
        on success.

        Reference: https://core.telegram.org/bots/api#getchatmenubutton
		'''

		response = await self._send_request('getChatMenuButton', {
			'chat_id': chat_id,
		})
		return MenuButtonAdapter.validate_python(response)

	async def set_my_default_administrator_rights(
		self,
		rights: Optional[ChatAdministratorRights] = None,
		for_channels: Optional[bool] = None,
	) -> bool:
		'''
        Use this method to change the default administrator
        rights requested by the bot when it's added
        as an administrator to groups or channels. These
        rights will be suggested to users, but they
        are free to modify the list before adding
        the bot. Returns True on success.

        Reference: https://core.telegram.org/bots/api#setmydefaultadministratorrights
		'''

		response = await self._send_request('setMyDefaultAdministratorRights', {
			'rights': rights,
			'for_channels': for_channels,
		})
		return BoolAdapter.validate_python(response)

	async def get_my_default_administrator_rights(
		self,
		for_channels: Optional[bool] = None,
	) -> ChatAdministratorRights:
		'''
        Use this method to get the current default
        administrator rights of the bot. Returns ChatAdministratorRights on
        success.

        Reference: https://core.telegram.org/bots/api#getmydefaultadministratorrights
		'''

		response = await self._send_request('getMyDefaultAdministratorRights', {
			'for_channels': for_channels,
		})
		return ChatAdministratorRights.model_validate(response)

	async def get_available_gifts(
		self,
	) -> Gifts:
		'''
        Returns the list of gifts that can be
        sent by the bot to users and channel
        chats. Requires no parameters. Returns a Gifts object.

        Reference: https://core.telegram.org/bots/api#getavailablegifts
		'''

		response = await self._send_request('getAvailableGifts', {})
		return Gifts.model_validate(response)

	async def send_gift(
		self,
		gift_id: str,
		user_id: Optional[int] = None,
		chat_id: Optional[Union[int, str]] = None,
		pay_for_upgrade: Optional[bool] = None,
		text: Optional[str] = None,
		text_parse_mode: Optional[str] = None,
		text_entities: Optional[List[MessageEntity]] = None,
	) -> bool:
		'''
        Sends a gift to the given user or
        channel chat. The gift can't be converted to
        Telegram Stars by the receiver. Returns True on
        success.

        Reference: https://core.telegram.org/bots/api#sendgift
		'''

		response = await self._send_request('sendGift', {
			'user_id': user_id,
			'chat_id': chat_id,
			'gift_id': gift_id,
			'pay_for_upgrade': pay_for_upgrade,
			'text': text,
			'text_parse_mode': text_parse_mode,
			'text_entities': text_entities,
		})
		return BoolAdapter.validate_python(response)

	async def gift_premium_subscription(
		self,
		user_id: int,
		month_count: int,
		star_count: int,
		text: Optional[str] = None,
		text_parse_mode: Optional[str] = None,
		text_entities: Optional[List[MessageEntity]] = None,
	) -> bool:
		'''
        Gifts a Telegram Premium subscription to the given
        user. Returns True on success.

        Reference: https://core.telegram.org/bots/api#giftpremiumsubscription
		'''

		response = await self._send_request('giftPremiumSubscription', {
			'user_id': user_id,
			'month_count': month_count,
			'star_count': star_count,
			'text': text,
			'text_parse_mode': text_parse_mode,
			'text_entities': text_entities,
		})
		return BoolAdapter.validate_python(response)

	async def verify_user(
		self,
		user_id: int,
		custom_description: Optional[str] = None,
	) -> bool:
		'''
        Verifies a user on behalf of the organization
        which is represented by the bot. Returns True
        on success.

        Reference: https://core.telegram.org/bots/api#verifyuser
		'''

		response = await self._send_request('verifyUser', {
			'user_id': user_id,
			'custom_description': custom_description,
		})
		return BoolAdapter.validate_python(response)

	async def verify_chat(
		self,
		chat_id: Union[int, str],
		custom_description: Optional[str] = None,
	) -> bool:
		'''
        Verifies a chat on behalf of the organization
        which is represented by the bot. Returns True
        on success.

        Reference: https://core.telegram.org/bots/api#verifychat
		'''

		response = await self._send_request('verifyChat', {
			'chat_id': chat_id,
			'custom_description': custom_description,
		})
		return BoolAdapter.validate_python(response)

	async def remove_user_verification(
		self,
		user_id: int,
	) -> bool:
		'''
        Removes verification from a user who is currently
        verified on behalf of the organization represented by
        the bot. Returns True on success.

        Reference: https://core.telegram.org/bots/api#removeuserverification
		'''

		response = await self._send_request('removeUserVerification', {
			'user_id': user_id,
		})
		return BoolAdapter.validate_python(response)

	async def remove_chat_verification(
		self,
		chat_id: Union[int, str],
	) -> bool:
		'''
        Removes verification from a chat that is currently
        verified on behalf of the organization represented by
        the bot. Returns True on success.

        Reference: https://core.telegram.org/bots/api#removechatverification
		'''

		response = await self._send_request('removeChatVerification', {
			'chat_id': chat_id,
		})
		return BoolAdapter.validate_python(response)

	async def read_business_message(
		self,
		business_connection_id: str,
		chat_id: int,
		message_id: int,
	) -> bool:
		'''
        Marks incoming message as read on behalf of
        a business account. Requires the can_read_messages business bot
        right. Returns True on success.

        Reference: https://core.telegram.org/bots/api#readbusinessmessage
		'''

		response = await self._send_request('readBusinessMessage', {
			'business_connection_id': business_connection_id,
			'chat_id': chat_id,
			'message_id': message_id,
		})
		return BoolAdapter.validate_python(response)

	async def delete_business_messages(
		self,
		business_connection_id: str,
		message_ids: List[int],
	) -> bool:
		'''
        Delete messages on behalf of a business account.
        Requires the can_delete_sent_messages business bot right to delete
        messages sent by the bot itself, or the
        can_delete_all_messages business bot right to delete any message.
        Returns True on success.

        Reference: https://core.telegram.org/bots/api#deletebusinessmessages
		'''

		response = await self._send_request('deleteBusinessMessages', {
			'business_connection_id': business_connection_id,
			'message_ids': message_ids,
		})
		return BoolAdapter.validate_python(response)

	async def set_business_account_name(
		self,
		business_connection_id: str,
		first_name: str,
		last_name: Optional[str] = None,
	) -> bool:
		'''
        Changes the first and last name of a
        managed business account. Requires the can_change_name business bot
        right. Returns True on success.

        Reference: https://core.telegram.org/bots/api#setbusinessaccountname
		'''

		response = await self._send_request('setBusinessAccountName', {
			'business_connection_id': business_connection_id,
			'first_name': first_name,
			'last_name': last_name,
		})
		return BoolAdapter.validate_python(response)

	async def set_business_account_username(
		self,
		business_connection_id: str,
		username: Optional[str] = None,
	) -> bool:
		'''
        Changes the username of a managed business account.
        Requires the can_change_username business bot right. Returns True
        on success.

        Reference: https://core.telegram.org/bots/api#setbusinessaccountusername
		'''

		response = await self._send_request('setBusinessAccountUsername', {
			'business_connection_id': business_connection_id,
			'username': username,
		})
		return BoolAdapter.validate_python(response)

	async def set_business_account_bio(
		self,
		business_connection_id: str,
		bio: Optional[str] = None,
	) -> bool:
		'''
        Changes the bio of a managed business account.
        Requires the can_change_bio business bot right. Returns True
        on success.

        Reference: https://core.telegram.org/bots/api#setbusinessaccountbio
		'''

		response = await self._send_request('setBusinessAccountBio', {
			'business_connection_id': business_connection_id,
			'bio': bio,
		})
		return BoolAdapter.validate_python(response)

	async def set_business_account_profile_photo(
		self,
		business_connection_id: str,
		photo: InputProfilePhoto,
		is_public: Optional[bool] = None,
	) -> bool:
		'''
        Changes the profile photo of a managed business
        account. Requires the can_edit_profile_photo business bot right. Returns
        True on success.

        Reference: https://core.telegram.org/bots/api#setbusinessaccountprofilephoto
		'''

		response = await self._send_request('setBusinessAccountProfilePhoto', {
			'business_connection_id': business_connection_id,
			'photo': photo,
			'is_public': is_public,
		})
		return BoolAdapter.validate_python(response)

	async def remove_business_account_profile_photo(
		self,
		business_connection_id: str,
		is_public: Optional[bool] = None,
	) -> bool:
		'''
        Removes the current profile photo of a managed
        business account. Requires the can_edit_profile_photo business bot right.
        Returns True on success.

        Reference: https://core.telegram.org/bots/api#removebusinessaccountprofilephoto
		'''

		response = await self._send_request('removeBusinessAccountProfilePhoto', {
			'business_connection_id': business_connection_id,
			'is_public': is_public,
		})
		return BoolAdapter.validate_python(response)

	async def set_business_account_gift_settings(
		self,
		business_connection_id: str,
		show_gift_button: bool,
		accepted_gift_types: AcceptedGiftTypes,
	) -> bool:
		'''
        Changes the privacy settings pertaining to incoming gifts
        in a managed business account. Requires the can_change_gift_settings
        business bot right. Returns True on success.

        Reference: https://core.telegram.org/bots/api#setbusinessaccountgiftsettings
		'''

		response = await self._send_request('setBusinessAccountGiftSettings', {
			'business_connection_id': business_connection_id,
			'show_gift_button': show_gift_button,
			'accepted_gift_types': accepted_gift_types,
		})
		return BoolAdapter.validate_python(response)

	async def get_business_account_star_balance(
		self,
		business_connection_id: str,
	) -> StarAmount:
		'''
        Returns the amount of Telegram Stars owned by
        a managed business account. Requires the can_view_gifts_and_stars business
        bot right. Returns StarAmount on success.

        Reference: https://core.telegram.org/bots/api#getbusinessaccountstarbalance
		'''

		response = await self._send_request('getBusinessAccountStarBalance', {
			'business_connection_id': business_connection_id,
		})
		return StarAmount.model_validate(response)

	async def transfer_business_account_stars(
		self,
		business_connection_id: str,
		star_count: int,
	) -> bool:
		'''
        Transfers Telegram Stars from the business account balance
        to the bot's balance. Requires the can_transfer_stars business
        bot right. Returns True on success.

        Reference: https://core.telegram.org/bots/api#transferbusinessaccountstars
		'''

		response = await self._send_request('transferBusinessAccountStars', {
			'business_connection_id': business_connection_id,
			'star_count': star_count,
		})
		return BoolAdapter.validate_python(response)

	async def get_business_account_gifts(
		self,
		business_connection_id: str,
		exclude_unsaved: Optional[bool] = None,
		exclude_saved: Optional[bool] = None,
		exclude_unlimited: Optional[bool] = None,
		exclude_limited: Optional[bool] = None,
		exclude_unique: Optional[bool] = None,
		sort_by_price: Optional[bool] = None,
		offset: Optional[str] = None,
		limit: Optional[int] = None,
	) -> OwnedGifts:
		'''
        Returns the gifts received and owned by a
        managed business account. Requires the can_view_gifts_and_stars business bot
        right. Returns OwnedGifts on success.

        Reference: https://core.telegram.org/bots/api#getbusinessaccountgifts
		'''

		response = await self._send_request('getBusinessAccountGifts', {
			'business_connection_id': business_connection_id,
			'exclude_unsaved': exclude_unsaved,
			'exclude_saved': exclude_saved,
			'exclude_unlimited': exclude_unlimited,
			'exclude_limited': exclude_limited,
			'exclude_unique': exclude_unique,
			'sort_by_price': sort_by_price,
			'offset': offset,
			'limit': limit,
		})
		return OwnedGifts.model_validate(response)

	async def convert_gift_to_stars(
		self,
		business_connection_id: str,
		owned_gift_id: str,
	) -> bool:
		'''
        Converts a given regular gift to Telegram Stars.
        Requires the can_convert_gifts_to_stars business bot right. Returns True
        on success.

        Reference: https://core.telegram.org/bots/api#convertgifttostars
		'''

		response = await self._send_request('convertGiftToStars', {
			'business_connection_id': business_connection_id,
			'owned_gift_id': owned_gift_id,
		})
		return BoolAdapter.validate_python(response)

	async def upgrade_gift(
		self,
		business_connection_id: str,
		owned_gift_id: str,
		keep_original_details: Optional[bool] = None,
		star_count: Optional[int] = None,
	) -> bool:
		'''
        Upgrades a given regular gift to a unique
        gift. Requires the can_transfer_and_upgrade_gifts business bot right. Additionally
        requires the can_transfer_stars business bot right if the
        upgrade is paid. Returns True on success.

        Reference: https://core.telegram.org/bots/api#upgradegift
		'''

		response = await self._send_request('upgradeGift', {
			'business_connection_id': business_connection_id,
			'owned_gift_id': owned_gift_id,
			'keep_original_details': keep_original_details,
			'star_count': star_count,
		})
		return BoolAdapter.validate_python(response)

	async def transfer_gift(
		self,
		business_connection_id: str,
		owned_gift_id: str,
		new_owner_chat_id: int,
		star_count: Optional[int] = None,
	) -> bool:
		'''
        Transfers an owned unique gift to another user.
        Requires the can_transfer_and_upgrade_gifts business bot right. Requires can_transfer_stars
        business bot right if the transfer is paid.
        Returns True on success.

        Reference: https://core.telegram.org/bots/api#transfergift
		'''

		response = await self._send_request('transferGift', {
			'business_connection_id': business_connection_id,
			'owned_gift_id': owned_gift_id,
			'new_owner_chat_id': new_owner_chat_id,
			'star_count': star_count,
		})
		return BoolAdapter.validate_python(response)

	async def post_story(
		self,
		business_connection_id: str,
		content: InputStoryContent,
		active_period: int,
		caption: Optional[str] = None,
		parse_mode: Optional[str] = 'HTML',
		caption_entities: Optional[List[MessageEntity]] = None,
		areas: Optional[List[StoryArea]] = None,
		post_to_chat_page: Optional[bool] = None,
		protect_content: Optional[bool] = None,
	) -> Story:
		'''
        Posts a story on behalf of a managed
        business account. Requires the can_manage_stories business bot right.
        Returns Story on success.

        Reference: https://core.telegram.org/bots/api#poststory
		'''

		response = await self._send_request('postStory', {
			'business_connection_id': business_connection_id,
			'content': content,
			'active_period': active_period,
			'caption': caption,
			'parse_mode': parse_mode if not caption_entities else None, # FIX,
			'caption_entities': caption_entities,
			'areas': areas,
			'post_to_chat_page': post_to_chat_page,
			'protect_content': protect_content,
		})
		return Story.model_validate(response)

	async def edit_story(
		self,
		business_connection_id: str,
		story_id: int,
		content: InputStoryContent,
		caption: Optional[str] = None,
		parse_mode: Optional[str] = 'HTML',
		caption_entities: Optional[List[MessageEntity]] = None,
		areas: Optional[List[StoryArea]] = None,
	) -> Story:
		'''
        Edits a story previously posted by the bot
        on behalf of a managed business account. Requires
        the can_manage_stories business bot right. Returns Story on
        success.

        Reference: https://core.telegram.org/bots/api#editstory
		'''

		response = await self._send_request('editStory', {
			'business_connection_id': business_connection_id,
			'story_id': story_id,
			'content': content,
			'caption': caption,
			'parse_mode': parse_mode if not caption_entities else None, # FIX,
			'caption_entities': caption_entities,
			'areas': areas,
		})
		return Story.model_validate(response)

	async def delete_story(
		self,
		business_connection_id: str,
		story_id: int,
	) -> bool:
		'''
        Deletes a story previously posted by the bot
        on behalf of a managed business account. Requires
        the can_manage_stories business bot right. Returns True on
        success.

        Reference: https://core.telegram.org/bots/api#deletestory
		'''

		response = await self._send_request('deleteStory', {
			'business_connection_id': business_connection_id,
			'story_id': story_id,
		})
		return BoolAdapter.validate_python(response)

	async def edit_message_text(
		self,
		text: str,
		business_connection_id: Optional[str] = None,
		chat_id: Optional[Union[int, str]] = None,
		message_id: Optional[int] = None,
		inline_message_id: Optional[str] = None,
		parse_mode: Optional[str] = 'HTML',
		entities: Optional[List[MessageEntity]] = None,
		link_preview_options: Optional[LinkPreviewOptions] = None,
		reply_markup: Optional[InlineKeyboardMarkup] = None,
	) -> Union[Message, bool]:
		'''
        Use this method to edit text and game
        messages. On success, if the edited message is
        not an inline message, the edited Message is
        returned, otherwise True is returned. Note that business
        messages that were not sent by the bot
        and do not contain an inline keyboard can
        only be edited within 48 hours from the
        time they were sent.

        Reference: https://core.telegram.org/bots/api#editmessagetext
		'''

		response = await self._send_request('editMessageText', {
			'business_connection_id': business_connection_id,
			'chat_id': chat_id,
			'message_id': message_id,
			'inline_message_id': inline_message_id,
			'text': text,
			'parse_mode': parse_mode if not entities else None, # FIX,
			'entities': entities,
			'link_preview_options': link_preview_options,
			'reply_markup': reply_markup,
		})
		if isinstance(response, (dict, list)):
			return Message.model_validate(response)
		else:
			return BoolAdapter.validate_python(response)

	async def edit_message_caption(
		self,
		business_connection_id: Optional[str] = None,
		chat_id: Optional[Union[int, str]] = None,
		message_id: Optional[int] = None,
		inline_message_id: Optional[str] = None,
		caption: Optional[str] = None,
		parse_mode: Optional[str] = 'HTML',
		caption_entities: Optional[List[MessageEntity]] = None,
		show_caption_above_media: Optional[bool] = None,
		reply_markup: Optional[InlineKeyboardMarkup] = None,
	) -> Union[Message, bool]:
		'''
        Use this method to edit captions of messages.
        On success, if the edited message is not
        an inline message, the edited Message is returned,
        otherwise True is returned. Note that business messages
        that were not sent by the bot and
        do not contain an inline keyboard can only
        be edited within 48 hours from the time
        they were sent.

        Reference: https://core.telegram.org/bots/api#editmessagecaption
		'''

		response = await self._send_request('editMessageCaption', {
			'business_connection_id': business_connection_id,
			'chat_id': chat_id,
			'message_id': message_id,
			'inline_message_id': inline_message_id,
			'caption': caption,
			'parse_mode': parse_mode if not caption_entities else None, # FIX,
			'caption_entities': caption_entities,
			'show_caption_above_media': show_caption_above_media,
			'reply_markup': reply_markup,
		})
		if isinstance(response, (dict, list)):
			return Message.model_validate(response)
		else:
			return BoolAdapter.validate_python(response)

	async def edit_message_media(
		self,
		media: InputMedia,
		business_connection_id: Optional[str] = None,
		chat_id: Optional[Union[int, str]] = None,
		message_id: Optional[int] = None,
		inline_message_id: Optional[str] = None,
		reply_markup: Optional[InlineKeyboardMarkup] = None,
	) -> Union[Message, bool]:
		'''
        Use this method to edit animation, audio, document,
        photo, or video messages, or to add media
        to text messages. If a message is part
        of a message album, then it can be
        edited only to an audio for audio albums,
        only to a document for document albums and
        to a photo or a video otherwise. When
        an inline message is edited, a new file
        can't be uploaded; use a previously uploaded file
        via its file_id or specify a URL. On
        success, if the edited message is not an
        inline message, the edited Message is returned, otherwise
        True is returned. Note that business messages that
        were not sent by the bot and do
        not contain an inline keyboard can only be
        edited within 48 hours from the time they
        were sent.

        Reference: https://core.telegram.org/bots/api#editmessagemedia
		'''

		response = await self._send_request('editMessageMedia', {
			'business_connection_id': business_connection_id,
			'chat_id': chat_id,
			'message_id': message_id,
			'inline_message_id': inline_message_id,
			'media': media,
			'reply_markup': reply_markup,
		})
		if isinstance(response, (dict, list)):
			return Message.model_validate(response)
		else:
			return BoolAdapter.validate_python(response)

	async def edit_message_live_location(
		self,
		latitude: float,
		longitude: float,
		business_connection_id: Optional[str] = None,
		chat_id: Optional[Union[int, str]] = None,
		message_id: Optional[int] = None,
		inline_message_id: Optional[str] = None,
		live_period: Optional[int] = None,
		horizontal_accuracy: Optional[float] = None,
		heading: Optional[int] = None,
		proximity_alert_radius: Optional[int] = None,
		reply_markup: Optional[InlineKeyboardMarkup] = None,
	) -> Union[Message, bool]:
		'''
        Use this method to edit live location messages.
        A location can be edited until its live_period
        expires or editing is explicitly disabled by a
        call to stopMessageLiveLocation. On success, if the edited
        message is not an inline message, the edited
        Message is returned, otherwise True is returned.

        Reference: https://core.telegram.org/bots/api#editmessagelivelocation
		'''

		response = await self._send_request('editMessageLiveLocation', {
			'business_connection_id': business_connection_id,
			'chat_id': chat_id,
			'message_id': message_id,
			'inline_message_id': inline_message_id,
			'latitude': latitude,
			'longitude': longitude,
			'live_period': live_period,
			'horizontal_accuracy': horizontal_accuracy,
			'heading': heading,
			'proximity_alert_radius': proximity_alert_radius,
			'reply_markup': reply_markup,
		})
		if isinstance(response, (dict, list)):
			return Message.model_validate(response)
		else:
			return BoolAdapter.validate_python(response)

	async def stop_message_live_location(
		self,
		business_connection_id: Optional[str] = None,
		chat_id: Optional[Union[int, str]] = None,
		message_id: Optional[int] = None,
		inline_message_id: Optional[str] = None,
		reply_markup: Optional[InlineKeyboardMarkup] = None,
	) -> Union[Message, bool]:
		'''
        Use this method to stop updating a live
        location message before live_period expires. On success, if
        the message is not an inline message, the
        edited Message is returned, otherwise True is returned.

        Reference: https://core.telegram.org/bots/api#stopmessagelivelocation
		'''

		response = await self._send_request('stopMessageLiveLocation', {
			'business_connection_id': business_connection_id,
			'chat_id': chat_id,
			'message_id': message_id,
			'inline_message_id': inline_message_id,
			'reply_markup': reply_markup,
		})
		if isinstance(response, (dict, list)):
			return Message.model_validate(response)
		else:
			return BoolAdapter.validate_python(response)

	async def edit_message_checklist(
		self,
		business_connection_id: str,
		chat_id: int,
		message_id: int,
		checklist: InputChecklist,
		reply_markup: Optional[InlineKeyboardMarkup] = None,
	) -> Message:
		'''
        Use this method to edit a checklist on
        behalf of a connected business account. On success,
        the edited Message is returned.

        Reference: https://core.telegram.org/bots/api#editmessagechecklist
		'''

		response = await self._send_request('editMessageChecklist', {
			'business_connection_id': business_connection_id,
			'chat_id': chat_id,
			'message_id': message_id,
			'checklist': checklist,
			'reply_markup': reply_markup,
		})
		return Message.model_validate(response)

	async def edit_message_reply_markup(
		self,
		business_connection_id: Optional[str] = None,
		chat_id: Optional[Union[int, str]] = None,
		message_id: Optional[int] = None,
		inline_message_id: Optional[str] = None,
		reply_markup: Optional[InlineKeyboardMarkup] = None,
	) -> Union[Message, bool]:
		'''
        Use this method to edit only the reply
        markup of messages. On success, if the edited
        message is not an inline message, the edited
        Message is returned, otherwise True is returned. Note
        that business messages that were not sent by
        the bot and do not contain an inline
        keyboard can only be edited within 48 hours
        from the time they were sent.

        Reference: https://core.telegram.org/bots/api#editmessagereplymarkup
		'''

		response = await self._send_request('editMessageReplyMarkup', {
			'business_connection_id': business_connection_id,
			'chat_id': chat_id,
			'message_id': message_id,
			'inline_message_id': inline_message_id,
			'reply_markup': reply_markup,
		})
		if isinstance(response, (dict, list)):
			return Message.model_validate(response)
		else:
			return BoolAdapter.validate_python(response)

	async def stop_poll(
		self,
		chat_id: Union[int, str],
		message_id: int,
		business_connection_id: Optional[str] = None,
		reply_markup: Optional[InlineKeyboardMarkup] = None,
	) -> Poll:
		'''
        Use this method to stop a poll which
        was sent by the bot. On success, the
        stopped Poll is returned.

        Reference: https://core.telegram.org/bots/api#stoppoll
		'''

		response = await self._send_request('stopPoll', {
			'business_connection_id': business_connection_id,
			'chat_id': chat_id,
			'message_id': message_id,
			'reply_markup': reply_markup,
		})
		return Poll.model_validate(response)

	async def approve_suggested_post(
		self,
		chat_id: int,
		message_id: int,
		send_date: Optional[int] = None,
	) -> bool:
		'''
        Use this method to approve a suggested post
        in a direct messages chat. The bot must
        have the 'can_post_messages' administrator right in the corresponding
        channel chat. Returns True on success.

        Reference: https://core.telegram.org/bots/api#approvesuggestedpost
		'''

		response = await self._send_request('approveSuggestedPost', {
			'chat_id': chat_id,
			'message_id': message_id,
			'send_date': send_date,
		})
		return BoolAdapter.validate_python(response)

	async def decline_suggested_post(
		self,
		chat_id: int,
		message_id: int,
		comment: Optional[str] = None,
	) -> bool:
		'''
        Use this method to decline a suggested post
        in a direct messages chat. The bot must
        have the 'can_manage_direct_messages' administrator right in the corresponding
        channel chat. Returns True on success.

        Reference: https://core.telegram.org/bots/api#declinesuggestedpost
		'''

		response = await self._send_request('declineSuggestedPost', {
			'chat_id': chat_id,
			'message_id': message_id,
			'comment': comment,
		})
		return BoolAdapter.validate_python(response)

	async def delete_message(
		self,
		chat_id: Union[int, str],
		message_id: int,
	) -> bool:
		'''
        Use this method to delete a message, including
        service messages, with the following limitations:- A message
        can only be deleted if it was sent
        less than 48 hours ago.- Service messages about
        a supergroup, channel, or forum topic creation can't
        be deleted.- A dice message in a private
        chat can only be deleted if it was
        sent more than 24 hours ago.- Bots can
        delete outgoing messages in private chats, groups, and
        supergroups.- Bots can delete incoming messages in private
        chats.- Bots granted can_post_messages permissions can delete outgoing
        messages in channels.- If the bot is an
        administrator of a group, it can delete any
        message there.- If the bot has can_delete_messages administrator
        right in a supergroup or a channel, it
        can delete any message there.- If the bot
        has can_manage_direct_messages administrator right in a channel, it
        can delete any message in the corresponding direct
        messages chat.Returns True on success.

        Reference: https://core.telegram.org/bots/api#deletemessage
		'''

		response = await self._send_request('deleteMessage', {
			'chat_id': chat_id,
			'message_id': message_id,
		})
		return BoolAdapter.validate_python(response)

	async def delete_messages(
		self,
		chat_id: Union[int, str],
		message_ids: List[int],
	) -> bool:
		'''
        Use this method to delete multiple messages simultaneously.
        If some of the specified messages can't be
        found, they are skipped. Returns True on success.

        Reference: https://core.telegram.org/bots/api#deletemessages
		'''

		response = await self._send_request('deleteMessages', {
			'chat_id': chat_id,
			'message_ids': message_ids,
		})
		return BoolAdapter.validate_python(response)

	async def send_sticker(
		self,
		chat_id: Union[int, str],
		sticker: Union[InputFile, str],
		business_connection_id: Optional[str] = None,
		message_thread_id: Optional[int] = None,
		direct_messages_topic_id: Optional[int] = None,
		emoji: Optional[str] = None,
		disable_notification: Optional[bool] = None,
		protect_content: Optional[bool] = None,
		allow_paid_broadcast: Optional[bool] = None,
		message_effect_id: Optional[str] = None,
		suggested_post_parameters: Optional[SuggestedPostParameters] = None,
		reply_parameters: Optional[ReplyParameters] = None,
		reply_markup: Optional[Union[InlineKeyboardMarkup, ReplyKeyboardMarkup, ReplyKeyboardRemove, ForceReply]] = None,
	) -> Message:
		'''
        Use this method to send static .WEBP, animated
        .TGS, or video .WEBM stickers. On success, the
        sent Message is returned.

        Reference: https://core.telegram.org/bots/api#sendsticker
		'''

		response = await self._send_request('sendSticker', {
			'business_connection_id': business_connection_id,
			'chat_id': chat_id,
			'message_thread_id': message_thread_id,
			'direct_messages_topic_id': direct_messages_topic_id,
			'sticker': sticker,
			'emoji': emoji,
			'disable_notification': disable_notification,
			'protect_content': protect_content,
			'allow_paid_broadcast': allow_paid_broadcast,
			'message_effect_id': message_effect_id,
			'suggested_post_parameters': suggested_post_parameters,
			'reply_parameters': reply_parameters,
			'reply_markup': reply_markup,
		})
		return Message.model_validate(response)

	async def get_sticker_set(
		self,
		name: str,
	) -> StickerSet:
		'''
        Use this method to get a sticker set.
        On success, a StickerSet object is returned.

        Reference: https://core.telegram.org/bots/api#getstickerset
		'''

		response = await self._send_request('getStickerSet', {
			'name': name,
		})
		return StickerSet.model_validate(response)

	async def get_custom_emoji_stickers(
		self,
		custom_emoji_ids: List[str],
	) -> List[Sticker]:
		'''
        Use this method to get information about custom
        emoji stickers by their identifiers. Returns an Array
        of Sticker objects.

        Reference: https://core.telegram.org/bots/api#getcustomemojistickers
		'''

		response = await self._send_request('getCustomEmojiStickers', {
			'custom_emoji_ids': custom_emoji_ids,
		})
		return [Sticker.model_validate(x) for x in response]

	async def upload_sticker_file(
		self,
		user_id: int,
		sticker: InputFile,
		sticker_format: str,
	) -> File:
		'''
        Use this method to upload a file with
        a sticker for later use in the createNewStickerSet,
        addStickerToSet, or replaceStickerInSet methods (the file can be
        used multiple times). Returns the uploaded File on
        success.

        Reference: https://core.telegram.org/bots/api#uploadstickerfile
		'''

		response = await self._send_request('uploadStickerFile', {
			'user_id': user_id,
			'sticker': sticker,
			'sticker_format': sticker_format,
		})
		return File.model_validate(response)

	async def create_new_sticker_set(
		self,
		user_id: int,
		name: str,
		title: str,
		stickers: List[InputSticker],
		sticker_type: Optional[str] = None,
		needs_repainting: Optional[bool] = None,
	) -> bool:
		'''
        Use this method to create a new sticker
        set owned by a user. The bot will
        be able to edit the sticker set thus
        created. Returns True on success.

        Reference: https://core.telegram.org/bots/api#createnewstickerset
		'''

		response = await self._send_request('createNewStickerSet', {
			'user_id': user_id,
			'name': name,
			'title': title,
			'stickers': stickers,
			'sticker_type': sticker_type,
			'needs_repainting': needs_repainting,
		})
		return BoolAdapter.validate_python(response)

	async def add_sticker_to_set(
		self,
		user_id: int,
		name: str,
		sticker: InputSticker,
	) -> bool:
		'''
        Use this method to add a new sticker
        to a set created by the bot. Emoji
        sticker sets can have up to 200 stickers.
        Other sticker sets can have up to 120
        stickers. Returns True on success.

        Reference: https://core.telegram.org/bots/api#addstickertoset
		'''

		response = await self._send_request('addStickerToSet', {
			'user_id': user_id,
			'name': name,
			'sticker': sticker,
		})
		return BoolAdapter.validate_python(response)

	async def set_sticker_position_in_set(
		self,
		sticker: str,
		position: int,
	) -> bool:
		'''
        Use this method to move a sticker in
        a set created by the bot to a
        specific position. Returns True on success.

        Reference: https://core.telegram.org/bots/api#setstickerpositioninset
		'''

		response = await self._send_request('setStickerPositionInSet', {
			'sticker': sticker,
			'position': position,
		})
		return BoolAdapter.validate_python(response)

	async def delete_sticker_from_set(
		self,
		sticker: str,
	) -> bool:
		'''
        Use this method to delete a sticker from
        a set created by the bot. Returns True
        on success.

        Reference: https://core.telegram.org/bots/api#deletestickerfromset
		'''

		response = await self._send_request('deleteStickerFromSet', {
			'sticker': sticker,
		})
		return BoolAdapter.validate_python(response)

	async def replace_sticker_in_set(
		self,
		user_id: int,
		name: str,
		old_sticker: str,
		sticker: InputSticker,
	) -> bool:
		'''
        Use this method to replace an existing sticker
        in a sticker set with a new one.
        The method is equivalent to calling deleteStickerFromSet, then
        addStickerToSet, then setStickerPositionInSet. Returns True on success.

        Reference: https://core.telegram.org/bots/api#replacestickerinset
		'''

		response = await self._send_request('replaceStickerInSet', {
			'user_id': user_id,
			'name': name,
			'old_sticker': old_sticker,
			'sticker': sticker,
		})
		return BoolAdapter.validate_python(response)

	async def set_sticker_emoji_list(
		self,
		sticker: str,
		emoji_list: List[str],
	) -> bool:
		'''
        Use this method to change the list of
        emoji assigned to a regular or custom emoji
        sticker. The sticker must belong to a sticker
        set created by the bot. Returns True on
        success.

        Reference: https://core.telegram.org/bots/api#setstickeremojilist
		'''

		response = await self._send_request('setStickerEmojiList', {
			'sticker': sticker,
			'emoji_list': emoji_list,
		})
		return BoolAdapter.validate_python(response)

	async def set_sticker_keywords(
		self,
		sticker: str,
		keywords: Optional[List[str]] = None,
	) -> bool:
		'''
        Use this method to change search keywords assigned
        to a regular or custom emoji sticker. The
        sticker must belong to a sticker set created
        by the bot. Returns True on success.

        Reference: https://core.telegram.org/bots/api#setstickerkeywords
		'''

		response = await self._send_request('setStickerKeywords', {
			'sticker': sticker,
			'keywords': keywords,
		})
		return BoolAdapter.validate_python(response)

	async def set_sticker_mask_position(
		self,
		sticker: str,
		mask_position: Optional[MaskPosition] = None,
	) -> bool:
		'''
        Use this method to change the mask position
        of a mask sticker. The sticker must belong
        to a sticker set that was created by
        the bot. Returns True on success.

        Reference: https://core.telegram.org/bots/api#setstickermaskposition
		'''

		response = await self._send_request('setStickerMaskPosition', {
			'sticker': sticker,
			'mask_position': mask_position,
		})
		return BoolAdapter.validate_python(response)

	async def set_sticker_set_title(
		self,
		name: str,
		title: str,
	) -> bool:
		'''
        Use this method to set the title of
        a created sticker set. Returns True on success.

        Reference: https://core.telegram.org/bots/api#setstickersettitle
		'''

		response = await self._send_request('setStickerSetTitle', {
			'name': name,
			'title': title,
		})
		return BoolAdapter.validate_python(response)

	async def set_sticker_set_thumbnail(
		self,
		name: str,
		user_id: int,
		format: str,
		thumbnail: Optional[Union[InputFile, str]] = None,
	) -> bool:
		'''
        Use this method to set the thumbnail of
        a regular or mask sticker set. The format
        of the thumbnail file must match the format
        of the stickers in the set. Returns True
        on success.

        Reference: https://core.telegram.org/bots/api#setstickersetthumbnail
		'''

		response = await self._send_request('setStickerSetThumbnail', {
			'name': name,
			'user_id': user_id,
			'thumbnail': thumbnail,
			'format': format,
		})
		return BoolAdapter.validate_python(response)

	async def set_custom_emoji_sticker_set_thumbnail(
		self,
		name: str,
		custom_emoji_id: Optional[str] = None,
	) -> bool:
		'''
        Use this method to set the thumbnail of
        a custom emoji sticker set. Returns True on
        success.

        Reference: https://core.telegram.org/bots/api#setcustomemojistickersetthumbnail
		'''

		response = await self._send_request('setCustomEmojiStickerSetThumbnail', {
			'name': name,
			'custom_emoji_id': custom_emoji_id,
		})
		return BoolAdapter.validate_python(response)

	async def delete_sticker_set(
		self,
		name: str,
	) -> bool:
		'''
        Use this method to delete a sticker set
        that was created by the bot. Returns True
        on success.

        Reference: https://core.telegram.org/bots/api#deletestickerset
		'''

		response = await self._send_request('deleteStickerSet', {
			'name': name,
		})
		return BoolAdapter.validate_python(response)

	async def answer_inline_query(
		self,
		inline_query_id: str,
		results: List[InlineQueryResult],
		cache_time: Optional[int] = None,
		is_personal: Optional[bool] = None,
		next_offset: Optional[str] = None,
		button: Optional[InlineQueryResultsButton] = None,
	) -> bool:
		'''
        Use this method to send answers to an
        inline query. On success, True is returned.No more
        than 50 results per query are allowed.

        Reference: https://core.telegram.org/bots/api#answerinlinequery
		'''

		response = await self._send_request('answerInlineQuery', {
			'inline_query_id': inline_query_id,
			'results': results,
			'cache_time': cache_time,
			'is_personal': is_personal,
			'next_offset': next_offset,
			'button': button,
		})
		return BoolAdapter.validate_python(response)

	async def answer_web_app_query(
		self,
		web_app_query_id: str,
		result: InlineQueryResult,
	) -> SentWebAppMessage:
		'''
        Use this method to set the result of
        an interaction with a Web App and send
        a corresponding message on behalf of the user
        to the chat from which the query originated.
        On success, a SentWebAppMessage object is returned.

        Reference: https://core.telegram.org/bots/api#answerwebappquery
		'''

		response = await self._send_request('answerWebAppQuery', {
			'web_app_query_id': web_app_query_id,
			'result': result,
		})
		return SentWebAppMessage.model_validate(response)

	async def save_prepared_inline_message(
		self,
		user_id: int,
		result: InlineQueryResult,
		allow_user_chats: Optional[bool] = None,
		allow_bot_chats: Optional[bool] = None,
		allow_group_chats: Optional[bool] = None,
		allow_channel_chats: Optional[bool] = None,
	) -> PreparedInlineMessage:
		'''
        Stores a message that can be sent by
        a user of a Mini App. Returns a
        PreparedInlineMessage object.

        Reference: https://core.telegram.org/bots/api#savepreparedinlinemessage
		'''

		response = await self._send_request('savePreparedInlineMessage', {
			'user_id': user_id,
			'result': result,
			'allow_user_chats': allow_user_chats,
			'allow_bot_chats': allow_bot_chats,
			'allow_group_chats': allow_group_chats,
			'allow_channel_chats': allow_channel_chats,
		})
		return PreparedInlineMessage.model_validate(response)

	async def send_invoice(
		self,
		chat_id: Union[int, str],
		title: str,
		description: str,
		payload: str,
		currency: str,
		prices: List[LabeledPrice],
		message_thread_id: Optional[int] = None,
		direct_messages_topic_id: Optional[int] = None,
		provider_token: Optional[str] = None,
		max_tip_amount: Optional[int] = None,
		suggested_tip_amounts: Optional[List[int]] = None,
		start_parameter: Optional[str] = None,
		provider_data: Optional[str] = None,
		photo_url: Optional[str] = None,
		photo_size: Optional[int] = None,
		photo_width: Optional[int] = None,
		photo_height: Optional[int] = None,
		need_name: Optional[bool] = None,
		need_phone_number: Optional[bool] = None,
		need_email: Optional[bool] = None,
		need_shipping_address: Optional[bool] = None,
		send_phone_number_to_provider: Optional[bool] = None,
		send_email_to_provider: Optional[bool] = None,
		is_flexible: Optional[bool] = None,
		disable_notification: Optional[bool] = None,
		protect_content: Optional[bool] = None,
		allow_paid_broadcast: Optional[bool] = None,
		message_effect_id: Optional[str] = None,
		suggested_post_parameters: Optional[SuggestedPostParameters] = None,
		reply_parameters: Optional[ReplyParameters] = None,
		reply_markup: Optional[InlineKeyboardMarkup] = None,
	) -> Message:
		'''
        Use this method to send invoices. On success,
        the sent Message is returned.

        Reference: https://core.telegram.org/bots/api#sendinvoice
		'''

		response = await self._send_request('sendInvoice', {
			'chat_id': chat_id,
			'message_thread_id': message_thread_id,
			'direct_messages_topic_id': direct_messages_topic_id,
			'title': title,
			'description': description,
			'payload': payload,
			'provider_token': provider_token,
			'currency': currency,
			'prices': prices,
			'max_tip_amount': max_tip_amount,
			'suggested_tip_amounts': suggested_tip_amounts,
			'start_parameter': start_parameter,
			'provider_data': provider_data,
			'photo_url': photo_url,
			'photo_size': photo_size,
			'photo_width': photo_width,
			'photo_height': photo_height,
			'need_name': need_name,
			'need_phone_number': need_phone_number,
			'need_email': need_email,
			'need_shipping_address': need_shipping_address,
			'send_phone_number_to_provider': send_phone_number_to_provider,
			'send_email_to_provider': send_email_to_provider,
			'is_flexible': is_flexible,
			'disable_notification': disable_notification,
			'protect_content': protect_content,
			'allow_paid_broadcast': allow_paid_broadcast,
			'message_effect_id': message_effect_id,
			'suggested_post_parameters': suggested_post_parameters,
			'reply_parameters': reply_parameters,
			'reply_markup': reply_markup,
		})
		return Message.model_validate(response)

	async def create_invoice_link(
		self,
		title: str,
		description: str,
		payload: str,
		currency: str,
		prices: List[LabeledPrice],
		business_connection_id: Optional[str] = None,
		provider_token: Optional[str] = None,
		subscription_period: Optional[int] = None,
		max_tip_amount: Optional[int] = None,
		suggested_tip_amounts: Optional[List[int]] = None,
		provider_data: Optional[str] = None,
		photo_url: Optional[str] = None,
		photo_size: Optional[int] = None,
		photo_width: Optional[int] = None,
		photo_height: Optional[int] = None,
		need_name: Optional[bool] = None,
		need_phone_number: Optional[bool] = None,
		need_email: Optional[bool] = None,
		need_shipping_address: Optional[bool] = None,
		send_phone_number_to_provider: Optional[bool] = None,
		send_email_to_provider: Optional[bool] = None,
		is_flexible: Optional[bool] = None,
	) -> str:
		'''
        Use this method to create a link for
        an invoice. Returns the created invoice link as
        String on success.

        Reference: https://core.telegram.org/bots/api#createinvoicelink
		'''

		response = await self._send_request('createInvoiceLink', {
			'business_connection_id': business_connection_id,
			'title': title,
			'description': description,
			'payload': payload,
			'provider_token': provider_token,
			'currency': currency,
			'prices': prices,
			'subscription_period': subscription_period,
			'max_tip_amount': max_tip_amount,
			'suggested_tip_amounts': suggested_tip_amounts,
			'provider_data': provider_data,
			'photo_url': photo_url,
			'photo_size': photo_size,
			'photo_width': photo_width,
			'photo_height': photo_height,
			'need_name': need_name,
			'need_phone_number': need_phone_number,
			'need_email': need_email,
			'need_shipping_address': need_shipping_address,
			'send_phone_number_to_provider': send_phone_number_to_provider,
			'send_email_to_provider': send_email_to_provider,
			'is_flexible': is_flexible,
		})
		return StrAdapter.validate_python(response)

	async def answer_shipping_query(
		self,
		shipping_query_id: str,
		ok: bool,
		shipping_options: Optional[List[ShippingOption]] = None,
		error_message: Optional[str] = None,
	) -> bool:
		'''
        If you sent an invoice requesting a shipping
        address and the parameter is_flexible was specified, the
        Bot API will send an Update with a
        shipping_query field to the bot. Use this method
        to reply to shipping queries. On success, True
        is returned.

        Reference: https://core.telegram.org/bots/api#answershippingquery
		'''

		response = await self._send_request('answerShippingQuery', {
			'shipping_query_id': shipping_query_id,
			'ok': ok,
			'shipping_options': shipping_options,
			'error_message': error_message,
		})
		return BoolAdapter.validate_python(response)

	async def answer_pre_checkout_query(
		self,
		pre_checkout_query_id: str,
		ok: bool,
		error_message: Optional[str] = None,
	) -> bool:
		'''
        Once the user has confirmed their payment and
        shipping details, the Bot API sends the final
        confirmation in the form of an Update with
        the field pre_checkout_query. Use this method to respond
        to such pre-checkout queries. On success, True is
        returned. Note: The Bot API must receive an
        answer within 10 seconds after the pre-checkout query
        was sent.

        Reference: https://core.telegram.org/bots/api#answerprecheckoutquery
		'''

		response = await self._send_request('answerPreCheckoutQuery', {
			'pre_checkout_query_id': pre_checkout_query_id,
			'ok': ok,
			'error_message': error_message,
		})
		return BoolAdapter.validate_python(response)

	async def get_my_star_balance(
		self,
	) -> StarAmount:
		'''
        A method to get the current Telegram Stars
        balance of the bot. Requires no parameters. On
        success, returns a StarAmount object.

        Reference: https://core.telegram.org/bots/api#getmystarbalance
		'''

		response = await self._send_request('getMyStarBalance', {})
		return StarAmount.model_validate(response)

	async def get_star_transactions(
		self,
		offset: Optional[int] = None,
		limit: Optional[int] = None,
	) -> StarTransactions:
		'''
        Returns the bot's Telegram Star transactions in chronological
        order. On success, returns a StarTransactions object.

        Reference: https://core.telegram.org/bots/api#getstartransactions
		'''

		response = await self._send_request('getStarTransactions', {
			'offset': offset,
			'limit': limit,
		})
		return StarTransactions.model_validate(response)

	async def refund_star_payment(
		self,
		user_id: int,
		telegram_payment_charge_id: str,
	) -> bool:
		'''
        Refunds a successful payment in Telegram Stars. Returns
        True on success.

        Reference: https://core.telegram.org/bots/api#refundstarpayment
		'''

		response = await self._send_request('refundStarPayment', {
			'user_id': user_id,
			'telegram_payment_charge_id': telegram_payment_charge_id,
		})
		return BoolAdapter.validate_python(response)

	async def edit_user_star_subscription(
		self,
		user_id: int,
		telegram_payment_charge_id: str,
		is_canceled: bool,
	) -> bool:
		'''
        Allows the bot to cancel or re-enable extension
        of a subscription paid in Telegram Stars. Returns
        True on success.

        Reference: https://core.telegram.org/bots/api#edituserstarsubscription
		'''

		response = await self._send_request('editUserStarSubscription', {
			'user_id': user_id,
			'telegram_payment_charge_id': telegram_payment_charge_id,
			'is_canceled': is_canceled,
		})
		return BoolAdapter.validate_python(response)

	async def set_passport_data_errors(
		self,
		user_id: int,
		errors: List[PassportElementError],
	) -> bool:
		'''
        Informs a user that some of the Telegram
        Passport elements they provided contains errors. The user
        will not be able to re-submit their Passport
        to you until the errors are fixed (the
        contents of the field for which you returned
        the error must change). Returns True on success.

        Reference: https://core.telegram.org/bots/api#setpassportdataerrors
		'''

		response = await self._send_request('setPassportDataErrors', {
			'user_id': user_id,
			'errors': errors,
		})
		return BoolAdapter.validate_python(response)

	async def send_game(
		self,
		chat_id: int,
		game_short_name: str,
		business_connection_id: Optional[str] = None,
		message_thread_id: Optional[int] = None,
		disable_notification: Optional[bool] = None,
		protect_content: Optional[bool] = None,
		allow_paid_broadcast: Optional[bool] = None,
		message_effect_id: Optional[str] = None,
		reply_parameters: Optional[ReplyParameters] = None,
		reply_markup: Optional[InlineKeyboardMarkup] = None,
	) -> Message:
		'''
        Use this method to send a game. On
        success, the sent Message is returned.

        Reference: https://core.telegram.org/bots/api#sendgame
		'''

		response = await self._send_request('sendGame', {
			'business_connection_id': business_connection_id,
			'chat_id': chat_id,
			'message_thread_id': message_thread_id,
			'game_short_name': game_short_name,
			'disable_notification': disable_notification,
			'protect_content': protect_content,
			'allow_paid_broadcast': allow_paid_broadcast,
			'message_effect_id': message_effect_id,
			'reply_parameters': reply_parameters,
			'reply_markup': reply_markup,
		})
		return Message.model_validate(response)

	async def set_game_score(
		self,
		user_id: int,
		score: int,
		force: Optional[bool] = None,
		disable_edit_message: Optional[bool] = None,
		chat_id: Optional[int] = None,
		message_id: Optional[int] = None,
		inline_message_id: Optional[str] = None,
	) -> Message:
		'''
        Use this method to set the score of
        the specified user in a game message. On
        success, if the message is not an inline
        message, the Message is returned, otherwise True is
        returned. Returns an error, if the new score
        is not greater than the user's current score
        in the chat and force is False.

        Reference: https://core.telegram.org/bots/api#setgamescore
		'''

		response = await self._send_request('setGameScore', {
			'user_id': user_id,
			'score': score,
			'force': force,
			'disable_edit_message': disable_edit_message,
			'chat_id': chat_id,
			'message_id': message_id,
			'inline_message_id': inline_message_id,
		})
		return Message.model_validate(response)

	async def get_game_high_scores(
		self,
		user_id: int,
		chat_id: Optional[int] = None,
		message_id: Optional[int] = None,
		inline_message_id: Optional[str] = None,
	) -> List[GameHighScore]:
		'''
        Use this method to get data for high
        score tables. Will return the score of the
        specified user and several of their neighbors in
        a game. Returns an Array of GameHighScore objects.

        Reference: https://core.telegram.org/bots/api#getgamehighscores
		'''

		response = await self._send_request('getGameHighScores', {
			'user_id': user_id,
			'chat_id': chat_id,
			'message_id': message_id,
			'inline_message_id': inline_message_id,
		})
		return [GameHighScore.model_validate(x) for x in response]

